package com.payu.checkoutpro.handlers

import android.os.Handler
import android.os.HandlerThread
import android.os.Looper
import androidx.fragment.app.Fragment
import com.payu.base.listeners.BaseTransactionListener
import com.payu.checkoutpro.listeners.NavigationHandlerListener
import com.payu.checkoutpro.utils.PayUCheckoutProConstants


class NavigationHandler(private var navigationHandlerListener: NavigationHandlerListener<Fragment?>?) {
    private var handler: Handler? = null
    private var mainHandler = Handler(Looper.getMainLooper())
    fun executeTask(task: () -> Fragment?) {
        if (handler == null) {
            val handlerThread = HandlerThread(PayUCheckoutProConstants.PAYU_NAVIGATION_HANDLER)
            handlerThread.start()
            val looper = handlerThread.looper
            handler = Handler(looper)
        }
        handler?.post {
            val result = task.invoke()
            mainHandler.post{
                navigationHandlerListener?.onResultReceived(result)
                handler?.looper?.quitSafely()
            }
        }
    }

}