package com.payu.checkoutpro.utils

import com.payu.base.models.*
import com.payu.checkoutpro.utils.CommonUtils.getEmiTenureListForBank
import com.payu.checkoutpro.utils.CommonUtils.isCardSchemeSupportedForMCP
import com.payu.checkoutpro.utils.CommonUtils.updatePaymentOptionWithMCPList
import com.payu.checkoutpro.utils.ParserUtils.isSufficientBalanceForLoadAndPay
import com.payu.checkoutpro.utils.PayUCheckoutProConstants.CP_BANK_CODE
import com.payu.checkoutpro.utils.PayUCheckoutProConstants.CP_OLAMONEY_CLASS_NAME

object PaymentOptionStateManager {
    internal fun getNextState(paymentModel: PaymentModel): PaymentFlowState? {

        val paymentOption = paymentModel.paymentOption
        if (paymentModel.paymentFlowState?.paymentState?.name.isNullOrEmpty()) {
            return when (paymentOption?.paymentType) {
                PaymentType.CARD -> {
                    if (ParserUtils.lookupDetails != null && isCardSchemeSupportedForMCP(
                            ParserUtils.lookupDetails?.supportedCardSchemes,
                            paymentOption.cardBinInfo
                        ) && !ParserUtils.lookupDetails?.mcpConversionBeans.isNullOrEmpty()
                    ) {
                        paymentModel.paymentOptionList = updatePaymentOptionWithMCPList(
                            ParserUtils.lookupDetails?.mcpConversionBeans,
                            paymentOption
                        )
                        PaymentFlowState().apply { paymentState = PaymentState.MCP }
                    } else {
                        PaymentFlowState().apply { paymentState = PaymentState.Default }
                    }
                }
                PaymentType.EMI -> {
                    paymentModel.paymentOptionList =
                        getEmiTenureListForBank(paymentOption as EMIOption)
                    paymentOption.category?.let { mapCategoryAsNextState(it) }
                }
                PaymentType.WALLET -> {
                    if ((paymentOption.otherParams as HashMap<String, Any>)[CP_BANK_CODE].toString() == PayUCheckoutProConstants.CP_OLAM
                        && !CommonUtils.isSdkAvailable(CP_OLAMONEY_CLASS_NAME)
                    )
                        PaymentFlowState().apply { paymentState = PaymentState.Default }
                    else
                        paymentOption.category?.let { mapCategoryAsNextState(it) }
                }
                PaymentType.CLOSED_LOOP_WALLET -> {
                    if((ParserUtils.closedLoopWalletCardOption.fetchedStatus == 1) &&
                        isSufficientBalanceForLoadAndPay(ParserUtils.closedLoopWalletCardOption.balance) && ((paymentOption as? SodexoCardOption)?.loadAmount.isNullOrEmpty())) {
                        PaymentFlowState().apply { paymentState = PaymentState.ClosedLoopWalletLoadAndPay }
                    } else {
                        PaymentFlowState().apply { paymentState = PaymentState.Default }
                    }
                }
                else -> {
                    paymentOption?.category?.let { mapCategoryAsNextState(it) }
                }
            }
        }
        return PaymentFlowState().apply { paymentState = PaymentState.Default }
    }

    internal fun mapCategoryAsNextState(category: String): PaymentFlowState {
        return PaymentFlowState().apply {
            paymentState = PaymentState.valueOf(category)
        }

    }

}