package com.payu.checkoutpro.reConverter

import android.content.Context
import com.payu.base.models.PaymentOption
import com.payu.base.models.PaymentType
import com.payu.base.models.UPIOption
import com.payu.checkoutpro.utils.AndroidUtils
import com.payu.checkoutpro.utils.CommonUtils
import com.payu.checkoutpro.utils.ParserUtils
import com.payu.checkoutpro.utils.PayUCheckoutProConstants
import com.payu.checkoutpro.utils.PayUCheckoutProConstants.CP_BANK_CODE
import com.payu.checkoutpro.utils.PayUCheckoutProConstants.CP_GPAY
import com.payu.checkoutpro.utils.PayUCheckoutProConstants.CP_G_PAY
import com.payu.checkoutpro.utils.PayUCheckoutProConstants.CP_KEY_ASSET_GOOGLE_PAY
import com.payu.india.Model.QuickPay.QuickPaySavedOption
import com.payu.india.Model.QuickPay.RecommendedOptions
import com.payu.india.Payu.PayuConstants

object UPIPaymentModeConverter {

    fun getSavedUPIPaymentMode(
        context: Context,
        quickPaySavedOption: QuickPaySavedOption
    ): ArrayList<PaymentOption> {
        val savedPaymentOption = UPIOption()
        val optionDetail: ArrayList<PaymentOption> = ArrayList()
        val paymentModeMap = ParserUtils.paymentOptionMap[PaymentType.UPI]
        val paymentOption: UPIOption? =
            paymentModeMap?.get(quickPaySavedOption.ibiboCode) as? UPIOption
        if (paymentOption != null) {
            val list = quickPaySavedOption.pgTitle?.split("-")
            if (!list.isNullOrEmpty() && list.size > 1) {
                savedPaymentOption.bankName = getUpiBankName(list[0])
            }
            savedPaymentOption.otherParams =
                CommonUtils.getOtherParamsMap(PayuConstants.UPI, quickPaySavedOption.ibiboCode)
            val otherParams = savedPaymentOption.otherParams as? HashMap<String, Any?>
            otherParams?.set(PayUCheckoutProConstants.CP_IS_L1_OPTION, true)
            otherParams?.set(
                PayUCheckoutProConstants.CP_UPI_APP_NAME,
                getUpiAppBankName(savedPaymentOption.bankName)
            )

            savedPaymentOption.isBankDown = !quickPaySavedOption.isPgUP
            savedPaymentOption.vpa = quickPaySavedOption.pgDetails
            savedPaymentOption.bankCode = getUpiAppBankName(savedPaymentOption.bankName)
            savedPaymentOption.phoneNumber = quickPaySavedOption.phoneNumber
            if (quickPaySavedOption.ibiboCode == PayuConstants.UPI_INTENT) {
                savedPaymentOption.paymentType = PaymentType.UPI_INTENT
                PaymentModeConverter.updateTaxValue(savedPaymentOption, PaymentType.UPI_INTENT)
                val installUpiList =
                    AndroidUtils.getInstalledUpiAppsList(context.applicationContext)
                (installUpiList?.firstOrNull() { paymentOption ->
                    paymentOption.bankName.uppercase() == savedPaymentOption.bankName.uppercase()
                } as? UPIOption)?.packageName?.let {
                    savedPaymentOption.packageName = it
                    if (savedPaymentOption.bankName == CP_GPAY)
                        savedPaymentOption.bankName = getUpiAppBankName(savedPaymentOption.bankName)
                    optionDetail.add(savedPaymentOption)
                }
            } else {
                savedPaymentOption.paymentType = PaymentType.UPI
                PaymentModeConverter.updateTaxValue(savedPaymentOption, PaymentType.UPI)
                optionDetail.add(savedPaymentOption)
            }
        }
        return optionDetail
    }

    fun getREUPIPaymentOption(recommendedOptions: RecommendedOptions): ArrayList<PaymentOption> {
        val optionDetails = ArrayList<PaymentOption>()
        val paymentModeMap = ParserUtils.paymentOptionMap[PaymentType.UPI]
        val paymentOption: UPIOption? =
            paymentModeMap?.get(recommendedOptions.ibiboCode) as? UPIOption
        if (paymentOption != null) {
            val othersParamMap =
                paymentOption.otherParams as? HashMap<String, String>
            if (othersParamMap?.get(PayUCheckoutProConstants.CP_BANK_CODE)
                    ?.isNotEmpty() == true
            )
                optionDetails.add(paymentOption)
        }
        return optionDetails
    }

    private fun getUpiAppBankName(bankName: String): String {
        return when (bankName) {
            CP_G_PAY -> CP_KEY_ASSET_GOOGLE_PAY
            CP_GPAY -> CP_G_PAY
            else -> bankName
        }
    }

    private fun getUpiBankName(bankName: String): String {
        return when (bankName) {
            CP_G_PAY -> CP_GPAY
            else -> bankName
        }
    }

    internal fun getDeleteApiSavedPaymentMode(paymentOption: UPIOption): QuickPaySavedOption {
        val quickPaySavedOption = QuickPaySavedOption()
        quickPaySavedOption.paymentType = PaymentType.UPI.name
        quickPaySavedOption.pgTitle = paymentOption.bankName + "-" + paymentOption.vpa
        quickPaySavedOption.pgDetails = paymentOption.vpa
        quickPaySavedOption.ibiboCode = CommonUtils.getValueFromPaymentOption(
            CP_BANK_CODE,
            paymentOption.otherParams as? java.util.HashMap<String, Any?>
        )
        return quickPaySavedOption
    }
}