package com.payu.checkoutpro.utils

import com.payu.base.models.InternalConfig
import com.payu.india.Model.PaymentDetailsForOffer
import com.payu.india.Model.UserDetailsForOffer
import com.payu.india.Model.validateOffer.ValidateOfferRequest
import com.payu.paymentparamhelper.PaymentParams
import org.json.JSONArray
import org.json.JSONObject

object V2ApRequestParser {

    internal fun getValidateOfferReq(
        payuBizparams: PaymentParams,
        offersKeyList: JSONArray?,
        sku: JSONObject?,
        userToken: String?,
        cardNumber: String?,
        cardToken: String?,
        category: String?,
        paymentCode: String?,
        isAutoApply: Boolean
    ): ValidateOfferRequest {
        val paymentDetails: PaymentDetailsForOffer =
            PaymentDetailsForOffer.Builder(category, paymentCode)
                .setVpa(payuBizparams.vpa)
                .setCardNumber(if (cardToken.isNullOrEmpty()) cardNumber else null)
                .setCardToken(cardToken)
                .setCardTokenType(payuBizparams.cardTokenType).build()
        val userDetailsBuilder =
            UserDetailsForOffer.Builder(userToken)
                .setEmail(payuBizparams.email)
                .setPhoneNo(payuBizparams.phone)
        if (InternalConfig.isUserPersonalizedOffersAvailable) {
            userDetailsBuilder.setLoggedInPhoneNumber(payuBizparams.loggedInPhoneNumber)
        }
        val userDetails: UserDetailsForOffer = userDetailsBuilder.build()
        return ValidateOfferRequest.Builder(payuBizparams.amount)
            .setOfferKey(offersKeyList)
            .setPaymentDetails(paymentDetails)
            .setuserDetails(userDetails)
            .setSkuDetails(sku?.toString())
            .setAutoApply(isAutoApply)
            .build()
    }
}