package com.payu.checkoutpro.reConverter


import com.payu.base.models.BnplOption
import com.payu.base.models.PaymentOption
import com.payu.base.models.PaymentType
import com.payu.checkoutpro.utils.CommonUtils
import com.payu.checkoutpro.utils.ParserUtils
import com.payu.checkoutpro.utils.PayUCheckoutProConstants
import com.payu.india.Model.QuickPay.QuickPaySavedOption
import com.payu.india.Model.QuickPay.RecommendedOptions
import com.payu.paymentparamhelper.PayuConstants

object BNPLPaymentModeConverter {

    fun getBNPLPaymentOption(quickPaySavedOption: QuickPaySavedOption): ArrayList<PaymentOption> {
        val savedPaymentOption = BnplOption()
        val optionDetail: ArrayList<PaymentOption> = ArrayList()
        val paymentModeMap = ParserUtils.paymentOptionMap[PaymentType.BNPL]
        if (paymentModeMap != null) {
            val paymentOption =
                paymentModeMap[quickPaySavedOption.ibiboCode] as? BnplOption
            if (paymentOption != null) {
                val list = quickPaySavedOption.pgTitle?.split("-")
                if (list?.size == 2) {
                    savedPaymentOption.bankName = list[0]
                } else {
                    savedPaymentOption.bankName = quickPaySavedOption.pgTitle
                }

                savedPaymentOption.isBankDown = quickPaySavedOption.isPgUP
                savedPaymentOption.paymentType = PaymentType.BNPL
                savedPaymentOption.phoneNumber = quickPaySavedOption.pgDetails
                savedPaymentOption.otherParams = CommonUtils.getOtherParamsMap(
                    PayuConstants.BANK_CODE,
                    quickPaySavedOption.ibiboCode
                )
                PaymentModeConverter.updateTaxValue(savedPaymentOption, PaymentType.BNPL)
//        savedPaymentOption.userCredential = quickPaySavedOption.userCredential
//        if (quickPaySavedOption.isTokenTxn)
                optionDetail.add(savedPaymentOption)
            }
        }
        return optionDetail

    }

    fun getREBNPLPaymentOption(recommendedOptions: RecommendedOptions): ArrayList<PaymentOption> {
        val optionDetails = ArrayList<PaymentOption>()
        val paymentModeMap = ParserUtils.paymentOptionMap[PaymentType.BNPL]
        if (paymentModeMap != null) {
            val paymentOption =
                paymentModeMap.get(recommendedOptions.ibiboCode) as? BnplOption
            if (paymentOption != null) {
                val option = (paymentOption).clone() as BnplOption
                option.isEligible = recommendedOptions.eligibilityCheck
                val othersParamMap = option.otherParams as? HashMap<String, String>
                if (othersParamMap?.get(PayUCheckoutProConstants.CP_BANK_CODE)
                        ?.isNotEmpty() == true
                ) {
                    if (option != null) {
                        optionDetails.add(option)
                    }
                }
            }
        }
        return optionDetails
    }


}