package com.payu.checkoutpro.models

import com.payu.base.models.OlwAPIResponse
import com.payu.base.models.PayUPaymentParams
import com.payu.checkoutpro.utils.AndroidUtils
import com.payu.checkoutpro.utils.OlwApiResponseParser
import com.payu.checkoutpro.utils.V2ApiHelper
import com.payu.india.Interfaces.V2ApiResponseListener
import com.payu.india.Model.ApiResponse
import com.payu.india.Model.Olw.SendOtpRequest
import com.payu.india.Model.Olw.VerifyMPinRequest
import com.payu.india.Payu.PayuConstants
import com.payu.india.Tasks.V2ApiTask
import com.payu.paymentparamhelper.PaymentParams
import org.json.JSONObject

class VerifyMPinApiObject(
    private val deviceId: String,
    private val mPin: String,
    private val walletIdentifier: String,
    private val bankCode: String,
    private val mobile: String,
    internal val payuBizParams: PaymentParams,
    payUPaymentParams: PayUPaymentParams,
    private val v2ApiResponseListener: (OlwAPIResponse?) -> Unit?
) : V2BaseApiObject(payUPaymentParams, payuBizParams),
    V2ApiResponseListener<ApiResponse<JSONObject>> {

    override fun callApi() {
        val sendOTpRequest =
            SendOtpRequest.Builder().setRequestDateTime(AndroidUtils.getRequestDateTimeFormat())
                .setClientTxnId(System.currentTimeMillis().toString()).setCustomerMobile("91$mobile")
                .build()
        val verifyMPinRequest =
            VerifyMPinRequest.Builder().setSendOtpRequest(sendOTpRequest).setMPin(mPin)
                .setDeviceId(deviceId).build()
        val v2ApiTask = V2ApiTask(payuBizparams.key, payuConfig)
        v2ApiTask.v2ApiCall(
            verifyMPinRequest.json,
            getHashName(),
            V2ApiHelper.getHeaderHashMap(walletIdentifier, bankCode),
            this,
            this
        )
    }

    override fun getHashName() = PayuConstants.PAYU_VERIFY_MPIN

    override fun onApiResponse(apiResponse: ApiResponse<JSONObject>?) {
        if (apiResponse?.payuResponse != null)
            v2ApiResponseListener.invoke(
                OlwApiResponseParser.getOlwParams(
                    apiResponse.payuResponse,
                    apiResponse.status
                )
            )
        else v2ApiResponseListener.invoke(null)
    }
}