package com.payu.checkoutpro.models

import android.text.TextUtils
import com.payu.base.models.PayUPaymentParams
import com.payu.checkoutpro.listeners.PayUInternalHashGenerationListener
import com.payu.checkoutpro.utils.CommonUtils
import com.payu.checkoutpro.utils.PayUCheckoutProConstants
import com.payu.india.Interfaces.HashCompletionListener
import com.payu.india.Interfaces.HashGenerationListener
import com.payu.paymentparamhelper.PaymentParams

abstract class V2BaseApiObject (
    protected val payUPaymentParams: Any, payuBizparams: PaymentParams) : BaseApiObject(payuBizparams),
    HashGenerationListener, PayUInternalHashGenerationListener {
    private var hashCompletionListener: HashCompletionListener? = null
    var startTime: Long = 0

    abstract fun callApi()
    abstract fun getHashName(): String
    override fun generateSignature(
        map: java.util.HashMap<String, String>?,
        hashCompletionListener: HashCompletionListener?
    ) {
        this.hashCompletionListener = hashCompletionListener
        val signingString = map?.get(PayUCheckoutProConstants.PAYU_SIGNING_STRING)
        signingString?.let { CommonUtils.setV2hashData(it,payUPaymentParams as PayUPaymentParams) }
        signingString?.let { CommonUtils.generateV2Hash(
                this
                ) }
    }

    override fun onHashGenerated(map: HashMap<String, String?>) {
        if (!TextUtils.isEmpty(map[getHashName()]))
            hashCompletionListener?.onSignatureGenerated(map)

    }
}