package com.payu.checkoutpro.models

import com.payu.checkoutpro.listeners.PayUInternalHashGenerationListener
import com.payu.paymentparamhelper.PaymentParams

abstract class V1BaseApiObject(
    payuBizparams: PaymentParams
) : BaseApiObject(payuBizparams), PayUInternalHashGenerationListener {
    abstract fun callApi(map: HashMap<String, String?>)
    abstract fun getHashName(): String

    override fun onHashGenerated(map: HashMap<String, String?>) {
        callApi(map)
    }
}