package com.payu.checkoutpro.models

import android.content.Context
import android.util.Log
import com.payu.base.models.ErrorResponse
import com.payu.base.models.PayUApiResponse
import com.payu.base.models.PayUPaymentParams
import com.payu.base.models.PaymentMode
import com.payu.base.models.QuickOptionsModel
import com.payu.checkoutpro.reConverter.PaymentModeConverter.prepareClwSodexoOptions
import com.payu.checkoutpro.utils.ApiResponseRepo
import com.payu.checkoutpro.utils.CPAnalyticsUtils
import com.payu.checkoutpro.utils.ParserUtils
import com.payu.checkoutpro.utils.PayUCheckoutProConstants.CP_DEVICE_ID
import com.payu.checkoutpro.utils.PayUCheckoutProConstants.CP_MOBILE_NUMBER
import com.payu.checkoutpro.utils.PayUCheckoutProConstants.CP_USERTOKEN
import com.payu.checkoutpro.utils.PayUCheckoutProConstants.QUICKPAY_EVENT
import com.payu.checkoutpro.utils.PayUCheckoutProConstants.REQUEST_TYPE
import com.payu.india.Interfaces.GlobalVaultListener
import com.payu.india.Model.PayuResponse
import com.payu.india.Model.QuickPay.QuickPayRequest
import com.payu.india.Payu.PayuConstants
import com.payu.india.Tasks.V2ApiTask
import com.payu.paymentparamhelper.PaymentParams

/**
 * The purpose of the class to handle Request call, Build request and response
 */
class QuickPayApiObject(
    private val context: Context,
    internal val payuBizParams: PaymentParams,
    payUPaymentParams: PayUPaymentParams,
    internal val map: HashMap<String, String>,
    private val onGVQuickPayListener: (QuickOptionsModel?) -> Unit?
) : V2BaseApiObject(payUPaymentParams, payuBizParams),
    GlobalVaultListener {

    private val TAG = this.javaClass.simpleName

    override fun getHashName() = QUICKPAY_EVENT

    private var v2ApiTask: V2ApiTask? = null

    override fun callApi() {
        Log.d(TAG, " callApi")

        val quickPayApiRequest =
            QuickPayRequest.Builder().setAmount(payuBizParams.amount.toDouble())
                .setPhone(map[CP_MOBILE_NUMBER]).setUserToken(map[CP_USERTOKEN])
                .setRequestId(payuBizparams.txnId+System.currentTimeMillis())
                .setRequestType(REQUEST_TYPE)
                .setDeviceId(map[CP_DEVICE_ID])
                .setUserCredential(payuBizParams.userCredentials)
                .build()
        startTime = System.currentTimeMillis()
        v2ApiTask = V2ApiTask(payuBizparams.key, payuConfig)
        v2ApiTask?.getQuickPayOptions(quickPayApiRequest, this, this)
    }

    override fun cancelQuickPayTask() {
        v2ApiTask?.cancelQuickPayTask()
    }


    override fun onQuickPayResponse(payuResponse: PayuResponse) {
        val timeTaken = System.currentTimeMillis() - startTime
        Log.d(TAG, "payuResponse test $payuResponse")
        ParserUtils.gvResponse = payuResponse
        ParserUtils.onGVQuickPayListener = onGVQuickPayListener

        val errorResponseHandler = {
            val quickOptionsModel = QuickOptionsModel().apply {
                errorResponse = onError(payuResponse)
                val quickOptionsList: ArrayList<PaymentMode> = ArrayList()
                prepareClwSodexoOptions(quickOptionsList)
                this.quickOptionsList = quickOptionsList
            }
            val payUGvResponse = PayUApiResponse(onGVQuickPayListener, false, quickOptionsModel)
            ApiResponseRepo.setGvResponse(payUGvResponse)
        }

        if (ParserUtils.isCheckOutCompleted) {
            if (payuResponse.responseStatus?.status.equals(
                    PayuConstants.SUCCESS,
                    ignoreCase = true
                )
            ) {
                CPAnalyticsUtils.logApiResponseSuccess(getHashName(), timeTaken, payuConfig.data)
                ParserUtils.prepareGvResponse(
                    context,
                    payuResponse.savedOption,
                    payuResponse.recommendedOptions,
                    onGVQuickPayListener
                )

            } else {
                CPAnalyticsUtils.logApiResponseFailure(getHashName(), timeTaken, payuResponse.responseStatus?.result, payuResponse.responseStatus?.code)
                errorResponseHandler.invoke()
            }
        }
    }

    private fun onError(payuResponse: PayuResponse): ErrorResponse {
        val errorResponse = ErrorResponse()
        errorResponse.errorMessage = payuResponse.responseStatus?.result
        errorResponse.errorCode = payuResponse.responseStatus?.code
        return errorResponse
    }
}