package com.payu.checkoutpro.models

import com.payu.base.models.PaymentState
import com.payu.base.models.PaymentType
import com.payu.checkoutpro.utils.ParserUtils
import com.payu.checkoutpro.utils.PayUCheckoutProConstants.CP_PAYMENT_TYPE
import com.payu.checkoutpro.utils.PayUCheckoutProConstants.ENFORCED_IBIBOCODE
import kotlin.collections.ArrayList
import kotlin.collections.HashMap

class NBManager(var enforceList: ArrayList<HashMap<String, String>>) : EnforcedHandler() {
    override fun getNextPaymentState(): PaymentState? {
        var paymentState: PaymentState? = null
        var isKeyEnforced: Boolean = false
        for (list in enforceList) {
            if (list[CP_PAYMENT_TYPE] == PaymentType.NB.name) {
                if (list[ENFORCED_IBIBOCODE] != null && list[ENFORCED_IBIBOCODE]!!.endsWith("ENCC") && ParserUtils.isSIMode) {
                    paymentState = PaymentState.BankDetails
                }
                isKeyEnforced = true
            } else
                continue
        }
        return if (isKeyEnforced) {
            paymentState// for NB non SI
        } else
            manager!!.getNextPaymentState()
    }
}