package com.payu.checkoutpro.models

import com.payu.base.listeners.OnEmiDetailsListener
import com.payu.base.models.ErrorResponse
import com.payu.checkoutpro.R
import com.payu.checkoutpro.layers.PayUbizApiLayer
import com.payu.checkoutpro.utils.CPAnalyticsUtils
import com.payu.checkoutpro.utils.ParserUtils
import com.payu.checkoutpro.utils.PayUCheckoutProConstants
import com.payu.india.Interfaces.EligibleBinsForEMIApiListener
import com.payu.india.Model.MerchantWebService
import com.payu.india.Model.PayuResponse
import com.payu.india.Payu.PayuConstants
import com.payu.india.Payu.PayuErrors
import com.payu.india.PostParams.MerchantWebServicePostParams
import com.payu.india.Tasks.EligibleBinsForEMITask
import com.payu.paymentparamhelper.PaymentParams

class EligibleBinsForEMIApiObject(
    payuBizparams: PaymentParams,
    listener: Any?,
    private val payUbizApiLayer: PayUbizApiLayer
) : V1BaseApiObject(payuBizparams), EligibleBinsForEMIApiListener {
    var emiDetailsListener = listener as? OnEmiDetailsListener
    private var startTime: Long = 0
    override fun callApi(map: HashMap<String, String?>) {
        emiDetailsListener?.showProgressDialog(true)
        payUbizApiLayer.isEmiDetailsApiInProgress = true

        val merchantWebService = MerchantWebService()
        merchantWebService.key = payuBizparams.key
        merchantWebService.command = PayUCheckoutProConstants.CP_ELIGIBLE_BINS_FOR_EMI
        merchantWebService.var1 = PayUCheckoutProConstants.CP_DEFAULT
        merchantWebService.hash = map[getHashName()]

        val postData =
            MerchantWebServicePostParams(merchantWebService).merchantWebServicePostParams

        if (postData.code == PayuErrors.NO_ERROR) { // ok we got the post params, let make an api call to payu to fetch the details
            payuConfig.data = postData.result

            val eligibleBinsForEMITask =
                EligibleBinsForEMITask(this)
            startTime = System.currentTimeMillis()
            eligibleBinsForEMITask.execute(payuConfig)
        } else {

            val errorResponse = ErrorResponse()
            errorResponse.errorMessage = postData.result
            emiDetailsListener?.showProgressDialog(false)
            emiDetailsListener?.onError(errorResponse)
        }
    }

    override fun getHashName() = PayUCheckoutProConstants.CP_ELIGIBLE_BINS_FOR_EMI

    private fun sendErrorResponse(errorCode: Int?, errorMessage: String?) {
        val errorResponse = ErrorResponse()
        errorResponse.errorMessage = errorMessage
        errorResponse.errorCode = errorCode
        emiDetailsListener?.showProgressDialog(false)
        emiDetailsListener?.onError(errorResponse)
    }

    override fun onEligibleBinsForEMIApiResponse(payuResponse: PayuResponse?) {
        val timeTaken = System.currentTimeMillis() - startTime
        payUbizApiLayer.isEmiDetailsApiInProgress = false
        if (payuResponse?.responseStatus?.status.equals(PayuConstants.SUCCESS, ignoreCase = true)) {
            val finalEmiList = ParserUtils.getEmiWithEligibleBins(payuResponse)
            if (finalEmiList.isNullOrEmpty()) {
                CPAnalyticsUtils.logApiResponseFailure(getHashName(), timeTaken, payUbizApiLayer.context.getString(R.string.payu_this_payment_option_currently_unavailable), payuResponse?.responseStatus?.code, payUbizApiLayer.context)
                sendErrorResponse(
                    PayUCheckoutProConstants.CP_DEFAULT_ERROR_CODE,
                    payUbizApiLayer.context.getString(R.string.payu_this_payment_option_currently_unavailable)
                )
            } else {
                CPAnalyticsUtils.logApiResponseSuccess(getHashName(), timeTaken, payuConfig.data, payUbizApiLayer.context.applicationContext)
                payUbizApiLayer.isEligibleBinsApiResponseReceived = true
                emiDetailsListener?.emiDetailsReceived(finalEmiList)
                emiDetailsListener?.showProgressDialog(false)
            }

        } else {
            CPAnalyticsUtils.logApiResponseFailure(getHashName(), timeTaken, payuResponse?.responseStatus?.result, payuResponse?.responseStatus?.code, payUbizApiLayer.context)
            sendErrorResponse(
                payuResponse?.responseStatus?.code,
                payuResponse?.responseStatus?.result
            )
        }
    }
}