package com.payu.checkoutpro.models

import android.content.Context
import com.payu.base.listeners.OnDeleteSavedOptionListener
import com.payu.base.models.ErrorResponse
import com.payu.checkoutpro.utils.CPAnalyticsUtils
import com.payu.india.Interfaces.DeleteTokenisedCardApiListener
import com.payu.india.Model.MerchantWebService
import com.payu.india.Model.PayuResponse
import com.payu.india.Payu.PayuConstants
import com.payu.india.Payu.PayuErrors
import com.payu.india.PostParams.MerchantWebServicePostParams
import com.payu.india.Tasks.DeleteTokenisedCardTask
import com.payu.paymentparamhelper.PaymentParams

class DeleteUserCardApiObject(
    private val context: Context,
    payuBizparams: PaymentParams,
    listener: Any?
) : V1BaseApiObject(payuBizparams), DeleteTokenisedCardApiListener {
    private var startTime: Long = 0
    private var onDeleteSavedOptionListener = listener as? OnDeleteSavedOptionListener
    override fun callApi(map: HashMap<String, String?>) {
        onDeleteSavedOptionListener?.showProgressDialog(true)

        val merchantWebService = MerchantWebService()
        merchantWebService.key = payuBizparams.key
        merchantWebService.command = PayuConstants.DELETE_TOKENISED_USER_CARD
        merchantWebService.var1 = payuBizparams.userCredentials
        merchantWebService.var2 = payuBizparams.cardToken
        merchantWebService.hash = map[getHashName()]

        val postData =
            MerchantWebServicePostParams(merchantWebService).merchantWebServicePostParams

        if (postData.code == PayuErrors.NO_ERROR) { // ok we got the post params, let make an api call to payu to fetch the payment related details
            payuConfig.data = postData.result

            val deleteCardTask =
                DeleteTokenisedCardTask(this)
            startTime = System.currentTimeMillis()
            deleteCardTask.execute(payuConfig)
        } else {

            val errorResponse = ErrorResponse()
            errorResponse.errorMessage = postData.result
            onDeleteSavedOptionListener?.showProgressDialog(false)
            onDeleteSavedOptionListener?.onError(errorResponse)
        }
    }

    override fun getHashName() = PayuConstants.DELETE_TOKENISED_USER_CARD

    private fun sendErrorResponse(errorCode: Int?, errorMessage: String?) {
        val errorResponse = ErrorResponse()
        errorResponse.errorMessage = errorMessage
        errorResponse.errorCode = errorCode
        onDeleteSavedOptionListener?.showProgressDialog(false)
        onDeleteSavedOptionListener?.onError(errorResponse)
    }

    override fun onDeleteTokenisedCardResponse(payuResponse: PayuResponse?) {
        val timeTaken = System.currentTimeMillis() - startTime
        if (payuResponse?.responseStatus?.status.equals(PayuConstants.SUCCESS, ignoreCase = true)) {
            CPAnalyticsUtils.logApiResponseSuccess(getHashName(), timeTaken, payuConfig.data, context)
            onDeleteSavedOptionListener?.onDeletedSuccessfully()
            onDeleteSavedOptionListener?.showProgressDialog(false)
        } else {
            CPAnalyticsUtils.logApiResponseFailure(getHashName(), timeTaken, payuResponse?.responseStatus?.result, payuResponse?.responseStatus?.code, context)
            sendErrorResponse(
                payuResponse?.responseStatus?.code,
                payuResponse?.responseStatus?.result
            )
        }

    }
}