package com.payu.checkoutpro.utils

import android.content.Context
import com.payu.base.models.BinBaseDetails
import com.payu.base.models.CardBinInfo
import com.payu.base.models.CardType
import com.payu.base.models.ConvenienceFeeCharges
import com.payu.base.models.DiscountDetailsofOffers
import com.payu.base.models.EMIOption
import com.payu.base.models.EmiType
import com.payu.base.models.FeeCombinations
import com.payu.base.models.OfferInfo
import com.payu.base.models.PayUPaymentParams
import com.payu.base.models.PayUUserDetail
import com.payu.base.models.PaymentOption
import com.payu.base.models.PaymentType
import com.payu.base.models.SKU
import com.payu.base.models.SelectedOfferInfo
import com.payu.checkoutpro.R
import com.payu.india.Model.ApiResponse
import com.payu.india.Model.CardInformation
import com.payu.india.Model.binBaseDetails.BinBaseDetailsResponse
import com.payu.india.Model.fetchConvenienceFee.FetchConvFeeCombinations
import com.payu.india.Model.validateOffer.ValidateOfferDetails
import com.payu.paymentparamhelper.PaymentParams

object V2ApiResponseParser {

    internal fun updateConvFeeResponse(convFeeMap: HashMap<String, FetchConvFeeCombinations>) {
        for ((key, value) in convFeeMap) {
            val keyArray = key.split("_")
            if (keyArray.size == 2) {
                val paymentTYpe = keyArray[0]
                val bankCode = keyArray[1]
                val payModeMap =
                    ParserUtils.paymentOptionMap[PaymentType.valueOf(paymentTYpe)] ?: mapOf()
                val paymentOption = payModeMap[bankCode.uppercase()] as? PaymentOption
                val convenienceFeeChargesList: ArrayList<ConvenienceFeeCharges> = ArrayList()
                value.convFeeCharges?.forEach { convFeeCharges ->
                    val convFeeChargeValues = ConvenienceFeeCharges(
                        convFeeCharges.chargeUuid,
                        convFeeCharges.chargeName,
                        convFeeCharges.baseFee,
                        convFeeCharges.taxAmount,
                        convFeeCharges.ruleId
                    )
                    convenienceFeeChargesList.add(convFeeChargeValues)
                }
                val feeCombinationsCharges = FeeCombinations(
                    value.combinationUUID,
                    value.requestUuid,
                    convenienceFeeCharges = convenienceFeeChargesList
                )
                paymentOption?.feeCombinations = feeCombinationsCharges
                if (paymentOption?.paymentType == PaymentType.UPI_INTENT) {
                    paymentOption.optionList?.forEach {
                        it.feeCombinations = feeCombinationsCharges
                    }
                }
            }
        }
    }

    internal fun parseValidateOfferResponse(
        payuPaymentParams: PayUPaymentParams,
        payuBizparams: PaymentParams,
        validateOfferDetails: ValidateOfferDetails?,
        binBaseDetails: BinBaseDetails
    ) {
        binBaseDetails.selectedOfferInfo =
            getSelectedOfferInfo(validateOfferDetails, payuPaymentParams, payuBizparams)
    }

    internal fun parseBinInfoResponse(
        context: Context?,
        payuPaymentParams: PayUPaymentParams,
        cardInfo: CardInformation,
        convFeeChargesMap: HashMap<String?, FetchConvFeeCombinations?>? = null,
        binBaseDetails: BinBaseDetails
    ) {
            val cardBinInfo = CardBinInfo()
            cardBinInfo.isDomestic = cardInfo.isDomestic ?: false
            cardBinInfo.cardScheme = CommonUtils.getCardScheme(cardInfo.cardType ?: "")
            cardBinInfo.cardType = CommonUtils.getCardType(cardInfo.cardCategory ?: "")
            cardBinInfo.issuingBank = cardInfo.issuingBank
            if (cardInfo.isBinLevel) {
                cardBinInfo.additionalCharge =
                    (cardInfo.convenienceFee?.toDoubleOrNull() ?: 0.0).plus(
                        cardInfo.gst?.toDoubleOrNull() ?: 0.0
                    )
                cardBinInfo.gstFlatValue = cardInfo.gst?.toDoubleOrNull() ?: 0.0
            } else cardBinInfo.additionalCharge = CommonUtils.getAdditionalChargesForCardBin(
                cardBinInfo, ParserUtils.convenienceFeeResponse
            )
            cardBinInfo.gstPercentageValue = CommonUtils.getGSTForCardBin(
                cardBinInfo, ParserUtils.convenienceFeeResponse
            )
            cardBinInfo.isSiSupported = cardInfo.isSiSupported ?: false
            if (payuPaymentParams.payUSIParams != null) {
                if (cardBinInfo.isSiSupported) cardBinInfo.isBankDown =
                    CommonUtils.getBankDownStatusForCards(cardBinInfo.issuingBank ?: "")
            } else {
                cardBinInfo.isBankDown =
                    CommonUtils.getBankDownStatusForCards(cardBinInfo.issuingBank ?: "")
            }
            cardBinInfo.cardCategory = cardInfo.cardType
            val map: HashMap<String, Any?> = HashMap()
            map[PayUCheckoutProConstants.CP_PAYMENT_TYPE] = PaymentType.CARD.name
            map[PayUCheckoutProConstants.CP_CARD_TYPE] = cardBinInfo.cardType?.name
            map[PayUCheckoutProConstants.CP_CARD_SCHEME] = cardBinInfo.cardScheme?.name
            if (cardBinInfo.cardType != null && !CommonUtils.isKeyEnforced(map)) {
                cardBinInfo.message = context?.getString(R.string.payu_payment_mode_is_not_allowed)
            }
            cardBinInfo.emiOption = getEmiOption(cardBinInfo)
            cardBinInfo.bankCode = cardInfo.bankCode
            binBaseDetails.cardBinInfo = cardBinInfo
            binBaseDetails.feeCombinations = getPricingInfoResponseForBin(convFeeChargesMap)
            updatePricingInfoResponseForBin(cardBinInfo.bankCode, convFeeChargesMap)

    }

    private fun getEmiOption(cardBinInfo: CardBinInfo): EMIOption? {
        if (ParserUtils.emiList != null && ParserUtils.emiList?.isNotEmpty() == true && cardBinInfo.cardType == CardType.CC) {
            for (option in ParserUtils.emiList ?: arrayListOf()) {
                if ((option as? EMIOption)?.emiType != EmiType.CC) continue
                for (emiOption in option.optionList ?: arrayListOf()) {
                    if ((emiOption as? EMIOption)?.bankShortName?.equals(cardBinInfo.issuingBank) == true) {
                        return emiOption
                    }
                }
            }
        }
        return null
    }

    private fun getPricingInfoResponseForBin(
        convFeeMap: HashMap<String?, FetchConvFeeCombinations?>?
    ): FeeCombinations? {
        val convenienceFeeChargesList: ArrayList<ConvenienceFeeCharges> = ArrayList()

        convFeeMap?.forEach {
            val value = it.value
            value?.convFeeCharges?.forEach { convFeeCharges ->
                val convFeeChargeValues = ConvenienceFeeCharges(
                    convFeeCharges.chargeUuid,
                    convFeeCharges.chargeName,
                    convFeeCharges.baseFee,
                    convFeeCharges.taxAmount,
                    convFeeCharges.ruleId
                )
                convenienceFeeChargesList.add(convFeeChargeValues)
            }
            return FeeCombinations(
                value?.combinationUUID.toString(),
                value?.requestUuid.toString(),
                convenienceFeeCharges = convenienceFeeChargesList
            )
        }
        return null
    }

    internal fun getSelectedOfferInfo(
        validateOfferDetails: ValidateOfferDetails?,
        payuPaymentParams: PayUPaymentParams,
        payuBizparams: PaymentParams
    ): SelectedOfferInfo {
        if (validateOfferDetails != null) {
            var isAutoApply = false
            var isNoCostEmiOffer = false
            val offerMap = HashMap<String, OfferInfo>()
            val validateOfferDetailsList = validateOfferDetails.validateOfferInfo ?: listOf()
            for (validateOfferDetailsResponse in validateOfferDetailsList) {
                if (validateOfferDetailsResponse != null && validateOfferDetailsResponse.isValid) {
                    val discountDetails = DiscountDetailsofOffers(
                        validateOfferDetailsResponse.offerPercentage,
                        null,
                        validateOfferDetailsResponse.discountDetails?.discountType,
                        validateOfferDetailsResponse.discountDetails?.discount,
                        validateOfferDetailsResponse.discountDetails?.discountedAmount
                    )
                    var payuUserDetail: PayUUserDetail? = null
                    validateOfferDetailsResponse.userDetails?.let {
                        payuUserDetail = PayUUserDetail (firstName = it.firstName, phoneNo = it.phoneNo, email = it.email)
                    }
                    val offerInfo = OfferInfo(
                        null,
                        validateOfferDetailsResponse.type,
                        validateOfferDetailsResponse.offerKey,
                        validateOfferDetailsResponse.title,
                        validateOfferDetailsResponse.description,
                        validateOfferDetailsResponse.tnc,
                        validateOfferDetailsResponse.tncLink,
                        validateOfferDetailsResponse.minTxnAmount,
                        validateOfferDetailsResponse.maxTxnAmount,
                        validateOfferDetailsResponse.offerType,
                        validateOfferDetailsResponse.validFrom,
                        validateOfferDetailsResponse.validTo,
                        validateOfferDetailsResponse.isNoCostEmi,
                        validateOfferDetailsResponse.isSkuOffer,
                        validateOfferDetailsResponse.isAllPaymentMethodsAvailable,
                        discountDetails,
                        null,
                        null,
                        null,
                        null,
                        null,
                        null,
                        null,
                        toDisplay = validateOfferDetailsResponse.isToDisplay,
                        isUserVerificationRequired = validateOfferDetailsResponse.isUserVerificationRequired,
                        userDetail = payuUserDetail
                    )
                    if (validateOfferDetailsResponse.isNoCostEmi) isNoCostEmiOffer =
                        validateOfferDetailsResponse.isNoCostEmi
                    offerMap[validateOfferDetailsResponse.offerKey] = offerInfo

                }
            }
            val skuOfferList = validateOfferDetails.skuOfferDetailsList
            if (!skuOfferList.isNullOrEmpty()) {
                for (skuOffer in skuOfferList) {
                    if (skuOffer != null && skuOffer.isValid) {
                        val sku = skuOffer.sku
                        payuPaymentParams.skuDetails?.skus?.forEach { skuParam ->
                            if (sku.skuId == skuParam.skuId) sku?.name = skuParam.skuName
                        }
                        isAutoApply = sku.isAutoApplyOffer
                        val skus = SKU(
                            sku.quantity,
                            sku.skuAmount,
                            sku.skuId,
                            sku.name,
                            autoApplyOffer = sku.isAutoApplyOffer
                        )

                        for (validateOfferInfo in skuOffer.validateOfferInfoList) {
                            val discountDetails = DiscountDetailsofOffers(
                                validateOfferInfo.offerPercentage,
                                null,
                                validateOfferInfo.discountDetails?.discountType,
                                validateOfferInfo.discountDetails?.discount,
                                validateOfferInfo.discountDetails?.discountedAmount
                            )
                            var payuUserDetail: PayUUserDetail? = null
                            validateOfferInfo.userDetails?.let {
                                payuUserDetail = PayUUserDetail (firstName = it.firstName, phoneNo = it.phoneNo, email = it.email)
                            }

                            val offerInfo = OfferInfo(
                                skus,
                                validateOfferInfo.type,
                                validateOfferInfo.offerKey,
                                validateOfferInfo.title,
                                validateOfferInfo.description,
                                validateOfferInfo.tnc,
                                validateOfferInfo.tncLink,
                                validateOfferInfo.minTxnAmount,
                                validateOfferInfo.maxTxnAmount,
                                validateOfferInfo.offerType,
                                validateOfferInfo.validFrom,
                                validateOfferInfo.validTo,
                                validateOfferInfo.isNoCostEmi,
                                validateOfferInfo.isSkuOffer,
                                validateOfferInfo.isAllPaymentMethodsAvailable,
                                discountDetails,
                                null,
                                null,
                                null,
                                null,
                                null,
                                null,
                                null,
                                toDisplay = validateOfferInfo.isToDisplay,
                                isUserVerificationRequired = validateOfferInfo.isUserVerificationRequired,
                                userDetail = payuUserDetail
                            )
                            if (validateOfferInfo.isNoCostEmi) isNoCostEmiOffer =
                                validateOfferInfo.isNoCostEmi
                            offerMap[validateOfferInfo.offerKey + skus.skuId] = offerInfo
                        }
                    }
                }
            }
            if (offerMap.isNotEmpty()) {
                payuBizparams.offerKey = null
                offerMap.keys.forEach {
                    if (payuBizparams.offerKey.isNullOrEmpty()) payuBizparams.offerKey = it
                    else payuBizparams.offerKey += ",$it"
                }
                if (validateOfferDetails.isAutoApply) isAutoApply = true
                val selectedOfferInfo = (SelectedOfferInfo(
                    validateOfferDetails.amount,
                    validateOfferDetails.totalCashbackDiscount,
                    validateOfferDetails.totalInstantDiscount,
                    validateOfferDetails.totalDiscountedAmount,
                    validateOfferDetails.skuOfferDetailsList != null,
                    isAutoApply,
                    isNoCostEmiOffer,
                    true,
                    isValid = true,
                    offerMap,
                    failureReason = validateOfferDetails.failureReason
                ))
                return selectedOfferInfo
            } else {
                val selectedOfferInfo = SelectedOfferInfo(
                    validateOfferDetails.amount,
                    validateOfferDetails.totalCashbackDiscount,
                    validateOfferDetails.totalInstantDiscount,
                    validateOfferDetails.totalDiscountedAmount,
                    isValid = validateOfferDetails.isValid,
                    isValidated = true,
                    offerMap = null,
                    failureReason = validateOfferDetails.failureReason
                )
                return selectedOfferInfo
            }

        } else {
            return SelectedOfferInfo(
                payuPaymentParams.amount?.toDoubleOrNull(),
                null,
                null,
                null,
                isValidated = true,
                isValid = false,
                offerMap = null
            )
        }
    }

    internal fun parseValidateOfferResponse(
        payuPaymentParams: PayUPaymentParams,
        payuBizparams: PaymentParams,
        binBaseDetailsResp: ApiResponse<BinBaseDetailsResponse>?,
        binBaseDetails: BinBaseDetails
    ) {
        val validateOfferDetails = binBaseDetailsResp?.payuResponse?.validateOfferDetails
        binBaseDetails.selectedOfferInfo =
            getSelectedOfferInfo(validateOfferDetails, payuPaymentParams, payuBizparams)
    }

    private fun updatePricingInfoResponseForBin(
        key: String?, convFeeMap: HashMap<String?, FetchConvFeeCombinations?>?
    ): FeeCombinations? {
        val convenienceFeeChargesList: ArrayList<ConvenienceFeeCharges> = ArrayList()
        convFeeMap?.get(key)?.let { value ->
            value.convFeeCharges?.forEach { convFeeCharges ->
                val convFeeChargeValues = ConvenienceFeeCharges(
                    convFeeCharges.chargeUuid,
                    convFeeCharges.chargeName,
                    convFeeCharges.baseFee,
                    convFeeCharges.taxAmount,
                    convFeeCharges.ruleId
                )
                convenienceFeeChargesList.add(convFeeChargeValues)
            }
            return FeeCombinations(
                value.combinationUUID,
                value.requestUuid,
                convenienceFeeCharges = convenienceFeeChargesList
            )
        }
        return null
    }
}