package com.payu.checkoutpro.utils

import android.annotation.SuppressLint
import android.app.Activity
import android.app.AlertDialog
import android.graphics.Color
import android.os.Looper
import android.webkit.WebView
import android.widget.ImageView
import android.widget.TextView
import androidx.appcompat.app.AppCompatActivity
import androidx.core.content.ContextCompat
import androidx.fragment.app.Fragment
import com.payu.base.listeners.BaseTransactionListener
import com.payu.base.models.ErrorResponse
import com.payu.base.models.InternalConfig
import com.payu.base.models.PaymentOption
import com.payu.base.models.PaymentType
import com.payu.base.models.PayuToolbar
import com.payu.base.models.UPIOption
import com.payu.checkoutpro.R
import com.payu.checkoutpro.models.PayUCheckoutProConfig
import com.payu.checkoutpro.models.PayuSdk
import com.payu.checkoutpro.utils.PayUCheckoutProConstants.CP_HASH_NAME
import com.payu.checkoutpro.utils.PayUCheckoutProConstants.CP_HASH_STRING
import com.payu.checkoutpro.utils.PayUCheckoutProConstants.CP_PPSDKLES
import com.payu.custombrowser.Bank
import com.payu.custombrowser.CustomBrowser
import com.payu.custombrowser.PayUCustomBrowserCallback
import com.payu.custombrowser.bean.CustomBrowserConfig
import com.payu.india.Model.PayuConfig
import com.payu.india.Payu.PayuConstants
import com.payu.otpassist.PayUOtpAssist
import com.payu.otpassist.PayUOtpAssistConfig
import com.payu.otpassist.listeners.PayUHashGenerationListener
import com.payu.otpassist.listeners.PayUOtpAssistCallback
import com.payu.otpassist.models.PayUAcsRequest
import com.payu.paymentparamhelper.PaymentParams
import com.payu.phonepe.PhonePe
import com.payu.phonepe.callbacks.PayUPhonePeCallback
//import com.payu.threeDS2.PayU3DS2
//import com.payu.threeDS2.config.PayU3DS2Config
//import com.payu.threedsbase.constants.PayU3DS2ErrorConstants
//import com.payu.threedsbase.interfaces.listeners.PayUHashGeneratedListener
//import com.payu.threedsui.interfaces.listeners.PayU3DS2PaymentCallback
import com.payu.ui.SdkUiInitializer
import com.payu.ui.model.listeners.PayUCheckoutProListener


class PaymentHelper {

    private var payUCustomBrowser: Bank? = null
    private var payUAcsRequest: PayUAcsRequest? = null


    /**
     * Function to call Custom Browser for making payment
     * @param payuConfig contains postdata for CB
     * */
    fun callCB(
        context: Activity,
        paymentOption: PaymentOption,
        baseTransactionListener: BaseTransactionListener?,
        payuConfig: PayuConfig,
        toolbar: PayuToolbar?,
        payUCheckoutProConfig: PayUCheckoutProConfig,
        paymentParams: PaymentParams
    ): Fragment? {

        var txnId = ""
        var merchantKey = ""
        var viewPortWide = false
        val url =
            if (payuConfig.environment == PayuConstants.PRODUCTION_ENV) PayuConstants.PRODUCTION_PAYMENT_URL else PayuConstants.TEST_PAYMENT_URL
        var list: Array<String>? = null
        if (payuConfig.data != null) list = payuConfig.data.split("&").toTypedArray()

        if (list != null) {
            for (item in list) {
                val items = item.split("=").toTypedArray()
                if (items.size >= 2) {
                    when (items[0]) {
                        "txnid" -> txnId = items[1]
                        "key" -> merchantKey = items[1]
                        "pg" -> if (items[1].contentEquals("NB")) {
                            viewPortWide = true
                        }
                    }
                }
            }
        }
        //Sets the configuration of custom browser
        val customBrowserConfig = CustomBrowserConfig(merchantKey, txnId)
        customBrowserConfig.merchantCheckoutActivityPath =
            "com.payu.ui.view.activities.CheckoutActivity"
        customBrowserConfig.setViewPortWideEnable(viewPortWide)
        customBrowserConfig.setAutoApprove(payUCheckoutProConfig.autoApprove) // set true to automatically approve the OTP
        customBrowserConfig.setAutoSelectOTP(payUCheckoutProConfig.autoSelectOtp) // set true to automatically select the OTP flow
        customBrowserConfig.merchantName = payUCheckoutProConfig.merchantName
        customBrowserConfig.userCredential = paymentParams.userCredentials
        customBrowserConfig.firstName = paymentParams.firstName
        customBrowserConfig.phoneNumber = paymentParams.phone
        customBrowserConfig.merchantKey = paymentParams.key
        customBrowserConfig.oneClickPayBankCodes = InternalConfig.oneClickPayBankCodes
        customBrowserConfig.email = paymentParams.email
        customBrowserConfig.primaryColor = payUCheckoutProConfig.primaryColor
        customBrowserConfig.baseTextColor = payUCheckoutProConfig.baseTextColor
        customBrowserConfig.isProduction = ParserUtils.isProdEnvironment

        //Set below flag to true to disable the default alert dialog of Custom Browser and use your custom dialog
        customBrowserConfig.setDisableBackButtonDialog(!payUCheckoutProConfig.showExitConfirmationOnPaymentScreen)

        //Set it to true to enable run time permission dialog to appear for all Android 6.0 and above devices
        customBrowserConfig.setMerchantSMSPermission(payUCheckoutProConfig.merchantSmsPermission)

        /**
         * Maximum number of times the SurePay dialog box will prompt the user to retry a transaction in case of network failures
         * Setting the sure pay count to 0, diables the sure pay dialog
         */
        customBrowserConfig.enableSurePay = payUCheckoutProConfig.surePayCount
        customBrowserConfig.merchantResponseTimeout = payUCheckoutProConfig.merchantResponseTimeout
//        customBrowserConfig.isActionBarPresent = paymentOption.isQuickPayTxn

        //Set the issuerUrl and issuerPostData to open in WebView for otp assist redirection to bank page
        if (!payUAcsRequest?.issuerUrl.isNullOrEmpty() && !payUAcsRequest?.issuerPostData.isNullOrEmpty()) {
            customBrowserConfig.postURL = payUAcsRequest?.issuerUrl
            customBrowserConfig.payuPostData = payUAcsRequest?.issuerPostData

        } else if (!payUAcsRequest?.acsTemplate.isNullOrEmpty()) {
            customBrowserConfig.htmlData = payUAcsRequest?.acsTemplate
            customBrowserConfig.payuPostData = payUAcsRequest?.issuerPostData
        } else {
            //Set the first url to open in WebView
            customBrowserConfig.postURL = url
            customBrowserConfig.payuPostData = payuConfig.data
        }
        customBrowserConfig.isProtectedScreen =
            payUCheckoutProConfig.isProtectedScreen

        if (toolbar != null) {
            customBrowserConfig.toolbarTitle = toolbar.title
            val toolbarView = context.layoutInflater.inflate(R.layout.payu_layout_toolbar, null)
            customBrowserConfig.toolBarView = toolbarView

            val title = toolbarView.findViewById<TextView>(R.id.tvPayText)
            title.text = toolbar.title
            title.setTextColor(toolbar.textColor)
            title.alpha = 0.8f
            toolbarView.setBackgroundColor(toolbar.bgColor)

            val backNavigation = toolbarView.findViewById<ImageView>(R.id.ivLeftArrow)
            backNavigation.setColorFilter(toolbar.textColor)
            backNavigation.setOnClickListener {
                if (payUCheckoutProConfig.showExitConfirmationOnPaymentScreen)
                    payUCustomBrowser?.showBackButtonDialog()
                else {
                    backApproved(baseTransactionListener)
                }
            }
//            val orderDetails = toolbarView.findViewById<ImageView>(R.id.ivOrderDetails)
//            orderDetails.setOnClickListener {
//                //TODO Handle view details click
//            }
        }

        val payUCustomBrowserCallback = object : PayUCustomBrowserCallback() {

            override fun onPaymentSuccess(payuResponse: String?, merchantResponse: String?) {
                paymentSuccess(payuResponse, merchantResponse, baseTransactionListener)
            }

            override fun onPaymentFailure(payuResponse: String?, merchantResponse: String?) {
                paymentFailed(payuResponse, merchantResponse, baseTransactionListener)
            }

            override fun setCBProperties(webview: WebView?, payUCustomBrowser: Bank?) {
                baseTransactionListener?.setWebViewProperties(webview, payUCustomBrowser)
                this@PaymentHelper.payUCustomBrowser = payUCustomBrowser
            }

            override fun onPaymentTerminate() {
            }

            override fun onBackButton(alertDialogBuilder: AlertDialog.Builder?) {
                if (null == alertDialogBuilder) {
                    backApproved(baseTransactionListener)
                }
            }

            override fun onBackApprove() {
                backApproved(baseTransactionListener)
            }

            override fun onCBErrorReceived(code: Int, errormsg: String?) {
                val errorResponse = ErrorResponse()
                errorResponse.errorCode = code
                errorResponse.errorMessage = errormsg
                baseTransactionListener?.onError(errorResponse)
            }

        }

        if (paymentOption is UPIOption && paymentOption.paymentType == PaymentType.UPI_INTENT) {
            customBrowserConfig.packageNameForSpecificApp = paymentOption.packageName
            customBrowserConfig.disableIntentSeamlessFailure = CustomBrowserConfig.ENABLE
        }
        customBrowserConfig.isActionBarPresent = !paymentOption.isQuickPayTxn
        if (ParserUtils.retryCount > 0)
            customBrowserConfig.payuPostData =
                customBrowserConfig.payuPostData.plus(PayUCheckoutProConstants.CP_RETRY_SDK)

        customBrowserConfig.setEnableSslDialog(payUCheckoutProConfig.enableSslDialog)
        return CustomBrowser().addSeamlessCustomBrowser(
            customBrowserConfig,
            payUCustomBrowserCallback, context
        )
    }

    private fun backApproved(baseTransactionListener: BaseTransactionListener?) {
        baseTransactionListener?.showProgressDialog(false)
        baseTransactionListener?.onPaymentCancel()
        InternalConfig.selectedOfferInfo?.let { InternalConfig.selectedOfferInfo = null }
        InternalConfig.userSelectedOfferInfo?.let { InternalConfig.userSelectedOfferInfo = null }
    }

    private fun paymentSuccess(
        payuResponse: String?,
        merchantResponse: String?,
        baseTransactionListener: BaseTransactionListener?
    ) {
        InternalConfig.selectedOfferInfo?.let { InternalConfig.selectedOfferInfo = null }
        InternalConfig.userSelectedOfferInfo?.let { InternalConfig.userSelectedOfferInfo = null }
        val responseMap: HashMap<String, String?> = HashMap()
        responseMap[PayUCheckoutProConstants.CP_PAYU_RESPONSE] = payuResponse
        responseMap[PayUCheckoutProConstants.CP_MERCHANT_RESPONSE] = merchantResponse
        baseTransactionListener?.showProgressDialog(false)
        baseTransactionListener?.onPaymentSuccess(responseMap)
    }

    private fun paymentFailed(
        payuResponse: String?,
        merchantResponse: String?,
        baseTransactionListener: BaseTransactionListener?
    ) {
        val responseMap: HashMap<String, String?> = HashMap()
        responseMap[PayUCheckoutProConstants.CP_PAYU_RESPONSE] = payuResponse
        responseMap[PayUCheckoutProConstants.CP_MERCHANT_RESPONSE] = merchantResponse
        baseTransactionListener?.showProgressDialog(false)
        InternalConfig.selectedOfferInfo?.let { InternalConfig.selectedOfferInfo = null }
        InternalConfig.userSelectedOfferInfo?.let { InternalConfig.userSelectedOfferInfo = null }
        val retryCount = ParserUtils.retryCount
        if (retryCount > 0) {
            ParserUtils.isRetryTxn = true
            ParserUtils.apiLayer?.fetchOfferDetailsApiObject?.getOfferDetailsForRetry()
            InternalConfig.isRetryTxn = true
            ParserUtils.enforcePaymentList = null
            baseTransactionListener?.loadRetryPaymentOption()
            ParserUtils.retryCount = retryCount - 1
        } else {
            baseTransactionListener?.onPaymentFailure(responseMap)
        }
    }

    fun callPhonePeSDK(
        context: Activity,
        baseTransactionListener: BaseTransactionListener?,
        postData: String
    ): Fragment? { // Returning fragment is done because of dexguard(seems dexguard is removing this method when obfuscating)
        val action = {
            val payuPhonePeCallBack = object : PayUPhonePeCallback() {
                override fun onPaymentOptionFailure(
                    payuResponse: String?,
                    merchantResponse: String?
                ) {
                    paymentFailed(payuResponse, merchantResponse, baseTransactionListener)
                }

                override fun onPaymentOptionSuccess(
                    payuResponse: String?,
                    merchantResponse: String?
                ) {
                    paymentSuccess(payuResponse, merchantResponse, baseTransactionListener)
                }

                override fun onBackApprove() {
                    backApproved(baseTransactionListener)
                }
            }

            PhonePe.getInstance().makePayment(payuPhonePeCallBack, context, postData, false, null)
        }
        if (Looper.myLooper() == Looper.getMainLooper()) {
            action.invoke()
        } else {
            context.runOnUiThread {
                action.invoke()
            }
        }
        return null // This is done because of dexguard(seems dexguard is removing this method when obfuscating)
    }

    @SuppressLint("ResourceType")
    fun callOtpAssist(
        context: Activity,
        pamentOption: PaymentOption,
        baseTransactionListener: BaseTransactionListener?,
        checkoutListener: PayUCheckoutProListener?,
        payuConfig: PayuConfig,
        toolbar: PayuToolbar?,
        payUCheckoutProConfig: PayUCheckoutProConfig,
        paymentParams: PaymentParams
    ): Fragment {
        val otpAssistCallback = object : PayUOtpAssistCallback() {
            override fun generateHash(
                map: HashMap<String, String?>,
                hashGenerationListener: PayUHashGenerationListener
            ) {
                checkoutListener?.generateHash(
                    map,
                    object : com.payu.ui.model.listeners.PayUHashGenerationListener {
                        override fun onHashGenerated(map: HashMap<String, String?>) {
                            hashGenerationListener.onHashGenerated(map)
                        }

                    })
            }

            override fun onError(errorCode: String?, errorMessage: String?) {
                InternalConfig.selectedOfferInfo?.let { InternalConfig.selectedOfferInfo = null }
                InternalConfig.userSelectedOfferInfo?.let {
                    InternalConfig.userSelectedOfferInfo = null
                }
                val errorResponse = ErrorResponse()
                errorResponse.errorCode = errorCode!!.toInt()
                errorResponse.errorMessage = errorMessage
                baseTransactionListener?.onError(errorResponse)
            }

            override fun onPaymentFailure(merchantResponse: String?, payUResponse: String?) {
                paymentFailed(payUResponse, merchantResponse, baseTransactionListener)
            }

            override fun onPaymentSuccess(merchantResponse: String?, payUResponse: String?) {
                paymentSuccess(payUResponse, merchantResponse, baseTransactionListener)

            }

            override fun shouldHandleFallback(payUAcsRequest: PayUAcsRequest): Boolean {
                this@PaymentHelper.payUAcsRequest = payUAcsRequest
                baseTransactionListener?.loadNextState(
                    callCB(
                        context,
                        pamentOption,
                        baseTransactionListener,
                        payuConfig,
                        toolbar,
                        payUCheckoutProConfig,
                        paymentParams
                    )
                )
                return false
            }

            override fun onPaymentInitiate(response: String?) {
            }
        }
        val payUOtpAssistConfig = PayUOtpAssistConfig()

        payUOtpAssistConfig.shouldAllowAutoSubmit = payUCheckoutProConfig.autoApprove
        payUOtpAssistConfig.postData = payuConfig.data
        payUOtpAssistConfig.shouldShowMerchantSummary = false
        payUOtpAssistConfig.merchantLogo =
            payUCheckoutProConfig.merchantLogo?.let { ContextCompat.getDrawable(context, it) }
        payUOtpAssistConfig.waitingTime = payUCheckoutProConfig.waitingTime.toLong()
        payUOtpAssistConfig.merchantResponseTimeout =
            payUCheckoutProConfig.merchantResponseTimeout.toLong()
        if (!SdkUiInitializer.apiLayer?.config?.primaryColor.isNullOrEmpty() &&
            HexCodeColorValidator.validate(SdkUiInitializer.apiLayer?.config?.primaryColor)
        ) {
            payUOtpAssistConfig.primaryColor =
                Color.parseColor(SdkUiInitializer.apiLayer?.config?.primaryColor)
        }

        payUOtpAssistConfig.shouldShowSecureWebView = pamentOption.isSecureWebview
        payUOtpAssistConfig.isSdkLessFlow = paymentParams.bankCode.equals(
            CP_PPSDKLES, ignoreCase = false)
        payUOtpAssistConfig.isProduction = (payuConfig.environment == 0)
        payUOtpAssistConfig.isProtectedScreen =
            payUCheckoutProConfig.isProtectedScreen

        return PayUOtpAssist.openSeamless(
            context,
            otpAssistCallback, payUOtpAssistConfig
        )
    }

//    internal fun call3dsSDK(
//        paymentOption: PaymentOption,
//        payuConfig: PayuConfig,
//        payUCheckoutProConfig: PayUCheckoutProConfig,
//        payuToolbar: PayuToolbar?,
//        context: AppCompatActivity,
//        paymentParams: PaymentParams,
//        checkoutListener: PayUCheckoutProListener?,
//        baseTransactionListener: BaseTransactionListener?
//    ) {
//        val action = {
//            val config = PayU3DS2Config()
//            config.fallback3DS1 = false
//            config.autoRead = payUCheckoutProConfig.autoSelectOtp
//            config.autoSubmit = payUCheckoutProConfig.autoApprove
//            PayU3DS2.initiatePayment(
//                context,
//                config,
//                paymentParams,
//                object : PayU3DS2PaymentCallback {
//                    override fun generateHash(
//                        map: HashMap<String, String>,
//                        hashGenerationListener: PayUHashGeneratedListener
//                    ) {
//                        val map3ds = HashMap<String, String?>()
//                        map3ds[CP_HASH_STRING] = map[CP_HASH_STRING]
//                        map3ds[CP_HASH_NAME] = map[CP_HASH_NAME]
//                        val hashName = map[CP_HASH_NAME]
//                        checkoutListener?.generateHash(map3ds, object :
//                            com.payu.ui.model.listeners.PayUHashGenerationListener {
//                            override fun onHashGenerated(map: HashMap<String, String?>) {
//                                val hashMap3ds = HashMap<String, String>()
//                                if (!hashName.isNullOrEmpty() && !map[hashName].isNullOrEmpty())
//                                    hashMap3ds[hashName] = map[hashName]!!
//                                hashGenerationListener.onHashGenerated(hashMap3ds)
//                            }
//                        })
//                    }
//
//                    override fun onError(errorCode: Int, errorMessage: String) {
//                        if (errorCode == PayU3DS2ErrorConstants.BIN_INFO_API_CARD_NOT_SUPPORTED_ERROR_CODE)
//                            call3dsFallback(
//                                paymentOption,
//                                payuConfig,
//                                payUCheckoutProConfig,
//                                payuToolbar,
//                                context,
//                                baseTransactionListener,
//                                checkoutListener,
//                                paymentParams
//                            )
//                        else {
//                            val errorResponse = ErrorResponse()
//                            errorResponse.errorCode = errorCode
//                            errorResponse.errorMessage = errorMessage
//                            baseTransactionListener?.onError(errorResponse)
//                        }
//                    }
//
//                    override fun onPaymentCancel(isTxnInitiated: Boolean) {
//                        baseTransactionListener?.onPaymentCancel()
//                    }
//
//                    override fun onPaymentFailure(failureResponse: Any) {
//                        paymentFailed(failureResponse.toString(), "", baseTransactionListener)
//                    }
//
//                    override fun onPaymentSuccess(successResponse: Any) {
//                        paymentSuccess(successResponse.toString(), "", baseTransactionListener)
//                    }
//
//
//                })
//        }
//        if (Looper.myLooper() == Looper.getMainLooper()) {
//            action.invoke()
//        } else {
//            context.runOnUiThread {
//                action.invoke()
//            }
//        }
//    }

//    private fun call3dsFallback(
//        paymentOption: PaymentOption,
//        payuConfig: PayuConfig,
//        payUCheckoutProConfig: PayUCheckoutProConfig,
//        toolbar: PayuToolbar?,
//        context: AppCompatActivity,
//        baseTransactionListener: BaseTransactionListener?,
//        checkoutListener: PayUCheckoutProListener?,
//        paymentParams: PaymentParams
//    ) {
//        if (CommonUtils.isSdkAvailable(
//                PayuSdk.OTP_ASSIST.getClassName()
//            )
//        ) baseTransactionListener?.loadNextState(
//            callOtpAssist(
//                context,
//                paymentOption!!,
//                baseTransactionListener,
//                checkoutListener,
//                payuConfig!!,
//                toolbar!!,
//                payUCheckoutProConfig!!,
//                paymentParams
//            )
//        )
//        else
//            baseTransactionListener?.loadNextState(
//                callCB(
//                    context,
//                    paymentOption!!,
//                    baseTransactionListener,
//                    payuConfig!!,
//                    toolbar,
//                    payUCheckoutProConfig!!,
//                    paymentParams
//                )
//            )
//    }
}