package com.payu.checkoutpro.utils

import com.payu.base.models.OlwAPIResponse
import com.payu.base.models.SetMPinResponse
import com.payu.india.Payu.PayuConstants
import org.json.JSONObject

object OlwApiResponseParser {

    internal fun getOlwParams(jsonObject: JSONObject, status: Int): OlwAPIResponse {
        if (status == 200) {
            val responseMessage = jsonObject.optString(PayUCheckoutProConstants.CP_RESPONSE_MESSAGE)
            val responseCode = jsonObject.optString(PayUCheckoutProConstants.CP_RESPONSE_CODE)
            val messageCode = jsonObject.optLong(PayUCheckoutProConstants.CP_MESSAGE_CODE)
            val responseDateTime =
                jsonObject.optString(PayUCheckoutProConstants.CP_RESPONSE_DATE_TIME)
            val clientTxnID = jsonObject.optString(PayuConstants.PAYU_CLIENT_TXN_ID)
            val token = jsonObject.optString(PayuConstants.PAYU_TOKEN)
            return OlwAPIResponse(
                responseMessage,
                responseCode,
                messageCode,
                responseDateTime,
                clientTxnID,
                token
            )
        } else {
            val responseMessage = jsonObject.optString(PayUCheckoutProConstants.CP_ERROR_MESSAGE)
            val responseCode = jsonObject.optString(PayUCheckoutProConstants.CP_ISSUE_CODE)
            val token = jsonObject.optString(PayuConstants.PAYU_TOKEN)
            return OlwAPIResponse(
                responseMessage ?: PayUCheckoutProConstants.CP_SOMETHING_WENT_WRONG_ERROR_MESSAGE,
                responseCode,
                null,
                null,
                null,
                token
            )
        }
    }

    internal fun getSetMPinResponse(jsonObject: JSONObject, status: Int): SetMPinResponse {
        val olwAPIResponse = getOlwParams(jsonObject, status)
        val mPinExpiryTime = jsonObject.optString(PayUCheckoutProConstants.CP_MPIN_EXPIRY_TIME)
        val deviceId = jsonObject.optString(PayUCheckoutProConstants.CP_DEVICE_ID)
        val tokenExpiryTime = jsonObject.optString(PayUCheckoutProConstants.CP_TOKEN_EXPIRY_TIME)
        val token = jsonObject.optString(PayuConstants.PAYU_TOKEN)
        return SetMPinResponse(
            olwAPIResponse,
            deviceId,
            token,
            tokenExpiryTime,
            mPinExpiryTime
        )
    }
}