package com.payu.checkoutpro.reConverter

import com.payu.base.models.PaymentOption
import com.payu.base.models.PaymentType
import com.payu.checkoutpro.utils.CommonUtils
import com.payu.checkoutpro.utils.ParserUtils
import com.payu.checkoutpro.utils.PayUCheckoutProConstants
import com.payu.india.Model.QuickPay.QuickPaySavedOption
import com.payu.india.Model.QuickPay.RecommendedOptions
import com.payu.india.Payu.PayuConstants

object NBPaymentModeConverter {

    fun getSavedNBPaymentMode(quickPaySavedOption: QuickPaySavedOption): ArrayList<PaymentOption> {
        val savedPaymentOption = PaymentOption()
        val optionDetail: ArrayList<PaymentOption> = ArrayList()
        val paymentModeMap = ParserUtils.paymentOptionMap[PaymentType.NB]
        val paymentOption: PaymentOption? =
            paymentModeMap?.get(quickPaySavedOption.ibiboCode) as? PaymentOption
        if (paymentOption != null) {
            savedPaymentOption.bankName = quickPaySavedOption.pgTitle
            savedPaymentOption.otherParams = CommonUtils.getOtherParamsMap(
                PayuConstants.PAYU_NB,
                quickPaySavedOption.ibiboCode
            )
            savedPaymentOption.bankCode = quickPaySavedOption.ibiboCode
            savedPaymentOption.isBankDown = !quickPaySavedOption.isPgUP
            savedPaymentOption.paymentType = PaymentType.NB
            savedPaymentOption.subText = quickPaySavedOption.pgDetails
            savedPaymentOption.phoneNumber = quickPaySavedOption.phoneNumber
            PaymentModeConverter.updateTaxValue(savedPaymentOption, PaymentType.NB)
            optionDetail.add(savedPaymentOption)
        }
        return optionDetail
    }

    fun getRENBPaymentOption(recommendedOptions: RecommendedOptions): ArrayList<PaymentOption> {
        val optionDetails = ArrayList<PaymentOption>()
        val paymentModeMap = ParserUtils.paymentOptionMap[PaymentType.NB]
        val paymentOption: PaymentOption? =
            paymentModeMap?.get(recommendedOptions.ibiboCode) as? PaymentOption
        if (paymentOption != null) {

            val othersParamMap =
                (paymentModeMap?.get(recommendedOptions.ibiboCode) as PaymentOption?)?.otherParams as? HashMap<String, String>
            if (othersParamMap?.get(PayUCheckoutProConstants.CP_BANK_CODE)
                    ?.isNotEmpty() == true
            )
                optionDetails.add(paymentOption)
        }
        return optionDetails
    }

    internal fun getDeleteApiSavedPaymentMode(paymentOption: PaymentOption): QuickPaySavedOption {
        val quickPaySavedOption = QuickPaySavedOption()
        quickPaySavedOption.paymentType = paymentOption.paymentType?.name
        quickPaySavedOption.pgTitle = paymentOption.bankName
        quickPaySavedOption.ibiboCode = CommonUtils.getValueFromPaymentOption(
            PayUCheckoutProConstants.CP_BANK_CODE,
            paymentOption.otherParams as? java.util.HashMap<String, Any?>
        )
        return quickPaySavedOption
    }

}