package com.payu.checkoutpro.parser

import android.app.Activity
import com.payu.base.models.PayUPaymentParams
import com.payu.checkoutpro.layers.PayUbizApiLayer
import com.payu.checkoutpro.models.PayUCheckoutProConfig
import com.payu.checkoutpro.parser.constants.PayUHybridKeys
import com.payu.ui.model.listeners.PayUCheckoutProListener

class HybridParameterMapParser {

    companion object {
        internal fun extractAndCreateAPILayer(
            activity: Activity,
            map: HashMap<String, Any>,
            checkoutListener: PayUCheckoutProListener
        ):
                PayUbizApiLayer? {
            var config: PayUCheckoutProConfig? = null
            var param: PayUPaymentParams? = null

            if (map.containsKey(PayUHybridKeys.Others.payUPaymentParams)) {
                param = PaymentParamParser.convertHashMapToPaymentParams(
                    map[PayUHybridKeys.Others.payUPaymentParams] as HashMap<String, Any>
                )
                PayUbizApiLayer(activity, param, checkoutListener)
            }

            if (map.containsKey(PayUHybridKeys.Others.payUCheckoutProConfig)) {
                config = CheckoutProConfigParser.convertHashMapToCheckoutProConfig(
                    activity,
                    map[PayUHybridKeys.Others.payUCheckoutProConfig] as HashMap<String, Any>
                )
            }
            if (param == null)
                return null
            return if (config == null)
                PayUbizApiLayer(activity, param, checkoutListener)
            else
                PayUbizApiLayer(activity, param, config, checkoutListener)
        }
    }
}