package com.payu.checkoutpro.parser

import android.app.Activity
import android.content.Context
import android.content.res.Resources
import com.payu.checkoutpro.models.PayUCheckoutProConfig
import com.payu.checkoutpro.parser.constants.PayUHybridKeys
import com.payu.checkoutpro.parser.utils.CheckoutProConfigParserUtils
import java.util.HashMap

object CheckoutProConfigParser {

    internal fun convertHashMapToCheckoutProConfig(
        activity: Activity,
        map: HashMap<String, Any>
    ): PayUCheckoutProConfig {
        val config = PayUCheckoutProConfig()
        if (map.containsKey(PayUHybridKeys.CheckoutProConfig.merchantSMSPermission))
            config.merchantSmsPermission =
                map[PayUHybridKeys.CheckoutProConfig.merchantSMSPermission] as Boolean
        if (map.containsKey(PayUHybridKeys.CheckoutProConfig.autoApprove))
            config.autoApprove =
                map[PayUHybridKeys.CheckoutProConfig.autoApprove] as Boolean
        if (map.containsKey(PayUHybridKeys.CheckoutProConfig.merchantResponseTimeout)
            && map[PayUHybridKeys.CheckoutProConfig.merchantResponseTimeout] is Int
        )
            config.merchantResponseTimeout =
                map[PayUHybridKeys.CheckoutProConfig.merchantResponseTimeout] as Int
        if (map.containsKey(PayUHybridKeys.CheckoutProConfig.waitingTime)
            && map[PayUHybridKeys.CheckoutProConfig.waitingTime] is Int
        )
            config.waitingTime =
                map[PayUHybridKeys.CheckoutProConfig.waitingTime] as Int
        if (map.containsKey(PayUHybridKeys.CheckoutProConfig.merchantName))
            config.merchantName =
                map[PayUHybridKeys.CheckoutProConfig.merchantName].toString()
        if (map.containsKey(PayUHybridKeys.CheckoutProConfig.autoSelectOtp))
            config.autoSelectOtp =
                map[PayUHybridKeys.CheckoutProConfig.autoSelectOtp] as Boolean
        if (map.containsKey(PayUHybridKeys.CheckoutProConfig.showCbToolbar))
            config.showCbToolbar =
                map[PayUHybridKeys.CheckoutProConfig.showCbToolbar] as Boolean
        if (map.containsKey(PayUHybridKeys.CheckoutProConfig.showExitConfirmationOnCheckoutScreen))
            config.showExitConfirmationOnCheckoutScreen =
                map[PayUHybridKeys.CheckoutProConfig.showExitConfirmationOnCheckoutScreen] as Boolean
        if (map.containsKey(PayUHybridKeys.CheckoutProConfig.showExitConfirmationOnPaymentScreen))
            config.showExitConfirmationOnPaymentScreen =
                map[PayUHybridKeys.CheckoutProConfig.showExitConfirmationOnPaymentScreen] as Boolean

        if (map.containsKey(PayUHybridKeys.CheckoutProConfig.showMerchantLogo))
            config.showMerchantLogo =
                map[PayUHybridKeys.CheckoutProConfig.showMerchantLogo] as Boolean
        if (map.containsKey(PayUHybridKeys.CheckoutProConfig.enableSavedCard))
            config.enableSavedCard =
                map[PayUHybridKeys.CheckoutProConfig.enableSavedCard] as Boolean

        if (map.containsKey(PayUHybridKeys.CheckoutProConfig.enableSslDialog))
            config.enableSslDialog =
                map[PayUHybridKeys.CheckoutProConfig.enableSslDialog] as Boolean
        if (map.containsKey(PayUHybridKeys.CheckoutProConfig.primaryColor))
            config.primaryColor =
                map[PayUHybridKeys.CheckoutProConfig.primaryColor].toString()
        if (map.containsKey(PayUHybridKeys.CheckoutProConfig.baseTextColor))
            config.baseTextColor =
                map[PayUHybridKeys.CheckoutProConfig.baseTextColor].toString()
        if (map.containsKey(PayUHybridKeys.CheckoutProConfig.enableREOptions))
            config.enableREOptions =
                map[PayUHybridKeys.CheckoutProConfig.enableREOptions] as Boolean
        if (map.containsKey(PayUHybridKeys.CheckoutProConfig.cartDetails))
            config.cartDetails =
                (CheckoutProConfigParserUtils.getCartDetails(map[PayUHybridKeys.CheckoutProConfig.cartDetails] as List<Any>))
        if (map.containsKey(PayUHybridKeys.CheckoutProConfig.paymentModesOrder))
            config.paymentModesOrder =
                CheckoutProConfigParserUtils.getPaymentOrder(map[PayUHybridKeys.CheckoutProConfig.paymentModesOrder] as List<Any>)
        if (map.containsKey(PayUHybridKeys.CheckoutProConfig.merchantLogo)) {
            try {
                val context: Context = activity.applicationContext
                val resId: Int = context.resources.getIdentifier(
                    map[PayUHybridKeys.CheckoutProConfig.merchantLogo].toString(),
                    PayUHybridKeys.Others.drawable,
                    context.packageName
                )
                config.merchantLogo = resId
            } catch (e: Resources.NotFoundException) {
            }
        }
        if(map.containsKey(PayUHybridKeys.CheckoutProConfig.upiAppsOrder)){
            config.upiAppsOrder = map[PayUHybridKeys.CheckoutProConfig.upiAppsOrder] as? String
        }
        (map[PayUHybridKeys.CheckoutProConfig.enforcePaymentList] as? ArrayList<HashMap<String, String>>)?.let { enforcePayment ->
            config.enforcePaymentList = enforcePayment
        }

        (map[PayUHybridKeys.CheckoutProConfig.customNotes] as? ArrayList<HashMap<String, Any>>)?.let { notesList ->
            config.customNoteDetails =
                CheckoutProConfigParserUtils.getCustomerNoteDetails(notesList)
        }


        return config
    }
}