package com.payu.checkoutpro.models

import android.content.Context
import com.payu.base.listeners.PaymentVerificationListener
import com.payu.base.models.ErrorResponse
import com.payu.checkoutpro.utils.CPAnalyticsUtils
import com.payu.checkoutpro.utils.ParserUtils
import com.payu.checkoutpro.utils.PayUCheckoutProConstants
import com.payu.india.Interfaces.VerifyPaymentApiListener
import com.payu.india.Model.MerchantWebService
import com.payu.india.Model.PayuResponse
import com.payu.india.Payu.PayuConstants
import com.payu.india.Payu.PayuErrors
import com.payu.india.PostParams.MerchantWebServicePostParams
import com.payu.india.Tasks.VerifyPaymentTask
import com.payu.paymentparamhelper.PaymentParams
import org.json.JSONObject


class VerifyPaymentApiObject(
    private val context: Context,
    payuBizparams: PaymentParams,
    listener: Any?
) : V1BaseApiObject(payuBizparams), VerifyPaymentApiListener {
    private var startTime: Long = 0
    private var paymentVerificationListener: PaymentVerificationListener? = null

    init {
        this.paymentVerificationListener = listener as PaymentVerificationListener
        paymentVerificationListener?.showProgressDialog(true)
    }

    override fun callApi(map: HashMap<String, String?>) {

        paymentVerificationListener?.showProgressDialog(true)

        val merchantWebService = MerchantWebService()
        merchantWebService.key = payuBizparams.key
        merchantWebService.command = PayuConstants.VERIFY_PAYMENT
        merchantWebService.var1 = payuBizparams.txnId

        merchantWebService.hash = map[getHashName()]

        val postData =
            MerchantWebServicePostParams(merchantWebService).merchantWebServicePostParams

        if (postData.code == PayuErrors.NO_ERROR) {
            payuConfig.data = postData.result

            val paymentRelatedDetailsForMobileSdkTask =
                VerifyPaymentTask(this)
            startTime = System.currentTimeMillis()
            paymentRelatedDetailsForMobileSdkTask.execute(payuConfig)
        } else {

            val errorResponse = ErrorResponse()
            errorResponse.errorMessage = postData.result
            paymentVerificationListener?.showProgressDialog(false)
            paymentVerificationListener?.onError(errorResponse)
        }
    }

    override fun getHashName(): String {
        return PayuConstants.VERIFY_PAYMENT
    }

    override fun onVerifyPaymentResponse(payuResponse: PayuResponse?) {
        val timeTaken = System.currentTimeMillis() - startTime
        paymentVerificationListener?.showProgressDialog(false)
        if (!payuResponse?.rawResponse?.toString().isNullOrEmpty()) {
            val rawResponse = payuResponse?.rawResponse
            val transactionDetails = rawResponse?.getJSONObject(PayuConstants.TRANSACTION_DETAILS)
                ?.getJSONObject(payuBizparams.txnId)
            val response = HashMap<String, Any?>()
            val transonJson:JSONObject? = transactionDetails?.let {
                ParserUtils.getTransactionResponseJson(
                    it
                )
            }
            response[PayUCheckoutProConstants.CP_PAYU_RESPONSE] = transonJson
            response[PayUCheckoutProConstants.CP_MERCHANT_RESPONSE] = null
            val status:String? = transonJson?.getString(PayuConstants.STATUS)
            if (status?.equals(PayUCheckoutProConstants.CP_SUCCESS, true) == true) {
                paymentVerificationListener?.onPaymentVerificationSuccess(response)
                CPAnalyticsUtils.logApiResponseSuccess(getHashName(), timeTaken, payuConfig.data, context)
            } else if (status?.equals(
                    PayUCheckoutProConstants.CP_FAILURE,
                    true
                ) == true
            ) {
                CPAnalyticsUtils.logApiResponseFailure(getHashName(), timeTaken, payuResponse.responseStatus.result, payuResponse.responseStatus?.code, context)
                paymentVerificationListener?.onPaymentVerificationFailed(response)
            } else if (status?.equals(PayUCheckoutProConstants.CP_NOT_FOUND, true) == false) {
                val errorResponse = ErrorResponse()
                errorResponse.errorMessage = status
                errorResponse.errorCode = PayuErrors.PENDING_TRANSACTION
                CPAnalyticsUtils.logApiResponseFailure(getHashName(), timeTaken, errorResponse.errorMessage, errorResponse.errorCode, context)
                paymentVerificationListener?.onPaymentVerificationPending(errorResponse)
            }
        }
    }

}