package com.payu.checkoutpro.models

import com.payu.base.listeners.OnValidateOfferListener
import com.payu.base.models.InternalConfig
import com.payu.base.models.PayUPaymentParams
import com.payu.checkoutpro.utils.CPAnalyticsUtils
import com.payu.checkoutpro.utils.ParserUtils
import com.payu.checkoutpro.utils.PayUCheckoutProConstants
import com.payu.checkoutpro.utils.V2ApRequestParser
import com.payu.checkoutpro.utils.V2ApiResponseParser
import com.payu.india.Interfaces.ValidateOfferApiListener
import com.payu.india.Model.PayuResponse
import com.payu.india.Tasks.V2ApiTask
import com.payu.paymentparamhelper.PaymentParams
import org.json.JSONArray

class ValidateOfferDetailsApiObject(
    payuBizParams: PaymentParams,
    payUPaymentParams: PayUPaymentParams,
    listener: Any
) : V2BaseApiObject(payUPaymentParams, payuBizParams), ValidateOfferApiListener {

    private val validateOfferApiListener = listener as OnValidateOfferListener
    private val payuPaymentParams = payUPaymentParams
    private var isAutoApply: Boolean = true

    override fun getHashName() = PayUCheckoutProConstants.CP_VALIDATE_OFFER_DETAILS

    override fun callApi() {
        var offersKeyList: JSONArray? = null
        InternalConfig.userSelectedOfferInfo?.let {
            if (!it.isSkuOffer) {
                offersKeyList = JSONArray()
                offersKeyList?.put(it.offerKey)
                this.isAutoApply = false
            }
        }
        val enforceOfferKeys = payuPaymentParams.enforcementOfferKeys
        if (InternalConfig.userSelectedOfferInfo == null && enforceOfferKeys.isNullOrEmpty()
                .not()
        ) {
            offersKeyList = JSONArray()
            enforceOfferKeys?.filter { it.trim().isNotEmpty() }?.forEach { key ->
                offersKeyList?.put(key)
            }
            if((offersKeyList?.length() ?: 0) <= 0){
                offersKeyList = null
            }
        }

        val (sku, isAutoApplied) =
            if (InternalConfig.userSelectedOfferInfo == null || InternalConfig.userSelectedOfferInfo?.isSkuOffer == true) ParserUtils.getSkuJson(payuPaymentParams, isAutoApply)
            else Pair(null, isAutoApply)
        isAutoApply = isAutoApplied
        startTime = System.currentTimeMillis()
        val validateOfferReq = V2ApRequestParser.getValidateOfferReq(
            payuBizparams,
            offersKeyList,
            sku,
            payuBizparams.userToken,
            payuBizparams.cardNumber,
            payuBizparams.cardToken,
            payuBizparams.category,
            payuBizparams.paymentCode,
            isAutoApply
        )
        val v2ApiTask = V2ApiTask(payuBizparams.key, payuConfig)
        v2ApiTask.validateOffers(validateOfferReq, this, this)
    }


    override fun onValiDateOfferResponse(payuResponse: PayuResponse?) {
        val timeTaken = System.currentTimeMillis() - startTime
        CPAnalyticsUtils.logApiResponseSuccess(getHashName(), timeTaken, payuConfig.data)
        validateOfferApiListener.onValidateOfferResponse(
            V2ApiResponseParser.getSelectedOfferInfo(
                payuResponse?.validateOfferDetails,
                payuPaymentParams,
                payuBizparams
            )
        )
    }

}