package com.payu.checkoutpro.models

import com.payu.base.models.BaseConfig
import com.payu.checkoutpro.utils.PayUCheckoutProConstants
import org.json.JSONObject


class PayUCheckoutProConfig : BaseConfig() {
    var showCbToolbar: Boolean = true
    var merchantSmsPermission: Boolean = true
    var autoSelectOtp: Boolean = false
    var autoApprove: Boolean = false
    var surePayCount: Int = 0
    var showExitConfirmationOnPaymentScreen: Boolean = true
    var merchantResponseTimeout: Int = 10000
    var waitingTime: Int = 30000
    var enableSslDialog: Boolean = false

    fun convertToJson(): JSONObject {
        val jsonObject = JSONObject()

        jsonObject.put(PayUCheckoutProConstants.PAYU_SHOW_CB_TOOLBAR, showCbToolbar)
        jsonObject.put(PayUCheckoutProConstants.PAYU_MERCHANT_SMS_PERMISSION, merchantSmsPermission)
        jsonObject.put(PayUCheckoutProConstants.PAYU_AUTO_SELECT_OTP, autoSelectOtp)
        jsonObject.put(PayUCheckoutProConstants.PAYU_AUTO_APPROVE, autoApprove)
        jsonObject.put(PayUCheckoutProConstants.PAYU_SURE_PAY_COUNT, surePayCount)
        jsonObject.put(PayUCheckoutProConstants.PAYU_EXIT_CONFIRMATION_ON_PAYMENT, showExitConfirmationOnPaymentScreen)
        jsonObject.put(PayUCheckoutProConstants.PAYU_MERCHANT_RESPONSE_TIMEOUT, merchantResponseTimeout)
        jsonObject.put(PayUCheckoutProConstants.PAYU_WAITING_TIME, waitingTime)
        jsonObject.put(PayUCheckoutProConstants.PAYU_ENABLE_SSL_DIALOG, enableSslDialog)
        paymentModesOrder?.let { mode ->
            val modeList = mode.map { it.getPaymentType() }
            jsonObject.put(PayUCheckoutProConstants.PAYU_PAYMENT_MODES_ORDER, modeList.joinToString())
        }
        cartDetails?.let { order ->
            val details = order.map { it.convertToJson().toString() }
            jsonObject.put(PayUCheckoutProConstants.PAYU_CART_DETAILS, details.joinToString())
        }
        customNoteDetails?.let {
            jsonObject.put(PayUCheckoutProConstants.PAYU_CUSTOM_NOTE_DETAILS, it.toString())
        }
        jsonObject.put(PayUCheckoutProConstants.PAYU_EXIT_CONFIRMATION_ON_CHECKOUT, showExitConfirmationOnCheckoutScreen)
        jsonObject.put(PayUCheckoutProConstants.PAYU_MERCHANT_NAME, merchantName)
        merchantLogo?.let {
            jsonObject.put(PayUCheckoutProConstants.PAYU_MERCHANT_LOGO, it)
        }
        enforcePaymentList?.let { list ->
            val paymentList = list.map { JSONObject(it as Map<String, String>).toString() }
            jsonObject.put(PayUCheckoutProConstants.PAYU_ENFORCE_PAYMENT_LIST, paymentList.joinToString())
        }
        merchantLogoUrl?.let {
            jsonObject.put(PayUCheckoutProConstants.PAYU_MERCHANT_LOGO_URL, it)
        }
        primaryColor?.let {
            jsonObject.put(PayUCheckoutProConstants.PAYU_PRIMARY_COLOR, it)
        }
        primaryColorDark?.let {
            jsonObject.put(PayUCheckoutProConstants.PAYU_PRIMARY_COLOR_DARK, it)
        }
        primaryColorAccent?.let {
            jsonObject.put(PayUCheckoutProConstants.PAYU_PRIMARY_COLOR_ACCENT, it)
        }
        baseTextColor?.let {
            jsonObject.put(PayUCheckoutProConstants.PAYU_BASE_TEXT_COLOR, it)
        }
        jsonObject.put(PayUCheckoutProConstants.PAYU_SHOW_MERCHANT_LOGO, showMerchantLogo)
        jsonObject.put(PayUCheckoutProConstants.PAYU_ENABLE_SAVED_CARD, enableSavedCard)
        jsonObject.put(PayUCheckoutProConstants.PAYU_IS_QR_SCAN, isQrScan)
        jsonObject.put(PayUCheckoutProConstants.PAYU_ENABLE_RE_OPTIONS, enableREOptions)
        upiAppsOrder?.let {
            jsonObject.put(PayUCheckoutProConstants.PAYU_UPI_APPS_ORDER, it)
        }
        return jsonObject
    }
}