package com.payu.checkoutpro.models

import android.util.Log
import com.payu.base.listeners.OnGVQuickPayListener
import com.payu.base.models.ErrorResponse
import com.payu.base.models.PayUPaymentParams
import com.payu.checkoutpro.utils.CPAnalyticsUtils
import com.payu.checkoutpro.utils.PayUCheckoutProConstants.CP_MOBILE_NUMBER
import com.payu.india.Interfaces.GlobalVaultListener
import com.payu.india.Model.PayuResponse
import com.payu.india.Model.QuickPay.GlobalVaultOTPRequest
import com.payu.india.Payu.PayuConstants
import com.payu.india.Tasks.V2ApiTask
import com.payu.paymentparamhelper.PaymentParams

/**
 * The purpose of the class to handle Request call, Build request and response
 */
class GlobalVaultSendOTPObject(
    payuBizParams: PaymentParams, payUPaymentParams: PayUPaymentParams,
    internal val map: HashMap<String, String>, listener: OnGVQuickPayListener
) : V2BaseApiObject(payUPaymentParams, payuBizParams),
    GlobalVaultListener {

    private val TAG = this.javaClass.simpleName

    private val onGVQuickPayListener = listener

    override fun getHashName(): String = "send_sign_in_otp"

    override fun callApi() {

        Log.d(TAG, " callApi")
        val globalVaultOTPRequest =
            GlobalVaultOTPRequest.Builder().setMobileNumber(map[CP_MOBILE_NUMBER])
                .build()
        startTime = System.currentTimeMillis()
        val v2ApiTask =
            V2ApiTask(payuBizparams.key, payuConfig)
        v2ApiTask.globalVaultSendOTP(globalVaultOTPRequest, this, this)
    }

    override fun onQuickPayResponse(payuResponse: PayuResponse) {
        val timeTaken = System.currentTimeMillis() - startTime
        Log.d(TAG, "payuResponse map $payuResponse")
        if (payuResponse.responseStatus?.status.equals(PayuConstants.SUCCESS, ignoreCase = true)) {
            CPAnalyticsUtils.logApiResponseSuccess(getHashName(), timeTaken, payuConfig.data)
            onGVQuickPayListener.onSuccess(payuResponse.responseStatus.result)
        } else {
            CPAnalyticsUtils.logApiResponseFailure(getHashName(), timeTaken, payuResponse.responseStatus?.result, payuResponse.responseStatus?.code)
            val errorResponse = ErrorResponse()
            errorResponse.errorMessage = payuResponse.responseStatus?.result
            errorResponse.errorCode = payuResponse.responseStatus?.code
            onGVQuickPayListener.onError(errorResponse)
        }
    }
}