package com.payu.checkoutpro.models

import com.payu.base.models.BankOfferInfoCards
import com.payu.base.models.CardType
import com.payu.base.models.CardsOfferInfo
import com.payu.base.models.DiscountDetailsofOffers
import com.payu.base.models.EmiOfferInfo
import com.payu.base.models.FetchOfferDetails
import com.payu.base.models.InternalConfig
import com.payu.base.models.NetworkOfferInfoCards
import com.payu.base.models.OfferInfo
import com.payu.base.models.PayUPaymentParams
import com.payu.base.models.PayUUserDetail
import com.payu.base.models.PaymentOptionOfferinfo
import com.payu.base.models.PaymentType
import com.payu.base.models.SKU
import com.payu.checkoutpro.utils.ApiResponseRepo
import com.payu.checkoutpro.utils.CPAnalyticsUtils
import com.payu.checkoutpro.utils.CommonUtils
import com.payu.checkoutpro.utils.ParserUtils
import com.payu.checkoutpro.utils.PayUCheckoutProConstants
import com.payu.india.Interfaces.FetchOfferDetailsListener
import com.payu.india.Model.FetchOffer.FetchOfferApiRequest
import com.payu.india.Model.FetchOfferInfo
import com.payu.india.Model.PayuResponse
import com.payu.india.Payu.PayuConstants
import com.payu.india.Tasks.V2ApiTask
import com.payu.paymentparamhelper.PaymentParams
import com.payu.paymentparamhelper.Sku
import org.json.JSONArray
import org.json.JSONObject

class FetchOfferDetailsApiObject(
    payuBizParams: PaymentParams,
    payUPaymentParams: PayUPaymentParams,
    private val offerListener: (FetchOfferDetails?) -> Unit?
) : V2BaseApiObject(payUPaymentParams, payuBizParams), FetchOfferDetailsListener {

    private val payuPaymentParams = payUPaymentParams
    private var offersResponse: PayuResponse? = null
    override fun getHashName() = PayUCheckoutProConstants.CP_GET_OFFER_DETAILS

    override fun callApi() {
        val couponOfferKeyAsList = arrayListOf<String>()
        InternalConfig.appliedCouponOfferKey?.let {
            couponOfferKeyAsList.add(it)
        }

        val fetchOfferApiRequest =
            FetchOfferApiRequest.Builder(payuBizparams.amount.toDouble(), payuBizparams.userToken)
                .setSkuDetails(getSkuJson(payuPaymentParams.skuDetails?.skus, couponOfferKeyAsList)?.toString())
                .setLoggedInPhoneNumber(payuBizparams.loggedInPhoneNumber)
                .setConsented(InternalConfig.isUserConsentAvailableForPersonalisedOffers)
                .setEnforcementOfferKeys( if(couponOfferKeyAsList.isEmpty().not()) couponOfferKeyAsList else payuPaymentParams.enforcementOfferKeys)
                .build()
        val v2ApiTask = V2ApiTask(payuBizparams.key, payuConfig)
        startTime = System.currentTimeMillis()
        v2ApiTask.getOffers(fetchOfferApiRequest, this, this)
    }

    fun getOfferDetailsForRetry() {
        offersResponse?.let {
            ParserUtils.enforcePaymentList = null
            onFetchOfferDetailsResponse(offersResponse)
        }
    }

    override fun onFetchOfferDetailsResponse(payuResponse: PayuResponse?) {
        val timeTaken = System.currentTimeMillis() - startTime
        InternalConfig.noCostEmi = ArrayList()
        InternalConfig.offerBankListEmi = ArrayList()
        offersResponse = payuResponse
        var fetchOfferDetails: FetchOfferDetails? = null
        val payuSkuOfferList: ArrayList<OfferInfo> = ArrayList()
        val payuOfferArrayList: ArrayList<OfferInfo> = ArrayList()
        payuResponse?.fetchofferDetails?.isUserPersonalizedOffersAvailable?.let {
            InternalConfig.isUserPersonalizedOffersAvailable = it
        }
        payuResponse?.fetchofferDetails?.couponsAvailable?.let {
            InternalConfig.couponsAvailable = it
        }
        val payuRewardOfferArrayList: ArrayList<OfferInfo> = ArrayList()
        payuResponse?.fetchofferDetails?.payuOfferList?.filter {
            it.offerType == PayuConstants.INSTANT
        }?.forEach { fetchOfferInfo ->
            prepareFetchOfferInfo(fetchOfferInfo, null, payuOfferArrayList)
        }
        payuResponse?.fetchofferDetails?.skuOfferInfoList?.forEach {
            prepareSkuOfferInfoList(it?.offerInfoArrayList ?: ArrayList(), it.sku, payuSkuOfferList)
        }
        payuResponse?.fetchofferDetails?.payuOfferList?.filter {
            it.offerType == PayuConstants.CASHBACK || it.offerType == PayuConstants.REWARD
        }?.forEach { fetchOfferInfo ->
            prepareFetchOfferInfo(fetchOfferInfo = fetchOfferInfo, null, payuRewardOfferArrayList)
        }


        CPAnalyticsUtils.logApiResponseSuccess(getHashName(), timeTaken, payuConfig.data)
        if (payuSkuOfferList.isEmpty() && payuOfferArrayList.isEmpty() && payuRewardOfferArrayList.isEmpty())
            ApiResponseRepo.setPayUFetchOfferResponse(null)
        else {
            fetchOfferDetails =
                FetchOfferDetails(payuOfferArrayList, payuSkuOfferList, payuRewardOfferArrayList)
            ApiResponseRepo.setPayUFetchOfferResponse(fetchOfferDetails)
        }
    }

    private fun prepareFetchOfferInfo(
        fetchOfferInfo: FetchOfferInfo,
        skUs: Sku?,
        offersList: ArrayList<OfferInfo>
    ): ArrayList<OfferInfo> {
        var offerInfo: OfferInfo? = null
        var discountDetailsOffers: DiscountDetailsofOffers? = null
        var emiCCOfferList: ArrayList<PaymentOptionOfferinfo>? = null
        var emiDCOfferList: ArrayList<PaymentOptionOfferinfo>? = null
        var emiCardLessOfferList: ArrayList<PaymentOptionOfferinfo>? = null
        var emiOfferInfo: EmiOfferInfo? = null

        if ((fetchOfferInfo.offerCategory.isNullOrEmpty() || fetchOfferInfo.offerCategory.equals(
                PayUCheckoutProConstants.MYSTERY_OFFER,
                ignoreCase = true
            ) || fetchOfferInfo.isSkuOffer || fetchOfferInfo.isNoCostEmi)
        ) {
            fetchOfferInfo.discountDetails?.let {
                discountDetailsOffers = DiscountDetailsofOffers(
                    it.discountPercentage,
                    it.maxDiscount,
                    it.discountType,
                    it.discount,
                    it.discountedAmount
                )
            }

            var bankOfferInfoCards: BankOfferInfoCards? = null
            var networkOfferInfoCards: NetworkOfferInfoCards? = null
            var cardsOfferInfo: CardsOfferInfo? = null
            val bankCCInfoCards =
                fetchOfferInfo.cardsOfferInfo?.bankOfferInfoCards?.banksListForCCCards?.let {
                    getPaymentOptionOfferInfoList(
                        it
                    )
                }
            val bankDCInfoCards =
                fetchOfferInfo.cardsOfferInfo?.bankOfferInfoCards?.banksListForDCCards?.let {
                    getPaymentOptionOfferInfoList(
                        it
                    )
                }
            bankOfferInfoCards =
                if (bankCCInfoCards.isNullOrEmpty() && bankDCInfoCards.isNullOrEmpty()) null
                else BankOfferInfoCards(bankCCInfoCards, bankDCInfoCards)

            val nwCCInfoCards =
                fetchOfferInfo.cardsOfferInfo?.networkOfferInfoCards?.networkListForCCCards?.let {
                    getPaymentOptionOfferInfoList(
                        it
                    )
                }
            val nwDCInfoCards =
                fetchOfferInfo.cardsOfferInfo?.networkOfferInfoCards?.networkListForDCCards?.let {
                    getPaymentOptionOfferInfoList(
                        it
                    )
                }
            networkOfferInfoCards =
                if (nwCCInfoCards.isNullOrEmpty() && nwDCInfoCards.isNullOrEmpty()) null
                else NetworkOfferInfoCards(nwCCInfoCards, nwDCInfoCards)
            cardsOfferInfo = if (bankOfferInfoCards == null && networkOfferInfoCards == null) null
            else CardsOfferInfo(bankOfferInfoCards, networkOfferInfoCards)

            val emiCCList = fetchOfferInfo.emiOfferInfo?.emiCCOffersArrayList
            val emiDCList = fetchOfferInfo.emiOfferInfo?.emiDCOffersArrayList
            val emiCardLessList = fetchOfferInfo.emiOfferInfo?.emiCardLessOffersArrayList
            if (!emiCCList.isNullOrEmpty())
                emiCCOfferList =
                    CommonUtils.getListForEmiOptionOffers(
                        emiCCList,
                        fetchOfferInfo.isNoCostEmi
                    )
            if (!emiDCList.isNullOrEmpty())
                emiDCOfferList =
                    CommonUtils.getListForEmiOptionOffers(
                        emiDCList,
                        fetchOfferInfo.isNoCostEmi
                    )
            if (!emiCardLessList.isNullOrEmpty())
                emiCardLessOfferList =
                    CommonUtils.getListForEmiOptionOffers(
                        emiCardLessList,
                        fetchOfferInfo.isNoCostEmi
                    )

            emiOfferInfo =
                if (emiCCOfferList.isNullOrEmpty() && emiDCOfferList.isNullOrEmpty() && emiCardLessOfferList.isNullOrEmpty()) null
                else EmiOfferInfo(
                    emiCCOfferList,
                    emiDCOfferList,
                    emiCardLessOfferList
                )

            payuPaymentParams.skuDetails?.skus?.forEach { sku ->
                if (sku.skuId == skUs?.skuId)
                    skUs.name = sku.skuName
            }
            var sku: SKU? = null
            if (skUs != null)
                sku = SKU(
                    skUs.quantity,
                    skUs.skuAmount,
                    skUs.skuId,
                    skUs.name
                )

            var payuUserDetail: PayUUserDetail? = null
            fetchOfferInfo.userDetails?.let {
                payuUserDetail = PayUUserDetail (firstName = it.firstName, phoneNo = it.phoneNo, email = it.email)
            }

            offerInfo = OfferInfo(
                sku,
                fetchOfferInfo.type,
                fetchOfferInfo.offerKey,
                fetchOfferInfo.title,
                fetchOfferInfo.description,
                fetchOfferInfo.tnc,
                fetchOfferInfo.tncLink,
                fetchOfferInfo.minTxnAmount,
                fetchOfferInfo.maxTxnAmount,
                fetchOfferInfo.offerType,
                fetchOfferInfo.validFrom,
                fetchOfferInfo.validTo,
                fetchOfferInfo.isNoCostEmi,
                fetchOfferInfo.isSkuOffer,
                fetchOfferInfo.isAllPayModeOffer,
                discountDetailsOffers,
                getPaymentOptionOfferInfoList(fetchOfferInfo.nbOfferList),
                getPaymentOptionOfferInfoList(fetchOfferInfo.walletOfferList),
                getPaymentOptionOfferInfoList(fetchOfferInfo.upiOfferList),
                getPaymentOptionOfferInfoList(fetchOfferInfo.bnplOfferList),
                cardsOfferInfo,
                emiOfferInfo,
                getPaymentOptionOfferInfoList(fetchOfferInfo.clwOfferInfoList),
                toDisplay = fetchOfferInfo.isToDisplay,
                isUserVerificationRequired = fetchOfferInfo.isUserVerificationRequired,
                userDetail = payuUserDetail
            )
            if (isSuportedOffer(fetchOfferInfo))
                offersList.add(offerInfo)
        }
        return offersList
    }

    fun isSuportedOffer(fetchOfferInfo: FetchOfferInfo): Boolean {
        return if (fetchOfferInfo.isAllPayModeOffer) true
        else (!fetchOfferInfo.nbOfferList.isNullOrEmpty() && checkForEnforcePayment(
            PaymentType.NB,
            ibiboCodes = getPipeSeperatedCodes(fetchOfferInfo.nbOfferList)
        ))
                || (!fetchOfferInfo.bnplOfferList.isNullOrEmpty() && checkForEnforcePayment(
            PaymentType.BNPL,
            ibiboCodes = getPipeSeperatedCodes(fetchOfferInfo.bnplOfferList)
        ))
                || (!fetchOfferInfo.walletOfferList.isNullOrEmpty() && checkForEnforcePayment(
            PaymentType.WALLET,
            ibiboCodes = getPipeSeperatedCodes(fetchOfferInfo.walletOfferList)
        ))
                || (!fetchOfferInfo.cardsOfferInfo?.bankOfferInfoCards?.banksListForCCCards.isNullOrEmpty() && checkForEnforcePayment(
            PaymentType.CARD,
            CardType.CC,
            ibiboCodes = getPipeSeperatedCodes(fetchOfferInfo.cardsOfferInfo.bankOfferInfoCards.banksListForCCCards)
        ))
                || (!fetchOfferInfo.cardsOfferInfo?.networkOfferInfoCards?.networkListForCCCards.isNullOrEmpty() && checkForEnforcePayment(
            PaymentType.CARD,
            CardType.CC,
            cardScheme = getPipeSeperatedCodes(fetchOfferInfo.cardsOfferInfo.networkOfferInfoCards.networkListForCCCards)
        ))
                || (!fetchOfferInfo.cardsOfferInfo?.bankOfferInfoCards?.banksListForDCCards.isNullOrEmpty() && checkForEnforcePayment(
            PaymentType.CARD,
            CardType.DC,
            ibiboCodes = getPipeSeperatedCodes(fetchOfferInfo.cardsOfferInfo.bankOfferInfoCards.banksListForDCCards)
        ))
                || (!fetchOfferInfo.cardsOfferInfo?.networkOfferInfoCards?.networkListForDCCards.isNullOrEmpty() && checkForEnforcePayment(
            PaymentType.CARD,
            CardType.DC,
            cardScheme = getPipeSeperatedCodes(fetchOfferInfo.cardsOfferInfo.networkOfferInfoCards.networkListForDCCards)
        ))
                || (!fetchOfferInfo.emiOfferInfo?.emiCCOffersArrayList.isNullOrEmpty() && checkForEnforcePayment(
            PaymentType.EMI,
            CardType.CC
        ))
                || (!fetchOfferInfo.emiOfferInfo?.emiDCOffersArrayList.isNullOrEmpty() && checkForEnforcePayment(
            PaymentType.EMI,
            CardType.DC
        ))
                || (!fetchOfferInfo.clwOfferInfoList.isNullOrEmpty() && checkForEnforcePayment(
            PaymentType.CLOSED_LOOP_WALLET,
            ibiboCodes = getPipeSeperatedCodes(fetchOfferInfo.clwOfferInfoList)
        ))
                || (!fetchOfferInfo.upiOfferList.isNullOrEmpty() && checkForEnforcePayment(
            PaymentType.UPI_INTENT,
            ibiboCodes = getPipeSeperatedCodes(fetchOfferInfo.upiOfferList)
        ))
                || (!fetchOfferInfo.upiOfferList.isNullOrEmpty() && checkForEnforcePayment(
            PaymentType.UPI,
            ibiboCodes = getPipeSeperatedCodes(fetchOfferInfo.upiOfferList)
        ))
    }

    internal fun getPipeSeperatedCodes(list: ArrayList<com.payu.india.Model.PaymentOptionOfferinfo>?): String? {
        var codes: String? = null
        for (item in list ?: listOf()) {
            codes += if (codes.isNullOrEmpty()) item.paymentCode else "|" + item.paymentCode
        }
        return codes
    }

    fun checkForEnforcePayment(
        paymentType: PaymentType,
        cardType: CardType? = null,
        cardScheme: String? = null,
        ibiboCodes: String? = null
    ): Boolean {
        val keyMap: java.util.HashMap<String, Any?> = java.util.HashMap()
        keyMap[PayUCheckoutProConstants.CP_PAYMENT_TYPE] = paymentType.name
        cardType?.name?.let { keyMap[PayUCheckoutProConstants.CP_CARD_TYPE] = it }
        cardScheme?.let { keyMap[PayUCheckoutProConstants.CP_CARD_SCHEME] = it }
        ibiboCodes?.let { keyMap[PayUCheckoutProConstants.ENFORCED_IBIBOCODE] = it }
        return CommonUtils.isKeyEnforced(keyMap)
    }

    private fun getPaymentOptionOfferInfoList(paymentOfferInfoList: ArrayList<com.payu.india.Model.PaymentOptionOfferinfo>?): ArrayList<PaymentOptionOfferinfo>? {

        if (!paymentOfferInfoList.isNullOrEmpty()) {
            val optionOfferInfoList: ArrayList<PaymentOptionOfferinfo> = ArrayList()
            for (paymentInfoList in paymentOfferInfoList) {
                val paymentOptionOfferInfo = PaymentOptionOfferinfo(
                    null,
                    paymentInfoList.title,
                    paymentInfoList.paymentCode,
                    paymentInfoList.paymentOptionName
                )
                optionOfferInfoList.add(paymentOptionOfferInfo)
            }

            return optionOfferInfoList
        }
        return null
    }

    private fun getSkuJson(skus: List<SKU>?, couponKeys: ArrayList<String>?): JSONObject? {
        if (!skus.isNullOrEmpty()) {
            var totalSkuAmount = 0.0
            val jsonArray = JSONArray()
            for (sku in skus) {
                val jsonObject = JSONObject()
                jsonObject.put(PayuConstants.P_SKU_M_ID, sku.skuId)
                totalSkuAmount += (sku.skuAmount.toDouble() ?: 0.0) * (sku.quantity)
                jsonObject.put(PayuConstants.P_SKU_M_AMOUNT, sku.skuAmount)
                jsonObject.put(PayuConstants.P_QUANTITY, sku.quantity)
                jsonObject.put(PayuConstants.OFFER_KEY, couponKeys ?: sku.offerKeys)
                jsonArray.put(jsonObject)
            }
            if (totalSkuAmount == (payuPaymentParams.amount?.toDouble() ?: 0.0)) {
                val jsonObject = JSONObject()
                jsonObject.put(PayuConstants.P_SKU_DETAILS, jsonArray)
                return jsonObject
            }
        }
        return null
    }

    private fun prepareSkuOfferInfoList(
        fetchOfferInfoList: ArrayList<FetchOfferInfo>,
        skUs: Sku?,
        offerInfoList: ArrayList<OfferInfo>
    ) {
        fetchOfferInfoList.forEach {
            prepareFetchOfferInfo(it, skUs, offerInfoList)
        }
    }

}