package com.payu.checkoutpro.models


import com.payu.base.models.ConvenienceFeeCharges
import com.payu.base.models.PayUPaymentParams
import com.payu.base.models.VariableDynamics
import com.payu.checkoutpro.utils.PayUCheckoutProConstants
import com.payu.checkoutpro.utils.V2ApiResponseParser
import com.payu.india.Interfaces.V2ApiResponseListener
import com.payu.india.Model.ApiResponse
import com.payu.india.Model.fetchConvenienceFee.CommonDynamicAttributes
import com.payu.india.Model.fetchConvenienceFee.FetchConvFeeRequest
import com.payu.india.Model.fetchConvenienceFee.FetchConvFeeResponse
import com.payu.india.Model.fetchConvenienceFee.VariableDynamicAttributes
import com.payu.india.Payu.PayuConstants
import com.payu.india.Tasks.V2ApiTask
import com.payu.paymentparamhelper.PaymentParams
import java.text.SimpleDateFormat
import java.util.Date
import java.util.Locale

class FetchConvFeeApiObject(
    internal val payuBizParams: PaymentParams,
    payUPaymentParams: PayUPaymentParams,
    private val mode: String,
    private val variableDynamicList: ArrayList<VariableDynamics>,
    private val onFetchConvFeeResponse: (HashMap<String, List<ConvenienceFeeCharges>>?) -> Unit?
) : V2BaseApiObject(payUPaymentParams, payuBizParams),
    V2ApiResponseListener<ApiResponse<FetchConvFeeResponse>> {
    override fun callApi() {
        val commonDynamicAttributes =  CommonDynamicAttributes(mode, PayuConstants.PAYU_CAPTURE)
        val dynamicAttributesList = variableDynamicList.map {
            VariableDynamicAttributes(it.combinationKey, it.ibiboCode)
        }


        val timestampFormat = PayUCheckoutProConstants.CP_TIME_FORMAT
        val currentTimestamp = SimpleDateFormat(timestampFormat, Locale.US).format(Date())

        val fetchConvFeeRequest = FetchConvFeeRequest.Builder().setPayuId(payuBizParams.txnId)
            .setMerchantKey(payuBizParams.key)
            .setAmount(payuBizParams.amount.toDoubleOrNull() ?: 0.0)
            .setSource(PayuConstants.PAYU_SOURCE_ANDROID_SDK.uppercase()).setTimeStamp(currentTimestamp)
            .setRequestId(payuBizparams.txnId+System.currentTimeMillis())
            .setCommonDynamicAttributes(commonDynamicAttributes)
            .setVariableDynamicAttributesList(dynamicAttributesList).build()
        val v2ApiTask = V2ApiTask(payuBizparams.key, payuConfig)
        v2ApiTask.fetchConvFeeDetails(fetchConvFeeRequest, this, this)
    }

    override fun getHashName() = PayuConstants.PAYU_FETCH_CONV_F
    override fun onApiResponse(apiResponse: ApiResponse<FetchConvFeeResponse>?) {
        apiResponse?.payuResponse?.convFeeChargesMap?.let { convFeeChargesMap ->
            V2ApiResponseParser.updateConvFeeResponse(
                convFeeChargesMap
            )
        }
//        onFetchConvFeeResponse.invoke(apiResponse?.payuResponse?.convFeeChargesMap)
    }
}