package com.payu.checkoutpro.models

import com.payu.base.models.ErrorResponse
import com.payu.checkoutpro.layers.PayUbizApiLayer
import com.payu.checkoutpro.utils.*
import com.payu.india.Interfaces.ConfigApiListener
import com.payu.india.Model.MerchantWebService
import com.payu.india.Model.PayuResponse
import com.payu.india.Payu.PayuConstants
import com.payu.india.Payu.PayuErrors
import com.payu.india.PostParams.MerchantWebServicePostParams
import com.payu.india.Tasks.GetConfigTask
import com.payu.paymentparamhelper.PaymentParams

class ConfigApiObject(
    payuBizparams: PaymentParams,
    payUbizApiLayer: PayUbizApiLayer
) : V1BaseApiObject(payuBizparams), ConfigApiListener {
    private var payUbizApiLayer: PayUbizApiLayer? = null
    private var startTime: Long = 0

    init {
        this.payUbizApiLayer = payUbizApiLayer
    }

    override fun onConfigApiResponse(payuResponse: PayuResponse?) {
        val timeTaken = System.currentTimeMillis() - startTime
        if (!payUbizApiLayer!!.checkoutAPICompleted) {
            if (payuResponse?.responseStatus?.status.equals(
                    PayuConstants.SUCCESS,
                    ignoreCase = true
                )
            ) {
                payUbizApiLayer!!.configAPICompleted = true
                if (payuResponse?.rawResponse!!.get("result").equals(null)) {
                    val cachedConfig =
                        ConfigUtils.getCachedConfigForAppVersion(payUbizApiLayer!!.context.applicationContext)
                    if (cachedConfig != null)
                        payuResponse?.rawResponse = cachedConfig
                } else
                    ConfigUtils.cacheConfig(
                        payUbizApiLayer!!.context.applicationContext,
                        payuResponse?.rawResponse
                    )

                CPAnalyticsUtils.logApiResponseSuccess(getHashName(), timeTaken, payuConfig.data, payUbizApiLayer!!.context.applicationContext, )
                ConfigUtils.updateConfig(
                    payuResponse?.rawResponse,
                    payUbizApiLayer?.payUCheckoutProConfig
                )
            } else {
                val errorResponse = ErrorResponse()
                errorResponse.errorMessage = payuResponse?.responseStatus?.result
                errorResponse.errorCode = payuResponse?.responseStatus?.code
                CPAnalyticsUtils.logApiResponseFailure(getHashName(), timeTaken, errorResponse.errorMessage, errorResponse.errorCode, payUbizApiLayer?.context)

            }
        } else {
            if (payUbizApiLayer!!.checkoutAPICompleted && payuResponse?.responseStatus?.status.equals(
                    PayuConstants.SUCCESS,
                    ignoreCase = true
                ) && !payuResponse?.rawResponse!!.get("result")
                    .equals(null)
            ) {
                CPAnalyticsUtils.logApiResponseSuccess(getHashName(), timeTaken, payuConfig.data, payUbizApiLayer?.context)
                ConfigUtils.cacheConfig(
                    payUbizApiLayer!!.context.applicationContext,
                    payuResponse?.rawResponse
                )
            }
        }
    }

    override fun callApi(map: HashMap<String, String?>) {
        val merchantWebService = MerchantWebService()
        merchantWebService.key = payuBizparams.key
        merchantWebService.command = PayuConstants.SDK_CONFIGURATION
        merchantWebService.var1 = "GET"

        merchantWebService.hash = map[getHashName()]

        val postData =
            MerchantWebServicePostParams(merchantWebService).merchantWebServicePostParams

        if (postData.code == PayuErrors.NO_ERROR) {
            payuConfig.data = postData.result
            val configTask = GetConfigTask(this)
            startTime = System.currentTimeMillis()
            configTask.execute(payuConfig)
        } else {
            val errorResponse = ErrorResponse()
            errorResponse.errorMessage = postData.result
        }
    }

    override fun getHashName(): String {
        return PayuConstants.SDK_CONFIGURATION
    }

}