package com.payu.checkoutpro.models

import com.payu.base.listeners.EmiCalculationListener
import com.payu.base.models.InternalConfig
import com.payu.base.models.PayUPaymentParams
import com.payu.base.models.calculateEmi.CalculateEmiRequest
import com.payu.base.models.calculateEmi.EmiDetails
import com.payu.base.models.calculateEmi.NceDiscount
import com.payu.checkoutpro.utils.CPAnalyticsUtils
import com.payu.checkoutpro.utils.PayUCheckoutProConstants
import com.payu.checkoutpro.utils.PayUCheckoutProConstants.CONFIG_RESPONSE_KEY
import com.payu.checkoutpro.utils.PayUCheckoutProConstants.CP_ADDITIONAL_COST
import com.payu.checkoutpro.utils.PayUCheckoutProConstants.CP_AMOUNT
import com.payu.checkoutpro.utils.PayUCheckoutProConstants.CP_BANK_CHARGE
import com.payu.checkoutpro.utils.PayUCheckoutProConstants.CP_BANK_RATE
import com.payu.checkoutpro.utils.PayUCheckoutProConstants.CP_CARDTYPE
import com.payu.checkoutpro.utils.PayUCheckoutProConstants.CP_CASHBACK
import com.payu.checkoutpro.utils.PayUCheckoutProConstants.CP_EMI_AMOUNT
import com.payu.checkoutpro.utils.PayUCheckoutProConstants.CP_EMI_INTEREST_PAID
import com.payu.checkoutpro.utils.PayUCheckoutProConstants.CP_EMI_PROCESSING_FEE
import com.payu.checkoutpro.utils.PayUCheckoutProConstants.CP_EMI_VALUE
import com.payu.checkoutpro.utils.PayUCheckoutProConstants.CP_FEE
import com.payu.checkoutpro.utils.PayUCheckoutProConstants.CP_INSTANT
import com.payu.checkoutpro.utils.PayUCheckoutProConstants.CP_LOAN_AMOUNT
import com.payu.checkoutpro.utils.PayUCheckoutProConstants.CP_NCE_DISCOUNT
import com.payu.checkoutpro.utils.PayUCheckoutProConstants.CP_OFFER_DISCOUNT
import com.payu.checkoutpro.utils.PayUCheckoutProConstants.CP_P_FEE_MESSAGE
import com.payu.checkoutpro.utils.PayUCheckoutProConstants.CP_SUBVENTION_AMOUNT
import com.payu.checkoutpro.utils.PayUCheckoutProConstants.CP_TENURE
import com.payu.checkoutpro.utils.PayUCheckoutProConstants.CP_TOTAL
import com.payu.checkoutpro.utils.PayUCheckoutProConstants.CP_TOTAL_PAYABLE
import com.payu.checkoutpro.utils.PayUCheckoutProConstants.CP_TRANSACTION_AMOUNT
import com.payu.india.Interfaces.OnEmiCalculaterListener
import com.payu.india.Model.PayuResponse
import com.payu.india.Payu.PayuConstants
import com.payu.india.Tasks.V2ApiTask
import com.payu.paymentparamhelper.PaymentParams
import org.json.JSONArray
import org.json.JSONObject

class CalculateEmiApiObject(
    payuBizparams: PaymentParams,
    payUPaymentParams: PayUPaymentParams,
    private val calculateEmiRequest: CalculateEmiRequest,
    listener: Any?
) : V2BaseApiObject(payUPaymentParams, payuBizparams),
    OnEmiCalculaterListener {

    private val emiListener = listener as EmiCalculationListener
    private val payuPaymentParams = payUPaymentParams

    override fun getHashName() = PayUCheckoutProConstants.CALCULATE_EMI_HASH_NAME


    override fun callApi() {
        val offersKeyList = JSONArray()
        InternalConfig.selectedOfferInfo?.let {
            if (!it.isSkuOffer) {
                it.offerMap?.keys?.forEach { offerKey ->
                    offersKeyList.put(offerKey)
                    this.calculateEmiRequest.autoApplyOffer = false
                }
            }
        }
        val sku =
            if (InternalConfig.selectedOfferInfo == null || InternalConfig.selectedOfferInfo?.isSkuOffer == true) getSkuJson().toString()
            else null
        val calculateEmiRequest = com.payu.india.Model.CalculateEmiRequest.Builder()
            .setTxnAmount(this.calculateEmiRequest.txnAmount.toLong())
            .setAdditionalCharges(this.calculateEmiRequest.additionalCharges?.toLong() ?: 0)
            .setOfferKeys(offersKeyList)
            .setBankCodes(this.calculateEmiRequest.bankCodes)
            .setEmiCodes(this.calculateEmiRequest.emiCodes)
            .setSkus(sku)
            .setAutoApplyOffer(this.calculateEmiRequest.autoApplyOffer)
            .setAdditionalCharge(payuPaymentParams.additionalCharges)
            .setPercentageAdditionalCharges(payuPaymentParams.percentageAdditionalCharges)
            .setTxnId(payuPaymentParams.transactionId)
            .setCardBin(this.calculateEmiRequest.cardBin)
            .build()

        startTime = System.currentTimeMillis()
        val v2ApiTask = V2ApiTask(payuBizparams.key, payuConfig)
        v2ApiTask.getEmiCalculator(calculateEmiRequest, this, this)
    }

    override fun onEmiCalculatorResponse(payuResponse: PayuResponse?) {
        val timeTaken = System.currentTimeMillis() - startTime
        CPAnalyticsUtils.logApiResponseSuccess(getHashName(), timeTaken, payuConfig.data)
        val resultJson = payuResponse?.rawResponse?.getJSONObject(CONFIG_RESPONSE_KEY)
        if (resultJson != null && resultJson.length() != 0) {
            val bankNameKeys = resultJson.keys()
            val emiDetailsArrayList = ArrayList<EmiDetails>()
            for (bankName in bankNameKeys) {
                val bankCodeKeys = payuResponse.rawResponse?.getJSONObject(CONFIG_RESPONSE_KEY)
                    ?.getJSONObject(bankName)?.keys()
                if (bankCodeKeys != null) {
                    for (emi in bankCodeKeys) {
                        val tenureJsonObject =
                            payuResponse.rawResponse.getJSONObject(CONFIG_RESPONSE_KEY)
                                .getJSONObject(bankName).getJSONObject(emi)
                        val emiDetails = EmiDetails()
                        val nceDiscount = NceDiscount()
                        val offerDiscount = NceDiscount()
                        emiDetails.transactionAmount =
                            tenureJsonObject.getDouble(CP_TRANSACTION_AMOUNT)
                        emiDetails.emiAmount = tenureJsonObject.getDouble(CP_EMI_AMOUNT)
                        emiDetails.additionalCost =
                            tenureJsonObject.getDouble(CP_ADDITIONAL_COST)
                        emiDetails.bankRate = tenureJsonObject.getDouble(CP_BANK_RATE)
                        emiDetails.bankCharge = tenureJsonObject.getDouble(CP_BANK_CHARGE)
                        emiDetails.amount = tenureJsonObject.getDouble(CP_AMOUNT)
                        emiDetails.cardType = tenureJsonObject.getString(CP_CARDTYPE)
                        emiDetails.tenure = tenureJsonObject.getString(CP_TENURE)
                        emiDetails.loanAmount = tenureJsonObject.getString(CP_LOAN_AMOUNT)
                        val offerDiscountJson =
                            tenureJsonObject.getJSONObject(CP_OFFER_DISCOUNT)
                        offerDiscount.total = offerDiscountJson.optDouble(CP_TOTAL)
                        if (offerDiscount.total != 0.0) {
                            offerDiscount.instant = offerDiscountJson.optDouble(CP_INSTANT)
                            offerDiscount.cashback = offerDiscountJson.optDouble(CP_CASHBACK)
                            emiDetails.offerDiscount = offerDiscount
                        }
                        val nceDiscountJson = tenureJsonObject.getJSONObject(CP_NCE_DISCOUNT)
                        nceDiscount.total = nceDiscountJson.optDouble(CP_TOTAL)
                        if (nceDiscount.total != 0.0) {
                            nceDiscount.instant = nceDiscountJson.optDouble(CP_INSTANT)
                            nceDiscount.cashback = nceDiscountJson.optDouble(CP_CASHBACK)
                            emiDetails.nceDiscount = nceDiscount
                        }
                        var offerDiscountInstant = 0.0
                        var offerDiscountCashBack = 0.0
                        var nceDiscountInstant = 0.0
                        var nceDiscountCashBack = 0.0
                        if ((tenureJsonObject.optJSONArray(PayuConstants.P_SKU)?.length()
                                ?: 0) > 0
                        ) {
                            val skus = tenureJsonObject.optJSONArray(PayuConstants.P_SKU)
                            for (i in 0 until (skus?.length() ?: 0)) {
                                val offerDiscountJsonSku = skus?.getJSONObject(i)
                                    ?.getJSONObject(CP_OFFER_DISCOUNT)
                                offerDiscountInstant += offerDiscountJsonSku?.optDouble(
                                    CP_INSTANT,
                                    0.0
                                ) ?: 0.0
                                offerDiscountCashBack += offerDiscountJson.optDouble(
                                    CP_CASHBACK,
                                    0.0
                                )
                                val nceDiscountJsonSku = skus?.getJSONObject(i)
                                    ?.getJSONObject(CP_NCE_DISCOUNT)
                                nceDiscountInstant += nceDiscountJsonSku?.optDouble(
                                    CP_INSTANT,
                                    0.0
                                )
                                    ?: 0.0
                                nceDiscountCashBack += nceDiscountJsonSku?.optDouble(
                                    CP_CASHBACK,
                                    0.0
                                ) ?: 0.0
                            }
                            offerDiscount.instant = offerDiscountInstant
                            offerDiscount.cashback = offerDiscountCashBack
                            offerDiscount.total =
                                offerDiscountInstant.plus(offerDiscountCashBack)
                            nceDiscount.instant = nceDiscountInstant
                            nceDiscount.cashback = nceDiscountCashBack
                            nceDiscount.total = nceDiscountInstant.plus(nceDiscountCashBack)
                            emiDetails.offerDiscount = offerDiscount
                            emiDetails.nceDiscount = nceDiscount

                        }

                        emiDetails.totalPayableAmount =
                            tenureJsonObject.getDouble(CP_TOTAL_PAYABLE)
                        emiDetails.subventionAmount =
                            tenureJsonObject.optDouble(CP_SUBVENTION_AMOUNT)
                        emiDetails.emiValue = tenureJsonObject.optDouble(CP_EMI_VALUE)
                        emiDetails.emiInterestPaid =
                            tenureJsonObject.optDouble(CP_EMI_INTEREST_PAID)
                        emiDetails.emiBankCode = emi
                        if (tenureJsonObject.has(CP_EMI_PROCESSING_FEE)) {
                            val processingFeeJson =
                                tenureJsonObject.getJSONObject(CP_EMI_PROCESSING_FEE)
                            emiDetails.processingFee =
                                processingFeeJson.getString(CP_FEE).toDoubleOrNull()
                            emiDetails.processingFeeMessage = processingFeeJson.getString(
                                CP_P_FEE_MESSAGE
                            )
                        }
                        emiDetailsArrayList.add(emiDetails)

                    }
                }
                emiListener.onEmiCalculated(emiDetailsArrayList)

            }
        } else {
            emiListener.onEmiCalculated(null)
        }
    }

    private fun getSkuJson(): JSONObject? {
        var totalSkuAmount = 0.0
        val skuDetailsJsonArray = JSONArray()
        payuPaymentParams.skuDetails?.skus?.let {
            for (sku in it) {
                val jsonObject = JSONObject()
                InternalConfig.selectedOfferInfo?.let { selectedOfferInfo ->
                    selectedOfferInfo.offerMap?.values?.forEach { offerInfo ->
                        if ((offerInfo.sku?.skuId == sku.skuId)) {
                            val offerKeyJson = JSONArray()
                            offerKeyJson.put(offerInfo.offerKey)
                            jsonObject.put(PayuConstants.OFFER_KEY, offerKeyJson)
                            this.calculateEmiRequest.autoApplyOffer = false
                            jsonObject.put(PayuConstants.P_AUTO_APPLY_M_OFFER, false)
                        } else jsonObject.put(PayuConstants.P_AUTO_APPLY_M_OFFER, true)
                    }
                }
                jsonObject.put(PayuConstants.P_SKU_M_ID, sku.skuId)
                totalSkuAmount += (sku.skuAmount.toDouble()) * (sku.quantity.toDouble())
                jsonObject.put(PayuConstants.P_SKU_M_AMOUNT, sku.skuAmount)
                jsonObject.put(PayuConstants.P_QUANTITY, sku.quantity)
                jsonObject.put(PayuConstants.P_SKU_NAME, sku.skuName)
                skuDetailsJsonArray.put(jsonObject)
            }
        }

        if (totalSkuAmount == (payuPaymentParams.amount?.toDouble() ?: 0.0)) {
            val jsonObject = JSONObject()
            jsonObject.put(PayuConstants.P_SKU_DETAILS, skuDetailsJsonArray)
            return jsonObject
        }

        return null
    }


}