package com.payu.checkoutpro.models

import android.content.Context
import com.payu.base.models.BinBaseDetails
import com.payu.base.models.InternalConfig
import com.payu.base.models.PayUPaymentParams
import com.payu.checkoutpro.utils.ParserUtils
import com.payu.checkoutpro.utils.V2ApRequestParser
import com.payu.checkoutpro.utils.V2ApiResponseParser
import com.payu.india.Interfaces.V2ApiResponseListener
import com.payu.india.Model.ApiResponse
import com.payu.india.Model.binBaseDetails.BinBaseDetailsRequest
import com.payu.india.Model.binBaseDetails.BinBaseDetailsResponse
import com.payu.india.Model.validateOffer.ValidateOfferRequest
import com.payu.india.Payu.PayuConstants
import com.payu.india.Tasks.V2ApiTask
import com.payu.paymentparamhelper.PaymentParams
import org.json.JSONArray
import java.util.Locale.Category

class BinBaseDetailsApiObject(
    private val context: Context?,
    internal val cardNumber: String,
    internal val cardToken: String?,
    internal val category: String?,
    internal val paymentCode: String?,
    internal val payuBizParams: PaymentParams,
    payUPaymentParams: PayUPaymentParams,
    private val onBinBaseDetailsResponse: (BinBaseDetails?) -> Unit?
) : V2BaseApiObject(payUPaymentParams, payuBizParams),
    V2ApiResponseListener<ApiResponse<BinBaseDetailsResponse>> {

    private val payuPaymentParams = payUPaymentParams
    private var isAutoApply: Boolean = true
    override fun callApi() {

        val validateOfferReq = getValidateOfferReq(cardNumber, cardToken, category, paymentCode)
        val binBaseDetailsRequest =
            BinBaseDetailsRequest.Builder(cardNumber).setAmount(payuBizparams.amount)
                .setTxnId(payuBizparams.txnId).setMerchantKey(payuBizparams.key)
                .setSource(PayuConstants.PAYU_SOURCE_ANDROID_SDK)
                .setAdditionalCharges(payuBizparams.additionalCharges)
                .setPercentageAdditionalCharges(payuBizparams.percentageAdditionalCharges)
                .setPricingCFEnable(InternalConfig.isPricingCFCall ?: false)
                .setIsSITxn(payuPaymentParams.payUSIParams != null)
                .setValidateOfferRequest(if (InternalConfig.isOfferEnabled) validateOfferReq else null)
                .build()
        val v2ApiTask = V2ApiTask(payuBizparams.key, payuConfig)
        v2ApiTask.getBinBaseDetails(binBaseDetailsRequest, this, this)
    }

    override fun getHashName() = PayuConstants.PAYU_BIN_BASE

    override fun onApiResponse(binBaseDetailsResp: ApiResponse<BinBaseDetailsResponse>?) {
        val binBaseDetails = BinBaseDetails()
        binBaseDetailsResp?.payuResponse?.cardInformation?.let { cardInfo ->
            V2ApiResponseParser.parseBinInfoResponse(
                context,
                payuPaymentParams,
                cardInfo,
                binBaseDetailsResp.payuResponse?.convFeeChargesMap,
                binBaseDetails
            )
        }

        binBaseDetailsResp?.payuResponse?.validateOfferDetails?.let { validateOfferDetails ->
            V2ApiResponseParser.parseValidateOfferResponse(
                payuPaymentParams,
                payuBizParams,
                validateOfferDetails,
                binBaseDetails
            )
        }

        onBinBaseDetailsResponse.invoke(binBaseDetails)
    }

    private fun getValidateOfferReq(
        cardNumber: String,
        cardToken: String?,
        category: String?,
        paymentCode: String?
    ): ValidateOfferRequest {
        var offersKeyList: JSONArray? = null
        InternalConfig.userSelectedOfferInfo?.let {
            if (!it.isSkuOffer) {
                offersKeyList = JSONArray()
                offersKeyList?.put(it.offerKey)
                this.isAutoApply = false
            }
        }
        val (sku, isAutoApplied) =
            if (InternalConfig.userSelectedOfferInfo == null || InternalConfig.userSelectedOfferInfo?.isSkuOffer == true) ParserUtils.getSkuJson(
                payuPaymentParams,
                isAutoApply
            )
            else Pair(null, isAutoApply)
        isAutoApply = isAutoApplied

        return V2ApRequestParser.getValidateOfferReq(
            payuBizParams,
            offersKeyList,
            sku,
            payuBizparams.userToken,
            cardNumber,
            cardToken,
            category,
            paymentCode,
            isAutoApply
        )
    }

}