package com.payu.checkoutpro.reConverter

import com.payu.base.models.*
import com.payu.checkoutpro.utils.CommonUtils
import com.payu.checkoutpro.utils.ParserUtils
import com.payu.checkoutpro.utils.PayUCheckoutProConstants
import com.payu.india.Model.QuickPay.QuickPaySavedOption
import com.payu.india.Model.QuickPay.RecommendedOptions
import com.payu.india.Payu.PayuConstants

object CardPaymentModeConverter {

    fun getSavedCardPaymentMode(quickPaySavedOption: QuickPaySavedOption): ArrayList<PaymentOption> {
        val savedCardOption = SavedCardOption()
        val optionDetail: ArrayList<PaymentOption> = ArrayList()
        val pgTitle = quickPaySavedOption.pgTitle
        val list = pgTitle?.split("-")
        if (list?.size == 2) {
            savedCardOption.cardNumber = list[1]
            savedCardOption.bankName = list[0]
        }

        savedCardOption.isBankDown = quickPaySavedOption.isPgUP
        val cardBinInfo = CardBinInfo()
        cardBinInfo.cardType = CardType.valueOf(quickPaySavedOption.paymentType.uppercase())
        cardBinInfo.cardScheme = CommonUtils.getCardScheme(quickPaySavedOption.ibiboCode)
        cardBinInfo.binNumber = savedCardOption.cardNumber.substring(0,6)
        savedCardOption.cardBinInfo = cardBinInfo
        savedCardOption.cardToken = quickPaySavedOption.pgDetails
        savedCardOption.isTokenTxn = quickPaySavedOption.isTokenTxn
        savedCardOption.paymentType = PaymentType.CARD
        savedCardOption.phoneNumber = quickPaySavedOption.phoneNumber
        savedCardOption.paymentMode = quickPaySavedOption.paymentType
        savedCardOption.otherParams =
            CommonUtils.getOtherParamsMap(PayuConstants.PAYU_CC, savedCardOption.bankName)
        savedCardOption.userCredential = quickPaySavedOption.userCredential
        updateTaxValue(
            savedCardOption,
            CommonUtils.getCardType(
                quickPaySavedOption.category ?: ""
            )
        )
        if (quickPaySavedOption.isTokenTxn)
            optionDetail.add(savedCardOption)
        return optionDetail
    }

    fun getRECardPaymentOption(recommendedOptions: RecommendedOptions): ArrayList<PaymentOption> {
        val optionDetails = ArrayList<PaymentOption>()
        val paymentModeMap = ParserUtils.paymentOptionMap[PaymentType.CARD]
        val paymentOption: CardOption? =
            paymentModeMap?.get(recommendedOptions.ibiboCode) as? CardOption
        if (paymentOption != null) {
            val othersParamMap =
                paymentOption.otherParams as? HashMap<String, String>
            if (othersParamMap?.get(PayUCheckoutProConstants.CP_BANK_CODE)?.isNotEmpty() == true)
                optionDetails.add(paymentOption)
        }
        return optionDetails
    }

    internal fun getDeleteApiSavedPaymentMode(paymentOption: SavedCardOption): QuickPaySavedOption {
        val quickPaySavedOption = QuickPaySavedOption()
        quickPaySavedOption.paymentType = paymentOption.paymentType?.name
        quickPaySavedOption.pgTitle = paymentOption.bankName + paymentOption.cardNumber
        quickPaySavedOption.pgDetails = paymentOption.cardToken
        quickPaySavedOption.userCredential = paymentOption.userCredential
        quickPaySavedOption.paymentType = paymentOption.paymentMode
        quickPaySavedOption.ibiboCode = CommonUtils.getValueFromPaymentOption(
            PayUCheckoutProConstants.CP_BANK_CODE,
            paymentOption.otherParams as? java.util.HashMap<String, Any?>
        )
        return quickPaySavedOption
    }

    private fun updateTaxValue(
        savedCardOption: SavedCardOption,
        cardType: CardType
    ) {
        when (cardType) {
            CardType.CC -> {
                for (paymentDetail in ParserUtils.convenienceFeeResponse?.creditCard
                    ?: arrayListOf()) {
                    if (paymentDetail.bankCode.equals(savedCardOption.bankCode, ignoreCase = true)) {
                        savedCardOption.additionalCharge =
                            paymentDetail.additionalCharge?.toDoubleOrNull() ?: 0.0
                        savedCardOption.gstPercentageValue =
                            ParserUtils.convenienceFeeResponse?.taxSpecification?.ccTaxValue?.toDoubleOrNull()
                                ?: 0.0
                    }
                }
            }

            CardType.DC -> {
                for (paymentDetail in ParserUtils.convenienceFeeResponse?.debitCard
                    ?: arrayListOf()) {
                    if (paymentDetail.bankCode.equals(savedCardOption.bankCode, ignoreCase = true)) {
                        savedCardOption.additionalCharge =
                            paymentDetail.additionalCharge?.toDoubleOrNull() ?: 0.0
                        savedCardOption.gstPercentageValue =
                            ParserUtils.convenienceFeeResponse?.taxSpecification?.dcTaxValue?.toDoubleOrNull()
                                ?: 0.0
                    }
                }
            }
        }
    }
}