package com.payu.checkoutpro.parser.constants

object PayUHybridKeys {
    object Others {
        const val payUPaymentParams = "payUPaymentParams"
        const val payUCheckoutProConfig = "payUCheckoutProConfig"
        const val onPaymentSuccess = "onPaymentSuccess"
        const val onPaymentFailure = "onPaymentFailure"
        const val onPaymentCancel = "onPaymentCancel"
        const val onError = "onError"
        const val generateHash = "generateHash"
        const val errorMsg = "errorMsg"
        const val errorCode = "errorCode"
        const val isTxnInitiated = "isTxnInitiated"
        const val drawable = "drawable"

        const val daily = "daily"
        const val weekly = "weekly"
        const val once = "once"
        const val yearly = "yearly"
        const val adhoc = "adhoc"
        const val monthly = "monthly"

        const val NetBanking = "NetBanking"
        const val UPI = "UPI"
        const val Wallets = "Wallets"
        const val EMI = "EMI"
        const val Cards = "Cards"
        const val TEZ = "TEZ"
        const val PAYTM = "PAYTM"
        const val PHONEPE = "PHONEPE"
        const val custom_note = "custom_note"
        const val custom_note_category = "custom_note_category"
        const val openCheckoutScreen = "openCheckoutScreen"
        const val hashGenerated = "hashGenerated"
    }

    object PaymentParam {
        const val key = "key"
        const val amount = "amount"
        const val productInfo = "productInfo"
        const val firstName = "firstName"
        const val email = "email"
        const val phone = "phone"
        const val surl = "android_surl"
        const val furl = "android_furl"
        const val environment = "environment"
        const val userCredential = "userCredential"
        const val transactionId = "transactionId"
        const val additionalParam = "additionalParam"
        const val payUSIParams = "payUSIParams"
        const val splitPaymentDetails = "splitPaymentDetails"
        const val userToken = "userToken"
        const val skus= "skus"
        const val quantity = "quantity"
        const val skuAmount = "skuAmount"
        const val skuId = "skuId"
        const val skuName = "skuName"
        const val offerKeys = "offerKeys"
        const val skuDetails = "skuDetails"
        const val payuBeneficiaryAccount = "beneficiaryAccount"
        const val payuBeneficiaryIfsc = "beneficiaryIfsc"
        const val payuBeneficiaryName = "beneficiaryName"
        const val payuBeneficiaryAccountType = "beneficiaryAccountType"
        const val payuBeneficiaryVerificationMode = "verificationMode"
        const val payUBeneficiaryDetail = "beneficiaryDetails"
        const val additionalCharges = "additionalCharges"
        const val percentageAdditionalCharges = "percentageAdditionalCharges"
        const val enforcementOfferKeys = "enforcementOfferKeys"
        const val addressDetails = "address"

        object AdditionalParam {
            const val payment = "payment"
            const val paymentSource = "payment_source"
            const val sourceId = "sourceId"

        }

        object SIParams {
            const val isFreeTrial = "isFreeTrial"
            const val billingAmount = "billingAmount"
            const val billingInterval = "billingInterval"
            const val paymentStartDate = "paymentStartDate"
            const val paymentEndDate = "paymentEndDate"
            const val billingCycle = "billingCycle"
            const val remarks = "remarks"
            const val billingCurrency = "billingCurrency"
            const val billingLimit = "billingLimit"
            const val billingRule = "billingRule"
            const val billingDate = "billingDate"
            const val isPreAuthTxn = "isPreAuthTxn"

        }

        object AddressDetails {
            const val lastName = "lastname"
            const val address1 = "address1"
            const val address2 = "address2"
            const val city = "city"
            const val state = "state"
            const val country = "country"
            const val zipcode = "zipcode"
        }
    }

    object CheckoutProConfig {
        const val merchantName = "merchantName"
        const val merchantLogo = "merchantLogo"
        const val showExitConfirmationOnCheckoutScreen = "showExitConfirmationOnCheckoutScreen"
        const val showExitConfirmationOnPaymentScreen = "showExitConfirmationOnPaymentScreen"
        const val cartDetails = "cartDetails"
        const val paymentModesOrder = "paymentModesOrder"
        const val merchantResponseTimeout = "merchantResponseTimeout"
        const val customNotes = "customNotes"
        const val autoSelectOtp = "autoSelectOtp"
        const val enforcePaymentList = "enforcePaymentList"
        const val waitingTime = "waitingTime" //-->(Android)
        const val autoApprove = "autoApprove" //-->(Android)
        const val merchantSMSPermission = "merchantSMSPermission" //-->(Android)
        const val showCbToolbar = "showCbToolbar" //-->(Android)
        const val showMerchantLogo = "showMerchantLogo" //-->(Android)
        const val enableSavedCard = "enableSavedCard" //-->(Android)
        const val enableSslDialog = "enableSslDialog" //-->(Android)
        const val primaryColor = "primaryColor" //-->(Android)
        const val baseTextColor = "baseTextColor" //-->(Android)
        const val enableREOptions = "enableREOptions" // //-->(Android)
        const val upiAppsOrder = "upiAppsOrder" // --> for upi apps order in L1

    }
}