package com.payu.checkoutpro.parser

import android.app.Activity
import com.payu.base.models.ErrorResponse
import com.payu.checkoutpro.parser.constants.PayUHybridKeys
import com.payu.checkoutpro.parser.constants.PayUHybridValues
import com.payu.ui.model.listeners.PayUHashGenerationListener

class CheckoutProCallbackToJSONParser {
    private var hashGenerationListener: PayUHashGenerationListener? = null

    fun hashGenerated(
        activity: Activity?,
        params: Any?,
        errorCallback: (ErrorResponse?) -> Unit
    ) {
        val hashMap = params as? HashMap<String, String?>
        if (activity != null && !activity.isFinishing && !activity.isDestroyed) {
            if (hashMap != null && hashMap.isNotEmpty()) {
                activity.runOnUiThread {
                    hashGenerationListener?.onHashGenerated(hashMap)
                    errorCallback(null)
                }
            } else {
                val errorResponse = ErrorResponse()
                errorResponse.errorCode = PayUHybridValues.Error.HASH_NOT_GENERATED_ERROR_CODE
                errorResponse.errorMessage = PayUHybridValues.Error.HASH_NOT_GENERATED_ERROR
                errorCallback(errorResponse)
            }
        } else {
            val errorResponse = ErrorResponse()
            errorResponse.errorMessage = PayUHybridValues.Error.ACTIVITY_OR_CONTEXT_NULL
            errorResponse.errorCode = PayUHybridValues.Error.NULL_CONTEXT_ERROR_CODE
            errorCallback(errorResponse)
        }
    }

    fun onPaymentSuccess(response: Any): Any {
        return response
    }

    fun onPaymentFailure(response: Any): Any {
        return response
    }

    fun onPaymentCancel(isTxnInitiated: Boolean): Any {
        val result: HashMap<String, Boolean> = HashMap()
        result[PayUHybridKeys.Others.isTxnInitiated] = isTxnInitiated
        return result
    }

    fun onError(errorResponse: ErrorResponse): Any {
        val result: HashMap<String, Any?> = HashMap()
        var errorMessage: String =
            if (errorResponse.errorMessage != null && errorResponse.errorMessage!!.isNotEmpty())
                errorResponse.errorMessage!!
            else PayUHybridValues.Error.SOME_ERROR_OCCURRED

        result[PayUHybridKeys.Others.errorCode] = errorResponse.errorCode
        result[PayUHybridKeys.Others.errorMsg] = errorMessage
        return result
    }

    fun generateHash(
        map: HashMap<String, String?>,
        hashListener: PayUHashGenerationListener
    ): HashMap<String, String?> {
        hashGenerationListener = hashListener
        return map
    }

}
