package com.payu.checkoutpro.models

import com.payu.base.models.DeviceIdRequestModel
import com.payu.base.models.PayUPaymentParams
import com.payu.india.Model.DeviceIdRequest
import com.payu.india.Tasks.V2ApiTask
import com.payu.paymentparamhelper.PaymentParams

class DeviceIdApiObject(
    deviceIdRequestModel: DeviceIdRequestModel,
    payUPaymentParams: PayUPaymentParams,
    payuBizparams: PaymentParams,
    listener: Any?
) : V2BaseApiObject(payUPaymentParams, payuBizparams) {

    private val deviceIdRequestModel: DeviceIdRequestModel = deviceIdRequestModel

    override fun getHashName(): String = "device_id"

    override fun callApi() {
        V2ApiTask(payuBizparams.key, payuConfig).updateDeviceId(
            DeviceIdRequest.Builder().setPayUID(deviceIdRequestModel.payUID)
                .setGaid(deviceIdRequestModel.gaID).build(), this
        )
    }

}