package com.payu.checkoutpro.models

import com.payu.base.listeners.OnDeleteSavedOptionListener
import com.payu.base.models.ErrorResponse
import com.payu.base.models.PayUPaymentParams
import com.payu.base.models.PaymentOption
import com.payu.checkoutpro.reConverter.PaymentModeConverter
import com.payu.checkoutpro.utils.CPAnalyticsUtils
import com.payu.checkoutpro.utils.PayUCheckoutProConstants.CP_DELETE_SAVED_OPTIONS
import com.payu.checkoutpro.utils.PayUCheckoutProConstants.CP_SAVED_OPTION_NOT_DELETED
import com.payu.india.Interfaces.DeleteSavedOptionsListener
import com.payu.india.Model.DeleteSavedOptionsRequest
import com.payu.india.Model.PayuResponse
import com.payu.india.Payu.PayuConstants
import com.payu.india.Tasks.V2ApiTask
import com.payu.paymentparamhelper.PaymentParams

class DeleteSavedOptionsApiObject(
    payuBizParams: PaymentParams,
    payUPaymentParams: PayUPaymentParams,
    private val deviceId: String,
    private val paymentOption: PaymentOption,
    listener: Any?
) : V2BaseApiObject(payUPaymentParams, payuBizParams), DeleteSavedOptionsListener {

    private var onDeleteSavedOptionListener = listener as? OnDeleteSavedOptionListener

    override fun callApi() {
        onDeleteSavedOptionListener?.showProgressDialog(true)
        val quickPaySavedOption = PaymentModeConverter.getDeleteSavedOptions(paymentOption)
        if (paymentOption.phoneNumber.isNotEmpty()) payuBizparams.phone = paymentOption.phoneNumber
        val deleteSavedOptionsRequest =
            DeleteSavedOptionsRequest.Builder().setPhone(payuBizparams.phone)
                .setDeviceId(deviceId).setConsent("0")
                .setPaymentMode(quickPaySavedOption?.paymentType)
                .setPgTitle(quickPaySavedOption?.pgTitle)
                .setPgDetails(quickPaySavedOption?.pgDetails)
                .setIbiboCode(quickPaySavedOption?.ibiboCode)
                .setUserCredential(quickPaySavedOption?.userCredential).build()

        startTime = System.currentTimeMillis()
        val v2ApiTask = V2ApiTask(payuBizparams.key, payuConfig)
        v2ApiTask.deleteSavedOptions(deleteSavedOptionsRequest, this, this)
    }

    override fun getHashName() = CP_DELETE_SAVED_OPTIONS




    override fun onDeleteSavedOptionResponse(payuResponse: PayuResponse?) {
        val timeTaken = System.currentTimeMillis() - startTime
        val consentResponse = payuResponse?.rawResponse
        val consent = consentResponse?.getBoolean(PayuConstants.STATUS)
        if (consent == true) {
            CPAnalyticsUtils.logApiResponseSuccess(getHashName(), timeTaken, payuConfig.data)
            onDeleteSavedOptionListener?.onDeletedSuccessfully()
        } else {
            CPAnalyticsUtils.logApiResponseFailure(getHashName(), timeTaken, CP_SAVED_OPTION_NOT_DELETED, payuResponse?.responseStatus?.code)
            sendErrorResponse(payuResponse?.responseStatus?.code, CP_SAVED_OPTION_NOT_DELETED)
        }
        onDeleteSavedOptionListener?.showProgressDialog(false)
    }

    private fun sendErrorResponse(errorCode: Int?, errorMessage: String?) {
        val errorResponse = ErrorResponse()
        errorResponse.errorMessage = errorMessage
        errorResponse.errorCode = errorCode
        onDeleteSavedOptionListener?.showProgressDialog(false)
        onDeleteSavedOptionListener?.onError(errorResponse)
    }
}