package com.payu.checkoutpro.models

import com.payu.base.models.ErrorResponse
import com.payu.checkoutpro.utils.CPAnalyticsUtils
import com.payu.checkoutpro.utils.PayUCheckoutProConstants
import com.payu.india.Interfaces.CheckBalanceListener
import com.payu.india.Model.MerchantWebService
import com.payu.india.Model.PayuResponse
import com.payu.india.Payu.PayuErrors
import com.payu.india.PostParams.MerchantWebServicePostParams
import com.payu.india.Tasks.CheckBalanceTask
import com.payu.paymentparamhelper.PaymentParams

class CheckBalanceApiObject(
    payuBizparams: PaymentParams,
    val response: (PayuResponse?) -> Unit,
    val var1: String
) : V1BaseApiObject(payuBizparams), CheckBalanceListener {

    private var startTime: Long = 0

    override fun callApi(map: HashMap<String, String?>) {
        val merchantWebService = MerchantWebService()
        merchantWebService.key = payuBizparams.key
        merchantWebService.command = PayUCheckoutProConstants.CP_CHECK_BALANCE
        merchantWebService.var1 = var1
        merchantWebService.hash = map[getHashName()]
        val postData =
            MerchantWebServicePostParams(merchantWebService).merchantWebServicePostParams

        if (postData.code == PayuErrors.NO_ERROR) {
            payuConfig.data = postData.result

            //As this will be independent call to Sodexo, and PayU don't have control over it, so we have made a timeout.
            // In case we don't get the response within that time, we show show the Tab to Fetch UI. It is in milliseconds.
            payuConfig.fetchSodexoBalanceTimeout =
                PayUCheckoutProConstants.SODEXO_CHECK_BALANCE_API_TIMEOUT

            val checkBalanceTask = CheckBalanceTask(this)
            startTime = System.currentTimeMillis()
            checkBalanceTask.execute(payuConfig)
        } else {
            val errorResponse = ErrorResponse()
            errorResponse.errorMessage = postData.result
//            onFetchPaymentOptionsListener.showProgressDialog(false)
//            onFetchPaymentOptionsListener.onError(errorResponse)
        }
    }

    override fun getHashName() = PayUCheckoutProConstants.CP_CHECK_BALANCE_HASH


    override fun onCheckBalanceResponse(payuResponse: PayuResponse?) {
        val timeTaken = System.currentTimeMillis() - startTime
        CPAnalyticsUtils.logApiResponseSuccess(getHashName(), timeTaken, payuConfig.data)
        response(payuResponse)
    }
}