/*
 * Decompiled with CFR 0.152.
 */
package com.payu.ui.model.utils;

import android.content.Context;
import android.content.SharedPreferences;
import android.security.keystore.KeyGenParameterSpec;
import android.util.Log;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import androidx.security.crypto.EncryptedSharedPreferences;
import androidx.security.crypto.MasterKeys;
import com.payu.base.models.ApiResponse;
import com.payu.base.models.BnplOption;
import com.payu.base.models.CardScheme;
import com.payu.base.models.CustomNote;
import com.payu.base.models.EMIOption;
import com.payu.base.models.EMiOptionInOffers;
import com.payu.base.models.EmiType;
import com.payu.base.models.InternalConfig;
import com.payu.base.models.OfferInfo;
import com.payu.base.models.PayUBeneficiaryAccountType;
import com.payu.base.models.PayUBillingCycle;
import com.payu.base.models.PayUSIParams;
import com.payu.base.models.PaymentFlowState;
import com.payu.base.models.PaymentMode;
import com.payu.base.models.PaymentModel;
import com.payu.base.models.PaymentOption;
import com.payu.base.models.PaymentOptionOfferinfo;
import com.payu.base.models.PaymentType;
import com.payu.ui.R;
import com.payu.ui.SdkUiInitializer;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00d0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b&\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00042\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\u0010\u0010\u0017\u001a\u00020\u00042\b\u0010\u0018\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u0019\u001a\u00020\u00042\b\u0010\u0018\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0017\u0010\u001e\u001a\u00020\u00042\b\u0010\u001f\u001a\u0004\u0018\u00010\u0004H\u0000\u00a2\u0006\u0002\b J\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0004J\u0010\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010'J\u0010\u0010(\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010'J\u001a\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020+0*J\u0012\u0010-\u001a\u0004\u0018\u00010\u00042\b\u0010.\u001a\u0004\u0018\u00010\u0004J)\u0010/\u001a\u0004\u0018\u00010\u00042\b\u00100\u001a\u0004\u0018\u0001012\u000e\u00102\u001a\n\u0012\u0004\u0012\u000203\u0018\u00010*H\u0000\u00a2\u0006\u0002\b4J\u0010\u00105\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010'J\u000e\u00106\u001a\u00020\u00042\u0006\u00107\u001a\u00020%J\u001c\u00108\u001a\u00020%2\b\u00100\u001a\u0004\u0018\u0001012\n\b\u0002\u00109\u001a\u0004\u0018\u00010:J\u001d\u0010;\u001a\u0004\u0018\u00010%2\u0006\u0010<\u001a\u00020=2\u0006\u00100\u001a\u000201\u00a2\u0006\u0002\u0010>J%\u0010?\u001a\n\u0012\u0004\u0012\u00020@\u0018\u00010*2\u000e\u0010A\u001a\n\u0012\u0004\u0012\u00020@\u0018\u00010*H\u0000\u00a2\u0006\u0002\bBJ\u0010\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020FH\u0002J\u000e\u0010G\u001a\u00020\u00042\u0006\u0010H\u001a\u00020\u0004J!\u0010I\u001a\u00020\u00042\b\u0010\u001f\u001a\u0004\u0018\u00010J2\u0006\u0010E\u001a\u00020FH\u0000\u00a2\u0006\u0004\bK\u0010LJ\u001c\u0010M\u001a\u0004\u0018\u00010\u00042\b\u0010N\u001a\u0004\u0018\u00010\u00042\b\u0010&\u001a\u0004\u0018\u00010'J\u001e\u0010O\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040P2\u0006\u0010E\u001a\u00020FJ\u001c\u0010Q\u001a\n\u0012\u0004\u0012\u00020@\u0018\u00010*2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020@0*J\r\u0010S\u001a\u00020JH\u0000\u00a2\u0006\u0002\bTJ\u0018\u0010U\u001a\u00020V2\u0006\u0010W\u001a\u00020@2\b\u0010X\u001a\u0004\u0018\u00010YJ\u001e\u0010Z\u001a\u0004\u0018\u00010@2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020+0*2\u0006\u00100\u001a\u000201J$\u0010[\u001a\n\u0012\u0004\u0012\u00020@\u0018\u00010*2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020+0*2\u0006\u00100\u001a\u000201J\b\u0010\\\u001a\u0004\u0018\u00010]J&\u0010^\u001a\n\u0012\u0004\u0012\u00020+\u0018\u00010*2\u000e\u0010,\u001a\n\u0012\u0004\u0012\u00020+\u0018\u00010*2\u0006\u00100\u001a\u000201J\u001c\u0010_\u001a\n\u0012\u0004\u0012\u00020+\u0018\u00010*2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020+0*J\u0016\u0010`\u001a\u00020\u00042\u0006\u0010a\u001a\u00020b2\u0006\u0010c\u001a\u00020bJ\u0016\u0010d\u001a\u0004\u0018\u00010@2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020@0*J7\u0010e\u001a\u0004\u0018\u0001Hf\"\u0004\b\u0000\u0010f2\u0006\u0010g\u001a\u00020\u00042\u0016\u0010h\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010iH\u0000\u00a2\u0006\u0004\bj\u0010kJ\u000e\u0010l\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010m\u001a\u00020n2\u0006\u0010N\u001a\u00020\u0004J\u001d\u0010o\u001a\u00020n2\u000e\u00102\u001a\n\u0012\u0004\u0012\u000203\u0018\u00010*H\u0000\u00a2\u0006\u0002\bpJ\u0010\u0010q\u001a\u00020n2\b\u0010&\u001a\u0004\u0018\u00010'J\u001b\u0010r\u001a\u00020n2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020@0*H\u0000\u00a2\u0006\u0002\bsJ\u0017\u0010t\u001a\u00020n2\b\u00100\u001a\u0004\u0018\u000101H\u0000\u00a2\u0006\u0002\buJ\u001d\u0010v\u001a\u00020n2\u000e\u0010w\u001a\n\u0012\u0004\u0012\u00020+\u0018\u00010*H\u0000\u00a2\u0006\u0002\bxJ \u0010y\u001a\u00020n2\u000e\u0010R\u001a\n\u0012\u0004\u0012\u00020z\u0018\u00010*2\u0006\u0010{\u001a\u00020\u0004H\u0002J\u001d\u0010|\u001a\u00020n2\u0006\u0010{\u001a\u00020\u00042\u0006\u00100\u001a\u000201H\u0000\u00a2\u0006\u0002\b}J\u001e\u0010~\u001a\u00020n2\u0006\u0010{\u001a\u00020\u00042\u0006\u0010\u007f\u001a\u00020\u0004H\u0000\u00a2\u0006\u0003\b\u0080\u0001J\u000f\u0010\u0081\u0001\u001a\u00020nH\u0000\u00a2\u0006\u0003\b\u0082\u0001J\u001e\u0010\u0083\u0001\u001a\u00020n2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020@0*2\u0007\u0010\u0084\u0001\u001a\u00020\u0004J\u001d\u0010\u0085\u0001\u001a\u00020n2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020@0*2\u0006\u00100\u001a\u000201J\u0012\u0010\u0086\u0001\u001a\u00020n2\t\u0010\u0087\u0001\u001a\u0004\u0018\u00010\u0004J\u0015\u0010\u0088\u0001\u001a\u00020n2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020@0*J\u000f\u0010\u0089\u0001\u001a\u00020n2\u0006\u0010N\u001a\u00020\u0004J\u001a\u0010\u008a\u0001\u001a\u00020n2\b\u0010&\u001a\u0004\u0018\u00010'2\u0007\u0010\u008b\u0001\u001a\u00020%J\u001a\u0010\u008c\u0001\u001a\u00020n2\u0007\u0010\u008d\u0001\u001a\u00020\u00042\b\u0010\u007f\u001a\u0004\u0018\u00010'J\u001a\u0010\u008e\u0001\u001a\u00020n2\b\u0010\u007f\u001a\u0004\u0018\u00010'2\u0007\u0010\u008b\u0001\u001a\u00020%J\u000f\u0010\u008f\u0001\u001a\u00020n2\u0006\u0010\u0018\u001a\u00020\u0004J\u0010\u0010\u0090\u0001\u001a\u00020n2\u0007\u0010\u0091\u0001\u001a\u00020\u0004J\u0010\u0010\u0092\u0001\u001a\u00020n2\u0007\u0010\u0093\u0001\u001a\u00020\u0004J\u0010\u0010\u0094\u0001\u001a\u00020n2\u0007\u0010\u008d\u0001\u001a\u00020\u0004J\u0010\u0010\u0095\u0001\u001a\u00020n2\u0007\u0010\u008d\u0001\u001a\u00020\u0004J\u0010\u0010\u0096\u0001\u001a\u00020n2\u0007\u0010\u0097\u0001\u001a\u00020\u0004J\u0010\u0010\u0098\u0001\u001a\u00020n2\u0007\u0010\u0099\u0001\u001a\u00020\u0004J\u000f\u0010\u009a\u0001\u001a\u00020n2\u0006\u0010N\u001a\u00020\u0004J\u0011\u0010\u009b\u0001\u001a\u00020\u00042\b\u00100\u001a\u0004\u0018\u000101J\u000f\u0010\u009c\u0001\u001a\u00020\u001b2\u0006\u0010E\u001a\u00020FJ!\u0010\u009d\u0001\u001a\u00020\u001b2\u0006\u0010E\u001a\u00020F2\u0007\u0010\u009e\u0001\u001a\u00020\u00042\u0007\u0010\u009f\u0001\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u0004\u0018\u00010\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00a0\u0001"}, d2={"Lcom/payu/ui/model/utils/Utils;", "", "()V", "AMEX_CARD_REGEX", "", "CARD_EXPIRE_REGEX", "NAME_ON_CARD_REGEX", "NUMBER_REGEX", "TAG", "VALIDATE_BAJAJ_CARD_REGEX", "VALIDATE_IFSC_REGEX", "VALIDATE_MOBILE_NUMBER_REGEX", "VALIDATE_VPA_REGEX", "customNote", "getCustomNote$one_payu_ui_sdk_android_release", "()Ljava/lang/String;", "setCustomNote$one_payu_ui_sdk_android_release", "(Ljava/lang/String;)V", "offerInfo", "Lcom/payu/base/models/OfferInfo;", "convertBillingCycle", "billingCycle", "Lcom/payu/base/models/PayUBillingCycle;", "convertYYYYMMDDTODDMMMYYYY", "date", "convertYYYYMMDDTODDMMYYYY", "displayKeyboard", "", "view", "Landroid/view/View;", "formatAmount", "amount", "formatAmount$one_payu_ui_sdk_android_release", "getAccountType", "Lcom/payu/base/models/PayUBeneficiaryAccountType;", "accountType", "getCardIconId", "", "cardScheme", "Lcom/payu/base/models/CardScheme;", "getCardInputMaxLength", "getCardPaymentOptionList", "Ljava/util/ArrayList;", "Lcom/payu/base/models/PaymentMode;", "paymentModesList", "getCategoryForOffer", "category", "getCustomeNoteDetails", "paymentType", "Lcom/payu/base/models/PaymentType;", "customeNoteDetails", "Lcom/payu/base/models/CustomNote;", "getCustomeNoteDetails$one_payu_ui_sdk_android_release", "getCvvInputLength", "getDayOfMonthSuffix", "n", "getDefaultDrawable", "emiType", "Lcom/payu/base/models/EmiType;", "getEligibilityDetails", "apiResponse", "Lcom/payu/base/models/ApiResponse;", "(Lcom/payu/base/models/ApiResponse;Lcom/payu/base/models/PaymentType;)Ljava/lang/Integer;", "getEligibleEmiTenuresList", "Lcom/payu/base/models/PaymentOption;", "emiTenureList", "getEligibleEmiTenuresList$one_payu_ui_sdk_android_release", "getEncryptedSharedPreference", "Landroid/content/SharedPreferences;", "context", "Landroid/content/Context;", "getExpiryYear", "currentDate", "getFormattedAmount", "", "getFormattedAmount$one_payu_ui_sdk_android_release", "(Ljava/lang/Double;Landroid/content/Context;)Ljava/lang/String;", "getFormattedString", "cardNumber", "getGlobalVaultStoredUserToken", "Lkotlin/Pair;", "getIntentAppsList", "list", "getOfferDiscountAmount", "getOfferDiscountAmount$one_payu_ui_sdk_android_release", "getPaymentModel", "Lcom/payu/base/models/PaymentModel;", "paymentOption", "paymentFlowState", "Lcom/payu/base/models/PaymentFlowState;", "getPaymentOptionFromModeList", "getPaymentOptionList", "getSIParams", "Lcom/payu/base/models/PayUSIParams;", "getSavedOptionsList", "getSodexoPaymentOptionList", "getTimeDifferenceInSeconds", "apiCalledTime", "", "currentTime", "getUpiCollectPaymentOption", "getValueFromPaymentOption", "T", "key", "map", "Ljava/util/HashMap;", "getValueFromPaymentOption$one_payu_ui_sdk_android_release", "(Ljava/lang/String;Ljava/util/HashMap;)Ljava/lang/Object;", "hideKeyboard", "isAmexCard", "", "isCustomeNoteCategoryNull", "isCustomeNoteCategoryNull$one_payu_ui_sdk_android_release", "isCvvLessCard", "isEligibleForEMI", "isEligibleForEMI$one_payu_ui_sdk_android_release", "isEnachPayment", "isEnachPayment$one_payu_ui_sdk_android_release", "isNonSodexoCardPresent", "quickOptionsList", "isNonSodexoCardPresent$one_payu_ui_sdk_android_release", "isOfferAvaialbleinList", "Lcom/payu/base/models/PaymentOptionOfferinfo;", "bankCode", "isOfferAvailable", "isOfferAvailable$one_payu_ui_sdk_android_release", "isOfferAvailableForCards", "scheme", "isOfferAvailableForCards$one_payu_ui_sdk_android_release", "isOfferSelected", "isOfferSelected$one_payu_ui_sdk_android_release", "isPaymentOptionAvailable", "paymentOptionName", "isPaymentTypeAvailable", "isSdkAvailable", "className", "isUpiIntentAvailable", "isValidBajajcardNumber", "isValidCardLength", "length", "isValidCvv", "number", "isValidCvvLength", "isValidExpiry", "isValidIfsc", "ifscCode", "isValidNameOnCard", "nameOnCard", "isValidNumber", "isValidNumberFormat", "isValidPhoneNumber", "phone", "isValidVPA", "vpa", "luhn", "phoneNumberLabel", "removeUserToken", "storeGlobalVaultUserToken", "userTokenGlobalVault", "vaultVerifiedPhoneNumber", "one-payu-ui-sdk-android_release"})
public final class Utils {
    @NotNull
    public static final Utils INSTANCE = new Utils();
    @NotNull
    private static String CARD_EXPIRE_REGEX = "^(0[1-9]|1[0-2])[/][0-9]{2}$";
    @NotNull
    private static final String VALIDATE_MOBILE_NUMBER_REGEX = "[6789][0-9]{9}?";
    @NotNull
    private static final String VALIDATE_VPA_REGEX = "^[a-zA-Z0-9]+[a-zA-Z0-9-._]{1,118}[a-zA-Z0-9]+@[a-zA-Z0-9]+[a-zA-Z0-9-.]{1,118}[a-zA-Z0-9]+$";
    @NotNull
    private static final String AMEX_CARD_REGEX = "^3[47][\\d]+";
    @NotNull
    private static final String NAME_ON_CARD_REGEX = "^[a-zA-Z0-9. ]+$";
    @NotNull
    private static final String VALIDATE_IFSC_REGEX = "^[A-Z0-9]{11}$";
    @NotNull
    private static final String VALIDATE_BAJAJ_CARD_REGEX = "^203040\\d{10}$";
    @NotNull
    private static final String NUMBER_REGEX = "[0-9]+";
    @Nullable
    private static String customNote;
    @Nullable
    private static OfferInfo offerInfo;
    @NotNull
    private static final String TAG;

    private Utils() {
    }

    public static /* synthetic */ int getDefaultDrawable$default(Utils utils, PaymentType paymentType, EmiType emiType, int n2, Object object) {
        if ((n2 & 2) != 0) {
            emiType = null;
        }
        return utils.getDefaultDrawable(paymentType, emiType);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isOfferAvaialbleinList(ArrayList<PaymentOptionOfferinfo> list, String bankCode) {
        if (list != null) {
            void var1_1;
            Iterator iterator = var1_1.iterator();
            while (iterator.hasNext()) {
                void var2_2;
                if (!var2_2.equals(((PaymentOptionOfferinfo)iterator.next()).getPaymentCode())) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final SharedPreferences getEncryptedSharedPreference(Context context) {
        void var1_1;
        String string2 = MasterKeys.getOrCreate((KeyGenParameterSpec)MasterKeys.AES256_GCM_SPEC);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getOrCreate(MasterKeys.AES256_GCM_SPEC)");
        EncryptedSharedPreferences.PrefKeyEncryptionScheme prefKeyEncryptionScheme = EncryptedSharedPreferences.PrefKeyEncryptionScheme.AES256_SIV;
        EncryptedSharedPreferences.PrefValueEncryptionScheme prefValueEncryptionScheme = EncryptedSharedPreferences.PrefValueEncryptionScheme.AES256_GCM;
        SharedPreferences sharedPreferences = EncryptedSharedPreferences.create((String)"userTokenPref", (String)string2, (Context)var1_1, (EncryptedSharedPreferences.PrefKeyEncryptionScheme)prefKeyEncryptionScheme, (EncryptedSharedPreferences.PrefValueEncryptionScheme)prefValueEncryptionScheme);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"create(\n            GLOB\u2026heme.AES256_GCM\n        )");
        return sharedPreferences;
    }

    static {
        TAG = "Utils";
    }

    @Nullable
    public final String getCustomNote$one_payu_ui_sdk_android_release() {
        return customNote;
    }

    public final void setCustomNote$one_payu_ui_sdk_android_release(@Nullable String string2) {
        customNote = string2;
    }

    /*
     * WARNING - void declaration
     */
    public final int getCardIconId(@Nullable CardScheme cardScheme) {
        int n2;
        void var1_1;
        switch (cardScheme == null ? -1 : WhenMappings.$EnumSwitchMapping$0[var1_1.ordinal()]) {
            default: {
                n2 = R.drawable.payu_cards_placeholder;
                break;
            }
            case 10: {
                n2 = R.drawable.payu_sodexo;
                break;
            }
            case 9: {
                n2 = R.drawable.payu_dinersclub;
                break;
            }
            case 8: {
                n2 = R.drawable.payu_jcb;
                break;
            }
            case 6: 
            case 7: {
                n2 = R.drawable.payu_rupay;
                break;
            }
            case 4: 
            case 5: {
                n2 = R.drawable.payu_maestro;
                break;
            }
            case 3: {
                n2 = R.drawable.payu_amex;
                break;
            }
            case 2: {
                n2 = R.drawable.payu_visa;
                break;
            }
            case 1: {
                n2 = R.drawable.payu_master_card;
            }
        }
        return n2;
    }

    /*
     * Handled duff style switch with additional control
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public final int getCardInputMaxLength(@Nullable CardScheme cardScheme) {
        void var1_1;
        int n2 = cardScheme == null ? -1 : WhenMappings.$EnumSwitchMapping$0[var1_1.ordinal()];
        int n3 = 0;
        block5: do {
            switch (n3 == 0 ? n2 : n3) {
                default: {
                    n3 = 2;
                    continue block5;
                }
                case 3: 
                case 9: {
                    return 17;
                }
                case 2: 
                case 4: 
                case 5: {
                    return 23;
                }
                case 1: 
                case 6: 
                case 7: 
                case 8: 
                case 11: 
            }
            return 19;
        } while (true);
        return 19;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isSdkAvailable(@Nullable String className) {
        block5: {
            if (className != null) {
                block6: {
                    void var1_1;
                    try {
                        if (!(var1_1.length() > 0)) break block5;
                    }
                    catch (Exception exception) {}
                    ClassLoader classLoader = Utils.class.getClassLoader();
                    if (classLoader == null) break block6;
                    classLoader.loadClass((String)var1_1);
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isValidCardLength(@Nullable CardScheme cardScheme, int length) {
        boolean bl;
        block11: {
            block10: {
                void var1_1;
                switch (cardScheme == null ? -1 : WhenMappings.$EnumSwitchMapping$0[var1_1.ordinal()]) {
                    default: {
                        void var2_2;
                        if (13 <= var2_2 && var2_2 < 20) {
                            break;
                        }
                        break block10;
                    }
                    case 9: {
                        void var2_2;
                        if (var2_2 == 14) {
                            break;
                        }
                        break block10;
                    }
                    case 3: {
                        void var2_2;
                        if (var2_2 == 15) {
                            break;
                        }
                        break block10;
                    }
                    case 2: 
                    case 4: 
                    case 5: {
                        void var2_2;
                        if (13 <= var2_2 && var2_2 < 20) {
                            break;
                        }
                        break block10;
                    }
                    case 1: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 10: 
                    case 11: {
                        void var2_2;
                        if (var2_2 != 16) break block10;
                    }
                }
                bl = true;
                break block11;
            }
            bl = false;
        }
        return bl;
    }

    public final boolean isCvvLessCard(@Nullable CardScheme cardScheme) {
        return cardScheme == CardScheme.SMAE;
    }

    /*
     * WARNING - void declaration
     */
    public final int getCvvInputLength(@Nullable CardScheme cardScheme) {
        void var1_1;
        return (cardScheme == null ? -1 : WhenMappings.$EnumSwitchMapping$0[var1_1.ordinal()]) == 3 ? 4 : 3;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isValidCvvLength(@Nullable CardScheme scheme, int length) {
        void var2_3;
        void var1_2;
        int n2 = scheme == null ? -1 : WhenMappings.$EnumSwitchMapping$0[var1_2.ordinal()];
        if (n2 != -1) {
            if (n2 != 3) {
                if (n2 != 12) {
                    if (var2_3 != 3) return false;
                    return true;
                }
            } else {
                if (var2_3 != 4) return false;
                return true;
            }
        }
        boolean bl = ArraysKt.contains((int[])new int[]{0, 3, 4}, (int)var2_3);
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isValidNumberFormat(@NotNull String number) {
        void var1_1;
        String string2 = number;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"number");
        return string2.length() > 0 ? new Regex(NUMBER_REGEX).matches((CharSequence)var1_1) : false;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isValidCvv(@NotNull String number, @Nullable CardScheme scheme) {
        void var2_2;
        void var1_1;
        void v0 = var1_1;
        Intrinsics.checkNotNullParameter((Object)v0, (String)"number");
        return this.isValidNumberFormat((String)v0) && this.isValidCvvLength((CardScheme)var2_2, var1_1.length());
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isValidExpiry(@NotNull String date) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        if (new Regex(CARD_EXPIRE_REGEX).matches((CharSequence)var1_1)) {
            SimpleDateFormat simpleDateFormat;
            Object object = simpleDateFormat;
            ((SimpleDateFormat)object)("MM/yy", Locale.getDefault());
            Object object2 = object;
            object = Calendar.getInstance().getTime();
            String string2 = ((DateFormat)object2).format((Date)object);
            return simpleDateFormat.parse((String)var1_1).after((Date)object) || string2.equals(var1_1);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isAmexCard(@NotNull String cardNumber) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)cardNumber, (String)"cardNumber");
        return new Regex(AMEX_CARD_REGEX).matches((CharSequence)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isValidNameOnCard(@NotNull String nameOnCard) {
        void var1_1;
        String string2 = nameOnCard;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"nameOnCard");
        return string2.length() == 0 ? false : new Regex(NAME_ON_CARD_REGEX).matches((CharSequence)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getExpiryYear(@NotNull String currentDate) {
        void var1_1;
        SimpleDateFormat simpleDateFormat;
        SimpleDateFormat simpleDateFormat2;
        Intrinsics.checkNotNullParameter((Object)currentDate, (String)"currentDate");
        SimpleDateFormat simpleDateFormat3 = simpleDateFormat2;
        try {
            simpleDateFormat2 = new SimpleDateFormat("yy", Locale.getDefault());
        }
        catch (ParseException parseException) {
            return "00";
        }
        SimpleDateFormat simpleDateFormat4 = simpleDateFormat;
        simpleDateFormat4("yyyy", Locale.getDefault());
        String string2 = simpleDateFormat.format(simpleDateFormat3.parse((String)var1_1));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"desiredDateFormat.format(currentYear)");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean luhn(@NotNull String cardNumber) {
        String string2 = cardNumber;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"cardNumber");
        int n2 = 0;
        boolean bl = false;
        int n3 = string2.length() - 1;
        if (n3 >= 0) {
            while (true) {
                void var1_2;
                int n4 = n3 + -1;
                String string3 = var1_2.substring(n3, n3 + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                n3 = Integer.parseInt(string3);
                if (bl && (n3 *= 2) > 9) {
                    n3 = n3 % 10 + 1;
                }
                n2 += n3;
                bl ^= true;
                if (n4 < 0) break;
                n3 = n4;
            }
        }
        return n2 % 10 == 0;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ArrayList<PaymentOption> getPaymentOptionList(@NotNull ArrayList<PaymentMode> paymentModesList, @NotNull PaymentType paymentType) {
        void var2_2;
        Iterator<PaymentMode> iterator;
        Intrinsics.checkNotNullParameter((Object)iterator, (String)"paymentModesList");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"paymentType");
        Object object = null;
        for (PaymentMode paymentMode : paymentModesList) {
            if (paymentMode.getType() != var2_2) continue;
            object = paymentMode.getOptionDetail();
        }
        return object;
    }

    @Nullable
    public final ArrayList<PaymentMode> getSodexoPaymentOptionList(@NotNull ArrayList<PaymentMode> paymentModesList) {
        ArrayList arrayList;
        ArrayList<PaymentMode> arrayList2 = paymentModesList;
        Intrinsics.checkNotNullParameter(arrayList2, (String)"paymentModesList");
        ArrayList arrayList3 = arrayList;
        arrayList = new ArrayList();
        for (PaymentMode paymentMode : arrayList2) {
            if (paymentMode.getType() != PaymentType.SODEXO) continue;
            arrayList3.add(paymentMode);
        }
        return arrayList3;
    }

    @NotNull
    public final ArrayList<PaymentMode> getCardPaymentOptionList(@NotNull ArrayList<PaymentMode> paymentModesList) {
        ArrayList arrayList;
        ArrayList<PaymentMode> arrayList2 = paymentModesList;
        Intrinsics.checkNotNullParameter(arrayList2, (String)"paymentModesList");
        ArrayList arrayList3 = arrayList;
        arrayList = new ArrayList();
        for (PaymentMode paymentMode : arrayList2) {
            if (paymentMode.getType() != PaymentType.CARD) continue;
            arrayList3.add(paymentMode);
        }
        return arrayList3;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final PaymentOption getPaymentOptionFromModeList(@NotNull ArrayList<PaymentMode> paymentModesList, @NotNull PaymentType paymentType) {
        void var2_2;
        PaymentMode paymentMode;
        Intrinsics.checkNotNullParameter((Object)paymentMode, (String)"paymentModesList");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"paymentType");
        Object object = paymentModesList.iterator();
        while (object.hasNext()) {
            paymentMode = (PaymentMode)object.next();
            if (paymentMode.getType() != var2_2) continue;
            ArrayList arrayList = paymentMode.getOptionDetail();
            if (arrayList == null || arrayList.isEmpty()) continue;
            object = paymentMode.getOptionDetail();
            return object == null ? null : (PaymentOption)((ArrayList)object).get(0);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ArrayList<PaymentMode> getSavedOptionsList(@Nullable ArrayList<PaymentMode> paymentModesList, @NotNull PaymentType paymentType) {
        Iterator iterator;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"paymentType");
        Object object = null;
        if (paymentModesList != null && !((ArrayList)((Object)iterator)).isEmpty()) {
            iterator = ((ArrayList)((Object)iterator)).iterator();
            while (iterator.hasNext()) {
                ArrayList<PaymentMode> arrayList;
                PaymentMode paymentMode = (PaymentMode)iterator.next();
                if (paymentMode.getType() != var2_2) continue;
                object = arrayList;
                new ArrayList<PaymentMode>().add(paymentMode);
            }
            return object;
        }
        return object;
    }

    @Nullable
    public final String getFormattedString(@Nullable String cardNumber, @Nullable CardScheme cardScheme) {
        Object object;
        String string2;
        String string3;
        if (cardScheme == null) {
            return string3;
        }
        if (WhenMappings.$EnumSwitchMapping$0[string2.ordinal()] == 3) {
            StringBuilder stringBuilder;
            object = stringBuilder;
            stringBuilder = new StringBuilder();
            if (string3 == null) {
                string2 = null;
            } else {
                string2 = string3.substring(0, 4);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            }
            object = ((StringBuilder)object).append((Object)string2).append(' ');
            if (string3 == null) {
                string2 = null;
            } else {
                string2 = string3.substring(4, 10);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            }
            object = ((StringBuilder)object).append((Object)string2).append(' ');
            if (string3 == null) {
                string3 = null;
            } else {
                string3 = string3.substring(10);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
            }
            object = ((StringBuilder)object).append((Object)string3).toString();
        } else {
            object = string3 == null ? null : new Regex("....(?!$)").replace((CharSequence)string3, "$0 ");
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PaymentModel getPaymentModel(@NotNull PaymentOption paymentOption, @Nullable PaymentFlowState paymentFlowState) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)paymentOption, (String)"paymentOption");
        PaymentModel paymentModel = new PaymentModel(null, null, null, 7, null);
        paymentModel.setPaymentOption((PaymentOption)var1_1);
        paymentModel.setPaymentFlowState((PaymentFlowState)var2_2);
        return paymentModel;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isValidPhoneNumber(@NotNull String phone) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)phone, (String)"phone");
        return Pattern.compile(VALIDATE_MOBILE_NUMBER_REGEX).matcher((CharSequence)var1_1).matches();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isValidNumber(@NotNull String number) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        return Pattern.compile(NUMBER_REGEX).matcher((CharSequence)var1_1).matches();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isValidBajajcardNumber(@NotNull String cardNumber) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)cardNumber, (String)"cardNumber");
        return Pattern.compile(VALIDATE_BAJAJ_CARD_REGEX).matcher((CharSequence)var1_1).matches();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isValidVPA(@NotNull String vpa) {
        void var1_1;
        String string2 = vpa;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"vpa");
        if (string2.length() > 0 && var1_1.length() >= 3 && var1_1.length() <= 120) {
            return Pattern.compile(VALIDATE_VPA_REGEX).matcher((CharSequence)var1_1).matches();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isPaymentTypeAvailable(@NotNull ArrayList<PaymentOption> list, @NotNull PaymentType paymentType) {
        void var2_3;
        Iterator<PaymentOption> iterator;
        Intrinsics.checkNotNullParameter((Object)iterator, (String)"list");
        Intrinsics.checkNotNullParameter((Object)var2_3, (String)"paymentType");
        boolean bl = false;
        iterator = list.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().getPaymentType() != var2_3) continue;
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public final boolean isPaymentOptionAvailable(@NotNull ArrayList<PaymentOption> list, @NotNull String paymentOptionName) {
        boolean bl;
        void var2_2;
        Iterator<PaymentOption> iterator;
        Intrinsics.checkNotNullParameter((Object)iterator, (String)"list");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"paymentOptionName");
        iterator = list.iterator();
        do {
            if (!iterator.hasNext()) {
                return false;
            }
            String string2 = (String)this.getValueFromPaymentOption$one_payu_ui_sdk_android_release("bankCode", (HashMap)iterator.next().getOtherParams());
            if (string2 != null && StringsKt.equals((String)string2, (String)var2_2, (boolean)true)) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    @Nullable
    public final ArrayList<PaymentOption> getIntentAppsList(@NotNull ArrayList<PaymentOption> list) {
        ArrayList<PaymentOption> arrayList = list;
        Intrinsics.checkNotNullParameter(arrayList, (String)"list");
        Object object = null;
        for (PaymentOption paymentOption : arrayList) {
            PaymentType paymentType = paymentOption.getPaymentType();
            if ((paymentType == null ? -1 : WhenMappings.$EnumSwitchMapping$1[paymentType.ordinal()]) != 1) continue;
            object = paymentOption.getOptionList();
        }
        return object;
    }

    @Nullable
    public final PaymentOption getUpiCollectPaymentOption(@NotNull ArrayList<PaymentOption> list) {
        ArrayList<PaymentOption> arrayList = list;
        Intrinsics.checkNotNullParameter(arrayList, (String)"list");
        Utils utils = null;
        for (PaymentOption paymentOption : arrayList) {
            PaymentType paymentType = paymentOption.getPaymentType();
            if ((paymentType == null ? -1 : WhenMappings.$EnumSwitchMapping$1[paymentType.ordinal()]) != 2) continue;
            utils = paymentOption;
        }
        return utils;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isUpiIntentAvailable(@NotNull ArrayList<PaymentOption> list) {
        void var1_1;
        Utils utils = this_;
        void v1 = var1_1;
        Intrinsics.checkNotNullParameter((Object)v1, (String)"list");
        ArrayList<PaymentOption> this_ = ((Utils)((Object)this_)).getIntentAppsList((ArrayList<PaymentOption>)v1);
        return utils.isPaymentTypeAvailable((ArrayList<PaymentOption>)var1_1, PaymentType.UPI_INTENT) && this_ != null && this_.size() > 0;
    }

    /*
     * WARNING - void declaration
     */
    public final int getDefaultDrawable(@Nullable PaymentType paymentType, @Nullable EmiType emiType) {
        int n2;
        void var1_2;
        switch (paymentType == null ? -1 : WhenMappings.$EnumSwitchMapping$1[var1_2.ordinal()]) {
            default: {
                n2 = R.drawable.payu_netbanking;
                break;
            }
            case 5: {
                n2 = R.drawable.payu_cards_placeholder;
                break;
            }
            case 4: {
                void var2_3;
                int n3 = var2_3 == null ? -1 : WhenMappings.$EnumSwitchMapping$2[var2_3.ordinal()];
                if (n3 != 1) {
                    if (n3 != 2) {
                        if (n3 != 3) {
                            n2 = R.drawable.payu_emi;
                            break;
                        }
                        n2 = R.drawable.payu_cardless_emi;
                        break;
                    }
                    n2 = R.drawable.payu_dc_emi;
                    break;
                }
                n2 = R.drawable.payu_cc_emi;
                break;
            }
            case 3: {
                n2 = R.drawable.payu_wallet;
                break;
            }
            case 1: 
            case 2: {
                n2 = R.drawable.payu_upi;
            }
        }
        return n2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String convertYYYYMMDDTODDMMMYYYY(@Nullable String date) {
        SimpleDateFormat simpleDateFormat;
        Date date2;
        void var1_1;
        try {
            date2 = new SimpleDateFormat("yyyy-MM-dd").parse((String)var1_1);
        }
        catch (ParseException parseException) {
            void v1 = var1_1;
            Intrinsics.checkNotNull((Object)v1);
            return v1;
        }
        SimpleDateFormat simpleDateFormat2 = simpleDateFormat;
        simpleDateFormat = new SimpleDateFormat("MMM, yyyy", Locale.getDefault());
        String string2 = new SimpleDateFormat("dd").format(date2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"formatDateOfMonth.format(date1)");
        int n2 = Integer.parseInt(string2);
        String string3 = "" + n2 + "" + ((Utils)((Object)string3)).getDayOfMonthSuffix(n2);
        return (String)string3 + ' ' + simpleDateFormat2.format(date2);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final String getDayOfMonthSuffix(int n2) {
        void var1_2;
        if (11 <= var1_2 && var1_2 < 14) {
            return "th";
        }
        boolean bl = false;
        if (bl) {
            return "th";
        }
        void var0_1 = var1_2 % 10;
        if (var0_1 == true) return "st";
        if (var0_1 == 2) return "nd";
        if (var0_1 == 3) return "rd";
        return "th";
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String convertYYYYMMDDTODDMMYYYY(@Nullable String date) {
        void var1_1;
        try {
            Date date2 = new SimpleDateFormat("yyyy-MM-dd").parse((String)var1_1);
        }
        catch (ParseException parseException) {
            void v1 = var1_1;
            Intrinsics.checkNotNull((Object)v1);
            return v1;
        }
        String string2 = new SimpleDateFormat("dd/MM/yyyy", Locale.getDefault()).format(date2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format2.format(date1)");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PayUBeneficiaryAccountType getAccountType(@NotNull String accountType) {
        void var1_1;
        String string2 = accountType;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"accountType");
        return Intrinsics.areEqual((Object)string2, (Object)"Savings account") ? PayUBeneficiaryAccountType.SAVINGS : (Intrinsics.areEqual((Object)var1_1, (Object)"Current account") ? PayUBeneficiaryAccountType.CURRENT : PayUBeneficiaryAccountType.SAVINGS);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String convertBillingCycle(@Nullable PayUBillingCycle billingCycle) {
        void var1_1;
        Object object = null;
        if (PayUBillingCycle.YEARLY == var1_1) {
            object = "year";
        } else if (PayUBillingCycle.MONTHLY == var1_1) {
            object = "month";
        } else if (PayUBillingCycle.DAILY == var1_1) {
            object = "day";
        } else if (PayUBillingCycle.WEEKLY == var1_1) {
            object = "week";
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isValidIfsc(@NotNull String ifscCode) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)ifscCode, (String)"ifscCode");
        return Pattern.compile(VALIDATE_IFSC_REGEX).matcher((CharSequence)var1_1).matches();
    }

    public final boolean isEligibleForEMI$one_payu_ui_sdk_android_release(@NotNull ArrayList<PaymentOption> emiTenureList) {
        ArrayList<PaymentOption> arrayList = emiTenureList;
        Intrinsics.checkNotNullParameter(arrayList, (String)"emiTenureList");
        if (arrayList.isEmpty()) {
            return false;
        }
        for (Object object : object) {
            object = object instanceof EMIOption ? (EMIOption)object : null;
            if (object == null || !object.isEligible()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public final ArrayList<PaymentOption> getEligibleEmiTenuresList$one_payu_ui_sdk_android_release(@Nullable ArrayList<PaymentOption> emiTenureList) {
        ArrayList arrayList;
        Iterator iterator;
        boolean bl = emiTenureList == null || iterator.isEmpty();
        if (bl) {
            return null;
        }
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        iterator = ((ArrayList)((Object)iterator)).iterator();
        while (iterator.hasNext()) {
            Object object = (PaymentOption)iterator.next();
            object = object instanceof EMIOption ? (EMIOption)object : null;
            if (object == null || !object.isEligible()) continue;
            arrayList2.add(object);
        }
        return arrayList2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getFormattedAmount$one_payu_ui_sdk_android_release(@Nullable Double amount, @NotNull Context context) {
        void var1_1;
        Object[] objectArray;
        Utils utils = object;
        Intrinsics.checkNotNullParameter((Object)objectArray, (String)"context");
        Object object = String.format("%.2f", Arrays.copyOf(new Object[]{var1_1}, 1));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"format(format, *args)");
        object = utils.formatAmount$one_payu_ui_sdk_android_release((String)object);
        int n2 = R.string.amount_with_rupee_symbol;
        Object[] objectArray2 = new Object[1];
        objectArray = objectArray2;
        objectArray2[0] = object;
        String string2 = context.getString(n2, objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.getString(R.stri\u2026pee_symbol, formatAmount)");
        return string2;
    }

    @NotNull
    public final String formatAmount$one_payu_ui_sdk_android_release(@Nullable String amount) {
        StringBuilder stringBuilder;
        Object object;
        boolean bl = amount == null || object.length() == 0;
        if (bl) {
            return "";
        }
        Object object2 = stringBuilder;
        stringBuilder = new StringBuilder();
        String string2 = "";
        if (StringsKt.contains$default((CharSequence)object, (CharSequence)".", (boolean)false, (int)2, null)) {
            void v2 = object;
            object = (String)StringsKt.split$default((CharSequence)v2, (String[])new String[]{"."}, (boolean)false, (int)0, (int)6, null).get(0);
            string2 = (String)StringsKt.split$default((CharSequence)v2, (String[])new String[]{"."}, (boolean)false, (int)0, (int)6, null).get(1);
        }
        object = object.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this as java.lang.String).toCharArray()");
        int n2 = 0;
        int n3 = 0;
        int n4 = ((char[])object).length + -1;
        if (n4 >= 0) {
            while (true) {
                int n5 = n4 + -1;
                if (n2 < 3) {
                    ((StringBuilder)object2).append(object[n4]);
                    ++n2;
                } else if (n3 < 2) {
                    if (n3 == 0) {
                        ((StringBuilder)object2).append(",");
                        ((StringBuilder)object2).append(object[n4]);
                        ++n3;
                    } else {
                        ((StringBuilder)object2).append(object[n4]);
                        n3 = 0;
                    }
                }
                if (n5 < 0) break;
                n4 = n5;
            }
        }
        if (string2.length() == 0) {
            object2 = ((StringBuilder)object2).reverse().toString();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"stringBuilder.reverse()\n            .toString()");
        } else {
            object2 = ((StringBuilder)object2).reverse().toString() + '.' + string2;
        }
        return object2;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public final boolean isEnachPayment$one_payu_ui_sdk_android_release(@Nullable PaymentType paymentType) {
        void var1_1;
        if (paymentType == null) {
            return false;
        }
        if (var1_1 != PaymentType.NB) return false;
        Utils utils = SdkUiInitializer.INSTANCE.getApiLayer();
        if (utils == null) return false;
        if ((utils = utils.getPayUPaymentParams()) == null) {
            return false;
        }
        PayUSIParams payUSIParams = utils.getPayUSIParams();
        if (payUSIParams == null) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Nullable
    public final String getCustomeNoteDetails$one_payu_ui_sdk_android_release(@Nullable PaymentType paymentType, @Nullable ArrayList<CustomNote> customeNoteDetails) {
        Iterator iterator;
        if (paymentType == null) return null;
        if (iterator != null && ((ArrayList)((Object)iterator)).isEmpty()) {
            return null;
        }
        boolean bl = false;
        if (bl) {
            return null;
        }
        Object object = "";
        if (iterator == null) return object;
        iterator = ((ArrayList)((Object)iterator)).iterator();
        while (iterator.hasNext()) {
            void var1_1;
            ArrayList arrayList;
            CustomNote customNote = (CustomNote)iterator.next();
            if (customNote.getCustom_note_category() == null || !((arrayList = customNote.getCustom_note_category()) != null && arrayList.contains(var1_1))) continue;
            object = customNote.getCustom_note();
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final boolean isCustomeNoteCategoryNull$one_payu_ui_sdk_android_release(@Nullable ArrayList<CustomNote> customeNoteDetails) {
        boolean bl = false;
        if (customeNoteDetails != null) {
            Iterator iterator;
            iterator = ((ArrayList)((Object)iterator)).iterator();
            while (iterator.hasNext()) {
                ArrayList arrayList;
                CustomNote customNote = (CustomNote)iterator.next();
                if (customNote.getCustom_note_category() == null || (arrayList = customNote.getCustom_note_category()) != null && arrayList.isEmpty()) {
                    bl = true;
                }
                Intrinsics.checkNotNull((Object)customNote.getCustom_note());
            }
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public final PayUSIParams getSIParams() {
        Utils utils = SdkUiInitializer.INSTANCE.getApiLayer();
        if (utils == null) return null;
        if ((utils = utils.getPayUPaymentParams()) == null) return null;
        PayUSIParams payUSIParams = utils.getPayUSIParams();
        return payUSIParams;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isNonSodexoCardPresent$one_payu_ui_sdk_android_release(@Nullable ArrayList<PaymentMode> quickOptionsList) {
        void var1_1;
        return !(quickOptionsList == null || var1_1.isEmpty()) && ((this = ((Utils)this).getCardPaymentOptionList((ArrayList<PaymentMode>)var1_1)) == null ? null : Integer.valueOf(((ArrayList)this).size())) > 0;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isOfferAvailable$one_payu_ui_sdk_android_release(@NotNull String bankCode, @NotNull PaymentType paymentType) {
        Object object;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"bankCode");
        Intrinsics.checkNotNullParameter((Object)paymentType, (String)"paymentType");
        offerInfo = InternalConfig.INSTANCE.getOfferInfo();
        switch (WhenMappings.$EnumSwitchMapping$1[object.ordinal()]) {
            default: {
                break;
            }
            case 4: {
                Object object2 = offerInfo;
                object2 = object2 == null ? null : object2.getEMiOptionInOffersList();
                boolean bl = object2 == null || object2.isEmpty();
                if (bl) {
                    return false;
                }
                if (object2 == null) break;
                object2 = object2.iterator();
                while (object2.hasNext()) {
                    object = ((EMiOptionInOffers)object2.next()).getPaymentOptionOfferinfoArrayList().iterator();
                    while (object.hasNext()) {
                        if (!((PaymentOptionOfferinfo)object.next()).getPaymentCode().equals(var1_1)) continue;
                        return true;
                    }
                }
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                Object object2 = offerInfo;
                object2 = object2 == null ? null : object2.getPaymentOptionOfferinfolist();
                if (object2 == null || object2.isEmpty()) break;
                object2 = ((ArrayList)object2).iterator();
                while (object2.hasNext()) {
                    object = (PaymentOptionOfferinfo)object2.next();
                    Locale locale = Locale.ROOT;
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
                    String string2 = var1_1.toLowerCase(locale);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(locale)");
                    String string3 = object.getPaymentCode();
                    Locale locale2 = locale;
                    Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"ROOT");
                    String string4 = string3.toLowerCase(locale2);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toLowerCase(locale)");
                    if (!string2.equals(string4)) continue;
                    return true;
                }
                break block0;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final double getOfferDiscountAmount$one_payu_ui_sdk_android_release() {
        double d2 = 0.0;
        offerInfo = InternalConfig.INSTANCE.getOfferInfo();
        if (!this_.isOfferSelected$one_payu_ui_sdk_android_release()) return d2;
        Utils this_ = offerInfo;
        if ((this_ == null || (this_ = this_.getDiscountDetailsofOffers()) == null ? null : this_.getDiscount()) == null) return d2;
        this_ = offerInfo;
        Double d3 = this_ == null || (this_ = this_.getDiscountDetailsofOffers()) == null ? null : this_.getDiscount();
        Intrinsics.checkNotNull(d3);
        return d3;
    }

    public final boolean isOfferSelected$one_payu_ui_sdk_android_release() {
        return InternalConfig.INSTANCE.getOfferInfo() != null;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isOfferAvailableForCards$one_payu_ui_sdk_android_release(@NotNull String bankCode, @NotNull String scheme) {
        boolean bl;
        block3: {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"bankCode");
            Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
            Object object = InternalConfig.INSTANCE.getOfferInfo();
            offerInfo = object;
            object = object == null ? null : object.getBanksListForCards();
            bl = this.isOfferAvaialbleinList((ArrayList<PaymentOptionOfferinfo>)object, (String)var1_1);
            Object object2 = offerInfo;
            object2 = object2 == null ? null : object2.getNetworkListForCards();
            if (!bl) {
                boolean bl2 = object == null || object.isEmpty();
                if (!bl2) break block3;
            }
            if (!(object2 == null || object2.isEmpty())) {
                void var2_3;
                bl = this.isOfferAvaialbleinList((ArrayList<PaymentOptionOfferinfo>)object2, (String)var2_3);
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final <T> T getValueFromPaymentOption$one_payu_ui_sdk_android_release(@NotNull String key, @Nullable HashMap<String, Object> map) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"key");
        Utils utils = null;
        if (map != null && var2_2.containsKey(var1_1) && var2_2.get(var1_1) != null) {
            utils = var2_2.get(var1_1);
        }
        return (T)utils;
    }

    /*
     * WARNING - void declaration
     */
    public final void storeGlobalVaultUserToken(@NotNull Context context, @NotNull String userTokenGlobalVault, @NotNull String vaultVerifiedPhoneNumber) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"context");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"userTokenGlobalVault");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"vaultVerifiedPhoneNumber");
        SharedPreferences.Editor editor = this.getEncryptedSharedPreference((Context)var1_1).edit();
        editor.putString("userToken", (String)var2_2);
        editor.putString("mobileNumber", (String)var3_3);
        editor.apply();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Pair<String, String> getGlobalVaultStoredUserToken(@NotNull Context context) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"context");
        Object this_ = ((Utils)this_).getEncryptedSharedPreference((Context)var1_1);
        Utils utils = this_;
        this_ = utils.getString("userToken", "");
        return new Pair(this_, (Object)utils.getString("mobileNumber", ""));
    }

    /*
     * WARNING - void declaration
     */
    public final void removeUserToken(@NotNull Context context) {
        void var1_1;
        void v0 = var1_1;
        Intrinsics.checkNotNullParameter((Object)v0, (String)"context");
        this.getEncryptedSharedPreference((Context)v0).edit().clear().apply();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String getCategoryForOffer(@Nullable String category) {
        boolean bl;
        void var1_1;
        if (Intrinsics.areEqual((Object)category, (Object)"CC")) {
            return "CREDITCARD";
        }
        if (Intrinsics.areEqual((Object)var1_1, (Object)"DC")) {
            return "DEBITCARD";
        }
        if (Intrinsics.areEqual((Object)var1_1, (Object)"NB")) {
            return "NETBANKING";
        }
        if (Intrinsics.areEqual((Object)var1_1, (Object)"UPI")) {
            bl = true;
        } else {
            Object object = Locale.ROOT;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ROOT");
            object = "Wallet".toUpperCase((Locale)object);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this as java.lang.String).toUpperCase(locale)");
            bl = Intrinsics.areEqual((Object)var1_1, (Object)object);
        }
        if ((bl ? true : Intrinsics.areEqual((Object)var1_1, (Object)"EMI")) ? true : Intrinsics.areEqual((Object)var1_1, (Object)"BNPL")) {
            return var1_1;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getTimeDifferenceInSeconds(long apiCalledTime, long currentTime) {
        void var1_1;
        void var3_2;
        return String.valueOf(TimeUnit.MILLISECONDS.toSeconds((long)(var3_2 - var1_1)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String phoneNumberLabel(@Nullable PaymentType paymentType) {
        void var1_1;
        Log.d((String)TAG, (String)Intrinsics.stringPlus((String)"PaymentType =", (Object)var1_1));
        return (paymentType == null ? -1 : WhenMappings.$EnumSwitchMapping$1[var1_1.ordinal()]) == 7 ? "Mobile Number Registered" : "Phone Number";
    }

    /*
     * WARNING - void declaration
     */
    public final void hideKeyboard(@NotNull View view) {
        View view2 = view;
        Intrinsics.checkNotNullParameter((Object)view2, (String)"view");
        view2.clearFocus();
        Object object = view2.getContext().getSystemService("input_method");
        if (object != null) {
            void var1_1;
            ((InputMethodManager)object).hideSoftInputFromWindow(var1_1.getWindowToken(), 0);
            return;
        }
        throw new NullPointerException("null cannot be cast to non-null type android.view.inputmethod.InputMethodManager");
    }

    /*
     * WARNING - void declaration
     */
    public final void displayKeyboard(@NotNull View view) {
        View view2 = view;
        Intrinsics.checkNotNullParameter((Object)view2, (String)"view");
        view2.requestFocus();
        Object object = view2.getContext().getSystemService("input_method");
        if (object != null) {
            void var1_1;
            ((InputMethodManager)object).showSoftInput((View)var1_1, 1);
            return;
        }
        throw new NullPointerException("null cannot be cast to non-null type android.view.inputmethod.InputMethodManager");
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final Integer getEligibilityDetails(@NotNull ApiResponse apiResponse, @NotNull PaymentType paymentType) {
        void var2_14;
        void var1_13;
        Intrinsics.checkNotNullParameter((Object)var1_13, (String)"apiResponse");
        Intrinsics.checkNotNullParameter((Object)paymentType, (String)"paymentType");
        int n2 = WhenMappings.$EnumSwitchMapping$1[var2_14.ordinal()];
        if (n2 != 2) {
            if (n2 != 3) {
                void var0_12;
                if (n2 != 4) {
                    void var0_8;
                    void var0_5;
                    if (n2 != 7) return null;
                    ArrayList arrayList = var1_13.getPaymentOptionList();
                    if (arrayList == null) {
                        Object var0_3 = null;
                    } else {
                        PaymentOption paymentOption = (PaymentOption)arrayList.get(0);
                    }
                    if (var0_5 instanceof BnplOption) {
                        BnplOption bnplOption = (BnplOption)var0_5;
                    } else {
                        Object var0_7 = null;
                    }
                    if (var0_8 == null) {
                        return null;
                    }
                    if (var0_8.isEligible()) return null;
                    boolean bl = true;
                    if (!bl) return null;
                    return R.string.mobile_not_eligibile_error;
                }
                ArrayList arrayList = var1_13.getPaymentOptionList();
                if (arrayList == null) {
                    Object var0_10 = null;
                } else {
                    PaymentOption paymentOption = (PaymentOption)arrayList.get(0);
                }
                if (var0_12 == null) throw new NullPointerException("null cannot be cast to non-null type com.payu.base.models.EMIOption");
                if (((EMIOption)var0_12).isEligible()) return null;
                return R.string.mobile_not_eligibile_error;
            }
            if (!Intrinsics.areEqual((Object)var1_13.getStatus(), (Object)Boolean.FALSE)) return null;
            return -1;
        }
        if (!Intrinsics.areEqual((Object)var1_13.getStatus(), (Object)Boolean.TRUE)) return null;
        return R.string.payu_vpa_supported_text;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[CardScheme.values().length];
            nArray[CardScheme.MAST.ordinal()] = 1;
            nArray[CardScheme.VISA.ordinal()] = 2;
            nArray[CardScheme.AMEX.ordinal()] = 3;
            nArray[CardScheme.MAES.ordinal()] = 4;
            nArray[CardScheme.SMAE.ordinal()] = 5;
            nArray[CardScheme.RUPAY.ordinal()] = 6;
            nArray[CardScheme.RUPAYCC.ordinal()] = 7;
            nArray[CardScheme.JCB.ordinal()] = 8;
            nArray[CardScheme.DINR.ordinal()] = 9;
            nArray[CardScheme.SODEXO.ordinal()] = 10;
            nArray[CardScheme.DISCOVER.ordinal()] = 11;
            nArray[CardScheme.UNKNOWN.ordinal()] = 12;
            $EnumSwitchMapping$0 = nArray;
            int[] nArray2 = new int[PaymentType.values().length];
            nArray2[PaymentType.UPI_INTENT.ordinal()] = 1;
            nArray2[PaymentType.UPI.ordinal()] = 2;
            nArray2[PaymentType.WALLET.ordinal()] = 3;
            nArray2[PaymentType.EMI.ordinal()] = 4;
            nArray2[PaymentType.CARD.ordinal()] = 5;
            nArray2[PaymentType.NB.ordinal()] = 6;
            nArray2[PaymentType.BNPL.ordinal()] = 7;
            $EnumSwitchMapping$1 = nArray2;
            int[] nArray3 = new int[EmiType.values().length];
            nArray3[EmiType.CC.ordinal()] = 1;
            nArray3[EmiType.DC.ordinal()] = 2;
            nArray3[EmiType.CARD_LESS.ordinal()] = 3;
            $EnumSwitchMapping$2 = nArray3;
        }
    }
}

