package com.payu.ui.viewmodel

import android.app.Application
import android.util.DisplayMetrics
import androidx.lifecycle.MutableLiveData
import com.payu.base.listeners.OnDeleteSavedOptionListener
import com.payu.base.models.ErrorResponse
import com.payu.base.models.PaymentMode
import com.payu.base.models.PaymentOption
import com.payu.base.models.PaymentType
import com.payu.base.models.SavedCardOption
import com.payu.ui.R
import com.payu.ui.SdkUiInitializer
import com.payu.ui.model.utils.SdkUiConstants
import com.payu.ui.model.utils.Utils
import kotlin.math.roundToInt

class SavedCardsViewModel(
    application: Application, mParam: Map<String, Any>
) : BaseViewModel(application), OnDeleteSavedOptionListener {
    var viewMoreCardVisible: MutableLiveData<Boolean> = MutableLiveData()
    var savedOptionsTitle: MutableLiveData<String> = MutableLiveData()
    var loadMoreLessText: MutableLiveData<String> = MutableLiveData()
    var shouldLoadAll: MutableLiveData<Boolean> = MutableLiveData()
    var hideAddCardLayout: MutableLiveData<Boolean> = MutableLiveData()
    var showManageHeader: MutableLiveData<Boolean> = MutableLiveData()
    var hideSavedCardsHeader: MutableLiveData<Boolean> = MutableLiveData()
    var showListWithDeleteIcon: MutableLiveData<Boolean> = MutableLiveData()
    var savedCardsListEmpty: MutableLiveData<Boolean> = MutableLiveData()
    var reCalculateHeight: MutableLiveData<Boolean> = MutableLiveData()
    var recyclerViewHeight: Int? = null
    var shouldAddObserver: MutableLiveData<Boolean> = MutableLiveData()
    var shouldShowManageOption: MutableLiveData<Boolean> = MutableLiveData()
    var siHeaderSummary: MutableLiveData<String> = MutableLiveData()
    val applicationContext = application
    var savedOption: SavedCardOption? = null
    var savedModesList: ArrayList<PaymentMode> =
        mParam[SdkUiConstants.SAVED_CARDS] as ArrayList<PaymentMode>
    var deleteIndex: Int? = null
    var cardToken: String? = null
    var maxItemAtATime: Int? = null
    val adapterList: MutableLiveData<ArrayList<PaymentMode>> = MutableLiveData()
    var adapterListWithOutSodexoCard: ArrayList<PaymentMode> = ArrayList()
    val titleText: MutableLiveData<String> = MutableLiveData()

    fun getTheFilteredItemsToShow(heightOfRecyclerView: Int, initiatedFrom: String) {
        val valueInPixels =
            pxToDp(
                applicationContext.resources.getDimension(R.dimen.payu_dimen_7dp)
                    .toInt()
            )
        val rcvDp = pxToDp(heightOfRecyclerView)
        maxItemAtATime = rcvDp / valueInPixels
        maxItemAtATime?.let {
            adapterList.value = getTheListToShow(it, savedModesList, initiatedFrom)
        }
    }

    /**
     * @param px, dimension(height) of Recyclerview.
     */
    private fun pxToDp(px: Int): Int {
        val displayMetrics = applicationContext.resources.displayMetrics
        return (px / (displayMetrics.xdpi / DisplayMetrics.DENSITY_DEFAULT)).roundToInt()
    }

    fun getTheListToShow(
        maxItemAtATime: Int,
        list: ArrayList<PaymentMode>,
        initiatedFrom: String
    ): ArrayList<PaymentMode> {
        var currentList: ArrayList<PaymentMode>
        saveListWithoutSodexoCard()
        if ((null != showListWithDeleteIcon && null != showListWithDeleteIcon.value && showListWithDeleteIcon.value!!) || (initiatedFrom == SdkUiConstants.CP_CARDS)) {
            currentList = adapterListWithOutSodexoCard
        } else {
            currentList = list
        }
        return when {
            currentList.size > maxItemAtATime -> {
                viewMoreCardVisible.value = true
                ArrayList(currentList.take(maxItemAtATime))
            }
            else -> {
                viewMoreCardVisible.value = false
                ArrayList(currentList)
            }
        }
    }

    fun saveOptionTitleAndAddCardOption(shouldHideAddCard: Boolean, initiatedFrom: String) {
        when {
            shouldHideAddCard -> {
                savedOptionsTitle.value = applicationContext.getString(R.string.payu_saved_option)
            }
            else -> {
                savedOptionsTitle.value = applicationContext.getString(R.string.payu_saved_card)
            }
        }
        val paymentType =
            if (initiatedFrom != SdkUiConstants.SODEXO) PaymentType.CARD else PaymentType.SODEXO
        siHeaderSummary.value = Utils.getCustomeNoteDetails(
            paymentType,
            SdkUiInitializer.apiLayer?.config?.customNoteDetails
        )
    }

    fun changeLoadMoreLessText(currentText: String?) {
        if (currentText.equals(applicationContext.getString(R.string.payu_view_more_cards))) {
            loadMoreLessText.value = applicationContext.getString(R.string.payu_view_less_cards)
            shouldLoadAll.value = true
            adapterList.value = savedModesList

        } else {
            shouldLoadAll.value = false
            loadMoreLessText.value = applicationContext.getString(R.string.payu_view_more_cards)
//            loadMoreLessText.value
        }
    }

    fun getHeightOfRecylerView(measuredHeight: Int) {
        if (measuredHeight > 0 && measuredHeight > (applicationContext.resources.getDimension(
                R.dimen.payu_dimen_7dp
            ).toInt())
        ) {
            recyclerViewHeight = measuredHeight
            shouldAddObserver.value = true
        } else {
            shouldAddObserver.value = false
        }
        loadMoreLessText.value = applicationContext.getString(R.string.payu_view_more_cards)
    }

    fun showManageStoreCardsView() {
        saveListWithoutSodexoCard()
        hideAddCardLayout.value = true
        showManageHeader.value = true
        showListWithDeleteIcon.value = true
        hideSavedCardsHeader.value = true
    }

    fun saveListWithoutSodexoCard() {
        adapterListWithOutSodexoCard.clear()
        adapterListWithOutSodexoCard = savedModesList.clone() as ArrayList<PaymentMode>

        if (!savedModesList.isNullOrEmpty() && savedModesList[0].type == PaymentType.SODEXO) {
            adapterListWithOutSodexoCard.removeAt(0)
        }
//Todo: Remove through PaymentType.
//      Utils.excludeSodexoArrayList(adapterListWithOutSodexoCard)

    }

    fun handleDeleteIconClick(deleteIndex: Int, savedOption: SavedCardOption?) {
        this.deleteIndex = deleteIndex
        this.savedOption = savedOption
        this.cardToken = savedOption?.cardToken
    }

    fun callDeleteSavedOptionApi() {
        hideBottomSheet.value = true
        savedOption?.let {
            SdkUiInitializer.apiLayer?.deleteSavedOption(it, this)
        }
    }

    override fun onDeletedSuccessfully() {
        if (savedModesList.isEmpty()) savedCardsListEmpty.value = true else {
            for (list in savedModesList) {
                if (list.type != PaymentType.SODEXO) {
                    var list1 = list.optionDetail!![0] as SavedCardOption
                    if (list1.cardToken.equals(cardToken)) {
                        savedModesList.remove(list)  // to delete card basis on cardToken
                        break
                    }
                }
            }
            if (adapterList.value?.size != savedModesList.size) reCalculateHeight.value = true
            else if (savedModesList.size == maxItemAtATime) viewMoreCardVisible.value = false
            adapterList.value = savedModesList
            saveListWithoutSodexoCard()
            showListWithDeleteIcon.value = true //For issue PE-18129
        }
    }

    override fun onError(errorResponse: ErrorResponse) {
        apiError.value = errorResponse
    }

    override fun showProgressDialog(showDialog: Boolean) {
        showProgressDialog.value = showDialog
    }

    fun resetManageView() {
        hideAddCardLayout.value = false
        showManageHeader.value = false
        showListWithDeleteIcon.value = false
        adapterList.value = savedModesList
        hideSavedCardsHeader.value = false
    }

    fun uiSetup(initiatedFrom: String) {
        showTitle(initiatedFrom)
        shouldShowManageOption(initiatedFrom)
    }

    fun showTitle(initiatedFrom: String) {
        when (initiatedFrom) {
            SdkUiConstants.CP_CARDS -> {
                titleText.value = applicationContext.getString(R.string.payu_add_new_card_small)
            }
            SdkUiConstants.SODEXO -> {
                titleText.value =
                    applicationContext.getString(R.string.payu_add_new_sodexo_card_small)
            }
        }
    }

    fun shouldShowManageOption(initiatedFrom: String) {
        when (initiatedFrom) {
            SdkUiConstants.CP_CARDS -> {
                shouldShowManageOption.value = false // TODO issue in delete card in sdk will uncomment when fixed
            }
            SdkUiConstants.SODEXO -> {
                shouldShowManageOption.value = false
            }
        }
    }

    internal fun validateOffer(paymentOption: PaymentOption?) {

        if(shouldCallValidateOfferApi().not())
            return

        if (paymentOption != null) {
            val bankCode = paymentOption.bankName

            val category = paymentOption.paymentType?.name
            val cardToken = (paymentOption as? SavedCardOption)?.cardToken
            category?.let {
                showAndroidLoader.value = Event(true)
                SdkUiInitializer.apiLayer?.validateOfferDetails(
                    it,
                    null,
                    bankCode,
                    cardToken,
                    loggedInPhoneNumber = getLoggedInPhoneNumber(),
                    this
                )
            }
        }

    }

    internal fun fetchBalanceForSodexo(){
        SdkUiInitializer.apiLayer?.getBalanceFromSodexo(
        ) { quickOptionsModel ->
            if (!quickOptionsModel?.quickOptionsList.isNullOrEmpty()) {
                quickOptionsModel?.quickOptionsList?.let {
                    val list = ArrayList<PaymentMode>()
                    it.forEach {
                        if (it.type == PaymentType.SODEXO) {
                            list.add(it)
                        }

                    }
                    adapterList.value = list
                }
            }
        }
    }

}
