package com.payu.ui.viewmodel

import android.app.Application
import com.payu.base.listeners.OnFetchImageListener
import com.payu.base.listeners.VerifyServiceListener
import com.payu.base.models.*
import com.payu.base.models.calculateEmi.CalculateEmiRequest
import com.payu.ui.R
import com.payu.ui.SdkUiInitializer
import com.payu.ui.model.utils.AnalyticsUtils
import com.payu.ui.model.utils.SdkUiConstants
import com.payu.ui.model.utils.Utils
import com.payu.ui.model.utils.ViewUtils

class EmiViewModel(application: Application, mParam: Map<String, Any>) :
    CardBaseViewModel(application, mParam),
    VerifyServiceListener {

    init {
        val eligibleList = Utils.getEligibleEmiTenuresList(emiTenureList)
        if (!eligibleList.isNullOrEmpty()) {
            updateEmiList.value = eligibleList
        }
        val emiOption = if (!eligibleList.isNullOrEmpty())
            eligibleList[0] as? EMIOption
        else emiTenureList?.get(0) as? EMIOption

        if (emiTenureList?.let { Utils.isEligibleForEMI(it) } == false) {
            disableCardNumber.value = true
            disableEmiTenures.value = true
            disableCvvExpiry.value = true
            disablePanNumber.value = true
            showEligibleError.value = applicationContext.getString(R.string.payu_emi_not_eligible_error)

        }
        emiOption?.let {
            supportedCardBins =
                if (it.supportedBins.isNullOrEmpty()) null else it.supportedBins
            mobileNumberLabelText.value = applicationContext.getString(
                R.string.payu_mobile_number_registered_with_bank,
                it.bankName
            )
            bankShortName = it.bankShortName
            cardNumberLabel.value =
                "${it.bankName} ${applicationContext.getString(R.string.payu_card_number)}"
            SdkUiInitializer.apiLayer?.getImageForPaymentOption(
                ImageParam(it, false, R.drawable.payu_wallet),
                onFetchImageListener = object : OnFetchImageListener {
                    override fun onImageGenerated(result: ImageDetails) {
                        emiIcon.value = result
                        emiFooterTitle.value = it.bankName
                    }
                })
                isEmiCalculated = false
            }
        siHeaderSummary.value = Utils.getCustomeNoteDetails(
            PaymentType.EMI,
            SdkUiInitializer.apiLayer?.config?.customNoteDetails
        )
        val bankCode = Utils.getValueFromPaymentOption<String>(
            SdkUiConstants.CP_BANK_CODE,
            emiOption?.otherParams as? HashMap<String, Any?>
        )
        if (bankCode != null && bankCode == SdkUiConstants.ZESTMON) {
            selectedTenureBankCode.value = bankCode
            isOfferAvailable.value = Utils.isOfferAvailable(bankCode, PaymentType.EMI)
        }

        showEmiTenureLayout.value = true
        showEmiInterestText.value = false
    }

    var panNumber = ""
        set(value) {
            field = value
            validatePanNumber(value)
        }

     var mobileNumber = ""
        set(value) {
            field = value
            validateMobileNumber(value)
        }

    var bajajCardNumber = ""
        set(value) {
            field = value
            cardError.value = null
            validateBajajCardNumber(value)
        }


    fun makePayment() {
        selectedEmiOption?.let {
            it.cardNumber = cardNumber.replace(cardSeparator, "", true)
            it.expiryMonth = cardMonth
            if (paymentState == PaymentState.CardMobileTenureEligibility || paymentState == PaymentState.CardTenureEligibility || paymentState == PaymentState.CardMobileTenureEligibility || paymentState == PaymentState.CardnumMobileTenureEligibility) {
                it.expiryYear = cardYear
                it.cvv = cvv
            }
            if (paymentState == PaymentState.MobilePanTenureEligibility || paymentState == PaymentState.CardMobileTenureEligibility || paymentState == PaymentState.CardnumMobileTenureEligibility)
                it.phoneNumber = mobileNumber.trim()
            if (!InternalConfig.selectedOfferInfo?.offerMap.isNullOrEmpty()) {
                for (offerKey in InternalConfig.selectedOfferInfo?.offerMap?.keys!!) {
                    if (InternalConfig.selectedOfferInfo?.offerMap?.size!! > 1)
                        it.offerKey = "$offerKey,"
                    else it.offerKey = offerKey
                }
            }

//            it.cardBinInfo = cardOption.cardBinInfo
//            it.shouldSaveCard = cardOption.shouldSaveCard
            val paymentFlowState = PaymentFlowState()
            paymentFlowState.paymentState = paymentState
            SdkUiInitializer.apiLayer?.updatePaymentState(
                Utils.getPaymentModel(it, paymentFlowState),
                ViewUtils.getToolbar(
                    applicationContext,
                    it.additionalCharge
                )
            )
            AnalyticsUtils.logMakePaymentEvent(
                applicationContext,
                selectedEmiOption!!
            )
        }
    }

    internal fun updatePanNumberFocus(hasFocus: Boolean) {
        highlightPanNumber.value = hasFocus
        isPanNumberValid = panNumber.isNotEmpty() && Utils.isValidPanNumber(panNumber)
        if (hasFocus) {
            panNumberError.value = null
            panNumberFieldColor.value = R.color.one_payu_colorPrimary
        } else if (isPanNumberValid)
            panNumberFieldColor.value = R.color.payu_color_338f9dbd
        else {
            panNumberError.value =
                applicationContext.getString(R.string.payu_invalid_pan_number)
            panNumberFieldColor.value = R.color.payu_color_de350b
        }

    }

    private fun validatePanNumber(panNumber: String) {
        isPanNumberValid = panNumber.isNotEmpty() && Utils.isValidPanNumber(panNumber)
        validatePaymentStatus(paymentState)
    }

    override fun eligibilityDetails(apiResponse: ApiResponse) {
        showMobileNumberProgressBar.value = false
        var eligibleList: ArrayList<PaymentOption>? = null
        val emiList = Utils.getEligibleEmiTenuresList(apiResponse.paymentOptionList)
        eligibleList = if (InternalConfig.selectedOfferInfo != null) emiList
        else Utils.getNoCostEmiEligibleList(apiResponse.paymentOptionList, noCostEmiList)
        if (eligibleList.isNullOrEmpty()) {
            isEmiTenureSelected = false
            resetSelectedTenurePosition.value = true
            disableCardNumber.value = true
            disableEmiTenures.value = true
            disableCvvExpiry.value = true
            disablePanNumber.value = true
            showEligibleError.value =
                apiResponse.errorMessage.ifEmpty { applicationContext.getString(R.string.payu_emi_not_eligible_error) }
        } else {
            disablePanNumber.value = false
            disableCardNumber.value = false
            disableEmiTenures.value = false
            disableCvvExpiry.value = false
            showEligibleError.value = null
            disablePanNumber.value = false
            updateEmiList.value = eligibleList
            emiList?.forEach {
                ((it as? EMIOption)?.clone() as? EMIOption)?.let { it1 -> emiTenureList?.add(it1) }
            }
        }
        validatePaymentStatus(paymentState)
    }

    private fun validateMobileNumber(mobileNumber: String) {
        val number = mobileNumber.trim()
        isValidMobileNumber = number.isNotEmpty() && Utils.isValidPhoneNumber(number)
        if (isValidMobileNumber) callVerifyApi(mobileNumber, emiTenureList?.get(0) as? EMIOption, this)
        validatePaymentStatus(paymentState)
    }

    internal fun validateBajajCardNumber(bajajCardNumber: String) {
        val cardNumber = bajajCardNumber.replace("\\s".toRegex(), "")
        isCardNumberValid =
            cardNumber.isNotEmpty() && Utils.isValidBajajcardNumber(cardNumber)
        validatePaymentStatus(paymentState)
    }

}