package com.payu.ui.viewmodel

import android.app.Application
import android.content.Intent
import androidx.fragment.app.FragmentActivity
import androidx.lifecycle.MutableLiveData
import com.payu.base.listeners.BaseApiListener
import com.payu.base.models.ErrorResponse
import com.payu.base.models.InternalConfig
import com.payu.base.models.PaymentMode
import com.payu.base.models.PaymentOption
import com.payu.base.models.PaymentType
import com.payu.base.models.SavedCardOption
import com.payu.base.models.SelectedOfferInfo
import com.payu.ui.R
import com.payu.ui.SdkUiInitializer
import com.payu.ui.model.utils.AnalyticsUtils
import com.payu.ui.model.utils.CPCallbackType
import com.payu.ui.model.utils.SdkUiConstants
import com.payu.ui.model.utils.Utils
import com.payu.ui.view.activities.CheckoutActivity

open class CommonViewModel(application: Application) : BaseViewModel(application),
    BaseApiListener {

    internal var openCheckout: MutableLiveData<Event<Boolean>> = MutableLiveData()
    internal var openQuickPay: MutableLiveData<ArrayList<PaymentMode>> = MutableLiveData()
    internal var quickPayOptionsList: ArrayList<PaymentMode>? = null

    override fun onError(errorResponse: ErrorResponse) {
        flowComplete.postValue(true)
        SdkUiInitializer.apiLayer?.reset()
        AnalyticsUtils.logCPCallbackEventKibana(application, CPCallbackType.Error)
        SdkUiInitializer.checkoutProListener?.onError(errorResponse)
    }

    override fun showProgressDialog(showDialog: Boolean) {
        showProgressDialog.value = showDialog
    }

    internal fun fetchPaymentOptions(hashMap: HashMap<String, String>) {
        showProgressDialog.value = true
        SdkUiInitializer.apiLayer?.fetchPaymentOptions(this) {}
        if (Utils.isSiTxn().not()) fetchOffers()
        SdkUiInitializer.apiLayer?.fetchConfig()
        fetchQuickPay(hashMap)
        AnalyticsUtils.logGetQuickPayOptionsEvent(application)
    }

    private fun fetchQuickPay(hashMap: HashMap<String, String>){
        SdkUiInitializer.apiLayer?.fetchGvQuickPay(hashMap) {
            val quickPayList = ArrayList<PaymentMode>()
            val otherMode = PaymentMode()
            val paymentOption = PaymentOption()
            paymentOption.bankName = application.getString(R.string.payu_other_options)
            val optionDetails = ArrayList<PaymentOption>()
            optionDetails.add(paymentOption)
            otherMode.optionDetail = optionDetails
            it?.quickOptionsList?.let { it1 ->
                for (mode in it1) {
                    if (mode.optionDetail?.get(0)?.paymentType != PaymentType.UPI && mode.type != PaymentType.CLOSED_LOOP_WALLET && mode.type != PaymentType.SODEXO)
                        quickPayList.add(mode)
                }
            }

            if (quickPayList.isNotEmpty() && !InternalConfig.isEnforced && InternalConfig.isQuickPayBottomSheetEnabled && InternalConfig.isQuickPayEnabled && Utils.isSiTxn()
                    .not()
            ) {
                val list =
                    if (quickPayList.size > 3) (quickPayList.take(3) as ArrayList<PaymentMode>) else quickPayList
                list.add(otherMode)
                openQuickPay.value = list
                showProgressDialog.value = false
                AnalyticsUtils.logQuickPayOptionsFetched(
                    application,
                    list.size,
                    list[0].type.toString(),
                    list[0].optionDetail?.get(0)?.bankName ?: ""
                )
                //quickPayOptionsList = list
//                validateOffer(quickPayOptionsList?.get(0)?.optionDetail?.get(0))
            } else {
                openCheckout.value = Event(true)
            }
        }
    }

    private fun fetchOffers(){
        Utils.getUserConsent(application.applicationContext).also {
            InternalConfig.isUserConsentAvailableForPersonalisedOffers = it
        }
        SdkUiInitializer.apiLayer?.fetchOfferDetails(resetCache = true, loggedInPhoneNumber = getLoggedInPhoneNumber()){}
    }

    internal fun openCheckout(activity: FragmentActivity) {
        showProgressDialog.value = false
        val intent = Intent(activity, CheckoutActivity::class.java)
        activity.startActivityForResult(intent, SdkUiConstants.REQUEST_CODE_SDK_INIT)
    }

}