package com.payu.ui.viewmodel

import android.app.Application
import androidx.lifecycle.MutableLiveData
import com.payu.base.listeners.EmiCalculationListener
import com.payu.base.listeners.OnCardBinInfoListener
import com.payu.base.listeners.VerifyServiceListener
import com.payu.base.models.BinBaseDetails
import com.payu.base.models.CardBinInfo
import com.payu.base.models.CardScheme
import com.payu.base.models.EMIOption
import com.payu.base.models.ErrorResponse
import com.payu.base.models.FeeCombinations
import com.payu.base.models.ImageDetails
import com.payu.base.models.InternalConfig
import com.payu.base.models.PaymentOption
import com.payu.base.models.PaymentState
import com.payu.base.models.PaymentType
import com.payu.base.models.SelectedOfferInfo
import com.payu.base.models.VariableDynamics
import com.payu.base.models.calculateEmi.CalculateEmiRequest
import com.payu.base.models.calculateEmi.EmiDetails
import com.payu.base.models.calculateEmi.EmiOfferInfo
import com.payu.base.models.calculateEmi.NceDiscount
import com.payu.ui.R
import com.payu.ui.SdkUiInitializer
import com.payu.ui.model.managers.CFManager
import com.payu.ui.model.models.ToolTipModel
import com.payu.ui.model.utils.AnalyticsUtils
import com.payu.ui.model.utils.SdkUiConstants
import com.payu.ui.model.utils.SdkUiConstants.CP_EMI
import com.payu.ui.model.utils.Utils

open class CardBaseViewModel(application: Application, mParam: Map<String, Any>?) :
    BaseViewModel(application),
    OnCardBinInfoListener, EmiCalculationListener {

    var emiTenureList: ArrayList<PaymentOption>? = null
    var noCostEmiList: ArrayList<PaymentOption>? = null
    var emiDefaultList: ArrayList<PaymentOption> = ArrayList()
    internal val updateEmiList: MutableLiveData<ArrayList<PaymentOption>?> = MutableLiveData()
    val updateSelectedPaymentOption: MutableLiveData<EMIOption> = MutableLiveData()
    val showEmiTenureLayout: MutableLiveData<Boolean> = MutableLiveData()
    val showEmiInterestText: MutableLiveData<Boolean> = MutableLiveData()
    val cardNumberLabel: MutableLiveData<String> = MutableLiveData()
    var siHeaderSummary: MutableLiveData<String> = MutableLiveData()
    val selectedTenureBankCode: MutableLiveData<String> = MutableLiveData()
    var supportedCardBins: ArrayList<String>? = null
    var bankShortName: String? = null
    val isOfferAvailable: MutableLiveData<Boolean> = MutableLiveData()
    var cardBinAdditionalCharge: MutableLiveData<Double?> = MutableLiveData()
    var cardBinGstAmount: MutableLiveData<Pair<Double?, Double?>> = MutableLiveData()
    val selectedTenure: MutableLiveData<String> = MutableLiveData()
    val tenureInterest: MutableLiveData<String?> = MutableLiveData()
    val highlightEmiField: MutableLiveData<Boolean> = MutableLiveData()
    val selectedTenureAmount: MutableLiveData<String> = MutableLiveData()
    var selectedEmiOption: EMIOption? = null
    var selectedOption: MutableLiveData<EMIOption> = MutableLiveData()
    val showBottomSheet: MutableLiveData<Int> = MutableLiveData()
    var hideToolTip: MutableLiveData<Boolean> = MutableLiveData()
    var isCardNumberValid: Boolean = false
    var isExpiryValid: Boolean = false
    var cardMonth: String = ""
    var cardYear: String = ""
    val applicationContext = application
    var expiryError: MutableLiveData<String?> = MutableLiveData()
    var isCardExpiryFocused: Boolean = false
    var highlightCardExpiry: MutableLiveData<Boolean> = MutableLiveData()
    var expiryValid: MutableLiveData<Boolean> = MutableLiveData()
    var cardScheme: MutableLiveData<CardScheme?> = MutableLiveData()
    var cardError: MutableLiveData<String?> = MutableLiveData()
    var isReadyToPay: MutableLiveData<Boolean?> = MutableLiveData(false)
    var isCVVValid: Boolean = false
    val hideCvvExpiryView: MutableLiveData<Boolean> = MutableLiveData()
    var highlightCardNumber: MutableLiveData<Boolean> = MutableLiveData()
    var cvvValid: MutableLiveData<Boolean> = MutableLiveData()
    var highlightCardCvv: MutableLiveData<Boolean> = MutableLiveData()
    var isCardCvvFocused: Boolean = false
    var cvvError: MutableLiveData<String?> = MutableLiveData()
    val disableCardNumber: MutableLiveData<Boolean> = MutableLiveData()
    var isEmiTenureSelected: Boolean = false
    var isCardBinSupported: Boolean = true //For EMI payments
    var isCardNumberFocused: Boolean = false
    var isEmiCalculated: Boolean = true
    val cardSeparator = " "
    internal val mobileNumberLabelText: MutableLiveData<String> = MutableLiveData()
    internal val showMobileNumberProgressBar: MutableLiveData<Boolean> = MutableLiveData()
    private val mobileNumberError: MutableLiveData<String?> = MutableLiveData()
    private val mobileNumberFieldColor: MutableLiveData<Int> = MutableLiveData()
    internal val disableEmiTenures: MutableLiveData<Boolean> = MutableLiveData()
    internal val showEligibleError: MutableLiveData<String?> = MutableLiveData()
    internal val resetSelectedTenurePosition: MutableLiveData<Boolean> = MutableLiveData()
    val disableCvvExpiry: MutableLiveData<Boolean> = MutableLiveData()
    var isValidMobileNumber: Boolean = false
    val emiIcon: MutableLiveData<ImageDetails> = MutableLiveData()
    val emiFooterTitle: MutableLiveData<String> = MutableLiveData()
    var cardNumberValid: MutableLiveData<Boolean> = MutableLiveData()
    var paymentState: PaymentState? = null
    var highlightPanNumber: MutableLiveData<Boolean> = MutableLiveData()
    internal var disablePanNumber: MutableLiveData<Boolean> = MutableLiveData()
    internal var isPanNumberValid: Boolean = false
    internal var panNumberError: MutableLiveData<String> = MutableLiveData()
    internal val panNumberFieldColor: MutableLiveData<Int> = MutableLiveData()
    internal var showEmiSummary: MutableLiveData<String> = MutableLiveData()
    internal var emiFeeSummary: MutableLiveData<String> = MutableLiveData()
    internal var updateHeaderAmount: MutableLiveData<Double> = MutableLiveData()
    internal var calculateEmi: MutableLiveData<CalculateEmiRequest> = MutableLiveData()
    internal var makePayment: MutableLiveData<Boolean> = MutableLiveData()
    internal var validateOfferBottomSheet: MutableLiveData<Boolean> = MutableLiveData()
    internal var cardOffer: MutableLiveData<String> = MutableLiveData()
    internal var showErrorSnackBar: MutableLiveData<Boolean> = MutableLiveData()
    var fetchedCardBin: String? = null
    var expiryToolTip: MutableLiveData<ToolTipModel> = MutableLiveData()
    var cvvToolTip: MutableLiveData<ToolTipModel> = MutableLiveData()
    var showTransparentView: MutableLiveData<Boolean> = MutableLiveData()
    var showNoCostTag: MutableLiveData<Boolean> = MutableLiveData()
    var showCashBackTenureText: MutableLiveData<String> = MutableLiveData()
    val showSavedCardSwitch: MutableLiveData<Boolean> = MutableLiveData()
    internal var isSaveCardInfoBottomSheet: MutableLiveData<Boolean> = MutableLiveData()
    internal val offerTextColor: MutableLiveData<Int> = MutableLiveData()
    internal var isEmiTxn: Boolean = false
    internal var isCardNumberChanged = false
    internal var isCardOfferRemovedManually: Boolean = false

    val updateCFinHeader: MutableLiveData<PaymentOption> = MutableLiveData()
    val updateCFinHeaderFromFeeComb: MutableLiveData<BinBaseDetails?> = MutableLiveData()

    init {
        if (mParam?.get(SdkUiConstants.CP_EMI_LIST) != null)
            emiTenureList = mParam[SdkUiConstants.CP_EMI_LIST] as ArrayList<PaymentOption>
        emiTenureList?.forEach {
            emiDefaultList.add((it as EMIOption).clone() as EMIOption)
        }
        if (mParam?.get(SdkUiConstants.CP_PAYMENT_STATE) != null)
            paymentState = mParam[SdkUiConstants.CP_PAYMENT_STATE] as PaymentState
        showSavedCard()
    }

    var cardNumber = ""
        set(value) {
            field = value
            hideToolTip.value = true
            isCardNumberChanged = true
            validateCardNumber()
            cardNumberValid.value = isCardNumberValid
        }
    var cardExpiry = ""
        set(value) {
            field = value
            hideToolTip.value = true
            validateExpiry()
            expiryValid.value = isExpiryValid

        }

    var cvv = ""
        set(value) {
            field = value
            hideToolTip.value = true
            validateCvv()
            cvvValid.value = isCVVValid
        }

    open fun tenureSelected(emiOption: EMIOption?, tenureText: String, totalAmountText: String) {
        emiOption?.let {
            updateSelectedPaymentOption.value = it
            isEmiTenureSelected = true
            cardBinAdditionalCharge.value = emiOption.additionalCharge
            cardBinGstAmount.value = Pair(emiOption.gstPercentageValue, emiOption.cardBinInfo?.gstFlatValue)
            emiOption.cardBinInfo = selectedEmiOption?.cardBinInfo
            selectedEmiOption = emiOption
            selectedTenure.value = tenureText
            showNoCostTag.value = emiOption.isNoCostEmi
            selectedTenureAmount.value = totalAmountText
            hideBottomSheet.value = true
            highlightEmiField.value = true
            showEmiInterestText.value = true
            InternalConfig.interestCharged = emiOption.interestCharged
            val emiOfferIn = EmiOfferInfo()
            if (emiOption.isNoCostEmi && emiOption.totalPayableAmount != 0.0) {
                emiOfferIn.nceDiscount = emiOption.nceDiscount
                tenureInterest.value =
                    applicationContext.getString(R.string.payu_no_interest_charged)
            } else {
                updateOfferView(emiOption)
            }
            updateSelectedTenureView(emiOption)

            if (emiOption.totalPayableAmount != 0.0)
                emiOfferIn.totalPayableAmount = emiOption.totalPayableAmount
            else emiOfferIn.totalPayableAmount =
                (SdkUiInitializer.apiLayer?.payUPaymentParams?.amount?.toDouble()
                    ?: 0.0).plus(emiOption.interestCharged)

            if (emiOption.revisedPrincipal != 0.0)
                emiOfferIn.revisedPrincipalAmount = emiOption.revisedPrincipal
            else emiOfferIn.revisedPrincipalAmount =
                (SdkUiInitializer.apiLayer?.payUPaymentParams?.amount?.toDouble()
                    ?: 0.0).plus(emiOption.additionalCharge ?: 0.0)

            emiOfferIn.offerDiscount = emiOption.offerDiscount
            InternalConfig.emiOfferInfo = emiOfferIn
            val bankCode = Utils.getValueFromPaymentOption<String>(
                SdkUiConstants.CP_BANK_CODE,
                emiOption.otherParams as? HashMap<String, Any?>
            )
            if (bankCode != null) {
                selectedTenureBankCode.value = bankCode
                isOfferAvailable.value = Utils.isOfferAvailable(bankCode, PaymentType.EMI)
            }
            AnalyticsUtils.logEmiTenureClicked(
                applicationContext,
                SdkUiConstants.CP_EMI_TENURE_SELECTION,
                emiOption.paymentType!!
            )
            calculateEmi(emiCodes = getSelectedEmiCode(), includeValidateOfferRequest = InternalConfig.selectedOfferInfo == null)
//        } else updateOfferTextValue()
            validatePaymentStatus(paymentState)
            updateHeaderAmount(emiOption)
        }
    }

    internal fun bottomSheetCloseClicked() {
        hideBottomSheet.value = true
    }

    internal fun updateCardExpiryFocusView() {
        if (isCardExpiryFocused)
            highlightCardExpiry.value = true
        else
            expiryError.value = null
    }

    override fun onEmiCalculated(list: ArrayList<EmiDetails>?) {
        if(list != null) {
            showEmiSummary.value = null
            emiFeeSummary.value = null
        }
        val emiList = ArrayList<PaymentOption>()
        emiDefaultList.forEach {
            (it as? EMIOption)?.let { emiOption -> emiList.add(emiOption) }
        }
        list?.let { getUpdatedEmiList(emiList, it) }
        showProgressDialog.value = false
        isEmiCalculated = true
        validatePaymentStatus(paymentState)
        if(isEmiTenureSelected){
            updateCFinHeader.value = selectedEmiOption
        }
    }

    override fun onError(errorResponse: ErrorResponse) {
        AnalyticsUtils.logEventNameForKibana(
            applicationContext,
            SdkUiConstants.ERROR_CODE + errorResponse.errorCode + " " + SdkUiConstants.ERROR_MESSAGE + errorResponse.errorMessage
        )
    }

    override fun showProgressDialog(showDialog: Boolean) {
        showProgressDialog.value = showDialog
    }

    internal fun updateCardCvvFocusView() {
        if (isCardCvvFocused)
            highlightCardCvv.value = true
        else
            cvvError.value = null
    }

    internal fun showBottomSheet() {
        showBottomSheet.value = R.layout.layout_emi_tenure
    }

    open fun setCardSchemeData(binInfo: CardBinInfo?) {
        cardScheme.value = binInfo?.cardScheme
    }

    internal fun validateCardNumberOnFocusChange() {
        if (!isCardNumberValid) showCardError()

    }

    internal fun showCardError() {
        if (disableCardNumber.value != null && disableCardNumber.value!!) return
        if (!isCardNumberValid)
            cardError.value =
                applicationContext.getString(R.string.payu_card_number_error)
    }

    internal fun emiTenuresClicked() {
        if (!isCardNumberValid) showCardError()
        if (!isExpiryValid) expiryError.value =
            applicationContext.getString(R.string.payu_invalid_expiry)
        if (!isCVVValid) cvvError.value =
            applicationContext.getString(R.string.payu_cvv_error)
    }

    internal fun emiTenureFocused(hasFocus: Boolean) {
        highlightEmiField.value = hasFocus
    }

    internal fun isValidCardNumber(): Boolean = isCardNumberValid

    internal fun isValidCVV(): Boolean =
        if (hideCvvExpiryView.value != null && hideCvvExpiryView.value!!) true else isCVVValid

    internal fun isValidExpiry(): Boolean =
        if (hideCvvExpiryView.value != null && hideCvvExpiryView.value!!) true else isExpiryValid

    internal fun checkCardBinSupported(cardNumber: String) {
        if (supportedCardBins == null) {
            binSupported()
            return
        } else if (supportedCardBins?.isEmpty() == true) {
            binNotSupported()
            return
        }
        if (cardNumber.length > 5) {
            if (supportedCardBins?.contains(cardNumber.take(6)) == true) binSupported() else binNotSupported()
        }
    }

    internal fun binNotSupported() {
        isCardBinSupported = false
            cardError.value =
                applicationContext.getString(R.string.payu_card_not_supported_for_emi_payments)
    }

    internal fun binSupported() {
        isCardBinSupported = true
    }

    internal fun mobileNumberFocusChanged(hasFocus: Boolean, number: String) {
        isValidMobileNumber = number.isNotEmpty() && Utils.isValidPhoneNumber(number)
        if (hasFocus) {
            mobileNumberError.value = null
            mobileNumberFieldColor.value = R.color.one_payu_colorPrimary
        } else if (isValidMobileNumber)
            mobileNumberFieldColor.value = R.color.payu_color_338f9dbd
        else {
            mobileNumberError.value =
                applicationContext.getString(R.string.payu_invalid_mobile_number)
            mobileNumberFieldColor.value = R.color.payu_color_de350b
        }
    }


    internal fun calculateNoCostEmiTenuresWithOffers(
        calculateEmiRequest: CalculateEmiRequest
    ) {
        showProgressDialog.value = true
        val bankCode = Utils.getValueFromPaymentOption<String>(
            SdkUiConstants.CP_BANK_CODE,
            selectedEmiOption?.otherParams as? HashMap<String, Any?>
        )
        calculateEmiRequest.cardBin = cardNumber.replace(" ", "")
        val card = cardNumber.replace(" ", "", true)
        SdkUiInitializer.apiLayer?.calculateEmiApi(
            category = CP_EMI,
            cardNumber = card,
            paymentCode = bankCode,
            cardToken = null,
            loggedInPhoneNumber = getLoggedInPhoneNumber(),
            includeValidateOfferRequest = if(calculateEmiRequest.includeOfferRequest) shouldCallValidateOfferApi() else false,
            calculateEmiRequest = calculateEmiRequest,
            emiCalculationListener = this,
            validateOfferListener = this
        )
    }

    fun isEmiSelected(): Boolean {
        return if (showEmiTenureLayout.value!!) isEmiTenureSelected else true
    }

    // Todo : to be removed after final usage check after CF
//    internal fun fetchCFAndValidateOffer(
//        category: String?,
//        includeValidateOfferRequest: Boolean = true
//    ) {
//        //called for sodexo and card flow have to check and remove, in card flow when switched between switch to emi on and emi off
//
//        val paymentType = selectedPaymentOption?.paymentType?.name
//
//        val callApi = isValidCardNumber()
//
//        if (shouldCallOnDemandCFandOfferApi(paymentType) && callApi) {
//            val variableDynamicList: ArrayList<VariableDynamics> = ArrayList()
//            val card = cardNumber.replace(" ", "", true)
//            var ibiboCode: String? = paymentType
//            (selectedPaymentOption?.otherParams as? HashMap<String, Any>)?.let { it1 ->
//                ibiboCode = Utils.getBankCodeFromMap(
//                    it1
//                )
//            }
//
//            if (!paymentType.isNullOrEmpty() && ibiboCode.isNullOrEmpty().not()) {
//                val variableDynamics = VariableDynamics(
//                    paymentType.plus("_${ibiboCode}"),
//                    ibiboCode ?: ""
//                )
//                variableDynamicList.add(variableDynamics)
//            }
//
//            if (shouldCallValidateOfferApi().not() && CFManager.checkIfCFPresent(
//                    ibiboCode ?: ""
//                )
//            ) {
//                ibiboCode?.let {
//                    CFManager.getConvFeeComb(it)?.let { it ->
//                        selectedPaymentOption?.feeCombinations = it
//                    }
//                    updateCFinHeader.value = selectedPaymentOption
//                    return
//                }
//            }
//
//            if (variableDynamicList.isNotEmpty()) {
//                showAndroidLoader.value = Event(true)
//                SdkUiInitializer.apiLayer?.fetchConvenienceFee(
//                    category = category ?: "",
//                    cardNumber = card,
//                    paymentCode = ibiboCode,
//                    cardToken = null,
//                    loggedInPhoneNumber = getLoggedInPhoneNumber(),
//                    includeValidateOfferRequest = if (includeValidateOfferRequest) shouldCallValidateOfferApi() else false,
//                    mode = paymentType ?: "",
//                    validateOfferListener = this,
//                    variableDynamicList = variableDynamicList
//                ) { cFandAdditionalCharges ->
//
//                    val additionalCharge = cFandAdditionalCharges.additionalCharge
//                    val feeCombinations = cFandAdditionalCharges.feeCombinations
//
//                    additionalCharge?.let {
//                        selectedPaymentOption?.additionalCharge =
//                            it.convenienceFee?.toDoubleOrNull()
//                        selectedPaymentOption?.gstValue = it.gst?.toDoubleOrNull()
//                    }
//                    if (additionalCharge == null && feeCombinations != null && feeCombinations.contains(
//                            ibiboCode
//                        )
//                    )
//                        selectedPaymentOption?.feeCombinations = feeCombinations[ibiboCode]
//
//                    showAndroidLoader.value = Event(false)
//                    updateCFinHeader.value = selectedPaymentOption
//                }
//            }
//        }
//    }

    open fun validateCardNumber() {
        val inputValue = cardNumber.replace(cardSeparator, "", true)
        if (inputValue.isNotEmpty())
            checkCardBinSupported(inputValue)
        else
            cardError.value = null
        if (inputValue.length > 5) {
            if (!inputValue.take(6).equals(fetchedCardBin)) {
                fetchedCardBin = inputValue.take(6)
                SdkUiInitializer.apiLayer?.fetchBinBaseDetails(
                    cardNumber = inputValue.take(6),
                    cardToken = "",
                    null,
                    null,
                    includeValidateOfferRequest = shouldCallValidateOfferApi() && isCardOfferRemovedManually.not()
                ) { binBaseDetails ->
                    isCardOfferRemovedManually = false
                    onCardBinInfo(binBaseDetails?.cardBinInfo)
                    calculateEmi()
                }
            }
        } else {
            isCardNumberValid = false
            fetchedCardBin = null
            if (Utils.isAmexCard(inputValue)) {
//                fetchedCardBin = inputValue
                setCardSchemeData(CardBinInfo().apply { cardScheme = CardScheme.AMEX })
            } else {
                cardError.value = null
                setCardSchemeData(null)
            }
        }
        verifyCardNumberValid()
    }

    internal open fun verifyCardNumberValid() {
        val inputValue = cardNumber.replace(cardSeparator, "", true)
        if (Utils.isValidNumberFormat(inputValue) && Utils.isValidCardLength(
                cardScheme.value,
                inputValue.length
            )
        ) {
            if (!Utils.luhn(inputValue) || !isCardBinSupported || cardScheme.value == null) {
                isCardNumberValid = false
                if (InternalConfig.selectedOfferInfo?.isAutoApply == true)
                    showOfferApplied.value = Event(false)
                if (cardError.value == null)
                    cardOffer.value = null
                InternalConfig.isPaymentOptionSelected = false

            } else {
                isCardNumberValid = true
                if (cardOffer.value == null)
                    cardError.value = null
            }
        } else {
            if (InternalConfig.selectedOfferInfo?.isAutoApply == true)
                showOfferApplied.value = Event(false)
            isCardNumberValid = false
            InternalConfig.isPaymentOptionSelected = false
            if (cardError.value == null)
                cardOffer.value = null
        }
        validatePaymentStatus(paymentState)
    }

    open fun validateExpiry() {
        validExpiry()
        validatePaymentStatus(paymentState)
    }

    open fun validateCvv() {
        if (!isExpiryValid)
            expiryError.value =
                applicationContext.getString(R.string.payu_invalid_expiry)
        isCVVValid = Utils.isValidCvv(cvv, cardScheme.value)
                || (cvv.isEmpty() && Utils.isCvvLessCard(cardScheme.value))

        updateCardCvvFocusView()
        validatePaymentStatus(paymentState)
    }

    internal fun cardNumberFocused(hasFocus: Boolean) {
        if (hasFocus) {
            isCardNumberFocused = true
            validateCardNumber()
            if (cardError.value == null) {
                highlightCardNumber.value = true
            }
//            updateOfferTextValue()
        } else {
            highlightCardNumber.value = false
            isCardNumberFocused = false
            showCardError()
            validateCardNumberOnFocusChange()
        }
    }

    internal fun cardExpiryFocused(hasFocus: Boolean) {
        if (hasFocus) {
            validateExpiry()
            isCardExpiryFocused = true

            if (expiryError.value == null) {
                highlightCardExpiry.value = true
            }
        } else {
            isCardExpiryFocused = false
            validateExpiryOnFocusChange()
        }
    }

    internal fun cardCvvFocused(hasFocus: Boolean) {
        if (hasFocus) {
            validateCvv()
            isCardCvvFocused = true

            if (cvvError.value == null)
                highlightCardCvv.value = true

        } else {
            isCardCvvFocused = false
            validateCvvOnFocusChange()
        }
    }

    private fun validateCvvOnFocusChange() {
        validateCvv()
        if (isCVVValid)
            cvvError.value = null
        else
            cvvError.value = applicationContext.getString(R.string.payu_cvv_error)
    }

    internal fun validateExpiryOnFocusChange() {
        validateExpiry()
        if (isExpiryValid)
            expiryError.value = null
        else
            expiryError.value =
                applicationContext.getString(R.string.payu_invalid_expiry)
    }

    internal fun callVerifyApi(
        mobileNumber: String,
        emiOption: EMIOption?,
        verifyServiceListener: VerifyServiceListener
    ) {
        emiOption?.let {
            it.phoneNumber = mobileNumber
            showMobileNumberProgressBar.value = true
            SdkUiInitializer.apiLayer?.verifyEligibilityAPI(it, verifyServiceListener)
        }
    }

    internal fun validatePaymentStatus(paymentState: PaymentState?) {
        if (!isEmiTxn) {
            when (paymentState) {
                PaymentState.CardMobileTenureEligibility -> isReadyToPay.value =
                    isValidCVV() && isValidCardNumber() && isValidExpiry() && isValidMobileNumber && isEmiTenureSelected && (isEmiCalculated)

                PaymentState.CardnumMobileTenureEligibility -> isReadyToPay.value =
                    isValidCardNumber() && isValidMobileNumber && isEmiTenureSelected && isEmiCalculated

                PaymentState.CardTenureEligibility -> isReadyToPay.value =
                    isValidCVV() && isValidCardNumber() && isValidExpiry() && isEmiTenureSelected && isEmiCalculated

                PaymentState.CardnumTenureEligibility -> isReadyToPay.value =
                    isValidCardNumber() && isEmiTenureSelected && isEmiCalculated

                else -> {
                    isReadyToPay.value =
                        isPanNumberValid && isValidMobileNumber && isEmiTenureSelected && isEmiCalculated
                }
            }
        } else {
            isReadyToPay.value =
                isValidCVV() && isValidCardNumber() && isValidExpiry() && isEmiTenureSelected && isEmiCalculated
        }
    }

    override fun onCardBinInfo(cardBinInfo: CardBinInfo?) {
        if (selectedEmiOption == null)
            selectedEmiOption = EMIOption()
        selectedEmiOption?.cardBinInfo = cardBinInfo
        selectedOption.value = selectedEmiOption
        setCardSchemeData(cardBinInfo)
        if(cardBinInfo == null)
            isCardNumberValid = false

//        updateOfferTextValue()
    }

    //TODO will uncommnent when reimlement card offer applied logic

//    internal open fun updateOfferTextValue() {
//        if ((InternalConfig.selectedOfferInfo != null || InternalConfig.emiOfferInfo?.offerDiscount != null) && isEmiTenureSelected && cardNumber.length >= 5 && isCardNumberValid) {
//            if (Utils.isOfferAvailable(
//                    selectedTenureBankCode.value!!,
//                    PaymentType.EMI
//                ) || InternalConfig.selectedOfferInfo?.offerMap != null
//            ) cardOffer.value =
//                applicationContext.getString(R.string.payu_offer_applied)
//            else cardOffer.value = applicationContext.getString(R.string.payu_offer_not_applied)
//        } else {
//            cardOffer.value = null
//        }
//    }

    internal fun validExpiry() {
        if (cardExpiry.length < 5) {
            updateCardExpiryFocusView()
            isExpiryValid = false
        } else if (cardExpiry.length == 5) {
            if (Utils.isValidExpiry(cardExpiry)) {
                val data = cardExpiry.split("/")
                cardMonth = data[0]
                val year = data[1]
                cardYear = Utils.getExpiryYear(year)
                updateCardExpiryFocusView()
                isExpiryValid = true
            } else {
                isExpiryValid = false
                expiryError.value =
                    applicationContext.getString(R.string.payu_invalid_expiry)
            }
        }
    }

    internal fun getEmiCodes(emiList: ArrayList<PaymentOption>? = emiTenureList): ArrayList<String>? {
        val emiCodes = ArrayList<String>()
        emiList?.forEach { paymentOption ->
            if (paymentOption.otherParams != null && paymentOption.otherParams is HashMap<*, *>) {
                val otherParams = paymentOption.otherParams as HashMap<String, String>
                otherParams[SdkUiConstants.CP_BANK_CODE]?.let { emiCodes.add(it) }
            }
        }
        return emiCodes
    }

    internal fun getSelectedEmiCode(): ArrayList<String>? {
        val emiCodes = ArrayList<String>()
        if (selectedEmiOption?.otherParams != null && selectedEmiOption?.otherParams is HashMap<*, *>) {
            val otherParams = selectedEmiOption?.otherParams as HashMap<String, String>
            otherParams[SdkUiConstants.CP_BANK_CODE]?.let { emiCodes.add(it) }
        }
        return emiCodes.ifEmpty { getEmiCodes() }
    }

    internal fun updateDefaultEmiList(emiList: ArrayList<PaymentOption>) {
        emiDefaultList = emiList
    }


    private fun getUpdatedEmiList(emiList: ArrayList<PaymentOption>, list: ArrayList<EmiDetails>) {
        for (item in emiList) {
            if (item.otherParams != null && item.otherParams is HashMap<*, *>) {
                val map = item.otherParams as HashMap<String, String>
                val emiCode = map[SdkUiConstants.CP_BANK_CODE]
                for (emi in list) {
                    if (emiCode == emi.emiBankCode) {
                        (item as EMIOption).emiValue = if(emi.emiValue == 0.0) emi.emiAmount else emi.emiValue
                        item.interestCharged = emi.emiInterestPaid
                        item.totalPayableAmount = emi.totalPayableAmount
                        item.revisedPrincipal = emi.revisedPrincipal
                        item.nceDiscount = emi.nceDiscount
                        item.offerDiscount = emi.offerDiscount
                        item.isNoCostEmi =
                            (item.nceDiscount?.total != null && item.nceDiscount?.total != 0.0)
                        emi.processingFee?.let { it1 ->
                            item.processingFee = it1
                        }
                        item.processingFeeMessage = emi.processingFeeMessage
                        item.additionalCharge = emi.additionalCost
                    }
                }
            }
        }
        updateEmiList.value = emiList
        updateSelectedTenureValue(emiList)
        noCostEmiList = emiList
    }

    private fun updateSelectedTenureValue(emiList: ArrayList<PaymentOption>) {
        for (emiOption in emiList) {
            if (isEmiTenureSelected && selectedEmiOption != null && (emiOption as EMIOption).months == selectedEmiOption?.months) {
                if (emiOption.totalPayableAmount != selectedEmiOption?.totalPayableAmount)
                    showErrorSnackBar.value = true
                if (InternalConfig.selectedOfferInfo?.isNoCostEmi == true && (emiOption.isNoCostEmi && emiOption.totalPayableAmount != 0.0)) {
                    val emiOfferInfo = EmiOfferInfo()
                    emiOfferInfo.nceDiscount = emiOption.nceDiscount
                    emiOfferInfo.offerDiscount = emiOption.offerDiscount
                    emiOfferInfo.totalPayableAmount = emiOption.totalPayableAmount
                    emiOfferInfo.revisedPrincipalAmount = emiOption.revisedPrincipal
                    showNoCostTag.value = true
                    InternalConfig.interestCharged = emiOption.interestCharged
                    tenureInterest.value =
                        applicationContext.getString(R.string.payu_no_interest_charged)
                    InternalConfig.emiOfferInfo = emiOfferInfo
                    val emiAmt = String.format(
                        "%.2f", emiOption.emiValue
                    )
                    selectedTenure.value = applicationContext.getString(
                        R.string.payu_pay_emi_amount,
                        Utils.formatAmount(emiAmt),
                        emiOption.months.toString()
                    )
                } else if (InternalConfig.selectedOfferInfo != null) {
                    val emiOfferInfo = EmiOfferInfo()
                    emiOfferInfo.offerDiscount = emiOption.offerDiscount
                    emiOfferInfo.totalPayableAmount = emiOption.totalPayableAmount
                    emiOfferInfo.revisedPrincipalAmount = emiOption.revisedPrincipal
                    InternalConfig.interestCharged = emiOption.interestCharged
                    InternalConfig.emiOfferInfo = emiOfferInfo
                    updateOfferView(emiOption)
                } else {
                    showNoCostTag.value = false
                    showCashBackTenureText.value = null
                    val interestValue = String.format(
                        "%.2f",
                        emiOption.interestCharged
                    )
                    InternalConfig.interestCharged = emiOption.interestCharged
                    tenureInterest.value = applicationContext.getString(
                        R.string.payu_applicable_interest_rupees,
                        interestValue,
                        emiOption.interestRate.toString()
                    )
                    val emiAmt = String.format(
                        "%.2f", emiOption.emiValue
                    )
                    selectedTenure.value = applicationContext.getString(
                        R.string.payu_pay_emi_amount,
                        Utils.formatAmount(emiAmt),
                        emiOption.months.toString()
                    )
                    showNoCostTag.value = false
                    showEmiSummary.value = null
                    emiFeeSummary.value = null

                }
                updateSelectedTenureView(emiOption)
            }
        }
    }

    private fun updateHeaderAmount(emiOption: EMIOption) {
        val totalDiscount =
            (emiOption.nceDiscount?.instant ?: 0.0).plus(emiOption.offerDiscount?.instant ?: 0.0)
        updateHeaderAmount.value = if(emiOption.revisedPrincipal!= 0.0) emiOption.revisedPrincipal else if (totalDiscount != 0.0)
            SdkUiInitializer.apiLayer?.payUPaymentParams?.amount?.toDoubleOrNull()
                ?.minus(totalDiscount)
        else if (InternalConfig.userSelectedOfferInfo != null && InternalConfig.userSelectedOfferInfo?.offerType == SdkUiConstants.CP_INSTANT_OFFER) {
            SdkUiInitializer.apiLayer?.payUPaymentParams?.amount?.toDoubleOrNull()
                ?.minus(
                    InternalConfig.userSelectedOfferInfo?.discountDetailsOfOffers?.discount ?: 0.0
                )
        } else SdkUiInitializer.apiLayer?.payUPaymentParams?.amount?.toDoubleOrNull()
    }

    fun toolTipExpiryClicked() {
        showTransparentView.value = true
        expiryToolTip.value = ToolTipModel(
            applicationContext.getString(R.string.payu_card_expiry),
            applicationContext.getString(R.string.payu_credit_card_expiry),
            null
        )
    }

    fun toolTipCvvClicked() {
        showTransparentView.value = true
        cvvToolTip.value = when {
            (cardScheme.value == CardScheme.AMEX) || (bankShortName != null && bankShortName!!.contains(
                CardScheme.AMEX.name
            )) -> ToolTipModel(
                applicationContext.getString(R.string.payu_what_is_csc),
                applicationContext.getString(R.string.payu_the_card_security_code),
                R.drawable.payu_tt_amex_cvv
            )

            else -> ToolTipModel(
                applicationContext.getString(R.string.payu_what_is_cvv),
                applicationContext.getString(R.string.payu_the_card_verification_value),
                R.drawable.payu_tt_cvv
            )
        }
    }

    fun transparentViewClicked() {
        showTransparentView.value = false
        hideToolTip.value = true
    }

    private fun updateSelectedTenureView(emiOption: EMIOption) {
        updateSelectedPaymentOption.value = emiOption
        val totalInstantDiscount =
            (emiOption.nceDiscount?.instant ?: 0.0).plus(emiOption.offerDiscount?.instant ?: 0.0)
        val totalCashBackDiscount =
            (emiOption.nceDiscount?.cashback ?: 0.0).plus(emiOption.offerDiscount?.cashback ?: 0.0)

        val revisedPrincipal = if (emiOption.revisedPrincipal != 0.0) emiOption.revisedPrincipal else null
        val amount = SdkUiInitializer.apiLayer?.payUPaymentParams?.amount?.toDoubleOrNull()
                ?.minus(totalInstantDiscount)
        val formatAmount = Utils.formatAmount(
            String.format(
                "%.2f",
                revisedPrincipal ?: amount?.plus(emiOption?.additionalCharge ?: 0.0)
            )
        )

        val interest = Utils.formatAmount(
            String.format(
                "%.2f",
                emiOption.interestCharged
            )
        )

        val finalAmt = if(emiOption.totalPayableAmount != 0.0) emiOption.totalPayableAmount else null
        val amt = amount?.plus(emiOption.interestCharged)
        val totalPayableAmount = Utils.formatAmount(
            String.format(
                "%.2f",
                finalAmt ?: amt?.plus(emiOption.additionalCharge ?: 0.0)
            )
        )

        showEmiSummary.value = applicationContext.getString(
            R.string.payu_emi_summary,
            formatAmount,
            interest,
            totalPayableAmount
        )

        if (totalCashBackDiscount > 0.0) {
            val formatAmount = Utils.formatAmount(
                String.format(
                    "%.2f",
                    totalCashBackDiscount
                )
            )
            showCashBackTenureText.value = applicationContext.getString(
                R.string.payu_cashback_info_text,
                formatAmount
            )
        } else {
            showCashBackTenureText.value = null
        }
        if (emiOption.processingFeeMessage != null)
            emiFeeSummary.value =
                emiOption.processingFeeMessage + " " + applicationContext.getString(
                    R.string.payu_emi_fee_summary,
                    bankShortName
                )
        else emiFeeSummary.value = null
        updateHeaderAmount(emiOption)
    }

    private fun updateOfferView(emiOption: EMIOption) {
        if (InternalConfig.selectedOfferInfo?.totalCashbackDiscount != null && InternalConfig.selectedOfferInfo?.totalCashbackDiscount != 0.0) {
            val formatAmount = Utils.formatAmount(
                String.format(
                    "%.2f",
                    InternalConfig.selectedOfferInfo?.totalCashbackDiscount
                )
            )
            showCashBackTenureText.value = applicationContext.getString(
                R.string.payu_cashback_info_text,
                formatAmount
            )
        } else {
            showCashBackTenureText.value = null
        }
        val emiOfferInfo = EmiOfferInfo()
        val offerDiscount = NceDiscount()
        val discount = InternalConfig.selectedOfferInfo?.totalInstantDiscount ?: 0.0
        val cashBack = InternalConfig.selectedOfferInfo?.totalCashbackDiscount ?: 0.0
        offerDiscount.cashback = cashBack
        offerDiscount.instant = discount
        emiOfferInfo.offerDiscount = offerDiscount
        emiOfferInfo.totalPayableAmount =
            if (emiOption.totalPayableAmount != 0.0)
                emiOption.totalPayableAmount
            else
                (SdkUiInitializer.apiLayer?.payUPaymentParams?.amount?.toDouble()?.minus(discount)
                    ?.plus(InternalConfig.interestCharged ?: 0.0))
                    ?: 0.0

        if (emiOption.revisedPrincipal != 0.0)
            emiOfferInfo.revisedPrincipalAmount = emiOption.revisedPrincipal
        else emiOfferInfo.revisedPrincipalAmount =
            (SdkUiInitializer.apiLayer?.payUPaymentParams?.amount?.toDouble()
                ?: 0.0).plus(emiOption.additionalCharge ?: 0.0)

        InternalConfig.emiOfferInfo = emiOfferInfo
        val interestValue = String.format(
            "%.2f",
            emiOption.interestCharged
        )
        tenureInterest.value = applicationContext.getString(
            R.string.payu_applicable_interest_rupees,
            interestValue,
            emiOption.interestRate.toString()
        )
        val emiAmt = String.format(
            "%.2f", emiOption.emiValue
        )

        selectedTenure.value = applicationContext.getString(
            R.string.payu_pay_emi_amount,
            Utils.formatAmount(emiAmt),
            emiOption.months.toString()
        )
        showNoCostTag.value = false
        showEmiSummary.value = null
        emiFeeSummary.value = null
    }

    internal fun showSavedCard() {
        showSavedCardSwitch.value =
            if (!InternalConfig.isQuickPayEnabled && !SdkUiInitializer.apiLayer?.payUPaymentParams?.userCredential.isNullOrEmpty()) {
                SdkUiInitializer.apiLayer?.config?.enableSavedCard == true
            } else if (InternalConfig.isQuickPayEnabled) {
                SdkUiInitializer.apiLayer?.config?.enableSavedCard == true
            } else {
                false
            }
    }

    internal open fun handlePayNow(isSaveCardInfoBottomSheet: Boolean) {
        if (!isSaveCardInfoBottomSheet) {
            selectedEmiOption?.shouldSaveCard = true
        }
        hideBottomSheet.value = true
    }

    internal fun handleSavedCardInfoNudge() {
        hideSoftKeyboard.value = true
        isSaveCardInfoBottomSheet.value = true
        showBottomSheet.value = R.layout.save_card_nudge_bottomsheet
    }

    internal fun handleSavedCardNudge() {
        hideSoftKeyboard.value = true
        isSaveCardInfoBottomSheet.value = false
        showBottomSheet.value = R.layout.save_card_nudge_bottomsheet
    }

    internal fun updateEmiOptionForSavedCard(shouldSavedCard: Boolean) {
        selectedEmiOption?.shouldSaveCard = shouldSavedCard
    }

    internal fun updateEmiListOnRemoveOffer() {
        calculateEmi(isAutoApplyOffer = false, includeValidateOfferRequest = false)
    }

    internal fun updateOfferTextValue(isOfferValid: Boolean) {
        cardOffer.value = if (InternalConfig.selectedOfferInfo != null) {
            if (isOfferValid) {
                offerTextColor.value = R.color.payu_color_36b37e
                applicationContext.getString(R.string.payu_offer_applied)
            } else {
                offerTextColor.value = R.color.payu_color_808080
                null
            }
        } else null
    }

    fun calculateEmi(
        includeValidateOfferRequest: Boolean = true,
        emiCodes: ArrayList<String>? = getEmiCodes(),
        isAutoApplyOffer: Boolean? = null
    ){
        val offerList = arrayListOf<String>()
        InternalConfig.userSelectedOfferInfo?.let {
            offerList.add(it.offerKey ?: "")
        }
        val amount =
            SdkUiInitializer.apiLayer?.payUPaymentParams?.amount?.toDoubleOrNull() ?: 0.0
        val calculateEmiRequest =
            emiCodes?.let { it1 ->
                CalculateEmiRequest(
                    emiCodes = it1,
                    txnAmount = amount,
                    offerKeys = offerList,
                    includeOfferRequest = includeValidateOfferRequest
                ).apply { if(isAutoApplyOffer != null) autoApplyOffer = isAutoApplyOffer }
            }
        calculateEmi.value = calculateEmiRequest
    }

}