package com.payu.ui.viewmodel

import android.app.Application
import androidx.lifecycle.ViewModel
import androidx.lifecycle.ViewModelProvider
import androidx.lifecycle.ViewModelStore
import kotlin.reflect.KClass

class BaseViewModelFactory(
    private val mApplication: Application,
    private val mParam: Map<String, Any>
) : ViewModelProvider.AndroidViewModelFactory(mApplication) {

    override fun <T : ViewModel> create(modelClass: Class<T>): T {

        when {
            modelClass.isAssignableFrom(PaymentOptionViewModel::class.java) -> {
                return PaymentOptionViewModel(mApplication) as T
            }
            modelClass.isAssignableFrom(SavedCardsViewModel::class.java) -> {
                return SavedCardsViewModel(mApplication, mParam) as T
            }
            modelClass.isAssignableFrom(WalletViewModel::class.java) -> {
                return WalletViewModel(mApplication, mParam) as T
            }
            modelClass.isAssignableFrom(BankViewModel::class.java) -> {
                return BankViewModel(mApplication, mParam) as T
            }
            modelClass.isAssignableFrom(AddNewCardViewModel::class.java) -> {
                return AddNewCardViewModel(mApplication) as T
            }
            modelClass.isAssignableFrom(NBDetailsViewModel::class.java) -> {
                return NBDetailsViewModel(mApplication, mParam) as T
            }
            modelClass.isAssignableFrom(EmiViewModel::class.java) -> {
                return EmiViewModel(mApplication, mParam) as T
            }
            modelClass.isAssignableFrom(CommonViewModel::class.java) -> {
                return CommonViewModel(mApplication) as T
            }
            modelClass.isAssignableFrom(QuickPayViewModel::class.java) -> {
                return QuickPayViewModel(mApplication) as T
            }
            modelClass.isAssignableFrom(SavedOptionsViewModel::class.java) -> {
                return SavedOptionsViewModel(mApplication, mParam) as T
            }
            else -> throw IllegalArgumentException("Unknown ViewModel class")
        }

    }

}