package com.payu.ui.viewmodel

import android.app.Application
import android.os.CountDownTimer
import android.os.Handler
import androidx.lifecycle.AndroidViewModel
import androidx.lifecycle.MutableLiveData
import com.payu.base.listeners.OnValidateOfferListener
import com.payu.base.models.ErrorResponse
import com.payu.base.models.InternalConfig
import com.payu.base.models.OfferInfo
import com.payu.base.models.PaymentOption
import com.payu.base.models.SavedCardOption
import com.payu.base.models.SelectedOfferInfo
import com.payu.base.models.SodexoCardOption
import com.payu.ui.R
import com.payu.ui.SdkUiInitializer
import com.payu.ui.model.managers.CFManager
import com.payu.ui.model.managers.OfferFilterManager
import com.payu.ui.model.models.FragmentModel
import com.payu.ui.model.models.SnackBarModel
import com.payu.ui.model.utils.SdkUiConstants
import com.payu.ui.model.utils.Utils
import com.payu.ui.model.utils.ViewUtils
import java.util.Locale
import kotlin.collections.contains

open class BaseViewModel(internal val application: Application) :
    AndroidViewModel(application),
    OnValidateOfferListener {

    internal var showOfferApplied: MutableLiveData<Event<Boolean>> = MutableLiveData()
    internal var showOfferAppliedDialog: MutableLiveData<Event<Boolean>> = MutableLiveData()
    internal var showProgressDialog: MutableLiveData<Boolean> = MutableLiveData()
    internal var showAndroidLoader: MutableLiveData<Event<Boolean>> = MutableLiveData()
    internal var selectedPaymentOption: PaymentOption? = null
    internal var showOfferError: MutableLiveData<Pair<Event<Boolean>, String?>> = MutableLiveData()
    internal var showErrorWithSnackBar: MutableLiveData<Pair<Event<Boolean>, String?>> =
        MutableLiveData()
    internal val showOfferAppliedTag: MutableLiveData<Event<Boolean>> = MutableLiveData()
    internal var loadFragment: MutableLiveData<FragmentModel> = MutableLiveData()
    internal val flowComplete: MutableLiveData<Boolean> = MutableLiveData()
    internal var apiError: MutableLiveData<ErrorResponse> = MutableLiveData()
    internal val popBackStack: MutableLiveData<Boolean> = MutableLiveData()
    internal val showTpvTiles: MutableLiveData<Boolean> = MutableLiveData()
    internal val showBottomSheetDialog = MutableLiveData<Boolean>()
    val showSnackBar: MutableLiveData<SnackBarModel> = MutableLiveData()
    val hideSoftKeyboard: MutableLiveData<Boolean> = MutableLiveData()
    val hideBottomSheet: MutableLiveData<Boolean> = MutableLiveData()

    override fun onValidateOfferResponse(selectedOfferInfo: SelectedOfferInfo?) {
        updateValidateOfferResponse(selectedOfferInfo)
    }

    private fun updateSelectedOfferInfo(
        selectedOfferInfo: SelectedOfferInfo,
        offerList: ArrayList<OfferInfo>
    ) {
        for (fetchOfferInfo in offerList) {
            selectedOfferInfo.offerMap?.get(fetchOfferInfo.offerKey)?.let {
                selectedOfferInfo.offerMap?.put(fetchOfferInfo.offerKey.toString(), fetchOfferInfo)
            }
        }
    }

    internal open fun removeOffer(isAutoApply: Boolean) {
        showOfferApplied.value = Event(!isAutoApply)
    }

    internal fun showOfferError(){
        InternalConfig.userSelectedOfferInfo = null
        showOfferError.value = Pair(
            Event(true),
            application.applicationContext?.getString(R.string.payu_offer_not_applicable_in_payment))
    }

    internal fun getLoggedInPhoneNumber(): String?{
        var loggedInPhoneNumber: String? = null
        val gvTokenAndNumber = Utils.getGlobalVaultStoredUserToken(application.applicationContext)

        if(gvTokenAndNumber.first.isNullOrEmpty().not() && gvTokenAndNumber.second.isNullOrEmpty().not())
            loggedInPhoneNumber = gvTokenAndNumber.second

        return loggedInPhoneNumber
    }

    internal fun shouldCallValidateOfferApi(): Boolean = ((OfferFilterManager.isAtleastOneOfferPresentForTheCurrentPaymentType() || InternalConfig.userSelectedOfferInfo != null) && InternalConfig.isOfferEnabled)

    internal fun updateValidateOfferResponse(selectedOfferInfo: SelectedOfferInfo?) {
        InternalConfig.userSelectedOfferInfo?.let {
            val skuId = it.sku?.skuId ?: ""
            if (selectedOfferInfo?.offerMap?.get(it.offerKey.toString() + skuId) != null)
                selectedOfferInfo.offerMap?.put((it.offerKey.toString() + skuId), it)
        }
        InternalConfig.selectedOfferInfo = selectedOfferInfo
        if (selectedOfferInfo?.isValid == true) {
            showOfferApplied.value = Event(true)
            showOfferAppliedDialog.value = Event(true)
            showOfferAppliedTag.value = Event(true)

        } else {
            InternalConfig.userSelectedOfferInfo?.let {
                showOfferAppliedDialog.value = Event(false)
                showOfferError.value =
                    Pair(Event(true), InternalConfig.selectedOfferInfo?.failureReason)
                showOfferApplied.value = Event(false)
                showOfferAppliedTag.value = Event(false)
            }

        }

        Handler().postDelayed({
            showAndroidLoader.value = Event(false)
        }, 1000)
    }

    fun makePaymentApiCall(paymentOption: PaymentOption) {
        hideSoftKeyboard.value = true
        hideBottomSheet.value = true
        val additionalCharge =
            if (paymentOption is SavedCardOption || paymentOption is SodexoCardOption) paymentOption.cardBinInfo?.additionalCharge else paymentOption.additionalCharge
        SdkUiInitializer.apiLayer?.updatePaymentState(
            Utils.getPaymentModel(
                paymentOption, null
            ),
            ViewUtils.getToolbar(
                application,
                additionalCharge
            )
        )
    }

    fun shouldCallOnDemandCFandOfferApi(paymentType: String?): Boolean {
        return shouldCallValidateOfferApi() || shouldCallCFapiForCFDetails(paymentType)
    }

    fun shouldCallCFapiForCFDetails(paymentType: String?): Boolean {
        paymentType ?: return false
        val isOfferSelected = InternalConfig.userSelectedOfferInfo != null

        if(isOfferSelected){
            return true
        }

        val isAdditionalChargesPassedByMerchant =
            (SdkUiInitializer.apiLayer?.payUPaymentParams?.additionalCharges != null && SdkUiInitializer.apiLayer?.payUPaymentParams?.additionalCharges?.contains(
                paymentType
            ) == true) || (SdkUiInitializer.apiLayer?.payUPaymentParams?.percentageAdditionalCharges != null && SdkUiInitializer.apiLayer?.payUPaymentParams?.percentageAdditionalCharges?.contains(
                paymentType
            ) == true)

        if(isAdditionalChargesPassedByMerchant)
            return true

        val cfPaymentType = CFManager.getPaymentModeNameForCF(paymentType)

        return (InternalConfig.pricingEnabledModes?.contains(cfPaymentType) == true)
    }


    override fun onCleared() {
        super.onCleared()
        loadFragment.value = null
    }

}