package com.payu.ui.viewmodel

import android.app.Application
import android.view.View
import androidx.lifecycle.MutableLiveData
import com.payu.base.listeners.OnLookupApiListener
import com.payu.base.models.BinBaseDetails
import com.payu.base.models.CardBinInfo
import com.payu.base.models.CardOption
import com.payu.base.models.CardScheme
import com.payu.base.models.CardType
import com.payu.base.models.EMIOption
import com.payu.base.models.ErrorResponse
import com.payu.base.models.InternalConfig
import com.payu.base.models.PayUSIParams
import com.payu.base.models.PaymentFlowState
import com.payu.base.models.PaymentState
import com.payu.base.models.PaymentType
import com.payu.base.models.SodexoCardOption
import com.payu.base.models.calculateEmi.CalculateEmiRequest
import com.payu.ui.R
import com.payu.ui.SdkUiInitializer
import com.payu.ui.model.utils.AnalyticsUtils
import com.payu.ui.model.utils.SdkUiConstants
import com.payu.ui.model.utils.Utils
import com.payu.ui.model.utils.ViewUtils

open class AddNewCardViewModel(application: Application) :
    CardBaseViewModel(application, null) {

    var cardSchemeIcon: MutableLiveData<Int?> = MutableLiveData()
    var cvvLength: MutableLiveData<Int?> = MutableLiveData()
    var cardType: MutableLiveData<CardType?> = MutableLiveData()
    var cardBinBankDownStatus: MutableLiveData<Boolean?> = MutableLiveData()
    var clearExpiry: MutableLiveData<Boolean> = MutableLiveData()
    var showNameOnCardView: MutableLiveData<Boolean> = MutableLiveData()
    var highlightCardName: MutableLiveData<Boolean> = MutableLiveData()
    var isNameOnCardValid: Boolean = false
    var cardOption: CardOption = CardOption()
    var sodexoCardOption: SodexoCardOption = SodexoCardOption()
    var offerText: String? = null
    var isOfferSelected: Boolean = false
    var isSISupported: Boolean = true
    var isCardTypeEnforced: Boolean = true
    var cardErrorMessage: String? = null
    var isBankDown: Boolean = false
    var cardCategory: MutableLiveData<String?> = MutableLiveData()
    val isSIMode: MutableLiveData<Boolean> = MutableLiveData()
    internal var initiatedAddCardFor: String = ""
    var isBinInfoResponseRecieved: Boolean = false
    var isErrorResponseRecived: Boolean = true
    val showCardNoGV: MutableLiveData<Boolean> = MutableLiveData()
    val showEmiLayoutSwitch: MutableLiveData<Boolean> = MutableLiveData()
    var showPayButtonLoader: MutableLiveData<Event<Boolean>> = MutableLiveData()

    init {
        showEmiTenureLayout.value = false
        cardNumberLabel.value = applicationContext.getString(R.string.payu_card_number)
        showConsent()
    }

    fun initiatedFor(initiatedFor: String) {
        initiatedAddCardFor = initiatedFor
        if (initiatedAddCardFor.isNotEmpty() && initiatedAddCardFor == SdkUiConstants.SODEXO) {
            showNameOnCardView.value = true
            siHeaderSummary.value = Utils.getCustomeNoteDetails(
                PaymentType.SODEXO,
                SdkUiInitializer.apiLayer?.config?.customNoteDetails
            )
        } else if (initiatedAddCardFor.isNotEmpty() && initiatedAddCardFor == SdkUiConstants.GLOBAL_VAULT) {
            showCardNoGV.value = true
            siHeaderSummary.value = Utils.getCustomeNoteDetails(
                PaymentType.CARD,
                SdkUiInitializer.apiLayer?.config?.customNoteDetails
            )
        } else {
            showCardNoGV.value = false
            siHeaderSummary.value = Utils.getCustomeNoteDetails(
                PaymentType.CARD,
                SdkUiInitializer.apiLayer?.config?.customNoteDetails
            )

        }

    }

    var nameOnCard = ""
        set(value) {
            field = value
            validateNameOnCard(value)
        }

    var mobileNumber = ""
        set(value) {
            field = value
            validateMobileNumber(value)
        }


    private fun validateNameOnCard(value: String) {
        isNameOnCardValid = Utils.isValidNameOnCard(value)
        validatePaymentStatus()
    }

    private fun validateMobileNumber(mobileNumber: String) {
        val number = mobileNumber.trim()
        isValidMobileNumber = number.isNotEmpty() && Utils.isValidPhoneNumber(number)
        validatePaymentStatus()
    }

    fun clearBinAndFetchBin(){
        fetchedCardBin = null
        isCardNumberChanged = true
        validateCardNumber()
    }

    /**
     * Validate Expiry
     */


    /**
     * Validate Card Number
     */
    override fun validateCardNumber() {
        val inputValue = cardNumber.replace(cardSeparator, "", true)
        if (inputValue.isNotEmpty())
            checkCardBinSupported(inputValue)
        else
            cardError.value = null
        if (inputValue.length > 5) {
            if (!inputValue.take(6).equals(fetchedCardBin)) {
                fetchedCardBin = inputValue.take(6)
                isErrorResponseRecived = true
            } else if (!isCardSchemeAllowed(cardScheme.value))
                showCardSchemeError(cardScheme.value)
            if (!cardErrorMessage.isNullOrEmpty() && !isCardTypeEnforced && initiatedAddCardFor != SdkUiConstants.CP_EMI) cardError.value =
                cardErrorMessage
        } else {
            showEmiLayoutSwitch.value = false
            isCardNumberValid = false
            isCardTypeEnforced = true
            if (initiatedAddCardFor != SdkUiConstants.SODEXO) {
                isBinInfoResponseRecieved = false
                isErrorResponseRecived = true
            }
            cardErrorMessage = null
            if (Utils.isAmexCard(inputValue)) {
                fetchedCardBin = inputValue
                setCardSchemeData(CardBinInfo().apply { cardScheme = CardScheme.AMEX })
            } else {
                fetchedCardBin = null
                cardOffer.value = null
                isBankDown = false
                cardError.value = null
                setCardSchemeData(null)
            }
        }

        verifyCardNumberValid()
    }

    override fun verifyCardNumberValid() {
        val inputValue = cardNumber.replace(cardSeparator, "", true)
        if (Utils.isValidNumberFormat(inputValue) && Utils.isValidCardLength(
                cardScheme.value,
                inputValue.length
            )
        ) {
            if (!Utils.luhn(inputValue) || !isCardTypeEnforced || !isCardBinSupported || (!isSISupported)) {
                isCardNumberValid = false
                if (InternalConfig.selectedOfferInfo?.isAutoApply == true)
                    showOfferApplied.value = Event(false)
                if (cardError.value.isNullOrEmpty())
                    cardOffer.value = null
                InternalConfig.isPaymentOptionSelected = false
                fetchedCardBin = null
                cardOffer.value = null
                isBankDown = false
                cardError.value = null
                setCardSchemeData(null)
                //showCardError()
            } else {
                updateCardNumberFocusView()
                isCardNumberValid = true
                fetchBinBaseDetails()
                InternalConfig.isPaymentOptionSelected = true
                if (cardOffer.value == null)
                    cardError.value = null
            }
        } else {
            if (InternalConfig.selectedOfferInfo?.isAutoApply == true)
                showOfferApplied.value = Event(false)
            isCardNumberValid = false
            InternalConfig.isPaymentOptionSelected = false
            fetchedCardBin = null
            cardOffer.value = null
            isBankDown = false
            cardError.value = null
            setCardSchemeData(null)
        }
        if (cardError.value.isNullOrEmpty()) {
            cardOffer.value = null
            cardBinBankDownStatus.value = isBankDown

        }
        validatePaymentStatus()
    }

    internal fun isCardSchemeAllowed(cardScheme: CardScheme?): Boolean {
        cardScheme?.let {
            return if (it == CardScheme.SODEXO
                && initiatedAddCardFor == SdkUiConstants.SODEXO
            ) true
            else it != CardScheme.SODEXO
                    && initiatedAddCardFor != SdkUiConstants.SODEXO
        }
        return false
    }

    internal fun showCardSchemeError(cardScheme: CardScheme?) {
        isCardNumberValid = false
        if (cardScheme == CardScheme.SODEXO
            && initiatedAddCardFor != SdkUiConstants.SODEXO
        ) {
            cardError.value =
                applicationContext.getString(R.string.payu_card_not_supported_error_for_ccdc)
        } else if (cardScheme != CardScheme.SODEXO
            && initiatedAddCardFor == SdkUiConstants.SODEXO
        ) {
            cardError.value =
                applicationContext.getString(R.string.payu_card_not_supported_for_sodexo_payments)
        }
    }

    fun callLookupApi() {
        SdkUiInitializer.apiLayer?.callLookupApi(cardOption, object : OnLookupApiListener {
            override fun onLookupApiCalled() {
            }

            override fun onError(errorResponse: ErrorResponse) {
//                AnalyticsUtils.logErrorOccurredEvent(applicationContext, errorResponse.errorMessage)
            }

            override fun showProgressDialog(showDialog: Boolean) {
                showProgressDialog.value = showDialog
            }
        })
    }


    fun updateCardNumberFocusView() {
        if (isCardNumberFocused) {
            highlightCardNumber.value = true
        } else {
            cardError.value = null
        }
    }


    override fun onError(errorResponse: ErrorResponse) {
//        AnalyticsUtils.logErrorOccurredEvent(applicationContext, errorResponse.errorMessage)

    }

    override fun showProgressDialog(showDialog: Boolean) {
    }

    private fun validatePaymentStatus() {
        isReadyToPay.value =
            isValidCVV() && isValidCardNumber() && isValidExpiry() && isEmiSelected() && isValidNameOnCard() && !(isBankDown) && isBinInfoResponseRecieved && !isErrorResponseRecived
    }

    fun isValidPhoneNumber(): Boolean = isValidMobileNumber

    fun isValidNameOnCard(): Boolean =
        if (showNameOnCardView.value != null && showNameOnCardView.value!!) isNameOnCardValid else true

     private fun onCardBinInfoResponse(cardBinInfo: CardBinInfo?) {
        val inputValue = cardNumber.replace(cardSeparator.toString(), "", true)
        cardOption.cardBinInfo = cardBinInfo
        cardOption.bankCode = cardBinInfo?.bankCode
        sodexoCardOption.cardBinInfo = cardBinInfo
        val siParams = getSIParams()
        if (siParams != null) {
            if (cardBinInfo == null || !cardBinInfo.isSiSupported) {
                isSISupported = false
                cardError.value =
                    applicationContext.getString(R.string.payu_card_not_supported_error)
            } else isSISupported = true
        }
        if (cardBinInfo != null && inputValue.length >= 6) {
            isBinInfoResponseRecieved = true
            fetchedCardBin = inputValue.take(6)
            cardBinInfo.binNumber = fetchedCardBin
//            if (!cardBinInfo.isDomestic) callLookupApi()
            setCardSchemeData(cardBinInfo)
            if (!isCardSchemeAllowed(cardScheme.value))
                showCardSchemeError(cardScheme.value)
            else {
                if (cardBinInfo.message != null && initiatedAddCardFor != SdkUiConstants.CP_EMI) {
                    isCardNumberValid = false
                    cardErrorMessage = cardBinInfo.message
                    cardError.value = cardBinInfo.message
                    isCardTypeEnforced = false
                    isErrorResponseRecived = true
                } else {
                    isCardTypeEnforced = true
                    cardErrorMessage = null
                    isErrorResponseRecived = false
                }
            }
            if (cardBinInfo.emiOption != null && initiatedAddCardFor == SdkUiConstants.CP_CARDS) {
                val eligibleList =
                    Utils.getEligibleEmiTenuresList(cardBinInfo.emiOption?.optionList)
                if (!eligibleList.isNullOrEmpty()) {
                    //TODO will undo change to true when offer support is given
                    showEmiLayoutSwitch.value = !Utils.isSiTxn()
                    resetSelectedTenurePosition.value = true
                    emiTenureList = ArrayList()
                    eligibleList.forEach {
                        val emiOption = (it as? EMIOption)?.clone() as? EMIOption
                        emiOption?.let { it1 ->
                            emiDefaultList.add(
                                it1
                            )
                        }
                        emiOption?.let { it1 ->
                            emiTenureList?.add(
                                it1
                            )
                        }
                    }
                    updateEmiList.value = eligibleList
                    showEmiInterestText.value = false
                }
            } else {
                showEmiLayoutSwitch.value = false
            }
        } else {
            cardBinInfo?.emiOption = null
            fetchedCardBin = null
            if (initiatedAddCardFor != SdkUiConstants.SODEXO) {
                isBinInfoResponseRecieved = false
                isErrorResponseRecived = true
            }
            isCardNumberValid = false
            setCardSchemeData(null)
        }
         validatePaymentStatus()
    }

    override fun setCardSchemeData(binInfo: CardBinInfo?) {
        cardOption.cardBinInfo = binInfo
        cardScheme.value = binInfo?.cardScheme
        cardSchemeIcon.value = Utils.getCardIconId(binInfo?.cardScheme)
        cvvLength.value = Utils.getCvvInputLength(binInfo?.cardScheme)
        if (initiatedAddCardFor == SdkUiConstants.CP_CARDS)
            showNameOnCardView.value = (binInfo != null && !binInfo.isDomestic)

        if (showEmiTenureLayout.value == false) {
            cardBinAdditionalCharge.value = binInfo?.additionalCharge
            cardBinGstAmount.value = Pair(binInfo?.gstPercentageValue, binInfo?.gstFlatValue)
        }
        cardBinBankDownStatus.value = binInfo?.isBankDown
        cardType.value = binInfo?.cardType
        cardCategory.value = binInfo?.cardCategory
        if (cvv.isNotEmpty()) {
            isCVVValid = (cvv.isNotEmpty() && Utils.isValidCvvLength(cardScheme.value, cvv.length))
                    || (cvv.isEmpty() && Utils.isCvvLessCard(cardScheme.value))
            if (isCVVValid)
                cvvError.value = null
            else
                cvvError.value = applicationContext.getString(R.string.payu_cvv_error)

            validatePaymentStatus()
        }
        //   cardBinGstAmount.value = binInfo?.gstAmount
        if (initiatedAddCardFor != SdkUiConstants.SODEXO)
            isErrorResponseRecived = true
    }

    fun updateCardNameFocusView(hasFocus: Boolean) {
        highlightCardName.value = hasFocus
    }

    fun makePayment() {
        showPayButtonLoader.value = Event(true)
        if (cardScheme.value == CardScheme.SODEXO) {
            setSodexoCardOptions(sodexoCardOption)
            AnalyticsUtils.logSaveCard(applicationContext, "L3 ${SdkUiConstants.SODEXO}")
            AnalyticsUtils.logMakePaymentEvent(
                applicationContext.applicationContext,
                sodexoCardOption
            )

        } else {
            setCardOptions(cardOption)
        }
        AnalyticsUtils.logSaveCard(applicationContext, "L3 ${SdkUiConstants.CP_CARDS}")
        AnalyticsUtils.logMakePaymentEvent(applicationContext.applicationContext, cardOption)
        val payUSIParams = getSIParams()

        if (payUSIParams != null) {
            payUSIParams.ccCategory = cardOption.cardBinInfo?.cardType?.name
            payUSIParams.ccCardType = cardOption.cardBinInfo?.cardCategory
        }
        if (isEmiTxn) {
            selectedEmiOption?.let {
                it.cardNumber = cardOption.cardNumber
                it.cardBinInfo = cardOption.cardBinInfo
                it.cvv = cardOption.cvv
                it.expiryMonth = cardOption.expiryMonth
                it.expiryYear = cardOption.expiryYear
                val paymentFlowState = PaymentFlowState()
                paymentFlowState.paymentState = PaymentState.CardTenureEligibility
                SdkUiInitializer.apiLayer?.updatePaymentState(
                    Utils.getPaymentModel(it, paymentFlowState),
                    ViewUtils.getToolbar(
                        applicationContext,
                        it.additionalCharge
                    )
                )
            }
        } else {
            if (cardScheme.value == CardScheme.SODEXO) {
                apiLayerMakePayment(sodexoCardOption)
            } else {
                apiLayerMakePayment(cardOption)
            }
        }
    }

    private fun apiLayerMakePayment(cardOption: CardOption) {
        if (!InternalConfig.selectedOfferInfo?.offerMap.isNullOrEmpty()) {
            for (offerKey in InternalConfig.selectedOfferInfo?.offerMap?.keys!!) {
                if (InternalConfig.selectedOfferInfo?.offerMap?.size!! > 1)
                    cardOption.offerKey = "$offerKey,"
                else cardOption.offerKey = offerKey
            }
        }
        SdkUiInitializer.apiLayer?.updatePaymentState(
            Utils.getPaymentModel(cardOption, null),
            ViewUtils.getToolbar(
                applicationContext,
                cardBinAdditionalCharge.value
            )
        )
    }

    fun setCardOptions(cardOption: CardOption) {
        cardOption.expiryMonth = cardMonth
        cardOption.expiryYear = cardYear
        cardOption.cardNumber = cardNumber.replace(cardSeparator, "", true)
        cardOption.cvv = cvv
        cardOption.paymentType = PaymentType.CARD
        cardOption.cardBinInfo?.additionalCharge = cardBinAdditionalCharge.value
    }

    fun setSodexoCardOptions(sodexoCardOption: SodexoCardOption) {
        sodexoCardOption.isNewCard = true
        sodexoCardOption.expiryMonth = cardMonth
        sodexoCardOption.expiryYear = cardYear
        sodexoCardOption.cardNumber = cardNumber.replace(cardSeparator, "", true)
        sodexoCardOption.cvv = cvv
        sodexoCardOption.paymentType = PaymentType.SODEXO
        sodexoCardOption.cardBinInfo?.additionalCharge = cardBinAdditionalCharge.value
    }


    fun getSIParams(): PayUSIParams? {
        return SdkUiInitializer.apiLayer?.payUPaymentParams?.payUSIParams
    }

    fun showConsent() {
        val payUSIParams = getSIParams()
        isSIMode.value = payUSIParams != null
    }

    fun requestFocusOnOfferApplied(view: View) {
        if (!isCardNumberValid)
            view.requestFocus()
    }

    fun showEmiTenure(isChecked: Boolean) {
        InternalConfig.isPaymentOptionSelected = false
        isEmiTenureSelected = false
        showEmiTenureLayout.value = isChecked
        selectedTenure.value = applicationContext.getString(R.string.payu_select_installment)
        tenureInterest.value = null
        isEmiTxn = isChecked
        selectedEmiOption = null
        showOfferApplied.value = Event(false)
        showNoCostTag.value = false
        showCashBackTenureText.value = null
        isEmiCalculated = false
        if (isChecked) {
            updateEmiList.value = emiTenureList
            calculateEmi()
        } else {
            showEmiSummary.value = null
            emiFeeSummary.value = null
            // check if this is required as we have moved to bin based details api for offers validation
            validateOffer()
        }
        validatePaymentStatus()
        InternalConfig.interestCharged = null
    }

    /**
     * Validate Expiry
     */
    override fun validateExpiry() {
        validExpiry()
        validatePaymentStatus()

    }

    override fun validateCvv() {
        if (!isExpiryValid)
            expiryError.value = applicationContext.getString(R.string.payu_invalid_expiry)
        if (!isCardNumberValid) {
            showCardError()
        }


        isCVVValid = Utils.isValidCvv(cvv, cardScheme.value)
                || (cvv.isEmpty() && Utils.isCvvLessCard(cardScheme.value))

        updateCardCvvFocusView()
        validatePaymentStatus()
    }

    internal fun updateSodexoOption(shouldSaveCard: Boolean) {
        sodexoCardOption.shouldSaveCard = shouldSaveCard
    }

    internal fun validateOffer() {
        if (!Utils.isSiTxn()) {
            if (isEmiTxn) {
                calculateEmi()
            } else {
                isCardNumberChanged = true
                clearBinAndFetchBin()
            }
        }
    }


    internal fun fetchPricingWithoutOffers(){
        cardOption.cardBinInfo?.let {
            if (InternalConfig.pricingEnabledModes?.contains(it.cardType?.name) == true) {
                isCardNumberChanged = true
                isCardOfferRemovedManually = true
                clearBinAndFetchBin()
            }
        }
    }

    override fun handlePayNow(isSaveCardInfoBottomSheet: Boolean) {
        if (!isSaveCardInfoBottomSheet) {
            cardOption.shouldSaveCard = true
            selectedEmiOption?.shouldSaveCard = true
        }
        hideBottomSheet.value = true
    }

    private fun fetchBinBaseDetails() {
        if (isCardNumberValid && isCardNumberChanged) {
            showAndroidLoader.value = Event(true)
            SdkUiInitializer.apiLayer?.fetchBinBaseDetails(
                cardNumber = cardNumber.replace(
                    cardSeparator,
                    "",
                    true
                ), cardToken = null,
                category = null,
                paymentCode = null,
                includeValidateOfferRequest = shouldCallValidateOfferApi() && isCardOfferRemovedManually.not()
            ) { binBaseDetails ->
                isCardOfferRemovedManually = false
                isCardNumberChanged = false
                showAndroidLoader.value = Event(false)
                onCardBinInfoResponse(binBaseDetails?.cardBinInfo)
                cardOption.feeCombinations = binBaseDetails?.feeCombinations
                updateValidateOfferResponse(binBaseDetails?.selectedOfferInfo)
                updateCFinHeaderFromFeeComb.value =  binBaseDetails
            }
        }
    }



}

