package com.payu.ui.view.fragments.olw

import android.app.Dialog
import android.os.Bundle
import android.text.InputFilter
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.view.WindowManager
import android.widget.Button
import android.widget.EditText
import android.widget.ImageView
import android.widget.LinearLayout
import android.widget.ProgressBar
import android.widget.ScrollView
import android.widget.TextView
import androidx.appcompat.content.res.AppCompatResources
import androidx.appcompat.widget.AppCompatImageView
import androidx.core.widget.doOnTextChanged
import androidx.lifecycle.ViewModelProvider
import com.google.android.material.bottomsheet.BottomSheetBehavior
import com.google.android.material.bottomsheet.BottomSheetDialog
import com.google.android.material.bottomsheet.BottomSheetDialogFragment
import com.payu.base.listeners.OnFetchImageListener
import com.payu.base.models.ImageDetails
import com.payu.base.models.ImageParam
import com.payu.base.models.MPinAction
import com.payu.ui.R
import com.payu.ui.SdkUiInitializer
import com.payu.ui.model.models.SetMPinData
import com.payu.ui.model.utils.AnalyticsUtils
import com.payu.ui.model.utils.ImageViewUtils
import com.payu.ui.model.utils.SdkUiConstants
import com.payu.ui.model.utils.Utils
import com.payu.ui.model.utils.ViewUtils
import com.payu.ui.model.utils.ViewUtils.setPayUDialogSettings
import com.payu.ui.viewmodel.OLWViewModel
import com.payu.ui.viewmodel.PaymentOptionViewModel
import org.json.JSONObject


class SetMPinFragment : BottomSheetDialogFragment(),  View.OnFocusChangeListener {

    override fun getTheme(): Int = R.style.PayU_BottomSheetDialogTheme
    override fun onCreateDialog(savedInstanceState: Bundle?): Dialog {
        val dialog =
            BottomSheetDialog(requireContext(), theme)
        dialog.setOnShowListener {
            val bottomSheet = dialog.findViewById<View>(com.google.android.material.R.id.design_bottom_sheet)
            bottomSheet?.let {
                BottomSheetBehavior.from(it).state = BottomSheetBehavior.STATE_EXPANDED
            }
            dialog.window?.setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_ADJUST_RESIZE)
        }
        return dialog;
    }

    private var viewModel: PaymentOptionViewModel? = null

    private var setMPinData: SetMPinData? = null

    private var primaryBtn: Button? = null
    private var headerIcon: ImageView? = null
    private var ivCloseIcon: ImageView? = null

    private var tvHeader: TextView? = null
    private var tvSubHeader: TextView? = null
    private var tvStep1Header: TextView? = null

    private var tvReAction: TextView? = null

    private var etOtp: EditText? = null

    private var tvSubTitle1: TextView? = null
    private var tvSubTitle2: TextView? = null
    private var tvReEnterMPinHeader: TextView? = null
    private var etSetMPin: EditText? = null
    private var etConfirmMPin: EditText? = null

    private var etError: TextView? = null
    private var etEnterMPinError: TextView? = null
    private var etReEnterMPinError: TextView? = null
    private var llProgressScreen: LinearLayout? = null
    private var viewHandle: View ? = null
    private var scrollView: ScrollView? = null
    private var llActionContainer: LinearLayout? = null
    private var payuloader : AppCompatImageView? = null
    private var pbOtpRead: ProgressBar? = null
    private var tvEnterMpinHeader: TextView? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
    }

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        return inflater.inflate(R.layout.payu_mpin_setup_bottomsheet, container, false)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        initViewModel()
        setMPinData?.let { setUpSetMPinScreen(data = it) }
        initObservers()
    }

    private fun initViewModel() {
        viewModel = activity?.run {
            ViewModelProvider(this)[PaymentOptionViewModel::class.java]
        } ?: throw Exception("Invalid Activity")
    }

    private fun setUpSetMPinScreen(data: SetMPinData) {
        headerIcon = view?.findViewById(R.id.ivHeaderIcon)
        ivCloseIcon = view?.findViewById(R.id.ivCloseIcon)
        tvHeader = view?.findViewById(R.id.tvHeader)
        tvSubHeader = view?.findViewById(R.id.tvSubHeader)
        tvStep1Header = view?.findViewById(R.id.tvEnterOtp)
        tvSubTitle1 = view?.findViewById(R.id.tvSubtitle1)
        tvSubTitle2 = view?.findViewById(R.id.tvSubtitle2)
        etOtp = view?.findViewById(R.id.etOtpField)
        etError = view?.findViewById(R.id.etError)
        etEnterMPinError = view?.findViewById(R.id.etSetMpinError)
        etReEnterMPinError = view?.findViewById(R.id.etReEnterMpinError)

        tvReAction = view?.findViewById(R.id.tvReAction)
        etSetMPin = view?.findViewById(R.id.etEnterMpin)
        tvReEnterMPinHeader = view?.findViewById(R.id.tvReEnterMpinHeader)
        etConfirmMPin = view?.findViewById(R.id.etReEnterMpin)
        primaryBtn = view?.findViewById(R.id.btnAction)
        llProgressScreen = view?.findViewById(R.id.llProgressScreen)
        viewHandle = view?.findViewById(R.id.viewHandle)
        scrollView = view?.findViewById(R.id.scrollView)
        llActionContainer = view?.findViewById(R.id.llActionContainer)
        payuloader = view?.findViewById(R.id.payu_loader)
        tvEnterMpinHeader = view?.findViewById(R.id.tvEnterMpinHeader)
        etOtp?.onFocusChangeListener = this
        etSetMPin?.onFocusChangeListener = this
        etConfirmMPin?.onFocusChangeListener = this
        ViewUtils.updateBackgroundColor(
            requireContext(),
            primaryBtn,
            SdkUiInitializer.apiLayer?.config?.primaryColor,
            R.color.one_payu_colorPrimary
        )
        ViewUtils.updateBackgroundColor(
            requireActivity(),
            pbOtpRead,
            SdkUiInitializer.apiLayer?.config?.primaryColor,
            R.color.one_payu_colorPrimary
        )
        ViewUtils.disableView(primaryBtn)

        if (data.setMPinAction == MPinAction.TOKENEXPIRED) {
            tvReEnterMPinHeader?.visibility = View.GONE
            etConfirmMPin?.visibility = View.GONE
        }

        val param = ImageParam(
            data.paymentOption,
            false,
            Utils.getDefaultDrawable(data.paymentOption.paymentType)
        )
        SdkUiInitializer.apiLayer?.getImageForPaymentOption(
            param,
            onFetchImageListener = object : OnFetchImageListener {
                override fun onImageGenerated(result: ImageDetails) {
                    ImageViewUtils.setImage(headerIcon, result)
                }
            })
        tvHeader?.text = data.bankName

        tvStep1Header?.text =
            getString(R.string.payu_enter_otp)
        tvSubTitle2?.text = Utils.getFormattedAmount(setMPinData?.currentBalance, requireContext())
        etOtp?.filters = arrayOf(InputFilter.LengthFilter(data.otpLength))
        etSetMPin?.filters = arrayOf(InputFilter.LengthFilter(data.mPinLength))
        etConfirmMPin?.filters = arrayOf(InputFilter.LengthFilter(data.mPinLength))
        tvReAction?.text = data.reActionText
        primaryBtn?.text = data.actionText
        tvEnterMpinHeader?.text = data.setMPinText

        etOtp?.doOnTextChanged { text, start, before, count ->
            etError?.text = ""
            etError?.visibility = View.GONE
            validateFields()
        }

        etSetMPin?.doOnTextChanged { text, start, before, count ->
            etEnterMPinError?.text = ""
            etEnterMPinError?.visibility = View.GONE
            validateFields()
        }

        etConfirmMPin?.doOnTextChanged { text, start, before, count ->
            etReEnterMPinError?.text = ""
            etReEnterMPinError?.visibility = View.GONE
            validateFields()
        }

        if (setMPinData?.setMPinAction == MPinAction.TOKENEXPIRED) {
            data.subHeader?.let {
                tvSubHeader?.visibility = View.VISIBLE
                tvSubHeader?.text = it
            }
        } else {
            tvSubHeader?.visibility = View.GONE
        }

        primaryBtn?.setOnClickListener {
            ViewUtils.hideSoftKeyboard(requireView())

            if (setMPinData?.setMPinAction == MPinAction.TOKENEXPIRED)
                viewModel?.makeOlwPayment(
                    mPin = etSetMPin?.text?.toString(),
                    otp = etOtp?.text?.toString(),
                    token = setMPinData?.paymentOption?.token
                )
            else
                viewModel?.setMPIn(
                    etOtp?.text?.toString() ?: "",
                    etSetMPin?.text?.toString() ?: "",
                    data.mobileNumber,
                    getActionValue(setMPinData?.setMPinAction),
                    olwPaymentOption = data.paymentOption,
                    postSuccessNavigation = data.postSuccessNavigation,
                    postFailureNavigation = {
                        newInstance(setMPinData = data)
                    },
                    onResponseCallBack = { dismiss() }
                )
        }

        tvReAction?.setOnClickListener {
            AnalyticsUtils.logKibanaInfoEvent(
                context = requireContext(),
                eventKey = SdkUiConstants.CP_OLW_RESEND_MPIN_OTP_CLICKED,
                eventValue = JSONObject().apply {
                    put(SdkUiConstants.CP_KEY_WALLET_NAME, data.paymentOption.bankName)
                    put(SdkUiConstants.CP_KEY_MOBILE, viewModel?.getLoggedInPhoneNumber())
                    put(SdkUiConstants.CP_KEY_FLOW, data.setMPinAction.name)
                }
            )
            viewModel?.sendOlwOtp(requireContext(), data.paymentOption)
        }

        ivCloseIcon?.setOnClickListener {
            dismiss()
        }

        etOtp?.requestFocus()

        isCancelable = false
    }


    private fun initObservers() {
        viewModel?.resendOtpTimerRemainingTime?.observe(viewLifecycleOwner) {
            tvReAction?.text = getString(R.string.resend_otp_in_sec, it)
        }

        viewModel?.isResendOtpTimerRunning?.observe(viewLifecycleOwner) {
            if (it.not()) {
                ViewUtils.enableView(tvReAction)
                tvReAction?.text = getString(R.string.payu_resend_otp)
            } else
                ViewUtils.disableView(tvReAction)
        }
        viewModel?.showBottomSheetDialog?.observe(viewLifecycleOwner) {
            if (it) {
                showProgressDialog()
            } else {
                hideProgressDialog()
            }
        }

        viewModel?.updateErrorTextForOtpOnSetMPin?.observe(viewLifecycleOwner) {
            if (it.isNullOrBlank().not()) {
                etError?.visibility = View.VISIBLE
                etError?.text = it
            } else {
                etError?.visibility = View.GONE
            }
        }

        viewModel?.updateErrorTextOnSetMPin?.observe(viewLifecycleOwner) {
            if (it.isNullOrBlank().not()) {
                etEnterMPinError?.visibility = View.VISIBLE
                etEnterMPinError?.text = it
            } else {
                etEnterMPinError?.visibility = View.GONE
            }
        }
    }

    companion object {
        @JvmStatic
        fun newInstance(setMPinData: SetMPinData) =
            SetMPinFragment().apply {
                this.setMPinData = setMPinData
            }
    }

    private fun getActionValue(mPinAction: MPinAction?): String {
        return when (mPinAction) {
            MPinAction.SETMPIN -> SdkUiConstants.CP_ACTION_SET
            MPinAction.FORGOTMPIN -> SdkUiConstants.CP_ACTION_FORGOT
            MPinAction.TOKENEXPIRED -> ""
            null -> ""
        }
    }

    private fun validateFields() {
        shouldEnableActionButton()
        validateOtpField()
        validatePinFields()
    }


    private fun validateOtpField(): Boolean{
        etError?.visibility = View.GONE
        val otp = etOtp?.text.toString()
        val otpLength = otp.length

        if(otp.isBlank() || etOtp?.hasFocus() == true)
            return false

        val isOtpValid = otp.isNotBlank() &&
                otpLength >= (setMPinData?.otpLength ?: 0)

        if (!isOtpValid) {
            etError?.visibility = View.VISIBLE
            etError?.text = if (otpLength < (setMPinData?.otpLength ?: 0)) {
                getString(R.string.please_enter_a_valid_otp)
            } else {
                getString(R.string.payu_otp_invalid)
            }
            return false
        }

        etError?.visibility = View.GONE
        return true
    }


    private fun shouldEnableActionButton(){
        val otp = etOtp?.text.toString()
        val mPin = etSetMPin?.text.toString()
        val reEnterMPin = etConfirmMPin?.text.toString()

        // Check all validation conditions
        val isOtpValid = otp.length == setMPinData?.otpLength
        val isMPinValid = mPin.length == setMPinData?.mPinLength
        val isReEnterMPinValid =
            if (setMPinData?.setMPinAction != MPinAction.TOKENEXPIRED) reEnterMPin.length == setMPinData?.mPinLength else true
        val doMPinsMatch = if (setMPinData?.setMPinAction != MPinAction.TOKENEXPIRED) (mPin == reEnterMPin) else isMPinValid

        // Set form validity
        val shouldEnableActionButton =
            isOtpValid && isMPinValid && isReEnterMPinValid && doMPinsMatch

        if (shouldEnableActionButton)
            ViewUtils.enableView(primaryBtn)
        else
            ViewUtils.disableView(primaryBtn)
    }

    private fun validatePinFields() {
        val mPin = etSetMPin?.text.toString()
        val reEnterMPin = etConfirmMPin?.text.toString()

        val isMPinValid = mPin.length == setMPinData?.mPinLength
        val isReEnterMPinValid = reEnterMPin.length == setMPinData?.mPinLength
        val doMPinsMatch = mPin == reEnterMPin

        etEnterMPinError?.visibility = View.GONE
        etReEnterMPinError?.visibility = View.GONE

        if (setMPinData?.setMPinAction == MPinAction.TOKENEXPIRED) {
            if(mPin.isEmpty()){
                return
            }
            if (isMPinValid) {
                etEnterMPinError?.visibility = View.GONE
            } else {
                if (mPin.length < (setMPinData?.mPinLength ?: 4)) {
                    etEnterMPinError?.text =
                        getString(R.string.mpin_should_be_of_length, setMPinData?.mPinLength ?: 4)
                    etEnterMPinError?.visibility = View.VISIBLE
                } else
                    etEnterMPinError?.text = getString(R.string.please_enter_a_valid_mpin)
                etEnterMPinError?.visibility = View.VISIBLE
            }
            return
        }

        if(isMPinValid && isReEnterMPinValid && doMPinsMatch){
            return
        }

        if(mPin.isEmpty() || reEnterMPin.isEmpty()){
            return
        }

        if(mPin.isNotEmpty() && reEnterMPin.isNotEmpty()){
            if(doMPinsMatch.not() || (mPin.length < (setMPinData?.mPinLength ?: 4))) {
                if(mPin.length < (setMPinData?.mPinLength ?: 4)){
                    etEnterMPinError?.text =
                        getString(R.string.mpin_should_be_of_length, setMPinData?.mPinLength ?: 4)
                    etEnterMPinError?.visibility = View.VISIBLE
                    return
                }
                etReEnterMPinError?.text =
                    getString(R.string.mpin_and_re_enter_mpin_is_not_same)
                etReEnterMPinError?.visibility = View.VISIBLE
                return
            }
        }
    }

    private fun showProgressDialog() {
        llProgressScreen?.visibility = View.VISIBLE
        setPayUDialogSettings(payuloader, requireActivity())
        viewHandle?.visibility = View.GONE
        scrollView?.visibility = View.GONE
        llActionContainer?.visibility = View.GONE
    }

    private fun hideProgressDialog() {
        llProgressScreen?.visibility = View.GONE
        viewHandle?.visibility = View.VISIBLE
        scrollView?.visibility = View.VISIBLE
        llActionContainer?.visibility = View.VISIBLE
    }

    override fun onFocusChange(v: View?, hasFocus: Boolean) {
        when (v?.id) {
            R.id.etOtpField -> {
                if (hasFocus) {
                    ViewUtils.updateStrokeColor(
                        requireActivity(),
                        etOtp,
                        SdkUiInitializer.apiLayer?.config?.primaryColor,
                        R.color.one_payu_colorPrimary
                    )
                } else {
                    ViewUtils.updateStrokeColor(requireContext(), etOtp)
                }
            }
            R.id.etEnterMpin -> {
                if (hasFocus) {
                    ViewUtils.updateStrokeColor(
                        requireActivity(),
                        etSetMPin,
                        SdkUiInitializer.apiLayer?.config?.primaryColor,
                        R.color.one_payu_colorPrimary
                    )
                } else {
                    ViewUtils.updateStrokeColor(requireContext(), etSetMPin)
                }
            }

            R.id.etReEnterMpin -> {
                if (hasFocus) {
                    ViewUtils.updateStrokeColor(
                        requireActivity(),
                        etConfirmMPin,
                        SdkUiInitializer.apiLayer?.config?.primaryColor,
                        R.color.one_payu_colorPrimary
                    )
                } else {
                    ViewUtils.updateStrokeColor(requireContext(), etConfirmMPin)
                }
            }
        }
    }

}

