package com.payu.ui.view.fragments.olw

import android.app.Dialog
import android.os.Bundle
import android.text.InputFilter
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.view.WindowManager
import android.widget.Button
import android.widget.EditText
import android.widget.ImageView
import android.widget.LinearLayout
import android.widget.TextView
import androidx.appcompat.content.res.AppCompatResources
import androidx.appcompat.widget.AppCompatImageView
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.core.content.ContextCompat
import androidx.core.view.ViewCompat
import androidx.core.view.WindowInsetsCompat
import androidx.core.widget.doOnTextChanged
import androidx.lifecycle.ViewModelProvider
import com.google.android.material.bottomsheet.BottomSheetBehavior
import com.google.android.material.bottomsheet.BottomSheetDialog
import com.google.android.material.bottomsheet.BottomSheetDialogFragment
import com.payu.base.listeners.OnFetchImageListener
import com.payu.base.models.ImageDetails
import com.payu.base.models.ImageParam
import com.payu.ui.R
import com.payu.ui.SdkUiInitializer
import com.payu.ui.model.models.EnterMPinData
import com.payu.ui.model.utils.AnalyticsUtils
import com.payu.ui.model.utils.ImageViewUtils
import com.payu.ui.model.utils.SdkUiConstants
import com.payu.ui.model.utils.Utils
import com.payu.ui.model.utils.ViewUtils
import com.payu.ui.model.utils.ViewUtils.setPayUDialogSettings
import com.payu.ui.viewmodel.OLWViewModel
import com.payu.ui.viewmodel.PaymentOptionViewModel
import org.json.JSONObject


class EnterMPinFragment : BottomSheetDialogFragment(),  View.OnFocusChangeListener {

    override fun getTheme(): Int = R.style.PayU_BottomSheetDialogTheme

    override fun onCreateDialog(savedInstanceState: Bundle?): Dialog {
        val dialog =
            BottomSheetDialog(requireContext(), theme)
        dialog.setOnShowListener {
            val bottomSheet = dialog.findViewById<View>(com.google.android.material.R.id.design_bottom_sheet)
            bottomSheet?.let {
                BottomSheetBehavior.from(it).state = BottomSheetBehavior.STATE_EXPANDED
            }
            dialog.window?.setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_ADJUST_RESIZE)
        }
        return dialog;
    }

    private var viewModel: PaymentOptionViewModel? = null

    private var enterMPinData: EnterMPinData? = null

    private var etNumberField: EditText? = null
    private var primaryBtn: Button? = null
    private var secondaryBtn: Button? = null

    private var reActionContainer: LinearLayout? = null
    private var tvReActionDesc: TextView? = null
    private var tvReAction: TextView? = null

    private var etError: TextView? = null

    private var ivBrandIcon: ImageView? = null
    private var tvCardName: TextView? = null
    private var tvCardBalance: TextView? = null
    private var tvTopUpAmount: TextView? = null
    private var tvBalanceWarning: TextView? = null

    private var clTopUpContainer: ConstraintLayout? = null
    private var llTopUpAmountContainer: LinearLayout? = null
    private var llProgressScreen: LinearLayout? = null
    private var viewHandle: View? = null
    private var rlCard: ConstraintLayout? = null
    private var clMainContainer: ConstraintLayout? = null
    private var llBtnLayout: LinearLayout? = null
    private var payuloader : AppCompatImageView? = null

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        return inflater.inflate(R.layout.payu_wallet_details_layout, container, false)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        initViewModel()
        enterMPinData?.let { setUpEnterMPinScreen(enterMPinData = it) }
        initObservers()
    }

    private fun initViewModel() {
        viewModel = activity?.run {
            ViewModelProvider(this)[PaymentOptionViewModel::class.java]
        } ?: throw Exception("Invalid Activity")
    }

    private fun initObservers() {
        viewModel?.showBottomSheetDialog?.observe(viewLifecycleOwner) {
            if (it) {
                showProgressDialog()
            } else {
                hideProgressDialog()
            }
        }


        viewModel?.updateErrorTextOnMPin?.observe(viewLifecycleOwner) {
            if (it.isNullOrBlank().not()) {
                etError?.visibility = View.VISIBLE
                etError?.text = it
                ViewUtils.disableView(primaryBtn)
            } else {
                etError?.visibility = View.GONE
            }
        }
    }

    override fun onStart() {
        super.onStart()
        dialog?.window?.setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_ADJUST_RESIZE)
    }


    private fun showProgressDialog() {
        llProgressScreen?.visibility = View.VISIBLE
        setPayUDialogSettings(payuloader, requireActivity())
        viewHandle?.visibility = View.GONE
        rlCard?.visibility = View.GONE
        clMainContainer?.visibility = View.GONE
        clTopUpContainer?.visibility = View.GONE
        llBtnLayout?.visibility = View.GONE
    }

    private fun hideProgressDialog() {
        llProgressScreen?.visibility = View.GONE
        viewHandle?.visibility = View.VISIBLE
        rlCard?.visibility = View.VISIBLE
        clMainContainer?.visibility = View.VISIBLE
        llBtnLayout?.visibility = View.VISIBLE
        showMPinView()
    }

    private fun showMPinView() {
        if (enterMPinData?.showInsufficientTag?.not() == true) {
            tvBalanceWarning?.visibility = View.GONE
        } else {
            tvBalanceWarning?.visibility = View.VISIBLE
        }

        if (enterMPinData?.showTopUpAmountConfirmation?.not() == true) {
            llTopUpAmountContainer?.visibility = View.GONE
        } else {
            llTopUpAmountContainer?.visibility = View.VISIBLE
        }

        if (enterMPinData?.showSecondaryButton?.not() == true) {
            secondaryBtn?.visibility = View.GONE
        } else {
            secondaryBtn?.visibility = View.VISIBLE
        }

    }

    private fun setUpEnterMPinScreen(enterMPinData: EnterMPinData) {
        etNumberField = view?.findViewById(R.id.etNumberField)
        etError = view?.findViewById(R.id.etError)
        primaryBtn = view?.findViewById(R.id.btnAction)
        secondaryBtn = view?.findViewById(R.id.btnSecondaryAction)
        reActionContainer = view?.findViewById(R.id.llReActionContainer)
        tvReActionDesc = view?.findViewById(R.id.tvReActionDesc)
        tvReAction = view?.findViewById(R.id.tvReAction)

        ivBrandIcon = view?.findViewById(R.id.ivBrandIcon)
        tvCardName = view?.findViewById(R.id.tvWalletName)
        tvCardBalance = view?.findViewById(R.id.tvBalanceAmount)
        tvBalanceWarning = view?.findViewById(R.id.tvBalanceWarning)
        tvTopUpAmount = view?.findViewById(R.id.tvTopupAmount)
        llProgressScreen = view?.findViewById(R.id.llProgressScreen)
        payuloader = view?.findViewById(R.id.payu_loader)
        viewHandle = view?.findViewById(R.id.viewHandle)
        rlCard = view?.findViewById(R.id.rl_card)
        clMainContainer = view?.findViewById(R.id.clMainContainer)

        clTopUpContainer = view?.findViewById(R.id.clTopUpContainer)
        llBtnLayout = view?.findViewById(R.id.llBtnLayout)
        clTopUpContainer?.visibility = View.GONE

        llTopUpAmountContainer = view?.findViewById(R.id.llTopupAmountContainer)
        etNumberField?.onFocusChangeListener = this
        llBtnLayout?.let {
            ViewCompat.setOnApplyWindowInsetsListener(it) { v, insets ->
                val bottomInset = insets.getInsets(WindowInsetsCompat.Type.systemBars()).bottom
                v.setPadding(
                    v.paddingLeft,
                    v.paddingTop,
                    v.paddingRight,
                    bottomInset + 16  // Add margin if needed
                )
                insets
            }
        }
        ViewUtils.updateBackgroundColor(
            requireContext(),
            primaryBtn,
            SdkUiInitializer.apiLayer?.config?.primaryColor,
            R.color.one_payu_colorPrimary
        )
        if (enterMPinData.showInsufficientTag.not()) {
            tvBalanceWarning?.visibility = View.GONE
        } else {
            tvBalanceWarning?.visibility = View.VISIBLE
        }

        if (enterMPinData.showTopUpAmountConfirmation.not()) {
            llTopUpAmountContainer?.visibility = View.GONE
        } else {
            llTopUpAmountContainer?.visibility = View.VISIBLE
        }

        if (enterMPinData.showSecondaryButton.not()) {
            secondaryBtn?.visibility = View.GONE
        } else {
            secondaryBtn?.visibility = View.VISIBLE
        }


        enterMPinData.bankIcon?.let {
            ivBrandIcon?.background = ContextCompat.getDrawable(requireContext(), it)
        }
        tvCardName?.text = enterMPinData.bankName
        tvCardBalance?.text = Utils.getFormattedAmount(
            enterMPinData.currentBalance,
            requireContext()
        )
        tvTopUpAmount?.text = Utils.getFormattedAmount(
            enterMPinData.topUpAmountNeeded,
            requireContext()
        )

        etNumberField?.hint = enterMPinData.mPinHint
        etNumberField?.filters = arrayOf(InputFilter.LengthFilter(enterMPinData.mPinLength))
        tvReActionDesc?.text = enterMPinData.reActionDescText
        tvReAction?.text = enterMPinData.reActionText
        primaryBtn?.text = enterMPinData.actionText

        primaryBtn?.setOnClickListener {
            AnalyticsUtils.logKibanaInfoEvent(
                context = requireContext(),
                eventKey = if (enterMPinData.showTopUpAmountConfirmation) SdkUiConstants.CP_OLW_LOAD_BALANCE_CONFIRMATION_PROCEED_CLICKED else SdkUiConstants.CP_OLW_ENTER_MPIN_PROCEED_CLICKED,
                eventValue = JSONObject().apply {
                    put(SdkUiConstants.CP_KEY_WALLET_NAME, enterMPinData.paymentOption.bankName)
                    put(SdkUiConstants.CP_KEY_MOBILE, viewModel?.getLoggedInPhoneNumber())
                    if (enterMPinData.showTopUpAmountConfirmation)
                        put(SdkUiConstants.CP_KEY_TOP_UP_AMOUNT, enterMPinData.topUpAmountNeeded)
                    else
                        put(
                            SdkUiConstants.CP_KEY_AMOUNT,
                            enterMPinData.currentBalance + enterMPinData.topUpAmountNeeded
                        )
                }
            )
            ViewUtils.hideSoftKeyboard(requireView())
            viewModel?.verifyMPin(
                requireActivity(),
                enterMPinData.paymentOption,
                etNumberField?.text?.toString() ?: ""
            )
        }

        ViewUtils.disableView(primaryBtn)

        tvReAction?.setOnClickListener {
            AnalyticsUtils.logKibanaInfoEvent(
                context = requireContext(),
                eventKey = SdkUiConstants.CP_OLW_RESET_MPIN_CLICKED,
                eventValue = JSONObject().apply {
                    put(SdkUiConstants.CP_KEY_WALLET_NAME, enterMPinData.paymentOption.bankName)
                    put(SdkUiConstants.CP_KEY_MOBILE, viewModel?.getLoggedInPhoneNumber())
                    if(enterMPinData.showTopUpAmountConfirmation)
                        put(SdkUiConstants.CP_KEY_TOP_UP_AMOUNT, enterMPinData.topUpAmountNeeded)
                    else
                        put(SdkUiConstants.CP_KEY_AMOUNT, enterMPinData.currentBalance + enterMPinData.topUpAmountNeeded)
                    put(SdkUiConstants.CP_KEY_SCREEN, if(enterMPinData.showTopUpAmountConfirmation) SdkUiConstants.CP_VALUE_TOP_UP_CONFIRMATION_SCREEN else SdkUiConstants.CP_VALUE_ENTER_MPIN_SCREEN)
                }
            )
            viewModel?.showReSetMPinBottomSheet(enterMPinData.paymentOption)
        }

        secondaryBtn?.setOnClickListener {
            AnalyticsUtils.logKibanaInfoEvent(
                context = requireContext(),
                eventKey = SdkUiConstants.CP_OLW_LOAD_BALANCE_CONFIRMATION_BACK_CLICKED,
                eventValue = JSONObject().apply {
                    put(SdkUiConstants.CP_KEY_WALLET_NAME, enterMPinData.paymentOption.bankName)
                    put(SdkUiConstants.CP_KEY_MOBILE, viewModel?.getLoggedInPhoneNumber())
                    put(SdkUiConstants.CP_KEY_TOP_UP_AMOUNT, enterMPinData.topUpAmountNeeded)
                }
            )
            viewModel?.showTopUpCardFragment(enterMPinData.paymentOption)
            dismiss()
        }

        etNumberField?.doOnTextChanged { text, start, before, count ->
            etError?.text = ""
            etError?.visibility = View.GONE
            if (Utils.isValidMPin(text.toString()))
                ViewUtils.enableView(primaryBtn)
            else
                ViewUtils.disableView(primaryBtn)
        }

        val param = ImageParam(
            enterMPinData.paymentOption,
            false,
            Utils.getDefaultDrawable(enterMPinData.paymentOption.paymentType)
        )
        SdkUiInitializer.apiLayer?.getImageForPaymentOption(
            param,
            onFetchImageListener = object : OnFetchImageListener {
                override fun onImageGenerated(result: ImageDetails) {
                    ImageViewUtils.setImage(ivBrandIcon, result)
                }
            })

    }

    companion object {
        @JvmStatic
        fun newInstance(enterMPinData: EnterMPinData) =
            EnterMPinFragment().apply {
                this.enterMPinData = enterMPinData
            }
    }

    override fun onFocusChange(v: View?, hasFocus: Boolean) {
        when (v?.id) {
            R.id.etNumberField -> {
                if (hasFocus) {
                    ViewUtils.updateStrokeColor(
                        requireActivity(),
                        etNumberField,
                        SdkUiInitializer.apiLayer?.config?.primaryColor,
                        R.color.one_payu_colorPrimary
                    )
                } else {
                    ViewUtils.updateStrokeColor(requireContext(), etNumberField)
                }
            }
        }
    }


}

