package com.payu.ui.view.fragments.handlers

import android.content.Context
import android.view.View
import android.view.View.GONE
import android.view.View.VISIBLE
import android.widget.RelativeLayout
import android.widget.TextView
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.core.content.ContextCompat
import androidx.fragment.app.FragmentActivity
import androidx.lifecycle.LifecycleOwner
import com.payu.ui.R
import com.payu.ui.SdkUiInitializer
import com.payu.ui.model.utils.ViewUtils
import com.payu.ui.viewmodel.CardBaseViewModel


class TenureUiHandler(private val activity: FragmentActivity) : View.OnClickListener,
    View.OnFocusChangeListener{

    private var tvTotalAmountDisplay: TextView? = null
    private var rlEmiTenuresLayout: ConstraintLayout? = null
    private var tvEmiInterest: TextView? = null
    private var rlEmiInstallment: ConstraintLayout? = null
    private var tvSelectInstallment: TextView? = null
    private var tvSelectEmiInstallment: TextView? = null
    private var bankCode: String? = null
    private var cardBaseViewModel: CardBaseViewModel? = null
    private var tvNoCostEmi: TextView? = null
    private var tvEmiCashBackText: TextView? = null


    internal fun initTenureUI(view: View, commonEmiViewModel: CardBaseViewModel?) {
        tvTotalAmountDisplay = view.findViewById(R.id.tvTotalAmountDisplay)
        rlEmiTenuresLayout = view.findViewById(R.id.rlEmiTenuresLayout)
        rlEmiInstallment = view.findViewById(R.id.rlEmiInstallment)
        tvEmiInterest = view.findViewById(R.id.tvEmiInterest)
        tvSelectInstallment = view.findViewById(R.id.tvSelectInstallment)
        tvSelectEmiInstallment = view.findViewById(R.id.tvSelectEmiInstallment)
        tvNoCostEmi = view.findViewById(R.id.tvNoCostEmi)
        tvEmiCashBackText = view.findViewById(R.id.tvEmiCashBackText)
        rlEmiInstallment?.setOnClickListener(this)
        this.cardBaseViewModel = commonEmiViewModel
        rlEmiInstallment?.onFocusChangeListener = this
    }

    private fun updateEmiTenureView(it: Boolean) {
        if (it) {
            tvSelectEmiInstallment?.alpha = 0.5f
            rlEmiInstallment?.alpha = 0.5f
            tvSelectInstallment?.alpha = 0.5f
            rlEmiInstallment?.setBackgroundResource(R.drawable.payu_rounded_corner_image_for_edittext)
            tvEmiInterest?.visibility = GONE
        } else {
            tvSelectEmiInstallment?.alpha = 1f
            rlEmiInstallment?.alpha = 1f
            tvSelectInstallment?.alpha = 1f
            if (!activity.isFinishing && !activity.isDestroyed && tvSelectInstallment?.text?.contains(
                    activity.getString(R.string.payu_select_installment)
                ) == true
            ) tvSelectInstallment?.setTextColor(
                ContextCompat.getColor(
                    activity,
                    R.color.payu_color_8f9dbd
                )
            )
        }
    }


    fun addTenureObserver(
        commonEmiViewModel: CardBaseViewModel?,
        context: Context
    ) {
        commonEmiViewModel?.disableEmiTenures?.observe(
            context as LifecycleOwner
        ) {
            tvSelectInstallment?.isEnabled = !it
            tvTotalAmountDisplay?.isEnabled = !it
            rlEmiInstallment?.isEnabled = !it
            updateEmiTenureView(it)
        }
        commonEmiViewModel?.highlightEmiField?.observe(
            context as LifecycleOwner
        ) {
            if (it) {
                ViewUtils.updateStrokeColor(
                    context,
                    rlEmiInstallment,
                    SdkUiInitializer.apiLayer?.config?.primaryColor,
                    R.color.one_payu_colorPrimary
                )
                tvSelectInstallment?.setTextColor(
                    ContextCompat.getColor(
                        context,
                        R.color.payu_color_0d1b2e
                    )
                )
                tvTotalAmountDisplay?.setTextColor(
                    ContextCompat.getColor(
                        context,
                        R.color.payu_color_0d1b2e
                    )
                )
                rlEmiTenuresLayout?.requestFocus()
            } else ViewUtils.updateStrokeColor(context, rlEmiInstallment)

        }


        commonEmiViewModel?.tenureInterest?.observe(
            context as LifecycleOwner
        ) {
            tvEmiInterest?.text = it
        }
        commonEmiViewModel?.selectedTenure?.observe(context as LifecycleOwner) {
            tvSelectInstallment?.text = it
        }
        commonEmiViewModel?.selectedTenureBankCode?.observe(context as LifecycleOwner) {
            bankCode = it
        }
        commonEmiViewModel?.updateEmiList?.observe(context as LifecycleOwner) {
            updateEmiTenureView(false)
        }
        commonEmiViewModel?.showEmiInterestText?.observe(context as LifecycleOwner) {
            if (it) tvEmiInterest?.visibility =
                VISIBLE else tvEmiInterest?.visibility =
                GONE
        }
        commonEmiViewModel?.selectedTenure?.observe(context as LifecycleOwner) {
            tvSelectInstallment?.text = it
        }
        commonEmiViewModel?.tenureInterest?.observe(context as LifecycleOwner) {
            tvEmiInterest?.text = it
        }
        commonEmiViewModel?.disableEmiTenures?.observe(
            context as LifecycleOwner
        ) {
            tvSelectInstallment?.isEnabled = !it
            tvTotalAmountDisplay?.isEnabled = !it
            rlEmiInstallment?.isEnabled = !it
            updateEmiTenureView(it)
        }
        commonEmiViewModel?.showNoCostTag?.observe(context as LifecycleOwner) {
            if (it){
                tvNoCostEmi?.visibility = VISIBLE
                ViewUtils.updateBackgroundColor(
                    context,
                    tvNoCostEmi,
                    SdkUiInitializer.apiLayer?.config?.primaryColor,
                    R.color.one_payu_colorPrimary
                )
            }
            else tvNoCostEmi?.visibility = GONE
        }
        commonEmiViewModel?.showCashBackTenureText?.observe(context as LifecycleOwner) {
            if (it != null) {
                tvEmiCashBackText?.text = it
                tvEmiCashBackText?.visibility = VISIBLE
            } else tvEmiCashBackText?.visibility = GONE
        }
    }

    override fun onClick(p0: View?) {
        rlEmiInstallment?.requestFocus()
        cardBaseViewModel?.showBottomSheet()
        cardBaseViewModel?.emiTenuresClicked()
    }

    override fun onFocusChange(p0: View?, hasFocus: Boolean) {
        cardBaseViewModel?.emiTenureFocused(hasFocus)
    }
}