package com.payu.ui.view.fragments.handlers

import android.content.Context
import android.view.View
import android.widget.TextView
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.lifecycle.LifecycleOwner
import com.payu.base.models.InternalConfig
import com.payu.ui.R
import com.payu.ui.viewmodel.EmiViewModel
import com.payu.ui.viewmodel.PaymentOptionViewModel

class OfferUIHandler(
    private val offerUIInterface: OfferUIInterface
) {
    private var changeOfferOption: ConstraintLayout? = null
    private var tvOfferTitle: TextView? = null
    private var tvOfferDetails: TextView? = null
    private var tvOfferDisc: TextView? = null
    private var removeOfferButton: TextView? = null

    internal fun initOfferUI(view: View) {
        changeOfferOption = view.findViewById(R.id.removeOfferToolbar)
        tvOfferTitle = view.findViewById(R.id.tvOfferTitle)
        tvOfferDetails = view.findViewById(R.id.tvOfferDetails)
        tvOfferDisc = view.findViewById(R.id.tvOfferDisc)
        removeOfferButton = view.findViewById(R.id.tvRemoveOfferButton)
        removeOfferButton?.setOnClickListener {
            InternalConfig.userSelectedOfferInfo = null
            offerUIInterface.removeOfferClick()
        }
       tvOfferDetails?.setOnClickListener {
           offerUIInterface.showSkuDetailsBtSheet()
        }
    }

    internal fun addOfferObserver(
        context: Context,
        paymentOptionViewModel: PaymentOptionViewModel
    ) {
        paymentOptionViewModel.showChangeOfferView.observe(context as LifecycleOwner) {
            if (it) {
                changeOfferOption?.visibility = View.VISIBLE
                val offerKeySet = HashSet<String>()
                InternalConfig.selectedOfferInfo?.offerMap?.values?.forEach {
                    it.offerKey?.let { it1 -> offerKeySet.add(it1) }
                }
                val length = offerKeySet.size
                if (length > 1) {
                    tvOfferTitle?.text = context.getString(
                        R.string.payu_offer_applied_text,
                        length.toString()
                    )
                    tvOfferDisc?.visibility = View.GONE
                } else if (length == 1) {
                    val offerKey = InternalConfig.selectedOfferInfo?.offerMap?.keys?.first()
                    tvOfferTitle?.text =
                        InternalConfig.selectedOfferInfo?.offerMap?.get(offerKey)?.title
                    tvOfferDisc?.visibility = View.VISIBLE
                    tvOfferDisc?.text =
                        InternalConfig.selectedOfferInfo?.offerMap?.get(offerKey)?.description
                } else changeOfferOption?.visibility = View.GONE
                if (InternalConfig.selectedOfferInfo?.isSkuOffer == true) tvOfferDetails?.visibility =
                    View.VISIBLE else tvOfferDetails?.visibility =
                    View.GONE
            } else {
                changeOfferOption?.visibility = View.GONE
            }
        }

    }

    interface OfferUIInterface {
        fun removeOfferClick()
        fun showSkuDetailsBtSheet()
    }

}