package com.payu.ui.view.fragments

import android.app.Activity
import android.app.PendingIntent
import android.content.Context
import android.content.Intent
import android.content.IntentSender.SendIntentException
import android.os.Bundle
import android.text.Editable
import android.text.InputFilter
import android.text.TextWatcher
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.Button
import android.widget.CheckBox
import android.widget.EditText
import android.widget.ImageView
import android.widget.LinearLayout
import android.widget.ProgressBar
import android.widget.RelativeLayout
import android.widget.TextView
import androidx.appcompat.widget.SwitchCompat
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.core.content.ContextCompat
import androidx.fragment.app.Fragment
import androidx.lifecycle.Observer
import androidx.lifecycle.ViewModelProvider
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.google.android.gms.auth.api.credentials.Credential
import com.google.android.gms.auth.api.credentials.Credentials
import com.google.android.gms.auth.api.credentials.CredentialsOptions
import com.google.android.gms.auth.api.credentials.HintRequest
import com.payu.base.models.InternalConfig
import com.payu.base.models.PaymentModel
import com.payu.base.models.PaymentType
import com.payu.commonui.utils.CommonUIViewUtils
import com.payu.ui.R
import com.payu.ui.SdkUiInitializer
import com.payu.ui.model.adapters.HorizontalAdapter
import com.payu.ui.model.adapters.HorizontalTilesAdapter
import com.payu.ui.model.managers.CFManager
import com.payu.ui.model.managers.NetworkManager
import com.payu.ui.model.utils.AnalyticsUtils
import com.payu.ui.model.utils.ImageViewUtils
import com.payu.ui.model.utils.MultipleClickHandler
import com.payu.ui.model.utils.SdkUiConstants
import com.payu.ui.model.utils.SdkUiConstants.CP_BANK_CODE
import com.payu.ui.model.utils.SdkUiConstants.CP_PAYMENT_MODEL
import com.payu.ui.model.utils.Utils
import com.payu.ui.model.utils.ViewUtils
import com.payu.ui.view.customViews.OfferAppliedDialog
import com.payu.ui.view.customViews.UpiOtmDetailBottomSheet
import com.payu.ui.viewmodel.BaseViewModelFactory
import com.payu.ui.viewmodel.PaymentOptionViewModel
import com.payu.ui.viewmodel.WalletViewModel


class WalletFragment : Fragment(), View.OnClickListener,
    View.OnFocusChangeListener {
    private var TAG = javaClass.simpleName

    private var paymentModel: PaymentModel? = null
    private var walletViewModel: WalletViewModel? = null
    private var paymentOptionViewModel: PaymentOptionViewModel? = null
    private var tvWalletName: TextView? = null
    private var tvWPPhoneNumberLabel: TextView? = null
    private var tvVerifyNumber: TextView? = null
    private var tvVerifiedText: TextView? = null
    private var tvOfferAppliedView: TextView? = null
    private var rlGpayMessage: RelativeLayout? = null
    private var tvFooterWalletName: TextView? = null
    private var btnPay: Button? = null
    private var llWalletFooter: LinearLayout? = null
    private var rlPhoneNumber: View? = null
    private var ivWallet: ImageView? = null
    private var etPhone: EditText? = null
    private var pbVerify: ProgressBar? = null
    private var ivVerified: ImageView? = null
    private var tvSISummary: TextView? = null
    private var tv_si_summary_title_layout: ConstraintLayout? = null
    private var tvOfferTitle: TextView? = null
    private var tvOfferDetails: TextView? = null
    private var removeOfferButton: TextView? = null
    private var changeOfferOption: ConstraintLayout? = null
    private var switchSaveWallet: SwitchCompat? = null
    private val rcHint = 1000
    private var rvlist: RecyclerView? = null
    private var beforeTxt: String = ""
    private var tvOfferDisc: TextView? = null
    private var rlSwitchSaveCard: RelativeLayout? = null
    private var switchSaveCard: CheckBox? = null
    private var tpvAccountOptions: ConstraintLayout? = null
    private var tvTpvInfo: TextView ? = null
    private var rvRecommendedOptions: RecyclerView? = null
    private var clRecommendedOptions: ConstraintLayout? = null

    // variable to track event time
    private var mLastClickTime: Long = 0
    private var tvConsentText: TextView? = null

    private var bankCode: String? = null
    var items: ArrayList<String> = ArrayList()
    private var showSavedPaymentSwitch: Boolean = false
    private var loginSectionView: View? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        arguments?.let {
            paymentModel = it.getParcelable(CP_PAYMENT_MODEL)
        }
    }

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {

        val view = inflater.inflate(R.layout.fragment_wallet, container, false)
        initUi(view)
        initViewModel()
        initFocus()
        addObservers()

        //TODO: Refactor this ; Do not to consume view model variable directly
        walletViewModel?.let {
            items = it.items
            rvlist = view.findViewById(R.id.list)
            rvlist?.layoutManager =
                LinearLayoutManager(context, LinearLayoutManager.HORIZONTAL, false)
            rvlist?.adapter = HorizontalAdapter(items, { handle -> it.handleEntered(handle) })
            rvlist?.visibility = View.GONE
        }
        return view
    }

    override fun onAttach(context: Context) {
        super.onAttach(context)
        CommonUIViewUtils.updateLayoutSecurity(
            requireActivity(),
            SdkUiInitializer.apiLayer?.config?.isProtectedScreen == true
        )
    }

    override fun onDetach() {
        super.onDetach()
        CommonUIViewUtils.updateLayoutSecurity(requireActivity(), false)
    }

    private fun initFocus() {
        etPhone?.requestFocus()
        walletViewModel?.numberFocusChanged(true)
    }

    private fun initUi(view: View) {
        tvWalletName = view.findViewById(R.id.tvWalletName)
        tvWPPhoneNumberLabel = view.findViewById(R.id.tvPhoneNumberLabel)
        tvVerifyNumber = view.findViewById(R.id.tvVerifyNumber)
        tvVerifiedText = view.findViewById(R.id.tvVerifiedText)
        tvOfferAppliedView = view.findViewById(R.id.tvOfferAppliedView)
        tvFooterWalletName = view.findViewById(R.id.tvFooterWalletName)
        btnPay = view.findViewById(R.id.btnPay)
        llWalletFooter = view.findViewById(R.id.llWalletFooter)
        ivWallet = view.findViewById(R.id.ivWallet)
        switchSaveWallet = view.findViewById(R.id.switchSaveWallet)
        pbVerify = view.findViewById(R.id.pbVerify)
        ivVerified = view.findViewById(R.id.ivVerified)
        rlPhoneNumber = view.findViewById(R.id.rlPhoneNumber)
        etPhone = view.findViewById(R.id.etPhone)
        tvSISummary = view.findViewById(R.id.tv_si_summary_title)
        tv_si_summary_title_layout = view.findViewById(R.id.tv_si_summary_title_layout)
        tvOfferTitle = view.findViewById(R.id.tvOfferTitle)
        tvOfferDetails = view.findViewById(R.id.tvOfferDetails)
        removeOfferButton = view.findViewById(R.id.tvRemoveOfferButton)
        changeOfferOption = view.findViewById(R.id.changeOfferOption)
        tvOfferDisc = view.findViewById(R.id.tvOfferDisc)
        rlSwitchSaveCard = view.findViewById(R.id.rlSwitchSaveCard)
        switchSaveCard = view.findViewById(R.id.switchSaveCard)
        removeOfferButton?.setOnClickListener(this)
        tvOfferDetails?.setOnClickListener(this)
        etPhone?.onFocusChangeListener = this
        tvVerifyNumber?.setOnClickListener(this)
        btnPay?.setOnClickListener(this)
        rlGpayMessage = view.findViewById(R.id.rlGpayMessage)
        tpvAccountOptions = view.findViewById(R.id.tpvAccountOptions)
        tvTpvInfo = view.findViewById(R.id.tvTpvInfo)
        clRecommendedOptions = view.findViewById(R.id.recommendedOption)
        rvRecommendedOptions = clRecommendedOptions?.findViewById(R.id.rvrecommendedoptions)
        ViewUtils.updateBackgroundColor(
            requireContext(),
            btnPay,
            SdkUiInitializer.apiLayer?.config?.primaryColor,
            R.color.one_payu_colorPrimary
        )
        ViewUtils.updateButtonTextColor(btnPay, SdkUiInitializer.apiLayer?.config?.baseTextColor)

        etPhone?.addTextChangedListener(object : TextWatcher {
            override fun afterTextChanged(s: Editable?) {
                walletViewModel?.numberEntered(s.toString())

                if (walletViewModel?.paymentType == PaymentType.UPI) {
                    rlPhoneNumber?.setBackgroundResource(R.drawable.payu_rounded_corner_image_for_edittext)
                    ViewUtils.updateStrokeColor(
                        requireContext(),
                        rlPhoneNumber,
                        R.color.payu_color_338f9dbd
                    )
                    walletViewModel?.setAutorecommendedHandlesVisibility(s.toString(), beforeTxt)
                }
                setSelectionForUpiHandles(s.toString())
            }

            override fun beforeTextChanged(s: CharSequence?, start: Int, count: Int, after: Int) {
                beforeTxt = s.toString()
            }

            override fun onTextChanged(s: CharSequence?, start: Int, before: Int, count: Int) {
            }

        })
        tvConsentText = view.findViewById(R.id.tv_consent_text)

        // Initialize login section view for timer
        loginSectionView = view.findViewById(R.id.rlGlobalVaultPhoneStting)
        initLoginSectionView()
    }

    private fun initLoginSectionView() {
        val tvLoggedInPhoneNumber = loginSectionView?.findViewById<TextView>(R.id.tvGlobalVaultPhoneNumber)
        val ivLoginSettings = loginSectionView?.findViewById<ImageView>(R.id.ivGvSettings)

        // Set click listeners
        tvLoggedInPhoneNumber?.setOnClickListener {
            paymentOptionViewModel?.showBottomSheetGlobalVaultSettings()
        }
        ivLoginSettings?.setOnClickListener {
            paymentOptionViewModel?.showBottomSheetGlobalVaultSettings()
        }
    }

    private fun showHint() {
        if (walletViewModel != null && walletViewModel?.isShowingPhonePicker == false) {
            context?.let {
                val hintRequest = HintRequest.Builder()
                    .setPhoneNumberIdentifierSupported(true)
                    .build()
                val options = CredentialsOptions.Builder()
                    .forceEnableSaveDialog()
                    .build()
                val intent: PendingIntent = Credentials.getClient(it, options)
                    .getHintPickerIntent(hintRequest)

                try {
                    startIntentSenderForResult(
                        intent.intentSender,
                        rcHint, null, 0, 0, 0, null
                    )
                    // TODO : will set true when phone no picker issue is fixed
                    walletViewModel?.isShowingPhonePicker = false
                } catch (e: SendIntentException) {
                    e.printStackTrace()
                }
            }
        }
    }

    private fun initViewModel() {
        /**
         * We will create ViewModel instance in the fragment using the activity scope so
         * that it will be available for all the fragment of the activity including activity itself.
         * */

        paymentOptionViewModel = activity?.run {
            ViewModelProvider(this)[PaymentOptionViewModel::class.java]
        } ?: throw Exception("Invalid Activity")
        if (InternalConfig.selectedOfferInfo?.totalDiscountedAmount != null) {
            paymentOptionViewModel?.updateHeaderAmount(
                InternalConfig.selectedOfferInfo?.totalDiscountedAmount,
                additionalCharge = paymentModel?.paymentOption?.additionalCharge,
                gstPercentageValue = paymentModel?.paymentOption?.gstPercentageValue,
                gstFlatValue = paymentModel?.paymentOption?.gstValue ?: 0.0,
                isOfferValid = true
            )
        } else {
            paymentOptionViewModel?.updateHeaderAmount(
                additionalCharge = paymentModel?.paymentOption?.additionalCharge,
                gstPercentageValue = paymentModel?.paymentOption?.gstPercentageValue,
                gstFlatValue = paymentModel?.paymentOption?.gstValue ?: 0.0
            )
        }

        val map = HashMap<String, Any>()
        paymentModel?.let { map[CP_PAYMENT_MODEL] = it }

        if (!requireActivity().isFinishing && !requireActivity().isDestroyed) {
            walletViewModel =
                ViewModelProvider(
                    this,
                    BaseViewModelFactory(requireActivity().application, map)
                )[WalletViewModel::class.java]
        }
        paymentOptionViewModel?.setScreenName("L3 " + paymentModel?.paymentOption?.paymentType)
    }

    private fun addObservers() {

        walletViewModel?.vpa?.observe(viewLifecycleOwner) {
            etPhone?.setText(it)
        }

        walletViewModel?.walletHeaderTitle?.observe(viewLifecycleOwner, Observer {
            tvWalletName?.text = it
        })
        walletViewModel?.walletFooterTitle?.observe(viewLifecycleOwner, Observer {
            tvFooterWalletName?.text = it
        })

        walletViewModel?.phoneNumberLabel?.observe(viewLifecycleOwner, Observer {
            tvWPPhoneNumberLabel?.text = it
        })

        walletViewModel?.showWalletFooter?.observe(viewLifecycleOwner, Observer {
            if (it) llWalletFooter?.visibility = View.VISIBLE else llWalletFooter?.visibility =
                View.GONE
        })

        walletViewModel?.walletIcon?.observe(viewLifecycleOwner, Observer {
            ImageViewUtils.setImage(ivWallet, it)
        })

        walletViewModel?.editTextInputType?.observe(viewLifecycleOwner, Observer {
            etPhone?.inputType = it
        })

        walletViewModel?.callValidateOffer?.observe(viewLifecycleOwner, Observer {
            if (it) {
                InternalConfig.isPaymentOptionSelected = true
                paymentOptionViewModel?.updateSelectedPaymentOption(walletViewModel?.paymentOption)
                walletViewModel?.fetchCFAndValidateOffer(isOfferRemovedManually = false, etPhone?.text.toString())
            }
        })

        walletViewModel?.enablePayBtn?.observe(viewLifecycleOwner, Observer {
            if (it) {
                ViewUtils.enableView(btnPay)
            } else {
                ViewUtils.disableView(btnPay)
                tvOfferAppliedView?.visibility = View.GONE
            }
//            changeOfferView(it)
        })

        walletViewModel?.enableVerify?.observe(viewLifecycleOwner, Observer {
            if (it) {
                tvVerifyNumber?.isEnabled = true
                ViewUtils.updateTextColor(
                    requireContext(),
                    tvVerifyNumber,
                    SdkUiInitializer.apiLayer?.config?.primaryColor,
                    R.color.one_payu_colorPrimary
                )
            } else {
                tvVerifyNumber?.isEnabled = false
                tvVerifyNumber?.setTextColor(
                    ContextCompat.getColor(
                        requireContext(),
                        R.color.payu_color_8f9dbd
                    )
                )
            }
        })

        walletViewModel?.showLoaderInEditText?.observe(viewLifecycleOwner, Observer {
            if (it) {
                pbVerify?.visibility = View.VISIBLE
                if (!SdkUiInitializer.apiLayer?.config?.primaryColor.isNullOrEmpty())
                    ViewUtils.changeProgressBarColor(
                        pbVerify,
                        SdkUiInitializer.apiLayer?.config?.primaryColor
                    )
            } else pbVerify?.visibility = View.GONE
        })

        walletViewModel?.showVerifiedImage?.observe(viewLifecycleOwner, Observer {
            if (it) ivVerified?.visibility = View.VISIBLE else ivVerified?.visibility = View.GONE
        })

        walletViewModel?.showVerifyNumber?.observe(viewLifecycleOwner, Observer {
            if (it) tvVerifyNumber?.visibility = View.VISIBLE else tvVerifyNumber?.visibility =
                View.GONE
        })

        walletViewModel?.phoneFieldColor?.observe(viewLifecycleOwner, Observer {
            if (it is String)
                ViewUtils.updateStrokeColor(
                    requireActivity(), rlPhoneNumber,
                    SdkUiInitializer.apiLayer?.config?.primaryColor, R.color.one_payu_colorPrimary
                )
            else ViewUtils.updateStrokeColor(requireContext(), rlPhoneNumber, it as Int)

        })

        walletViewModel?.showPhonePickerDialog?.observe(viewLifecycleOwner, Observer {
            if (it) showHint()
        })

        walletViewModel?.verifiedText?.observe(viewLifecycleOwner, Observer {
            tvVerifiedText?.text = it
        })

        walletViewModel?.verifiedTextColor?.observe(viewLifecycleOwner, Observer {
            tvVerifiedText?.setTextColor(ContextCompat.getColor(requireContext(), it))
        })

        walletViewModel?.hideSoftKeyboard?.observe(viewLifecycleOwner, Observer {
            if (it) ViewUtils.hideSoftKeyboardFromToken(
                requireActivity(),
                etPhone
            ) else ViewUtils.showSoftKeyboard(
                requireActivity()
            )
        })

        walletViewModel?.showVerifiedText?.observe(viewLifecycleOwner, Observer {
            if (it) tvVerifiedText?.visibility = View.VISIBLE else tvVerifiedText?.visibility =
                View.GONE
        })

        walletViewModel?.showGpayMessage?.observe(viewLifecycleOwner, Observer {
            if (it) rlGpayMessage?.visibility = View.VISIBLE else rlGpayMessage?.visibility =
                View.GONE
        })

        walletViewModel?.phoneNumberText?.observe(viewLifecycleOwner, Observer {
            etPhone?.setText(it)
            etPhone?.setSelection(it.length)
        })
        walletViewModel?.editTextInputLength?.observe(viewLifecycleOwner, Observer {
            etPhone?.filters = arrayOf<InputFilter>(InputFilter.LengthFilter(it!!))
        })

        walletViewModel?.isSIMode?.observe(viewLifecycleOwner, Observer {
            if (it) tvConsentText?.visibility = View.VISIBLE
            else tvConsentText?.visibility = View.GONE
        })

        walletViewModel?.textErrorMessage?.observe(viewLifecycleOwner, Observer {
            if (it.isNullOrEmpty()) {
                tvConsentText?.visibility = View.GONE
            } else {
                tvConsentText?.visibility = View.VISIBLE
                tvConsentText?.text = it
            }
        })

        walletViewModel?.textErrorMessageColor?.observe(viewLifecycleOwner, Observer {
            tvConsentText?.setTextColor(ContextCompat.getColor(requireContext(), it))
        })

        walletViewModel?.siHeaderSummary?.observe(viewLifecycleOwner, Observer { value ->
            if (value != null && value.isNotEmpty()) {
                tv_si_summary_title_layout?.visibility = View.VISIBLE
                tvSISummary?.text = value
            }
        })

        walletViewModel?.shakeVerfiedText?.observe(viewLifecycleOwner) {
            if (it) {
                ViewUtils.shakeAnimationInView(tvVerifiedText!!)
            }
        }

        walletViewModel?.updateAdapter?.observe(viewLifecycleOwner) {
            if (it) {
                rvlist?.adapter = HorizontalAdapter(
                    walletViewModel!!.lastItems
                ) { handle -> walletViewModel?.handleEntered(handle) }
                rvlist?.visibility = View.VISIBLE
            } else {
                rvlist?.visibility = View.GONE
            }
        }

        walletViewModel?.setSelection?.observe(viewLifecycleOwner) {
            if (it >= 0) {
                etPhone?.setSelection(it)
            }
        }

        paymentOptionViewModel?.showChangeOfferView?.observe(viewLifecycleOwner) { value ->
            if (value != null && value) {
                changeOfferOption?.visibility = View.VISIBLE
                val offerKeySet = HashSet<String>()
                InternalConfig.selectedOfferInfo?.offerMap?.values?.forEach {
                    it.offerKey?.let { it1 -> offerKeySet.add(it1) }
                }
                val length = offerKeySet.size
                if (length > 1) {
                    tvOfferTitle?.text = requireContext().getString(
                        R.string.payu_offer_applied_text,
                        length.toString()
                    )
                    tvOfferDisc?.visibility = View.GONE
                } else if (length == 1) {
                    val offerKey = InternalConfig.selectedOfferInfo?.offerMap?.keys?.first()
                    tvOfferTitle?.text =
                        InternalConfig.selectedOfferInfo?.offerMap?.get(offerKey)?.title
                    tvOfferDisc?.visibility = View.VISIBLE
                    tvOfferDisc?.text =
                        InternalConfig.selectedOfferInfo?.offerMap?.get(offerKey)?.description
                } else changeOfferOption?.visibility = View.GONE
                if (InternalConfig.selectedOfferInfo?.isSkuOffer == true) tvOfferDetails?.visibility =
                    View.VISIBLE else tvOfferDetails?.visibility = View.GONE
                if (InternalConfig.selectedOfferInfo?.isAutoApply == false && InternalConfig.selectedOfferInfo?.isValidated == false && InternalConfig.isPaymentOptionSelected) {
                    paymentOptionViewModel?.updateSelectedPaymentOption(walletViewModel?.paymentOption)
                    walletViewModel?.fetchCFAndValidateOffer(isOfferRemovedManually = false, etPhone?.text.toString())
                }
            } else {
                changeOfferOption?.visibility = View.GONE
                walletViewModel?.fetchCFAndValidateOffer(isOfferRemovedManually = true, etPhone?.text.toString())
            }
        }

        paymentOptionViewModel?.updateOffer?.observe(viewLifecycleOwner) {
            if (it) {
                bankCode = Utils.getValueFromPaymentOption<String>(
                    CP_BANK_CODE,
                    paymentModel?.paymentOption?.otherParams as? HashMap<String, Any?>
                ).toString()

                if (Utils.isOfferSelected() && (InternalConfig.selectedOfferInfo?.isValid == true
                            || InternalConfig.selectedOfferInfo?.isAutoApply == true) && InternalConfig.isPaymentOptionSelected
                ) {
                    tvOfferAppliedView?.visibility = View.VISIBLE
                } else tvOfferAppliedView?.visibility = View.GONE
            } else tvOfferAppliedView?.visibility = View.GONE
        }

        walletViewModel?.showErrorSnackBar?.observe(viewLifecycleOwner) {
            if (activity?.isDestroyed == false && activity?.isFinishing == false) {
                ViewUtils.showSnackBar(
                    getString(R.string.payu_payment_option_error_message),
                    R.drawable.payu_emi,
                    activity
                )
            }
        }
        walletViewModel?.showOfferApplied?.observe(viewLifecycleOwner) {
            paymentOptionViewModel?.showChangeOfferView(it.getContentIfNotHandled() ?: false, false)
        }
        walletViewModel?.showOfferAppliedDialog?.observe(viewLifecycleOwner) {
            if (it.getContentIfNotHandled() == true) {
                val offerAppliedDialog = OfferAppliedDialog(requireContext())
                offerAppliedDialog.showOfferDialog(paymentOptionViewModel?.selectedPaymentOption)
            }
        }

        walletViewModel?.showOfferError?.observe(viewLifecycleOwner) {
            if (it.first.getContentIfNotHandled() != null) {
                InternalConfig.selectedOfferInfo = null
                ViewUtils.showSnackBar(
                    InternalConfig.selectedOfferInfo?.failureReason
                        ?: requireContext().getString(R.string.payu_offer_not_applicable_on_this),
                    R.drawable.verification, requireActivity(),
                    R.color.payu_color_FCE9E9
                )
            }
        }
        paymentOptionViewModel?.showTpvTiles?.observe(viewLifecycleOwner) {
            if (it) {
                val tilesDataList = paymentOptionViewModel?.getTilesList() ?: arrayListOf()
                tpvAccountOptions?.visibility = View.VISIBLE
                tvTpvInfo?.text = requireContext().getString(R.string.payu_tpv_info_summary)
                rvRecommendedOptions?.layoutManager =
                    LinearLayoutManager(context, LinearLayoutManager.HORIZONTAL, false)
                val horizontalTilesAdapter = HorizontalTilesAdapter(tilesDataList)
                rvRecommendedOptions?.adapter = horizontalTilesAdapter
            }
        }
        if (InternalConfig.isQuickPayEnabled && InternalConfig.isQuickPayBottomSheetEnabled && !Utils.isSiTxn()) {
            rlSwitchSaveCard?.visibility = View.VISIBLE
            switchSaveCard?.isChecked = true
        } else {
            rlSwitchSaveCard?.visibility = View.GONE
            switchSaveCard?.isChecked = false
        }

        walletViewModel?.updateCFinHeader?.observe(viewLifecycleOwner) { paymentOption ->
            paymentOption?.let {
                if (it.additionalCharge != null && it.additionalCharge != 0.0) {
                    paymentOptionViewModel?.updateHeaderAmount(
                        amount = SdkUiInitializer.apiLayer?.payUPaymentParams?.amount?.toDouble()
                            ?.minus(
                                InternalConfig.selectedOfferInfo?.totalInstantDiscount ?: 0.0
                            ),
                        isOfferValid = InternalConfig.selectedOfferInfo != null,
                        additionalCharge = it.additionalCharge,
                        gstFlatValue = it.gstValue,
                    )
                } else if(it.feeCombinations != null){
                    it.feeCombinations?.let { data ->
                        paymentOptionViewModel?.updateHeaderAmount(
                            amount = SdkUiInitializer.apiLayer?.payUPaymentParams?.amount?.toDouble()
                                ?.minus(InternalConfig.selectedOfferInfo?.totalInstantDiscount ?: 0.0),
                            isOfferValid = InternalConfig.selectedOfferInfo != null,
                            cfAmount = data.convenienceFeeCharges.firstOrNull()?.baseFee,
                            taxAmount = data.convenienceFeeCharges.firstOrNull()?.taxAmount
                        )
                    }
                }
            }
        }

        paymentOptionViewModel?.showLoginPhoneLayout?.observe(viewLifecycleOwner) {
            if (it) {
                populateLogInContainer()
            } else {
                // User has logged out - handle logout
                handleLogout()
                paymentOptionViewModel?.resetBankItem()
            }
        }

        showTimer()
    }

    private fun populateLogInContainer() {
        // Ensure login section view is initialized
        if (loginSectionView == null) {
            loginSectionView = view?.findViewById(R.id.rlGlobalVaultPhoneStting)
        }

        val loggedInNumber = paymentOptionViewModel?.getLoggedInPhoneNumber()
        val tvLoggedInPhoneNumber = loginSectionView?.findViewById<TextView>(R.id.tvGlobalVaultPhoneNumber)
        val ivLoginSettings = loginSectionView?.findViewById<ImageView>(R.id.ivGvSettings)

        // Update phone number and settings visibility
        tvLoggedInPhoneNumber?.text = loggedInNumber
        ivLoginSettings?.visibility = if (loggedInNumber.isNullOrEmpty()) View.GONE else View.VISIBLE

        // Check if there's a timer string from ViewModel (current value)
        val hasTimer = !paymentOptionViewModel?.timerString?.value.isNullOrEmpty()

        // CRITICAL: Never hide the view if there's a timer - timer takes priority
        // Only update visibility if there's no timer
        if (!hasTimer) {
            // Only control visibility if there's no timer
            // loggedInNumber will be null if user is logged out (automatically handled)
            if (loggedInNumber != null) {
                loginSectionView?.visibility = View.VISIBLE
            } else {
                loginSectionView?.visibility = View.GONE
            }
        } else {
            // If timer exists, ensure view is visible
            loginSectionView?.visibility = View.VISIBLE
        }
    }

    private fun handleLogout() {
        // Ensure login section view is initialized
        if (loginSectionView == null) {
            loginSectionView = view?.findViewById(R.id.rlGlobalVaultPhoneStting)
        }

        // Check if there's a timer - if yes, keep view visible for timer
        // If no timer, hide the view completely
        // Phone number will be null from getLoggedInPhoneNumber() when logged out
        val hasTimer = !paymentOptionViewModel?.timerString?.value.isNullOrEmpty()

        if (hasTimer) {
            // Timer exists - keep view visible for timer
            // Phone number will be automatically hidden since getLoggedInPhoneNumber() returns null
            loginSectionView?.visibility = View.VISIBLE
            // Update phone number display (will be null if logged out)
            populateLogInContainer()
        } else {
            // No timer - hide the view completely
            loginSectionView?.visibility = View.GONE
        }
    }

    fun showTimer() {
        // Ensure login section view is initialized
        if (loginSectionView == null) {
            loginSectionView = view?.findViewById(R.id.rlGlobalVaultPhoneStting)
        }

        paymentOptionViewModel?.timerString?.observe(viewLifecycleOwner) { timerString ->
            val tvTimer = loginSectionView?.findViewById<TextView>(R.id.tvTimer)
            val tvLoggedInPhoneNumber = loginSectionView?.findViewById<TextView>(R.id.tvGlobalVaultPhoneNumber)
            val ivLoginSettings = loginSectionView?.findViewById<ImageView>(R.id.ivGvSettings)

            // Update timer text - works for Wallet/UPI
            tvTimer?.text = timerString

            // Get current login state - will be null if user is logged out
            val loggedInNumber = paymentOptionViewModel?.getLoggedInPhoneNumber()

            // Update phone number and settings
            // loggedInNumber will be null if user is logged out (automatically handled)
            tvLoggedInPhoneNumber?.text = loggedInNumber
            if (loggedInNumber.isNullOrEmpty()) {
                tvLoggedInPhoneNumber?.visibility = View.GONE
                ivLoginSettings?.visibility = View.GONE
            } else {
                tvLoggedInPhoneNumber?.visibility = View.VISIBLE
                ivLoginSettings?.visibility = View.VISIBLE
            }

            // CRITICAL: Always show the login section view if there's a timer string
            // This ensures timer is visible in Wallet/UPI mode
            if (!timerString.isNullOrEmpty()) {
                loginSectionView?.visibility = View.VISIBLE
            } else if (!loggedInNumber.isNullOrEmpty()) {
                // Show if there's a phone number (even without timer)
                loginSectionView?.visibility = View.VISIBLE
            } else {
                // Hide if there's no timer AND no phone number
                loginSectionView?.visibility = View.GONE
            }
        }

        // Also check current value immediately in case timer is already running when fragment is created
        paymentOptionViewModel?.timerString?.value?.let { currentTimerString ->
            if (!currentTimerString.isNullOrEmpty()) {
                val tvTimer = loginSectionView?.findViewById<TextView>(R.id.tvTimer)
                val tvLoggedInPhoneNumber = loginSectionView?.findViewById<TextView>(R.id.tvGlobalVaultPhoneNumber)
                val ivLoginSettings = loginSectionView?.findViewById<ImageView>(R.id.ivGvSettings)

                tvTimer?.text = currentTimerString

                // Update phone number - will be null if logged out
                val loggedInNumber = paymentOptionViewModel?.getLoggedInPhoneNumber()
                tvLoggedInPhoneNumber?.text = loggedInNumber
                if (loggedInNumber.isNullOrEmpty()) {
                    tvLoggedInPhoneNumber?.visibility = View.GONE
                    ivLoginSettings?.visibility = View.GONE
                } else {
                    tvLoggedInPhoneNumber?.visibility = View.VISIBLE
                    ivLoginSettings?.visibility = View.VISIBLE
                }

                // Force show the view if timer is already running
                loginSectionView?.visibility = View.VISIBLE
            }
        }
    }

    companion object {
        /**
         * Use this factory method to create a new instance of
         * this fragment using the provided parameters.
         *
         * @param paymentModel paymentModel
         * @return A new instance of fragment WalletFragment.
         */
        @JvmStatic
        fun newInstance(paymentModel: PaymentModel) =
            WalletFragment().apply {
                arguments = Bundle().apply {
                    putParcelable(CP_PAYMENT_MODEL, paymentModel)
                }
            }
    }

    override fun onActivityResult(requestCode: Int, resultCode: Int, data: Intent?) {
        super.onActivityResult(requestCode, resultCode, data)
        if (requestCode == rcHint) {
            walletViewModel?.isShowingPhonePicker = false
            if (resultCode == Activity.RESULT_OK && data != null) {
                val cred: Credential? = data.getParcelableExtra(Credential.EXTRA_KEY)
                if (cred != null && cred.id.isNotEmpty())
                    walletViewModel?.phoneNumberPicked(cred.id)
            } else walletViewModel?.phonePickerDismissed()
        }
    }

    override fun onClick(v: View?) {
        when (v?.id) {
            R.id.tvVerifyNumber -> {
                rlPhoneNumber?.requestFocus()
                if (ViewUtils.isInternetAvailable(requireContext())) {
                    ViewUtils.dismissSnackBar()

                    //Log Analytics
//                    paymentModel?.paymentOption?.paymentType?.let {
//                        if (activity != null && !requireActivity().isFinishing)
//                            AnalyticsUtils.logVerifyApiCalled(requireActivity().applicationContext, it)
//                    }

                    walletViewModel?.verifyNumberClicked(etPhone?.text.toString())
                } else noInternetAvailable()
            }

            R.id.btnPay -> {
                if (ViewUtils.isInternetAvailable(requireContext())) {
                    ViewUtils.dismissSnackBar()

                    // To handle OTM flow for UPI collect
                    if (SdkUiInitializer.apiLayer?.payUPaymentParams?.payUSIParams?.isPreAuthTxn == true) {
                        val bottomSheet =
                            UpiOtmDetailBottomSheet.Builder(
                                childFragmentManager,
                                TAG
                            )
                        bottomSheet.setPrivacyUrlClickListener {
                            ViewUtils.openPrivacyUrl(requireActivity())
                        }
                        bottomSheet.setProceedListener {
                            onPayClick(false)
                        }
                        bottomSheet.build().show()
                    } else {
                        onPayClick(switchSaveCard?.isChecked == true)
                        v.isEnabled = false
                    }
                    CommonUIViewUtils.updateLayoutSecurity(requireActivity(), false)
                } else noInternetAvailable()
            }

            R.id.tvRemoveOfferButton -> if (MultipleClickHandler.isSafeOnClickListener()) {
                paymentOptionViewModel?.showChangeOfferView(false)
            }

            R.id.tvOfferDetails -> {
                paymentOptionViewModel?.showSkuBottomSheet(true)
            }
        }
    }

    private fun onPayClick(showSavePaymentSwitch: Boolean) {
        //Log Analytics
        walletViewModel?.paymentOption?.let {
            if (activity != null && !requireActivity().isFinishing)
                AnalyticsUtils.logMakePaymentEvent(
                    requireActivity().applicationContext,
                    it,
                    "L3 " + it.paymentType,
                    SdkUiConstants.CP_NEW_VPA
                )
        }
        walletViewModel?.payButtonClicked(
            etPhone?.text.toString(),
            showSavePaymentSwitch
        )
    }

    private fun noInternetAvailable() {
        NetworkManager.registerReceiver(requireContext().applicationContext)
        ViewUtils.showSnackBar(
            requireContext().resources.getString(R.string.payu_no_internet_connection),
            R.drawable.payu_no_internet,
            requireActivity()
        )
    }

    override fun onFocusChange(v: View?, hasFocus: Boolean) {
        when (v?.id) {
            R.id.etPhone -> walletViewModel?.numberFocusChanged(hasFocus)
        }
    }


    fun setSelectionForUpiHandles(s: String) {
        if (!s.isNullOrEmpty() && (s.subSequence(0, s.length - 1).toString().equals(beforeTxt))) {
            etPhone?.setSelection(s.length)
        }
    }

}
