package com.payu.ui.view.fragments

import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.view.ViewTreeObserver
import android.widget.Button
import android.widget.ImageView
import android.widget.TextView
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.constraintlayout.widget.Group
import androidx.fragment.app.Fragment
import androidx.lifecycle.Observer
import androidx.lifecycle.ViewModelProvider
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.payu.base.listeners.OnFetchImageListener
import com.payu.base.models.ImageDetails
import com.payu.base.models.ImageParam
import com.payu.base.models.InternalConfig
import com.payu.base.models.PaymentMode
import com.payu.base.models.PaymentOption
import com.payu.base.models.PaymentType
import com.payu.base.models.SavedCardOption
import com.payu.ui.R
import com.payu.ui.SdkUiInitializer
import com.payu.ui.model.adapters.SavedCardsListAdapter
import com.payu.ui.model.managers.NetworkManager
import com.payu.ui.model.models.FragmentModel
import com.payu.ui.model.utils.AnalyticsUtils
import com.payu.ui.model.utils.ImageViewUtils
import com.payu.ui.model.utils.SdkUiConstants
import com.payu.ui.model.utils.Utils
import com.payu.ui.model.utils.ViewUtils
import com.payu.ui.model.widgets.RoundedCornerBottomSheet
import com.payu.ui.viewmodel.BaseViewModelFactory
import com.payu.ui.viewmodel.PaymentOptionViewModel
import com.payu.ui.viewmodel.SavedCardsViewModel

/**
 *This Fragment created to show the saved card. Initially It shows the complete items(cards) according to the screen size,
 * with Show More Cards(If we have some cards).
 * Showing cards data using adapter **[SavedCardsListAdapter]]** When the user click Show More cards, then show the complete
 * list.}
 */

class PayUSavedCardsFragment : Fragment(), View.OnClickListener,
    RoundedCornerBottomSheet.OnBottomSheetListener, SavedCardsListAdapter.SavedOptionsListener {
    private var paymentOptionViewModel: PaymentOptionViewModel? = null
    private var payuSavedCardsViewModel: SavedCardsViewModel? = null
    private var list: ArrayList<PaymentMode>? = ArrayList()
    private var rvSavedCard: RecyclerView? = null
    private var savedCardsListAdapter: SavedCardsListAdapter? = null
    private var parentView: ConstraintLayout? = null
    private var savecardLayout: ConstraintLayout? = null
    private var tvSavedCardTxt: TextView? = null
    private var viewMoreCards: ConstraintLayout? = null
    private var viewMoreCardsText: TextView? = null
    private var tvManage: TextView? = null
    private var tvSISummary: TextView? = null
    private var tv_si_summary_title_layout: ConstraintLayout? = null
    private var rlHeaderAddNewCard: ConstraintLayout? = null
    private var rlManageSavedOptions: Group? = null
    private var shouldHideAddCard: Boolean = false
    private var roundedCornerBottomSheet: RoundedCornerBottomSheet? = null
    private var onGlobalLayoutListener: ViewTreeObserver.OnGlobalLayoutListener? = null
    private var shouldShowManageCards: Boolean = false
    private var initiatedFrom: String = SdkUiConstants.CP_CARDS
    private var tvAccessSavedOption: TextView? = null
    private var mesaureHeight: Int = 0
    private var changeOfferOption: ConstraintLayout? = null
    private var removeOfferButton: TextView? = null
    private var tvOfferTitle: TextView? = null
    private var tvOfferDetails: TextView? = null
    private var tvOfferDisc: TextView? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        argumentsData()

    }

    private fun argumentsData() {
        arguments?.let {
            val paymentModeCard = it.getParcelableArrayList<PaymentMode>(SdkUiConstants.SAVED_CARDS)
            shouldHideAddCard = it.getBoolean(SdkUiConstants.SHOULD_HIDE_ADD_CARD)
            if (null != it.get(SdkUiConstants.INITIATED_FROM))
                initiatedFrom = it.getString(SdkUiConstants.INITIATED_FROM).toString()
            shouldShowManageCards = it.getBoolean(SdkUiConstants.SHOULD_SHOW_MANAGE_CARDS)
            if (null != paymentModeCard)
                list = paymentModeCard
        }

    }

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        // Inflate the layout for this fragment
        val view = inflater.inflate(R.layout.fragment_card, container, false)
        rvSavedCard = view?.findViewById(R.id.rcvSavedCards)
        parentView = view?.findViewById(R.id.rvTransparent)
        viewMoreCards = view?.findViewById(R.id.viewMoreCards)
        tvManage = view?.findViewById(R.id.tvManage)
        viewMoreCardsText = view?.findViewById(R.id.viewMoreCardsText)
        rlHeaderAddNewCard = view?.findViewById(R.id.rlHeaderAddNewCard)
        rlManageSavedOptions = view?.findViewById(R.id.rlManageSavedOptions)
        tvSavedCardTxt = view?.findViewById(R.id.tvSavedCardTxt)
        tvSISummary = view.findViewById(R.id.tv_si_summary_title)
        tv_si_summary_title_layout = view.findViewById(R.id.tv_si_summary_title_layout)
        tvAccessSavedOption = view.findViewById(R.id.tvAccessSavedOption)
        savecardLayout = view.findViewById(R.id.clOtherOption)
        tvOfferTitle = view.findViewById(R.id.tvOfferTitle)
        tvOfferDetails = view.findViewById(R.id.tvOfferDetails)
        tvOfferDisc = view.findViewById(R.id.tvOfferDisc)
        removeOfferButton = view.findViewById(R.id.tvRemoveOfferButton)
        changeOfferOption = view.findViewById(R.id.changeOfferOption)
        tvManage?.setOnClickListener(this)
        removeOfferButton?.setOnClickListener(this)
        initViewModel()
        getLayoutHeight()
        addObserver()
        payuSavedCardsViewModel?.uiSetup(initiatedFrom)
        if (shouldShowManageCards) {
            payuSavedCardsViewModel?.showManageStoreCardsView()
        }
        if (initiatedFrom == SdkUiConstants.SODEXO)
            payuSavedCardsViewModel?.fetchBalanceForSodexo()
        viewMoreCards?.setOnClickListener {
            if (activity != null && !requireActivity().isFinishing) {
                val ctaName = if (viewMoreCardsText?.text.toString()
                        .equals(requireActivity().applicationContext.getString(R.string.payu_view_more_cards))
                )
                    SdkUiConstants.CP_VIEW_MORE else SdkUiConstants.CP_VIEW_LESS
            }
            payuSavedCardsViewModel?.changeLoadMoreLessText(viewMoreCardsText?.text.toString())
        }
        rlHeaderAddNewCard?.setOnClickListener {
            if (activity != null && !requireActivity().isFinishing)
                AnalyticsUtils.logCardsL2ClickEvents(
                    requireActivity().applicationContext,
                    SdkUiConstants.CP_ADD_CARD,
                    false
                )
            val fragment = AddCardFragment.newInstance(initiatedFrom)
            if (initiatedFrom == SdkUiConstants.SODEXO)
                paymentOptionViewModel?.loadFragment(fragment, "SODEXO", PaymentType.SODEXO)
            else paymentOptionViewModel?.loadFragment(fragment, "ADD CARD", PaymentType.CARD)

        }
        when {
            shouldHideAddCard || shouldShowManageCards -> rlHeaderAddNewCard?.visibility = View.GONE
            else -> rlHeaderAddNewCard?.visibility = View.VISIBLE
        }

        if (null != activity && !activity?.isFinishing!! && !activity?.isDestroyed!!) {
            rvSavedCard?.layoutManager = LinearLayoutManager(activity)

            /**
             * Init recycler view with empty list just to create an adapter and set inital configurations
             * Later on this list is updated based on screen height and recycler view height
             * */
            savedCardsListAdapter = SavedCardsListAdapter(
                this,
                ArrayList()
            )
            rvSavedCard?.adapter = savedCardsListAdapter
        }
        return view
    }

    private fun addObserver() {
        payuSavedCardsViewModel?.hideAddCardLayout?.observe(viewLifecycleOwner, Observer {
            if (!shouldHideAddCard || !shouldShowManageCards) {
                //handle this logic when screen has both options add new card and saved cards list
                if (it) rlHeaderAddNewCard?.visibility =
                    View.GONE else rlHeaderAddNewCard?.visibility = View.VISIBLE
            }
        })

        payuSavedCardsViewModel?.showManageHeader?.observe(viewLifecycleOwner, Observer {
            if (it) rlManageSavedOptions?.visibility =
                View.VISIBLE else rlManageSavedOptions?.visibility = View.GONE
        })

        payuSavedCardsViewModel?.shouldShowManageOption?.observe(viewLifecycleOwner, Observer { it ->
            if (it) {
                tvManage?.visibility = View.VISIBLE
                ViewUtils.updateTextColor(
                    requireContext(),
                    tvManage,
                    SdkUiInitializer.apiLayer?.config?.primaryColor,
                    R.color.one_payu_colorPrimary
                )
            } else
                tvManage?.visibility = View.GONE

        })

        payuSavedCardsViewModel?.hideSavedCardsHeader?.observe(viewLifecycleOwner, Observer {
            tvSavedCardTxt?.visibility = if (it) View.GONE else  View.VISIBLE
            tvManage?.visibility = if (it) View.GONE else  View.VISIBLE
        })

        payuSavedCardsViewModel?.showListWithDeleteIcon?.observe(viewLifecycleOwner, Observer {
            if (it) {
                savedCardsListAdapter?.savedCardsList =
                    payuSavedCardsViewModel?.adapterListWithOutSodexoCard!!
                savedCardsListAdapter?.showDeleteIcon = true
                savedCardsListAdapter?.notifyDataSetChanged()
            } else {
                savedCardsListAdapter?.savedCardsList = payuSavedCardsViewModel?.savedModesList!!
                savedCardsListAdapter?.showDeleteIcon = false
                savedCardsListAdapter?.notifyDataSetChanged()
            }
        })

        payuSavedCardsViewModel?.adapterList?.observe(viewLifecycleOwner, Observer {

            if (null != paymentOptionViewModel && null != context) {
                savedCardsListAdapter?.savedCardsList = it
                savedCardsListAdapter?.notifyDataSetChanged()
            }
        })

        payuSavedCardsViewModel?.savedCardsListEmpty?.observe(viewLifecycleOwner, Observer {
            if (shouldHideAddCard) {
                //take user to L1 fragment when on saved cards list was displayed and that too becomes empty
                //Current stack is L1 -> SavedCardsList -> ManageFragment
                paymentOptionViewModel?.popBackStack?.value = true
                paymentOptionViewModel?.popBackStack?.value = true
            } else {
                /**
                 * if screen has Add New Card option along with saved cards list then when list becomes empty
                 * take user to next actionable screen i.e Add New Card screen
                 */
                if (it) {
                    paymentOptionViewModel?.popBackStack?.value = true
                    paymentOptionViewModel?.loadFragment?.value = FragmentModel().also {
                        it.fragment = AddCardFragment.newInstance(initiatedFrom)
                        it.addToBackStack = false
                        it.tag = SdkUiConstants.TAG_REPLACED_FRAGMENT
                    }
                }
            }
        })
        payuSavedCardsViewModel?.siHeaderSummary?.observe(viewLifecycleOwner, Observer { value ->
            if (value != null && value.isNotEmpty() && shouldShowManageCards == false) {
                tv_si_summary_title_layout?.visibility = View.VISIBLE
                tvSISummary?.text = value
            }
        })

/*        paymentOptionViewModel?.resetManageView?.observe(viewLifecycleOwner, Observer {
            if (it) payuSavedCardsViewModel?.resetManageView()
        })*/

        payuSavedCardsViewModel?.hideBottomSheet?.observe(viewLifecycleOwner, Observer {
            if (it) roundedCornerBottomSheet?.dismiss()
        })

        payuSavedCardsViewModel?.showProgressDialog?.observe(viewLifecycleOwner, Observer {
            if (it) ViewUtils.showProgressDialog(context) else ViewUtils.hideProgressDialog()
        })

        payuSavedCardsViewModel?.showAndroidLoader?.observe(viewLifecycleOwner) {
            if (it.getContentIfNotHandled() == true)
                ViewUtils.showProgressDialog(context)
            else
                ViewUtils.hideProgressDialog()
        }

        payuSavedCardsViewModel?.apiError?.observe(viewLifecycleOwner, Observer { errorResponse ->
            //Log Analytics
//            activity?.let { if (!it.isFinishing) AnalyticsUtils.logErrorOccurredEvent(it.applicationContext, errorResponse.errorMessage)}
            ViewUtils.showSnackBar(errorResponse.errorMessage, R.drawable.payu_cards, activity)
        })

        payuSavedCardsViewModel?.reCalculateHeight?.observe(viewLifecycleOwner, Observer {
            if (it) getLayoutHeight()
        })

        payuSavedCardsViewModel?.savedOptionsTitle?.observe(viewLifecycleOwner, Observer {

            tvSavedCardTxt?.text = it
        })
        payuSavedCardsViewModel?.viewMoreCardVisible?.observe(viewLifecycleOwner, Observer {

            if (it)
                viewMoreCards?.visibility = View.VISIBLE
            else
                viewMoreCards?.visibility = View.GONE
        })

        payuSavedCardsViewModel?.shouldLoadAll?.observe(viewLifecycleOwner, Observer {
            if (!it) payuSavedCardsViewModel?.getTheFilteredItemsToShow(
                heightOfRecyclerView!!,
                initiatedFrom
            )
        })
        payuSavedCardsViewModel?.loadMoreLessText?.observe(viewLifecycleOwner, Observer {

            viewMoreCardsText?.text = it
        })
        payuSavedCardsViewModel?.titleText?.observe(viewLifecycleOwner, Observer {
            tvAccessSavedOption?.text = it

        })

        paymentOptionViewModel?.updatedSodexoOptionList?.observe(viewLifecycleOwner, Observer {

            if (null != context && initiatedFrom.equals(SdkUiConstants.SODEXO)) {
                savedCardsListAdapter?.savedCardsList = it
                savedCardsListAdapter?.notifyDataSetChanged()
            }
        })

        paymentOptionViewModel?.showChangeOfferView?.observe(viewLifecycleOwner) { value ->
            if (value) {
                changeOfferOption?.visibility = View.VISIBLE
                val offerKeySet = HashSet<String>()
                InternalConfig.selectedOfferInfo?.offerMap?.values?.forEach {
                    it.offerKey?.let { it1 -> offerKeySet.add(it1) }
                }
                val length = offerKeySet.size
                if (length > 1) {
                    tvOfferTitle?.text = requireContext().getString(
                        R.string.payu_offer_applied_text,
                        length.toString()
                    )
                    tvOfferDisc?.visibility = View.GONE
                } else if (length == 1) {

                    val offerKey = InternalConfig.selectedOfferInfo?.offerMap?.keys?.first()
                    tvOfferTitle?.text =
                        InternalConfig.selectedOfferInfo?.offerMap?.get(offerKey)?.title
                    tvOfferDisc?.visibility = View.VISIBLE
                    tvOfferDisc?.text =
                        InternalConfig.selectedOfferInfo?.offerMap?.get(offerKey)?.description
                } else changeOfferOption?.visibility = View.GONE
                if (InternalConfig.selectedOfferInfo?.isSkuOffer == true) tvOfferDetails?.visibility =
                    View.VISIBLE else tvOfferDetails?.visibility = View.GONE
            } else {
                changeOfferOption?.visibility = View.GONE
            }
        }

        paymentOptionViewModel?.showOfferApplied?.observe(viewLifecycleOwner) {
            paymentOptionViewModel?.showChangeOfferView(
                shouldShowChangeOffer = it.getContentIfNotHandled() ?: false
            )
        }

        paymentOptionViewModel?.showOfferError?.observe(viewLifecycleOwner) {
            if (it.first.getContentIfNotHandled() == true) {
                InternalConfig.userSelectedOfferInfo?.let {
                    ViewUtils.showSnackBar(
                        InternalConfig.selectedOfferInfo?.failureReason
                            ?: requireContext().getString(R.string.payu_offer_not_applicable_on_this),
                        R.drawable.verification, requireActivity(),
                        R.color.payu_color_FCE9E9
                    )
                }

            }
        }
    }

    private fun getLayoutHeight() {
        parentView?.viewTreeObserver?.addOnGlobalLayoutListener(object :
            ViewTreeObserver.OnGlobalLayoutListener {
            override fun onGlobalLayout() {
                if (context != null) {
                    onGlobalLayoutListener = this
                    when {
                        shouldHideAddCard -> when {
                            ViewUtils.savedCardHeight > 0 -> payuSavedCardsViewModel?.getHeightOfRecylerView(
                                ViewUtils.savedCardHeight
                            )
                            else -> payuSavedCardsViewModel?.getHeightOfRecylerView(parentView?.measuredHeight!!)
                        }
                        else -> when {
                            ViewUtils.savedCardHeightWithAddCard > 0 -> {
                                payuSavedCardsViewModel?.getHeightOfRecylerView(ViewUtils.savedCardHeightWithAddCard)
                            }
                            else -> {
                                if (mesaureHeight == 0)
                                    mesaureHeight = parentView?.measuredHeight!!
                                payuSavedCardsViewModel?.getHeightOfRecylerView(mesaureHeight)
                            }
                        }
                    }
                    addObserverToListenRecyclerViewHeight()

                }
            }
        })
    }

    private var heightOfRecyclerView: Int? = null

    companion object {
        /**
         * Use this factory method to create a new instance of
         * this fragment using the provided parameters.
         * @return A new instance of fragment PayUSavedCardsFragment.
         */
        @JvmStatic
        fun newInstance(quickOptionsList: ArrayList<PaymentMode>?, shouldHideAddCard: Boolean) =
            PayUSavedCardsFragment().apply {
                arguments = Bundle().apply {
                    putParcelableArrayList(SdkUiConstants.SAVED_CARDS, quickOptionsList)
                    putBoolean(SdkUiConstants.SHOULD_HIDE_ADD_CARD, shouldHideAddCard)
                }
            }

        @JvmStatic
        fun newInstance(
            quickOptionsList: ArrayList<PaymentMode>?,
            shouldHideAddCard: Boolean,
            initiatedFrom: String
        ) =
            PayUSavedCardsFragment().apply {
                arguments = Bundle().apply {
                    putParcelableArrayList(SdkUiConstants.SAVED_CARDS, quickOptionsList)
                    putBoolean(SdkUiConstants.SHOULD_HIDE_ADD_CARD, shouldHideAddCard)
                    putString(SdkUiConstants.INITIATED_FROM, initiatedFrom)
                }
            }

        /**
         * Use this factory method to create a new instance of
         * this fragment using the provided parameters.
         * @return A new instance of fragment PayUSavedCardsFragment.
         */
        @JvmStatic
        fun newInstance(
            quickOptionsList: ArrayList<PaymentMode>?,
            shouldHideAddCard: Boolean,
            shouldShowManageCards: Boolean,
            initiatedFrom: String
        ) =
            PayUSavedCardsFragment().apply {
                arguments = Bundle().apply {
                    putParcelableArrayList(SdkUiConstants.SAVED_CARDS, quickOptionsList)
                    putBoolean(SdkUiConstants.SHOULD_HIDE_ADD_CARD, shouldHideAddCard)
                    putBoolean(SdkUiConstants.SHOULD_SHOW_MANAGE_CARDS, shouldShowManageCards)
                }
            }
    }

    private fun initViewModel() {

        /**
         * We will create ViewModel instance in the fragment using the activity scope so
         * that it will be available for all the fragment of the activity including activity itself.
         * */


        if (null != activity && !activity?.isFinishing!! && !activity?.isDestroyed!!) {

            paymentOptionViewModel = activity?.run {
                ViewModelProvider(this)[PaymentOptionViewModel::class.java]
            } ?: throw Exception("Invalid Activity")

            val map = HashMap<String, Any>()
            map[SdkUiConstants.SAVED_CARDS] = list!!
            payuSavedCardsViewModel = ViewModelProvider(
                this,
                BaseViewModelFactory(activity?.application!!, map)
            ).get(SavedCardsViewModel::class.java)
        }
    }

    private fun getScreenName() {
        paymentOptionViewModel?.setScreenName("L2 " + initiatedFrom)
    }

    private fun addObserverToListenRecyclerViewHeight() {
        payuSavedCardsViewModel?.shouldAddObserver?.observe(viewLifecycleOwner, Observer {
            if (it) {
                heightOfRecyclerView = payuSavedCardsViewModel?.recyclerViewHeight
                if (shouldHideAddCard || shouldShowManageCards)
                    ViewUtils.savedCardHeight = heightOfRecyclerView!!
                else {
                    ViewUtils.savedCardHeightWithAddCard = heightOfRecyclerView!!
                }
                parentView?.viewTreeObserver?.removeOnGlobalLayoutListener(onGlobalLayoutListener)
                payuSavedCardsViewModel?.saveOptionTitleAndAddCardOption(
                    shouldHideAddCard,
                    initiatedFrom
                )
                payuSavedCardsViewModel?.getTheFilteredItemsToShow(
                    heightOfRecyclerView!!,
                    initiatedFrom
                )
            }
        })
    }

    override fun onClick(v: View?) {
        when (v?.id) {
            R.id.tvManage -> {
                if (activity != null && !requireActivity().isFinishing && (list != null && list!!.size > 0)) {
                    paymentOptionViewModel?.loadFragment?.value = FragmentModel().also {
                        it.fragment = newInstance(
                            payuSavedCardsViewModel?.savedModesList,
                            shouldHideAddCard,
                            true,
                            SdkUiConstants.CP_MANAGE
                        )
                        AnalyticsUtils.logManageCard(
                            requireActivity().applicationContext,
                            SdkUiConstants.CP_MANAGE_CARDS,
                            list?.get(0)?.type!!
                        )
                    }
                }
            }

            R.id.tvRemoveOfferButton ->{
                paymentOptionViewModel?.showChangeOfferView(false, false)
            }
        }
    }

    private fun showBottomSheet(layout: Int) {
        if (activity != null && !requireActivity().isFinishing && !requireActivity().isDestroyed) {

            /*     val bottomSheetFragment = requireActivity().supportFragmentManager.findFragmentByTag(SdkUiConstants.CP_SAVED_CARD_BOTTOM_SHEET)
                 if (bottomSheetFragment == null) {*/
            roundedCornerBottomSheet =
                RoundedCornerBottomSheet.newInstance(layout)
            roundedCornerBottomSheet?.show(
                requireActivity().supportFragmentManager,
                SdkUiConstants.CP_SAVED_CARD_BOTTOM_SHEET
            )
            roundedCornerBottomSheet?.setListener(this)
//            }
        }
    }

    override fun getInflatedView(view: View, roundedCornerBottomSheet: RoundedCornerBottomSheet) {
        val ivCardIssuerIcon: ImageView = view.findViewById(R.id.ivCardIssuerIcon)
        val tvBankName: TextView = view.findViewById(R.id.tvBankName)
        val tvCardScheme: TextView = view.findViewById(R.id.tvCardScheme)
        val tvCardNumber: TextView = view.findViewById(R.id.tvCardNumber)
        val tvYes: TextView = view.findViewById(R.id.tvYes)
        val btnNo: Button = view.findViewById(R.id.btnNo)

        ViewUtils.updateBackgroundColor(
            requireContext(),
            btnNo,
            SdkUiInitializer.apiLayer?.config?.primaryColor,
            R.color.one_payu_colorPrimary
        )
        ViewUtils.updateButtonTextColor(btnNo, SdkUiInitializer.apiLayer?.config?.baseTextColor)

        payuSavedCardsViewModel?.savedOption?.let {
            tvCardNumber.text = Utils.getFormattedString(
                it.cardNumber,
                it.cardBinInfo?.cardScheme
            )
            if (!it.bankName.isNullOrEmpty() && it.bankName.trim().equals("null", true))
                tvBankName.text = it.bankName
            else
                tvBankName.visibility = View.GONE
            tvCardScheme.text = it.cardBinInfo?.cardType?.getTypeName()
            tvCardScheme.visibility = View.VISIBLE
            val param = ImageParam(it, true, R.drawable.payu_cards_placeholder)
            SdkUiInitializer.apiLayer?.getImageForPaymentOption(
                param,
                onFetchImageListener = object : OnFetchImageListener {
                    override fun onImageGenerated(result: ImageDetails) {
                        ImageViewUtils.setImage(ivCardIssuerIcon, result)
                    }
                })
            tvYes.setOnClickListener {
                if (activity != null && !requireActivity().isFinishing)
//                    AnalyticsUtils.logConfirmationDialogEvent(requireActivity().applicationContext, SdkUiConstants.CP_YES, SdkUiConstants.CP_SCREEN_DELETE_CARD)

                    if (ViewUtils.isInternetAvailable(requireContext())) {
                        ViewUtils.dismissSnackBar()
                        payuSavedCardsViewModel?.callDeleteSavedOptionApi()
                    } else {
                        roundedCornerBottomSheet.dismiss()
                        NetworkManager.registerReceiver(requireContext().applicationContext)
                        ViewUtils.showSnackBar(
                            resources.getString(R.string.payu_no_internet_connection),
                            R.drawable.payu_no_internet,
                            activity
                        )
                    }
            }

            btnNo.setOnClickListener {
                if (activity != null && !requireActivity().isFinishing)
//                    AnalyticsUtils.logConfirmationDialogEvent(requireActivity().applicationContext, SdkUiConstants.CP_NO, SdkUiConstants.CP_SCREEN_DELETE_CARD)

                    this.roundedCornerBottomSheet?.dismiss()
            }
        }
    }

    override fun handleBottomSheetClose() {
    }

    override fun bottomSheetDetach() {
    }

    override fun bottomSheetAttach() {
    }

    override fun onDestroyView() {
        super.onDestroyView()
        ViewUtils.dismissSnackBar()
        ViewUtils.hideProgressDialog()
    }

    override fun onDeleteClicked(deleteIndex: Int, savedCardOption: SavedCardOption) {
        showBottomSheet(R.layout.layout_delete_saved_option)
        payuSavedCardsViewModel?.handleDeleteIconClick(deleteIndex, savedCardOption)
    }

    override fun onDestroy() {
        super.onDestroy()
        ViewUtils.savedCardHeight = 0
        ViewUtils.savedCardHeightWithAddCard = 0
    }

    override fun validateOffer(paymentOption: PaymentOption) {
       payuSavedCardsViewModel?.validateOffer(paymentOption)
    }

    override fun quickOptionSelected(paymentMode: PaymentMode) {
        paymentOptionViewModel?.quickOptionSelected(paymentMode)
    }

    override fun showBottomSheet(type: PaymentType?, paymentOption: PaymentOption?) {
        paymentOptionViewModel?.showBottomSheet(type = type, paymentOption = paymentOption)
    }

    override fun fetchSodexoBalance() {
        payuSavedCardsViewModel?.fetchBalanceForSodexo()
    }
}
