package com.payu.ui.view.fragments

import android.content.Context
import android.os.Bundle
import android.text.Editable
import android.text.InputFilter
import android.text.InputFilter.AllCaps
import android.text.TextWatcher
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.view.WindowManager
import android.widget.Button
import android.widget.EditText
import android.widget.ImageView
import android.widget.ProgressBar
import android.widget.RadioButton
import android.widget.RadioGroup
import android.widget.RelativeLayout
import android.widget.TextView
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.constraintlayout.widget.Group
import androidx.core.content.ContextCompat
import androidx.core.view.isVisible
import androidx.fragment.app.Fragment
import androidx.lifecycle.Observer
import androidx.lifecycle.ViewModelProvider
import androidx.recyclerview.widget.RecyclerView
import com.payu.base.models.InternalConfig
import com.payu.base.models.NBOptions
import com.payu.base.models.PayUBeneficiaryVerificationMode
import com.payu.base.models.PaymentModel
import com.payu.commonui.utils.CommonUIViewUtils
import com.payu.ui.R
import com.payu.ui.SdkUiInitializer
import com.payu.ui.model.managers.NetworkManager
import com.payu.ui.model.utils.ImageViewUtils
import com.payu.ui.model.utils.SdkUiConstants
import com.payu.ui.model.utils.Utils
import com.payu.ui.model.utils.ViewUtils
import com.payu.ui.model.widgets.RoundedCornerBottomSheet
import com.payu.ui.viewmodel.BaseViewModelFactory
import com.payu.ui.viewmodel.NBDetailsViewModel
import com.payu.ui.viewmodel.PaymentOptionViewModel


class NBDetailsFragment : Fragment(), View.OnFocusChangeListener, View.OnClickListener,
    RoundedCornerBottomSheet.OnBottomSheetListener, TextWatcher {
    private var paymentModel: PaymentModel? = null
    private var etAccountNumber: EditText? = null
    private var etIfsc: EditText? = null
    private var tvIfscError: TextView? = null
    private var ivRetryIfscDetails: ImageView? = null
    private var etAccountHolderName: EditText? = null
    private var etAccountType: EditText? = null
    private var etModeOfVerification: EditText? = null
    private var ivBankImage: ImageView? = null
    private var nbDetailsViewModel: NBDetailsViewModel? = null
    private var paymentOptionViewModel: PaymentOptionViewModel? = null
    private var rlAccountNumber: View? = null
    private var roundedCornerBottomSheet: RoundedCornerBottomSheet? = null
    private var btnPay: Button? = null
    private var selectedAccountType: String? = null
    private var rbSelectedAccountTypeId: Int? = null
    private var tvConsentText: TextView? = null
    private var tvAccountNumberMinLengthError: TextView? = null
    private var rlAccountName: View? = null
    private var rlIfsc: View? = null
    private var rlAccountType: View? = null
    private var pbfetchIfsc: ProgressBar? = null
    private var tvAccountNumberLabel: TextView? = null
    private var tvSISummary: TextView? = null
    private var tv_si_summary_title_layout: ConstraintLayout? = null
    private var llVerificationMode: Group? = null
    private var rlVerificationMode: View? = null
    private var tvOfferTitle: TextView? = null
    private var tvOfferDetails: TextView? = null
    private var tvRemoveOffer: TextView? = null
    private var changeOfferOption: RelativeLayout? = null
    private var tvOfferDisc: TextView? = null
    private var tpvAccountOptions: ConstraintLayout? = null
    private var tvTpvInfo: TextView? = null
    private var rvRecommendedOptions: RecyclerView? = null
    private var clRecommendedOptions: ConstraintLayout? = null

    private var isTpvFlow = false

    companion object {
        @JvmStatic
        fun newInstance(paymentModel: PaymentModel) =
            NBDetailsFragment().apply {
                arguments = Bundle().apply {
                    putParcelable(SdkUiConstants.CP_PAYMENT_MODEL, paymentModel)
                }
            }
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        arguments?.let {
            paymentModel = it.getParcelable(SdkUiConstants.CP_PAYMENT_MODEL)
        }
    }

    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        val view = inflater.inflate(R.layout.add_net_banking_details_layout, container, false)
        initView(view)
        initViewModel()
        addObservers()
        return view
    }

    override fun onAttach(context: Context) {
        super.onAttach(context)
        CommonUIViewUtils.updateLayoutSecurity(
            requireActivity(),
            SdkUiInitializer.apiLayer?.config?.isProtectedScreen == true
        )
    }

    override fun onDetach() {
        super.onDetach()
        CommonUIViewUtils.updateLayoutSecurity(requireActivity(), false)
    }

    private fun addObservers() {
        nbDetailsViewModel?.bankImage?.observe(viewLifecycleOwner, Observer {
            ImageViewUtils.setImage(ivBankImage, it)
        })

        nbDetailsViewModel?.showKeyboard?.observe(viewLifecycleOwner, Observer {
            if (it)
                ViewUtils.showSoftKeyboard(requireActivity())
            else
                ViewUtils.hideSoftKeyboard(requireActivity())
        })

        nbDetailsViewModel?.accountNumberFieldColor?.observe(viewLifecycleOwner, Observer {
            if (it is String)
                ViewUtils.updateStrokeColor(
                    requireActivity(), rlAccountNumber,
                    SdkUiInitializer.apiLayer?.config?.primaryColor, R.color.one_payu_colorPrimary
                )
            else ViewUtils.updateStrokeColor(requireContext(), rlAccountNumber, it as Int)
        })

        nbDetailsViewModel?.showVerificationModeBottomSheet?.observe(viewLifecycleOwner, Observer {
            showBottomSheet(it, SdkUiConstants.VERIFICATION_MODE_BOTTOM_SHEET)
        })

        nbDetailsViewModel?.showAccountTypeBottomSheet?.observe(viewLifecycleOwner, Observer {
            showBottomSheet(it, SdkUiConstants.ACCOUNT_TYPE_BOTTOM_SHEET)
        })

        nbDetailsViewModel?.enablePayButton?.observe(viewLifecycleOwner, Observer {
            if (it)
                ViewUtils.enableView(btnPay)
            else ViewUtils.disableView(btnPay)
        })

        nbDetailsViewModel?.hideBottomSheet?.observe(viewLifecycleOwner, Observer {
            if (it) roundedCornerBottomSheet?.dismiss()
        })

        nbDetailsViewModel?.isSIMode?.observe(viewLifecycleOwner, Observer {
            if (it) tvConsentText?.visibility = View.VISIBLE
            else tvConsentText?.visibility = View.GONE
        })

        nbDetailsViewModel?.accountNumberMinLengthError?.observe(viewLifecycleOwner, Observer {
            if (it) {
                tvAccountNumberMinLengthError?.visibility = View.VISIBLE
            } else {
                tvAccountNumberMinLengthError?.visibility = View.GONE
            }
        })

        nbDetailsViewModel?.accountNameFieldColor?.observe(viewLifecycleOwner, Observer {
            if (it is String)
                ViewUtils.updateStrokeColor(
                    requireActivity(), rlAccountName,
                    SdkUiInitializer.apiLayer?.config?.primaryColor, R.color.one_payu_colorPrimary
                )
            else ViewUtils.updateStrokeColor(requireContext(), rlAccountName, it as Int)
        })

        nbDetailsViewModel?.ifscFieldColor?.observe(viewLifecycleOwner, Observer {
            if (!isTpvFlow) {
                if (it is String)
                    ViewUtils.updateStrokeColor(
                        requireActivity(),
                        rlIfsc,
                        SdkUiInitializer.apiLayer?.config?.primaryColor,
                        R.color.one_payu_colorPrimary
                    )
                else ViewUtils.updateStrokeColor(requireContext(), rlIfsc, it as Int)
            }
        })

        nbDetailsViewModel?.accountTypeFieldColor?.observe(viewLifecycleOwner, Observer {
            if (it is String)
                ViewUtils.updateStrokeColor(
                    requireActivity(), rlAccountType,
                    SdkUiInitializer.apiLayer?.config?.primaryColor, R.color.one_payu_colorPrimary
                )
            else ViewUtils.updateStrokeColor(requireContext(), rlAccountType, it as Int)
        })
        nbDetailsViewModel?.modeOfVerificationTypeFieldColor?.observe(viewLifecycleOwner, Observer {
            if (it is String)
                ViewUtils.updateStrokeColor(
                    requireActivity(), rlVerificationMode,
                    SdkUiInitializer.apiLayer?.config?.primaryColor, R.color.one_payu_colorPrimary
                )
            else ViewUtils.updateStrokeColor(requireContext(), rlVerificationMode, it as Int)
        })

        nbDetailsViewModel?.showLoaderInEditText?.observe(viewLifecycleOwner, Observer {
            if (it) {
                pbfetchIfsc?.visibility = View.VISIBLE
                if (!SdkUiInitializer.apiLayer?.config?.primaryColor.isNullOrEmpty())
                    ViewUtils.changeProgressBarColor(
                        pbfetchIfsc,
                        SdkUiInitializer.apiLayer?.config?.primaryColor
                    )
            } else pbfetchIfsc?.visibility = View.GONE
        })

        nbDetailsViewModel?.retryIfscDetails?.observe(viewLifecycleOwner, Observer {
            it.getContentIfNotHandled()?.let { it1 ->
                ivRetryIfscDetails?.isVisible = it1
            }
        })

        nbDetailsViewModel?.ifscCodeError?.observe(viewLifecycleOwner, Observer {

            if (it != null) {
                tvIfscError?.text = it
                tvIfscError?.setTextColor(
                    ContextCompat.getColor(
                        requireContext(),
                        R.color.payu_color_de350b
                    )
                )
                tvIfscError?.visibility = View.VISIBLE
            } else {
                tvIfscError?.visibility = View.GONE
            }
        })

        nbDetailsViewModel?.ifscDetailsText?.observe(viewLifecycleOwner, Observer {
            tvIfscError?.text = it
            ViewUtils.updateTextColor(
                requireContext(), tvIfscError, SdkUiInitializer.apiLayer?.config?.primaryColor,
                R.color.payu_color_0065ff
            )
            tvIfscError?.visibility = View.VISIBLE
        })

        nbDetailsViewModel?.accountNumberLabelText?.observe(viewLifecycleOwner, Observer {
            tvAccountNumberLabel?.text = it
        })
        nbDetailsViewModel?.siHeaderSummary?.observe(viewLifecycleOwner, Observer { value ->
            if (value != null && !value.isEmpty()) {
                tv_si_summary_title_layout?.visibility = View.VISIBLE
                tvSISummary?.text = value
            }

        })
        nbDetailsViewModel?.verificationModeLabelText?.observe(viewLifecycleOwner, Observer {
            etModeOfVerification?.setText(it)
        })
        nbDetailsViewModel?.shouldShowVerificationModeOption?.observe(viewLifecycleOwner, Observer {
            if (it) llVerificationMode?.visibility = View.VISIBLE
            else llVerificationMode?.visibility = View.GONE
        })

        nbDetailsViewModel?.disableVerificationMode?.observe(viewLifecycleOwner, Observer {
            it.getContentIfNotHandled()?.let { it1 ->
                if (it1) disableEditText(etModeOfVerification)
            }
        })

        paymentOptionViewModel?.showChangeOfferView?.observe(viewLifecycleOwner) { value ->
            if (value != null && value) {
                changeOfferOption?.visibility = View.VISIBLE
                val offerKeySet = HashSet<String>()
                InternalConfig.selectedOfferInfo?.offerMap?.values?.forEach {
                    it.offerKey?.let { it1 -> offerKeySet.add(it1) }
                }
                val length = offerKeySet.size
                if (length > 1) {
                    tvOfferTitle?.text = requireContext().getString(
                        R.string.payu_offer_applied_text,
                        length.toString()
                    )
                    tvOfferDisc?.visibility = View.GONE
                } else if (length == 1) {
                    val offerKey = InternalConfig.selectedOfferInfo?.offerMap?.keys?.first()
                    tvOfferTitle?.text =
                        InternalConfig.selectedOfferInfo?.offerMap?.get(offerKey)?.title
                    tvOfferDisc?.visibility = View.VISIBLE
                    tvOfferDisc?.text =
                        InternalConfig.selectedOfferInfo?.offerMap?.get(offerKey)?.description
                } else changeOfferOption?.visibility = View.GONE
                if (InternalConfig.selectedOfferInfo?.isSkuOffer == true) tvOfferDetails?.visibility =
                    View.VISIBLE else tvOfferDetails?.visibility = View.GONE
            } else {
                changeOfferOption?.visibility = View.GONE
            }
        }
    }

    private fun initView(view: View?) {
        etAccountNumber = view?.findViewById(R.id.et_account_number)
        etAccountHolderName = view?.findViewById(R.id.et_account_holder_name)
        etIfsc = view?.findViewById(R.id.etIfsc)
        etIfsc?.filters = arrayOf(AllCaps(), InputFilter.LengthFilter(11))
        tvIfscError = view?.findViewById(R.id.tvIfscError)
        ivRetryIfscDetails = view?.findViewById(R.id.ivRetryIfscDetails)
        pbfetchIfsc = view?.findViewById(R.id.pbfetchIfsc)
        etAccountType = view?.findViewById(R.id.et_account_type)
        ivBankImage = view?.findViewById(R.id.iv_bank_image)
        rlAccountNumber = view?.findViewById(R.id.rlAccountNumber)
        btnPay = view?.findViewById(R.id.btnPay)
        tvConsentText = view?.findViewById(R.id.tv_consent_text)
        tvAccountNumberMinLengthError = view?.findViewById(R.id.tvAccountNumberMinLengthError)
        rlAccountName = view?.findViewById(R.id.rlAccountHolderName)
        rlIfsc = view?.findViewById(R.id.rlIfsc)
        rlAccountType = view?.findViewById(R.id.rlAccountType)
        tvAccountNumberLabel = view?.findViewById(R.id.tvAccountNumberLabel)
        rlVerificationMode = view?.findViewById(R.id.rlVerificationMode)
        llVerificationMode = view?.findViewById(R.id.llVerificationMode)
        etModeOfVerification = view?.findViewById(R.id.et_verification_mode)
        tvSISummary = view?.findViewById(R.id.tv_si_summary_title)
        tv_si_summary_title_layout = view?.findViewById(R.id.tv_si_summary_title_layout)
        tvOfferTitle = view?.findViewById(R.id.tvOfferTitle)
        tvOfferDetails = view?.findViewById(R.id.tvOfferDetails)
        tvRemoveOffer = view?.findViewById(R.id.tvRemoveOfferButton)
        changeOfferOption = view?.findViewById(R.id.changeOfferOption)
        tvOfferDisc = view?.findViewById(R.id.tvOfferDisc)
        tpvAccountOptions = view?.findViewById(R.id.tpvAccountOptions)
        tpvAccountOptions?.visibility = View.GONE
        tvTpvInfo = view?.findViewById(R.id.tvTpvInfo)
        clRecommendedOptions = view?.findViewById(R.id.recommendedOption)
        rvRecommendedOptions = clRecommendedOptions?.findViewById(R.id.rvrecommendedoptions)
        tvRemoveOffer?.setOnClickListener(this)
        ViewUtils.disableView(btnPay)
        etAccountNumber?.onFocusChangeListener = this
        etAccountHolderName?.onFocusChangeListener = this
        etIfsc?.onFocusChangeListener = this
        etAccountType?.setOnClickListener(this)
        etModeOfVerification?.setOnClickListener(this)

        etAccountNumber?.addTextChangedListener(this)
        etAccountHolderName?.addTextChangedListener(this)
        etIfsc?.addTextChangedListener(this)
        etAccountType?.addTextChangedListener(this)
        btnPay?.setOnClickListener(this)
        ivRetryIfscDetails?.setOnClickListener(this)
        ViewUtils.updateBackgroundColor(
            requireContext(),
            btnPay,
            SdkUiInitializer.apiLayer?.config?.primaryColor,
            R.color.one_payu_colorPrimary
        )
        ViewUtils.updateButtonTextColor(btnPay, SdkUiInitializer.apiLayer?.config?.baseTextColor)
    }

    private fun makePayment() {
        if (ViewUtils.isInternetAvailable(requireContext())) {
            ViewUtils.dismissSnackBar()
            CommonUIViewUtils.updateLayoutSecurity(requireActivity(), false)
            nbDetailsViewModel?.makePayment(
                etAccountHolderName?.text.toString(),
                etAccountNumber?.text.toString(),
                etIfsc?.text.toString(),
                selectedAccountType!!
            )
        } else {
            NetworkManager.registerReceiver(requireContext().applicationContext)
            ViewUtils.showSnackBar(
                resources.getString(R.string.payu_no_internet_connection),
                R.drawable.payu_no_internet,
                activity
            )
        }
    }

    private fun initViewModel() {
        val map = HashMap<String, Any>()
        map[SdkUiConstants.CP_PAYMENT_MODEL] = paymentModel!!

        if (activity != null && !requireActivity().isFinishing && !requireActivity().isDestroyed) {
            nbDetailsViewModel =
                ViewModelProvider(
                    this,
                    BaseViewModelFactory(requireActivity().application, map)
                )[NBDetailsViewModel::class.java]


            /**
             * We will create ViewModel instance in the fragment using the activity scope so
             * that it will be available for all the fragment of the activity including activity itself.
             * */

            paymentOptionViewModel = activity?.run {
                ViewModelProvider(this)[PaymentOptionViewModel::class.java]
            } ?: throw Exception("Invalid Activity")

            if (InternalConfig.selectedOfferInfo?.totalDiscountedAmount != null) {
                paymentOptionViewModel?.updateHeaderAmount(
                    InternalConfig.selectedOfferInfo?.totalDiscountedAmount,
                    additionalCharge = paymentModel?.paymentOption?.additionalCharge,
                    gstPercentageValue = paymentModel?.paymentOption?.gstPercentageValue,
                    gstFlatValue = paymentModel?.paymentOption?.gstValue ?: 0.0,
                    isEnachPayment = Utils.isEnachPayment(paymentModel?.paymentOption?.paymentType)
                )
            } else {
                paymentOptionViewModel?.updateHeaderAmount(
                    additionalCharge = paymentModel?.paymentOption?.additionalCharge,
                    gstPercentageValue = paymentModel?.paymentOption?.gstPercentageValue,
                    gstFlatValue = paymentModel?.paymentOption?.gstValue ?: 0.0,
                    isEnachPayment = Utils.isEnachPayment(paymentModel?.paymentOption?.paymentType)
                )
            }
            checkForTpvDetails()
        }
    }

    private fun checkForTpvDetails() {
        (paymentModel?.paymentOption as? NBOptions)?.let { nbOption ->
            val beneficiaryDetails = nbOption.beneficiaryDetails
            if (beneficiaryDetails?.beneficiaryAccountNumber.isNullOrEmpty().not()) {
                isTpvFlow = true
                setAndDisableEditText(etAccountNumber, beneficiaryDetails!!.beneficiaryAccountNumber)
                nbDetailsViewModel?.validateAccountNumberMinLength(beneficiaryDetails.beneficiaryAccountNumber, false)
                if (beneficiaryDetails?.beneficiaryIfsc.isNullOrEmpty().not()) {
                    setAndDisableEditText(etIfsc, beneficiaryDetails!!.beneficiaryIfsc)
                    nbDetailsViewModel?.validateIfsc(beneficiaryDetails.beneficiaryIfsc!!, true)
                }
                if (beneficiaryDetails?.beneficiaryName.isNullOrEmpty().not()) {
                    setAndDisableEditText(etAccountHolderName, beneficiaryDetails!!.beneficiaryName)
                    nbDetailsViewModel?.validateName(beneficiaryDetails.beneficiaryName)
                }
                beneficiaryDetails?.beneficiaryAccountType?.let { accountType ->
                    setAndDisableEditText(etAccountType, accountType.getTypeName())
                    selectedAccountType = accountType.getTypeName()
                    nbDetailsViewModel?.validateAccountType(accountType.getTypeName())
                    etAccountType?.setCompoundDrawablesWithIntrinsicBounds(null, null, null, null)
                }
                beneficiaryDetails?.verificationMode?.let { mode ->
                    nbDetailsViewModel?.verificationModeSelection(mode, false)
                    disableEditText(etModeOfVerification)
                    etModeOfVerification?.setCompoundDrawablesWithIntrinsicBounds(null, null, null, null)
                }
                nbDetailsViewModel?.validateForm()
            } else {
                initFocus()
            }
        } ?: initFocus()
    }

    private fun setAndDisableEditText(editText: EditText?, text: String?) {
        editText?.setText(text)
        disableEditText(editText)
    }

    private fun disableEditText(editText: EditText?) {
        editText?.isEnabled = false
        editText?.isFocusable = false
        editText?.isFocusableInTouchMode = false
        editText?.alpha = 0.5f
    }

    private fun initFocus() {
        etAccountNumber?.requestFocus()
        nbDetailsViewModel?.accountNumberFocused(true)
    }

    override fun onFocusChange(v: View?, hasFocus: Boolean) {
        nbDetailsViewModel?.accountTypeFocused(false)
        nbDetailsViewModel?.modeOfVerificationTypeFocused(false)
        when (v?.id) {
            R.id.et_account_number -> {
                nbDetailsViewModel?.accountNumberFocused(hasFocus)
                nbDetailsViewModel?.validateAccountNumberMinLength(
                    etAccountNumber?.text?.toString(), hasFocus
                )
            }

            R.id.etIfsc -> nbDetailsViewModel?.ifscFocused(hasFocus)
            R.id.et_account_holder_name -> {
                nbDetailsViewModel?.accountNameFocused(hasFocus)
            }
        }
    }

    override fun onClick(v: View?) {
        when (v?.id) {
            R.id.et_account_type -> {
                rlAccountType?.requestFocus()
                nbDetailsViewModel?.showKeyboard?.value = false
                nbDetailsViewModel?.showAccountType()
            }
            R.id.et_verification_mode -> {
                rlVerificationMode?.requestFocus()
                nbDetailsViewModel?.showKeyboard?.value = false
                nbDetailsViewModel?.showModeOfVerificationType()
            }
            R.id.btnPay -> makePayment()
            R.id.tvRemoveOfferButton -> paymentOptionViewModel?.showChangeOfferView(false)
            R.id.ivRetryIfscDetails -> nbDetailsViewModel?.validateIfsc(etIfsc?.text.toString())
        }
    }

    override fun beforeTextChanged(s: CharSequence?, start: Int, count: Int, after: Int) {
    }

    override fun onTextChanged(s: CharSequence?, start: Int, before: Int, count: Int) {
    }

    override fun afterTextChanged(s: Editable?) {

        when {
            etAccountNumber!!.hasFocus() -> {
                nbDetailsViewModel?.validateAccountNumberMinLength(
                    etAccountNumber?.text?.toString(), etAccountNumber!!.hasFocus()
                )
            }
            etIfsc!!.hasFocus() -> {
                nbDetailsViewModel?.validateIfsc(etIfsc?.text.toString())
            }
            etAccountHolderName!!.hasFocus() -> {
                nbDetailsViewModel?.validateName(etAccountHolderName?.text?.toString())
            }
        }

        nbDetailsViewModel?.validateForm()
    }

    override fun getInflatedView(view: View, roundedCornerBottomSheet: RoundedCornerBottomSheet) {
        if (roundedCornerBottomSheet.tag == SdkUiConstants.VERIFICATION_MODE_BOTTOM_SHEET) {
            nbDetailsViewModel?.accountTypeFocused(false)
            nbDetailsViewModel?.modeOfVerificationTypeFocused(true)
            val nbRadioButton = view.findViewById<RadioButton>(R.id.rb_net_banking)
            val dcRadioButton = view.findViewById<RadioButton>(R.id.rb_debit_card)
            val aadhaarRadioButton = view.findViewById<RadioButton>(R.id.rb_aadhaar)
            val rlNetBanking = view.findViewById<RelativeLayout>(R.id.rl_net_banking)
            val rlDebitCard = view.findViewById<RelativeLayout>(R.id.rl_debit_card)
            val rlAadhaar = view.findViewById<RelativeLayout>(R.id.rl_aadhaar)
            rlNetBanking.isVisible = nbDetailsViewModel?.verificationModeList?.contains(PayUBeneficiaryVerificationMode.NET_BANKING) == true
            rlDebitCard.isVisible = nbDetailsViewModel?.verificationModeList?.contains(PayUBeneficiaryVerificationMode.DEBIT_CARD) == true
            rlAadhaar.isVisible = nbDetailsViewModel?.verificationModeList?.contains(PayUBeneficiaryVerificationMode.AADHAAR) == true
            if (nbDetailsViewModel?.verificationModeSelected != null) {
                when (nbDetailsViewModel?.verificationModeSelected) {
                    PayUBeneficiaryVerificationMode.NET_BANKING -> {
                        nbRadioButton.isChecked = true
                        dcRadioButton.isChecked = false
                        aadhaarRadioButton.isChecked = false
                    }
                    PayUBeneficiaryVerificationMode.DEBIT_CARD -> {
                        nbRadioButton.isChecked = false
                        dcRadioButton.isChecked = true
                        aadhaarRadioButton.isChecked = false
                    }
                    else -> {
                        nbRadioButton.isChecked = false
                        dcRadioButton.isChecked = false
                        aadhaarRadioButton.isChecked = true
                    }
                }
            }
            nbRadioButton.setOnClickListener {
                nbDetailsViewModel?.verificationModeSelection(PayUBeneficiaryVerificationMode.NET_BANKING)
            }
            dcRadioButton.setOnClickListener {
                nbDetailsViewModel?.verificationModeSelection(PayUBeneficiaryVerificationMode.DEBIT_CARD)
            }
            aadhaarRadioButton.setOnClickListener {
                nbDetailsViewModel?.verificationModeSelection(PayUBeneficiaryVerificationMode.AADHAAR)
            }

        } else {
            nbDetailsViewModel?.modeOfVerificationTypeFocused(false)
            nbDetailsViewModel?.accountTypeFocused(true)

            if (rbSelectedAccountTypeId != null)
                view.findViewById<RadioGroup>(R.id.rg_account_type)
                    ?.check(rbSelectedAccountTypeId!!)
            view.findViewById<RadioGroup>(R.id.rg_account_type)
                ?.setOnCheckedChangeListener { group, checkedId ->
                    rbSelectedAccountTypeId = checkedId
                    val rbSelectedAccountType = group.findViewById<RadioButton>(checkedId)
                    selectedAccountType = rbSelectedAccountType?.text?.toString()
                    nbDetailsViewModel?.validateAccountType(selectedAccountType)
                    etAccountType?.setText(selectedAccountType)
                    nbDetailsViewModel?.bottomSheetCloseClicked()
                }
        }
        view.findViewById<ImageView>(R.id.ivCloseIcon)?.setOnClickListener {
            (nbDetailsViewModel)?.bottomSheetCloseClicked()
        }
    }

    override fun handleBottomSheetClose() {
        activity?.window?.setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_STATE_ALWAYS_HIDDEN)
    }

    override fun bottomSheetDetach() {

    }

    override fun bottomSheetAttach() {
    }


    private fun showBottomSheet(layout: Int, tag: String) {
        if (activity != null && !requireActivity().isFinishing && !requireActivity().isDestroyed) {
            roundedCornerBottomSheet =
                RoundedCornerBottomSheet.newInstance(layout)
            roundedCornerBottomSheet?.show(
                requireActivity().supportFragmentManager,
                tag
            )
            roundedCornerBottomSheet?.setListener(this)
        }
    }
}