package com.payu.ui.view.fragments

import android.graphics.drawable.Drawable
import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.annotation.DrawableRes
import androidx.appcompat.widget.AppCompatImageView
import androidx.fragment.app.Fragment
import androidx.vectordrawable.graphics.drawable.Animatable2Compat
import androidx.vectordrawable.graphics.drawable.AnimatedVectorDrawableCompat
import com.payu.ui.R

class LoaderFragment : Fragment() {

    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        val view = inflater.inflate(R.layout.payu_loader_layout, container, false)
        val payuLoader: AppCompatImageView? = view?.findViewById(R.id.payu_loader)
        payuLoader?.applyLoopingAnimatedVectorDrawable(R.drawable.payu_loader);
        return view;
    }

    companion object {
        @JvmStatic
        fun newInstance() = LoaderFragment()
    }

    internal fun AppCompatImageView.applyLoopingAnimatedVectorDrawable(@DrawableRes avdResId: Int) {
        val animated = AnimatedVectorDrawableCompat.create(context, avdResId)
        animated?.registerAnimationCallback(object : Animatable2Compat.AnimationCallback() {
            override fun onAnimationEnd(drawable: Drawable?) {
                this@applyLoopingAnimatedVectorDrawable.post { animated.start() }
            }
        })
        this.setImageDrawable(animated)
        animated?.start()
    }
}
