package com.payu.ui.view.customViews

import android.app.Dialog
import android.content.Context
import android.graphics.Paint
import android.util.Log
import android.view.View
import android.view.Window
import android.widget.ImageView
import android.widget.TextView
import androidx.core.content.res.ResourcesCompat
import com.payu.base.models.InternalConfig
import com.payu.base.models.PaymentOption
import com.payu.ui.R
import com.payu.ui.SdkUiInitializer
import com.payu.ui.model.managers.CFManager
import com.payu.ui.model.utils.Utils
import com.payu.ui.model.utils.ViewUtils


class OfferAppliedDialog(private val context: Context) {

    internal fun showOfferDialog(selectedPaymentOption: PaymentOption? = null) {
        val selectedOfferInfo = InternalConfig.selectedOfferInfo
        val dialog = Dialog(context)
        dialog.requestWindowFeature(Window.FEATURE_NO_TITLE)
        dialog.setContentView(R.layout.offer_applied_layout)

        val width = (context.resources.displayMetrics.widthPixels * 0.95).toInt()
        dialog.window?.attributes?.height?.let { dialog.window?.setLayout(width, it) }
        dialog.window?.setBackgroundDrawable(
            ViewUtils.getDrawable(
                context,
                R.drawable.payu_rounded_corner_white_inset
            )
        )
        val tvBestOffer: TextView = dialog.findViewById(R.id.tvBestOffer)
        val tvPayableNow: TextView = dialog.findViewById(R.id.tvPayableNow)
        val tvDiscountedAmt: TextView = dialog.findViewById(R.id.tvDiscountedAmt)
        val tvPayableAmount: TextView = dialog.findViewById(R.id.tvPayableAmount)
        val tvBestOfferDiscount: TextView = dialog.findViewById(R.id.tvBestOfferDiscount)
        val tvBestOfferDiscountWithCashBack: TextView =
            dialog.findViewById(R.id.tvBestOfferDiscountWithCashBack)
        val ivCloseIcon = dialog.findViewById<ImageView>(R.id.ivCloseIcon)
        val tvtOfferNotApplied: TextView = dialog.findViewById(R.id.tvtOfferNotApplied)
        if ((selectedOfferInfo?.isSkuOffer == true && selectedOfferInfo.offerMap?.size == 1) || (selectedOfferInfo?.isAutoApply == false)) tvBestOffer.text =
            context.getString(R.string.payu_offer_apply)

        var conFee =
            if (selectedPaymentOption?.feeCombinations != null) CFManager.getCFandTaxAmountFromFeeComb(
                selectedPaymentOption?.feeCombinations
            ) else null

        val totalPayableAmount = getPayableAmountWithCharges(
            amount = SdkUiInitializer.apiLayer?.payUPaymentParams?.amount?.toDouble(),
            additionalCharge = selectedPaymentOption?.additionalCharge,
            gstFlatValue = selectedPaymentOption?.gstValue,
            gstPercentageValue = selectedPaymentOption?.gstPercentageValue,
            cfAmount = conFee?.first,
            taxAmount = conFee?.second,
        )

        if ((selectedOfferInfo?.totalCashbackDiscount
                ?: 0.0) != 0.0 && (selectedOfferInfo?.totalInstantDiscount ?: 0.0) != 0.0
        ) {
            tvBestOfferDiscountWithCashBack.text = context.getString(
                R.string.payu_cashback_with_instant_text,
                Utils.getFormattedAmountValue(selectedOfferInfo?.totalInstantDiscount),
                Utils.getFormattedAmountValue(selectedOfferInfo?.totalCashbackDiscount),
            )
            tvPayableAmount.text = context.getString(
                R.string.payu_amount_text,
                Utils.getFormattedAmountValue(SdkUiInitializer.apiLayer?.payUPaymentParams?.amount?.toDouble()),
            )
            tvDiscountedAmt.text = if(InternalConfig.emiOfferInfo!= null && InternalConfig.emiOfferInfo?.revisedPrincipalAmount != 0.0) InternalConfig.emiOfferInfo?.revisedPrincipalAmount.toString() else context.getString(
                R.string.payu_amount_text,
                Utils.getFormattedAmountValue(
                    (totalPayableAmount?.minus(
                            InternalConfig.selectedOfferInfo?.totalInstantDiscount ?: 0.0
                        ))
                )
            )
            tvPayableAmount.paintFlags = Paint.STRIKE_THRU_TEXT_FLAG
            tvBestOfferDiscountWithCashBack.visibility = View.VISIBLE
            tvDiscountedAmt.visibility = View.VISIBLE
            tvPayableAmount.visibility = View.VISIBLE
        } else if ((selectedOfferInfo?.totalCashbackDiscount
                ?: 0.0) != 0.0
        ) {
            tvPayableNow.text = context.getString(
                R.string.payu_cashback_received
            )
            //ToDo - need to check, crashing in emulator & working in real device
            try {
                val typeface = ResourcesCompat.getFont(context, R.font.roboto_medium)
                tvPayableAmount.typeface = typeface
            } catch (e: Exception) {
                Log.d("OfferAppliedDialog", "Exception " + e.message)
            }
            tvPayableAmount.visibility = View.VISIBLE
            tvPayableAmount.text = context.getString(
                R.string.payu_amount_text,
                Utils.getFormattedAmountValue(selectedOfferInfo?.totalCashbackDiscount)
            )
            tvBestOfferDiscount.visibility = View.VISIBLE
            tvBestOfferDiscount.text = context.getString(
                R.string.payu_offer_discount_text,
                Utils.getFormattedAmountValue(selectedOfferInfo?.totalCashbackDiscount)
            )
        } else if ((selectedOfferInfo?.totalInstantDiscount
                ?: 0.0) != 0.0
        ) {
            tvBestOfferDiscount.visibility = View.VISIBLE
            tvDiscountedAmt.visibility = View.VISIBLE
            tvPayableAmount.visibility = View.VISIBLE
            tvBestOfferDiscount.text = context.getString(
                R.string.payu_offer_discount_text,
                Utils.getFormattedAmountValue(selectedOfferInfo?.totalInstantDiscount)
            )
            tvPayableAmount.paintFlags = Paint.STRIKE_THRU_TEXT_FLAG
            tvPayableAmount.text = context.getString(
                R.string.payu_amount_text,
                Utils.getFormattedAmountValue(SdkUiInitializer.apiLayer?.payUPaymentParams?.amount?.toDouble())
            )
            tvDiscountedAmt.text = if(InternalConfig.emiOfferInfo!= null && InternalConfig.emiOfferInfo?.revisedPrincipalAmount != 0.0) InternalConfig.emiOfferInfo?.revisedPrincipalAmount.toString() else context.getString(
                R.string.payu_amount_text,
                Utils.getFormattedAmountValue(
                    (totalPayableAmount?.minus(
                        InternalConfig.selectedOfferInfo?.totalInstantDiscount ?: 0.0
                    ))
                )
            )

        } else if ((selectedOfferInfo?.totalCashbackDiscount
                ?: 0.0) == 0.0
        ) {
            tvPayableNow.text = context.getString(
                R.string.you_will_get_best_cashback_on,
                selectedPaymentOption?.bankName
            )
            //ToDo - need to check, crashing in emulator & working in real device
            try {
                val typeface = ResourcesCompat.getFont(context, R.font.roboto_medium)
                tvPayableAmount.typeface = typeface
            } catch (e: Exception) {
                Log.d("OfferAppliedDialog", "Exception " + e.message)
            }
            tvPayableAmount.visibility = View.GONE
            tvBestOfferDiscount.visibility = View.GONE
        }

        val selectedOfferKey = if (InternalConfig.userSelectedOfferInfo?.isSkuOffer == true) {
            InternalConfig.userSelectedOfferInfo?.offerKey + InternalConfig.userSelectedOfferInfo?.sku?.skuId
        } else {
            InternalConfig.userSelectedOfferInfo?.offerKey
        }

        if (InternalConfig.userSelectedOfferInfo != null && selectedOfferInfo?.offerMap?.get(
                selectedOfferKey
            ) == null
        ) {
            InternalConfig.userSelectedOfferInfo = null
            tvtOfferNotApplied.visibility = View.VISIBLE
            tvBestOffer.text = context.getText(R.string.payu_better_offer_found)
        }


        dialog.show()

        ivCloseIcon.setOnClickListener {
            dialog.dismiss()
        }
        tvBestOffer.postDelayed({
            dialog.dismiss()
        }, 15000)
    }

    fun getPayableAmountWithCharges(
        amount: Double? = SdkUiInitializer.apiLayer?.payUPaymentParams?.amount?.toDoubleOrNull(),
        additionalCharge: Double? = null,
        gstFlatValue: Double? = null,
        gstPercentageValue: Double? = null,
        cfAmount: Double? = null,
        taxAmount: Double? = null,
    ): Double? {
        var additonalCharges: String? = null
        var convenienceFeeCharges: String? = null
        var gstAmount: String? = null

        if ((cfAmount != null && taxAmount != null) || (additionalCharge != null && additionalCharge != 0.0)) {
            additonalCharges = additionalCharge.toString()

            convenienceFeeCharges = if (gstPercentageValue != null && gstPercentageValue != 0.0)
                getConvenienceFeeCharges(
                    gstValue = gstFlatValue,
                    gstPercentage = gstPercentageValue,
                    additionalCharge
                )?.toString() ?: "0.0" else additonalCharges

            gstAmount =
                if (gstPercentageValue != null && gstPercentageValue != 0.0) additionalCharge?.minus(
                    convenienceFeeCharges.toDouble()
                ).toString() else gstFlatValue?.toString() ?: "0.0"

            val pricingCF = cfAmount?.toString() ?: "0.0"
            val pricingTax = taxAmount?.toString() ?: "0.0"

            val finalCf = if (additionalCharge != null && additionalCharge != 0.0) {
                convenienceFeeCharges
            } else pricingCF
            val finalTax = if (additionalCharge != null && additionalCharge != 0.0) {
                gstAmount
            } else pricingTax

            convenienceFeeCharges = finalCf
            gstAmount = finalTax

            if (gstPercentageValue == null || gstPercentageValue != 0.0)
                additonalCharges = convenienceFeeCharges.toDoubleOrNull()
                    ?.plus(gstAmount.toDoubleOrNull() ?: 0.0)?.toString()
                    ?: additionalCharge.toString()

            val updatedAmount =
                amount?.plus(finalCf.toDoubleOrNull() ?: additonalCharges.toDouble())
                    ?.plus(finalTax.toDouble())
            return updatedAmount ?: amount
        } else return amount
    }

    internal fun getConvenienceFeeCharges(
        gstValue: Double?,
        gstPercentage: Double?,
        additionalCharge: Double?
    ): Double? {
        return if (gstValue != null && !gstValue.equals(0.0)) additionalCharge?.minus(gstValue)
        else if (gstPercentage != null)
            (additionalCharge ?: 0.0) / (1 + (gstPercentage / 100))
        else additionalCharge
    }

}